/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.pixex.visat;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptorFactory;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.ParameterDescriptorFactory;
import org.esa.snap.core.gpf.ui.OperatorMenu;
import org.esa.snap.core.gpf.ui.OperatorParameterSupport;
import org.esa.snap.core.gpf.ui.ParameterUpdater;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.WildcardMatcher;
import org.esa.snap.pixex.Coordinate;
import org.esa.snap.pixex.PixExOp;
import org.esa.snap.pixex.visat.PixelExtractionIOForm;
import org.esa.snap.pixex.visat.PixelExtractionParametersForm;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.ModelessDialog;

class PixelExtractionDialog
extends ModelessDialog
implements ParameterUpdater {
    private static final String OPERATOR_NAME = "PixEx";
    private final Map<String, Object> parameterMap;
    private final AppContext appContext;
    private final PixelExtractionIOForm ioForm;
    private final PixelExtractionParametersForm parametersForm;

    PixelExtractionDialog(AppContext appContext, String title, String helpID) {
        super(appContext.getApplicationWindow(), title, 145, helpID);
        this.appContext = appContext;
        AbstractButton button = this.getButton(1);
        button.setText("Extract");
        button.setMnemonic('E');
        this.parameterMap = new HashMap<String, Object>();
        OperatorSpi operatorSpi = GPF.getDefaultInstance().getOperatorSpiRegistry().getOperatorSpi(OPERATOR_NAME);
        PropertyContainer propertyContainer = PixelExtractionDialog.createParameterMap(this.parameterMap);
        OperatorParameterSupport parameterSupport = new OperatorParameterSupport(operatorSpi.getOperatorDescriptor(), (PropertySet)propertyContainer, this.parameterMap, (ParameterUpdater)this);
        OperatorMenu operatorMenu = new OperatorMenu((Component)this.getJDialog(), operatorSpi.getOperatorDescriptor(), parameterSupport, appContext, this.getHelpID());
        this.getJDialog().setJMenuBar(operatorMenu.createDefaultMenu());
        ListDataListener changeListener = new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.contentsChanged(e);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.contentsChanged(e);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                Product firstProduct;
                String[] inputPaths;
                Product[] sourceProducts = PixelExtractionDialog.this.ioForm.getSourceProducts();
                if (sourceProducts.length > 0) {
                    PixelExtractionDialog.this.parametersForm.setActiveProduct(sourceProducts[0]);
                    return;
                }
                if (PixelExtractionDialog.this.parameterMap.containsKey("sourceProductPaths") && (inputPaths = (String[])PixelExtractionDialog.this.parameterMap.get("sourceProductPaths")).length > 0 && (firstProduct = PixelExtractionDialog.this.openFirstProduct(inputPaths)) != null) {
                    PixelExtractionDialog.this.parametersForm.setActiveProduct(firstProduct);
                    return;
                }
                PixelExtractionDialog.this.parametersForm.setActiveProduct(null);
            }
        };
        this.ioForm = new PixelExtractionIOForm(appContext, propertyContainer, changeListener);
        this.parametersForm = new PixelExtractionParametersForm(appContext, propertyContainer);
        JPanel ioPanel = this.ioForm.getPanel();
        ioPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        JPanel parametersPanel = this.parametersForm.getPanel();
        parametersPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        JTabbedPane tabbedPanel = new JTabbedPane();
        tabbedPanel.addTab("Input/Output", ioPanel);
        tabbedPanel.addTab("Parameters", parametersPanel);
        this.setContent(tabbedPanel);
    }

    private Product openFirstProduct(String[] inputPaths) {
        if (inputPaths != null) {
            Logger logger = SystemUtils.LOG;
            for (String inputPath : inputPaths) {
                if (inputPath == null || inputPath.trim().length() == 0) continue;
                try {
                    TreeSet fileSet = new TreeSet();
                    WildcardMatcher.glob((String)inputPath, fileSet);
                    for (File file : fileSet) {
                        Product product = ProductIO.readProduct((File)file);
                        if (product == null) continue;
                        return product;
                    }
                }
                catch (IOException e) {
                    logger.severe("I/O problem occurred while scanning source product files: " + e.getMessage());
                }
            }
        }
        return null;
    }

    protected void onOK() {
        this.handleParameterSaveRequest(this.parameterMap);
        MyProgressMonitorSwingWorker worker = new MyProgressMonitorSwingWorker(this.getParent(), "Creating output file(s)...");
        worker.executeWithBlocking();
    }

    public void close() {
        super.close();
        this.ioForm.clear();
    }

    public int show() {
        this.ioForm.addProduct(this.appContext.getSelectedProduct());
        return super.show();
    }

    private static PropertyContainer createParameterMap(Map<String, Object> map) {
        ParameterDescriptorFactory parameterDescriptorFactory = new ParameterDescriptorFactory();
        PropertyContainer container = PropertyContainer.createMapBacked(map, PixExOp.class, (PropertyDescriptorFactory)parameterDescriptorFactory);
        container.setDefaultValues();
        return container;
    }

    public void handleParameterSaveRequest(Map<String, Object> parameterMap) {
        parameterMap.put("expression", this.parametersForm.getExpression());
        parameterMap.put("exportExpressionResult", this.parametersForm.isExportExpressionResultSelected());
        parameterMap.put("timeDifference", this.parametersForm.getAllowedTimeDifference());
        parameterMap.put("coordinates", this.parametersForm.getCoordinates());
    }

    public void handleParameterLoadRequest(Map<String, Object> parameterMap) {
        Object expressionObject = parameterMap.get("expression");
        String expression = "";
        if (expressionObject instanceof String) {
            expression = (String)expressionObject;
        }
        this.parametersForm.setExpression(expression);
        Object exportExpressionResultObject = parameterMap.get("exportExpressionResult");
        if (exportExpressionResultObject instanceof Boolean) {
            this.parametersForm.setExportExpressionResultSelected((Boolean)exportExpressionResultObject);
        }
        Object timeDifferenceObject = parameterMap.get("timeDifference");
        String timeDifference = null;
        if (timeDifferenceObject instanceof String) {
            timeDifference = (String)timeDifferenceObject;
        }
        this.parametersForm.setAllowedTimeDifference(timeDifference);
        Object coordinatesObject = parameterMap.get("coordinates");
        Coordinate[] coordinates = new Coordinate[]{};
        if (coordinatesObject instanceof Coordinate[]) {
            coordinates = (Coordinate[])coordinatesObject;
        }
        this.parametersForm.setCoordinates(coordinates);
        this.parametersForm.updateUi();
    }

    private class MyProgressMonitorSwingWorker
    extends ProgressMonitorSwingWorker<Void, Void> {
        protected MyProgressMonitorSwingWorker(Component parentComponent, String title) {
            super(parentComponent, title);
        }

        protected Void doInBackground(ProgressMonitor pm) throws Exception {
            pm.beginTask("Computing pixel values...", -1);
            AbstractButton runButton = PixelExtractionDialog.this.getButton(1);
            runButton.setEnabled(false);
            try {
                GPF.createProduct((String)PixelExtractionDialog.OPERATOR_NAME, (Map)PixelExtractionDialog.this.parameterMap, (Product[])PixelExtractionDialog.this.ioForm.getSourceProducts());
                pm.worked(1);
            }
            finally {
                pm.done();
            }
            return null;
        }

        protected void done() {
            try {
                this.get();
                Object outputDir = PixelExtractionDialog.this.parameterMap.get("outputDir");
                String message = outputDir != null ? String.format("The pixel extraction tool has run successfully and written the result file(s) to %s.", outputDir.toString()) : "The pixel extraction tool has run successfully and written the result file to to std.out.";
                JOptionPane.showMessageDialog(PixelExtractionDialog.this.getJDialog(), message);
            }
            catch (InterruptedException runButton) {
            }
            catch (ExecutionException e) {
                PixelExtractionDialog.this.appContext.handleError(e.getMessage(), (Throwable)e);
            }
            finally {
                AbstractButton runButton = PixelExtractionDialog.this.getButton(1);
                runButton.setEnabled(true);
            }
        }
    }
}

