/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.classification.gpf.ui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.esa.snap.classification.gpf.BaseClassifier;
import org.esa.snap.classification.gpf.VectorUtils;
import org.esa.snap.classification.gpf.ui.AttributeDialog;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUIUtils;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.AppContext;

public abstract class BaseClassifierOpUI
extends BaseOperatorUI {
    private final JRadioButton loadBtn = new JRadioButton("Load and apply classifier", false);
    private final JRadioButton trainBtn = new JRadioButton("Train and apply classifier", true);
    private final JComboBox<String> classifierNameComboBox = new JComboBox();
    private final JButton deleteClassiferBtn = new JButton("X");
    private final JTextField newClassifierNameField = new JTextField("newClassifier");
    private final JRadioButton trainOnRasterBtn = new JRadioButton("Train on Raster", false);
    private final JRadioButton trainOnVectorsBtn = new JRadioButton("Train on Vectors", true);
    private final JTextField numTrainSamples = new JTextField("");
    private final JCheckBox evaluateClassifier = new JCheckBox("");
    private final JCheckBox evaluateFeaturePowerSet = new JCheckBox("");
    private final JCheckBox doClassValQuantization = new JCheckBox();
    private final JTextField minClassValue = new JTextField("");
    private final JTextField classValStepSize = new JTextField("");
    private final JTextField classLevels = new JTextField("");
    private final JLabel maxClassValue = new JLabel("");
    private final JRadioButton labelSourceVectorName = new JRadioButton("Vector node name", true);
    private final JRadioButton labelSourceAttribute = new JRadioButton("Attribute value", false);
    private final JList<String> trainingBands = new JList();
    private final JList<String> trainingVectors = new JList();
    private final JList<String> featureBandNames = new JList();
    protected JPanel classifierPanel;
    protected JPanel rasterPanel;
    protected JPanel vectorPanel;
    protected JPanel featurePanel;
    protected GridBagConstraints classifiergbc;
    private final String classifierType;

    public BaseClassifierOpUI(String classifierType) {
        this.classifierType = classifierType;
    }

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JPanel panel = this.createPanel();
        this.doClassValQuantization.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseClassifierOpUI.this.enableQuantization(BaseClassifierOpUI.this.doClassValQuantization.isSelected());
            }
        });
        this.minClassValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseClassifierOpUI.this.updateMaxClassValue();
            }
        });
        this.classValStepSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseClassifierOpUI.this.updateMaxClassValue();
            }
        });
        this.classLevels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseClassifierOpUI.this.updateMaxClassValue();
            }
        });
        this.evaluateClassifier.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseClassifierOpUI.this.evaluateFeaturePowerSet.setEnabled(BaseClassifierOpUI.this.evaluateClassifier.isSelected());
            }
        });
        this.loadBtn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean doTraining = e.getStateChange() != 1;
                BaseClassifierOpUI.this.enableTraining(doTraining);
                BaseClassifierOpUI.this.enableTrainOnRaster(doTraining, BaseClassifierOpUI.this.trainOnRasterBtn.isSelected());
            }
        });
        this.labelSourceAttribute.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AttributeDialog dlg = new AttributeDialog("Labels from Attribute", VectorUtils.getAttributesList((Product[])BaseClassifierOpUI.this.sourceProducts), null);
                    dlg.show();
                    if (dlg.IsOK()) {
                        BaseClassifierOpUI.this.labelSourceAttribute.setText(dlg.getValue());
                    }
                }
            }
        });
        this.populateClassifierNames();
        this.classifierNameComboBox.setEditable(false);
        this.classifierNameComboBox.setMaximumRowCount(5);
        this.deleteClassiferBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseClassifierOpUI.this.requestDeleteClassifier();
            }
        });
        this.trainingBands.setSelectionMode(0);
        this.trainingVectors.setSelectionMode(2);
        this.trainOnRasterBtn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                BaseClassifierOpUI.this.enableTrainOnRaster(BaseClassifierOpUI.this.trainBtn.isSelected(), e.getStateChange() == 1);
            }
        });
        this.initParameters();
        return new JScrollPane(panel);
    }

    private Path getClassifierFolder() {
        return SystemUtils.getAuxDataPath().resolve("classifiers").resolve(this.classifierType);
    }

    private void populateClassifierNames() {
        Path classifierDir = this.getClassifierFolder();
        File folder = new File(classifierDir.toString());
        File[] listOfFiles = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".class");
            }
        });
        if (listOfFiles != null && listOfFiles.length > 0) {
            for (File file : listOfFiles) {
                this.classifierNameComboBox.addItem(FileUtils.getFilenameWithoutExtension((File)file));
            }
            this.classifierNameComboBox.setSelectedIndex(0);
        } else {
            this.trainBtn.setSelected(true);
        }
    }

    private void requestDeleteClassifier() {
        Dialogs.Answer answer;
        String name = (String)this.classifierNameComboBox.getSelectedItem();
        if (name != null && (answer = Dialogs.requestDecision((String)"Delete Classifier", (String)("Are you sure you want to delete classifier " + name), (boolean)true, null)).equals((Object)Dialogs.Answer.YES)) {
            Path classifierDir = this.getClassifierFolder();
            File classiferFile = classifierDir.resolve(name + ".class").toFile();
            if (classiferFile.exists()) {
                if (BaseClassifierOpUI.deleteClassifier(classiferFile, name)) {
                    this.classifierNameComboBox.removeItem(name);
                    if (this.classifierNameComboBox.getItemCount() == 0) {
                        this.trainBtn.setSelected(true);
                    }
                } else {
                    Dialogs.showError((String)("Unable to delete classifier " + classiferFile));
                }
            } else {
                Dialogs.showError((String)("Unable to find classifier " + classiferFile));
            }
        }
    }

    private static boolean deleteClassifier(File classifierFile, final String classifierName) {
        boolean ok = classifierFile.delete();
        File[] files = classifierFile.getParentFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return FileUtils.getFilenameWithoutExtension((File)pathname).equals(classifierName);
            }
        });
        if (files != null) {
            for (File file : files) {
                file.delete();
            }
        }
        return ok;
    }

    protected abstract void setEnabled(boolean var1);

    private void enableTrainOnRaster(boolean doTraining, boolean trainOnRaster) {
        if (doTraining) {
            if (trainOnRaster) {
                OperatorUIUtils.initParamList(this.trainingBands, (String[])this.getTrainingBands());
            } else {
                OperatorUIUtils.initParamList(this.trainingVectors, (String[])this.getPolygons());
            }
        }
        this.rasterPanel.setVisible(doTraining && trainOnRaster);
        this.vectorPanel.setVisible(doTraining && !trainOnRaster);
        this.featurePanel.setVisible(doTraining);
    }

    private void enableQuantization(boolean enable) {
        this.minClassValue.setEnabled(enable);
        this.classValStepSize.setEnabled(enable);
        this.classLevels.setEnabled(enable);
        this.maxClassValue.setEnabled(enable);
    }

    private void setEnableDoClassValQuantization(boolean enable) {
        this.doClassValQuantization.setEnabled(enable);
        this.minClassValue.setEnabled(enable && this.doClassValQuantization.isSelected());
        this.classValStepSize.setEnabled(enable && this.doClassValQuantization.isSelected());
        this.classLevels.setEnabled(enable && this.doClassValQuantization.isSelected());
        this.maxClassValue.setEnabled(enable && this.doClassValQuantization.isSelected());
    }

    private void enableTraining(boolean doTraining) {
        this.classifierNameComboBox.setEnabled(!doTraining);
        this.deleteClassiferBtn.setEnabled(!doTraining);
        this.newClassifierNameField.setEnabled(doTraining);
        this.setEnableDoClassValQuantization(doTraining);
        this.trainOnRasterBtn.setEnabled(doTraining);
        this.trainOnVectorsBtn.setEnabled(doTraining);
        this.numTrainSamples.setEnabled(doTraining);
        this.trainingBands.setEnabled(doTraining);
        if (!this.trainingBands.isEnabled()) {
            this.trainingBands.clearSelection();
        }
        this.trainingVectors.setEnabled(doTraining);
        if (!this.trainingVectors.isEnabled()) {
            this.trainingVectors.clearSelection();
        }
        this.featureBandNames.setEnabled(doTraining);
        this.setEnabled(doTraining);
    }

    private void updateMaxClassValue() {
        double minVal = Double.parseDouble(this.minClassValue.getText());
        double stepSize = Double.parseDouble(this.classValStepSize.getText());
        int levels = Integer.parseInt(this.classLevels.getText());
        double maxClassVal = BaseClassifier.getMaxValue((double)minVal, (double)stepSize, (int)levels);
        this.maxClassValue.setText(String.valueOf(maxClassVal));
    }

    public void initParameters() {
        Boolean trainOnRastersVal;
        Boolean doQuant;
        Boolean evalPS;
        String newClassifierName = (String)this.paramMap.get("savedClassifierName");
        if (DialogUtils.contains(this.classifierNameComboBox, (Object)newClassifierName)) {
            this.classifierNameComboBox.setSelectedItem(newClassifierName);
        }
        String numSamples = String.valueOf(this.paramMap.get("numTrainSamples"));
        this.numTrainSamples.setText(numSamples);
        Boolean eval = (Boolean)this.paramMap.get("evaluateClassifier");
        if (eval != null) {
            this.evaluateClassifier.setSelected(eval);
        }
        if ((evalPS = (Boolean)this.paramMap.get("evaluateFeaturePowerSet")) != null) {
            this.evaluateFeaturePowerSet.setSelected(evalPS);
        }
        if ((doQuant = (Boolean)this.paramMap.get("doClassValQuantization")) != null) {
            this.doClassValQuantization.setSelected(doQuant);
        }
        this.minClassValue.setText(String.valueOf(this.paramMap.get("minClassValue")));
        this.classValStepSize.setText(String.valueOf(this.paramMap.get("classValStepSize")));
        this.classLevels.setText(String.valueOf(this.paramMap.get("classLevels")));
        Double minVal = (Double)this.paramMap.get("minClassValue");
        Double stepSize = (Double)this.paramMap.get("classValStepSize");
        Integer levels = (Integer)this.paramMap.get("classLevels");
        if (minVal != null && stepSize != null && levels != null) {
            double maxClassVal = BaseClassifier.getMaxValue((double)minVal, (double)stepSize, (int)levels);
            this.maxClassValue.setText(String.valueOf(maxClassVal));
        }
        boolean trainOnRasters = (trainOnRastersVal = (Boolean)this.paramMap.get("trainOnRaster")) != null && trainOnRastersVal != false;
        this.trainOnRasterBtn.setSelected(trainOnRasters);
        String labelSource = (String)this.paramMap.get("labelSource");
        if (labelSource == null || labelSource.equals("VectorNodeName")) {
            this.labelSourceVectorName.setSelected(true);
        }
        boolean doTraining = true;
        this.enableTraining(doTraining);
        this.enableTrainOnRaster(doTraining, trainOnRasters);
        this.paramMap.put("bandsOrVectors", null);
        OperatorUIUtils.initParamList(this.featureBandNames, (String[])this.getFeatures());
    }

    public UIValidation validateParameters() {
        if (this.loadBtn.isSelected() || DialogUtils.contains(this.classifierNameComboBox, (Object)this.newClassifierNameField.getText())) {
            // empty if block
        }
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        this.paramMap.put("numTrainSamples", Integer.parseInt(this.numTrainSamples.getText()));
        this.paramMap.put("evaluateClassifier", this.evaluateClassifier.isSelected());
        this.paramMap.put("evaluateFeaturePowerSet", this.evaluateFeaturePowerSet.isSelected());
        this.paramMap.put("doClassValQuantization", this.doClassValQuantization.isSelected());
        this.paramMap.put("minClassValue", Double.parseDouble(this.minClassValue.getText()));
        this.paramMap.put("classValStepSize", Double.parseDouble(this.classValStepSize.getText()));
        this.paramMap.put("classLevels", Integer.parseInt(this.classLevels.getText()));
        this.paramMap.put("trainOnRaster", this.trainOnRasterBtn.isSelected());
        String classifierName = this.loadBtn.isSelected() ? (String)this.classifierNameComboBox.getSelectedItem() : this.newClassifierNameField.getText();
        this.paramMap.put("savedClassifierName", classifierName);
        if (this.labelSourceAttribute.isSelected()) {
            this.paramMap.put("labelSource", this.labelSourceAttribute.getText());
        } else {
            this.paramMap.put("labelSource", "VectorNodeName");
        }
        OperatorUIUtils.updateParamList(this.trainingBands, (Map)this.paramMap, (String)"trainingBands");
        OperatorUIUtils.updateParamList(this.trainingVectors, (Map)this.paramMap, (String)"trainingVectors");
        OperatorUIUtils.updateParamList(this.featureBandNames, (Map)this.paramMap, (String)"featureBands");
    }

    private static void dumpSelectedValues(String name, JList<String> paramList) {
        SystemUtils.LOG.info(name + " selected values:");
        List<String> selectedValues = paramList.getSelectedValuesList();
        for (String selectedValue : selectedValues) {
            SystemUtils.LOG.info(' ' + selectedValue);
        }
    }

    protected JPanel createPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        this.classifierPanel = this.createClassifierPanel();
        ++gbc.gridy;
        contentPane.add((Component)this.classifierPanel, gbc);
        this.rasterPanel = this.createRasterPanel();
        ++gbc.gridy;
        contentPane.add((Component)this.rasterPanel, gbc);
        this.vectorPanel = this.createVectorPanel();
        contentPane.add((Component)this.vectorPanel, gbc);
        this.featurePanel = this.createFeaturePanel();
        ++gbc.gridy;
        contentPane.add((Component)this.featurePanel, gbc);
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }

    private JPanel createClassifierPanel() {
        JPanel classifierPanel = new JPanel();
        classifierPanel.setLayout(new GridBagLayout());
        classifierPanel.setBorder(new TitledBorder("Classifier"));
        this.classifiergbc = DialogUtils.createGridBagConstraints();
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.trainBtn);
        group1.add(this.loadBtn);
        classifierPanel.add((Component)this.trainBtn, this.classifiergbc);
        this.classifiergbc.gridx = 1;
        classifierPanel.add((Component)this.newClassifierNameField, this.classifiergbc);
        this.classifiergbc.gridx = 0;
        this.classifiergbc.gridx = 0;
        ++this.classifiergbc.gridy;
        classifierPanel.add((Component)this.loadBtn, this.classifiergbc);
        this.classifiergbc.gridx = 1;
        classifierPanel.add(this.classifierNameComboBox, this.classifiergbc);
        this.classifiergbc.gridx = 2;
        classifierPanel.add((Component)this.deleteClassiferBtn, this.classifiergbc);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.trainOnRasterBtn);
        group2.add(this.trainOnVectorsBtn);
        JPanel radioPanel = new JPanel(new FlowLayout());
        radioPanel.add(this.trainOnRasterBtn);
        radioPanel.add(this.trainOnVectorsBtn);
        ++this.classifiergbc.gridy;
        this.classifiergbc.gridx = 1;
        classifierPanel.add((Component)radioPanel, this.classifiergbc);
        this.classifiergbc.gridx = 0;
        ++this.classifiergbc.gridy;
        DialogUtils.addComponent((JPanel)classifierPanel, (GridBagConstraints)this.classifiergbc, (String)"Evaluate classifier", (JComponent)this.evaluateClassifier);
        ++this.classifiergbc.gridy;
        DialogUtils.addComponent((JPanel)classifierPanel, (GridBagConstraints)this.classifiergbc, (String)"Evaluate Feature Power Set", (JComponent)this.evaluateFeaturePowerSet);
        ++this.classifiergbc.gridy;
        DialogUtils.addComponent((JPanel)classifierPanel, (GridBagConstraints)this.classifiergbc, (String)"Number of training samples", (JComponent)this.numTrainSamples);
        DialogUtils.fillPanel((JPanel)classifierPanel, (GridBagConstraints)this.classifiergbc);
        return classifierPanel;
    }

    private JPanel createRasterPanel() {
        JPanel rasterPanel = new JPanel();
        rasterPanel.setLayout(new GridBagLayout());
        rasterPanel.setBorder(new TitledBorder("Raster Training"));
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)rasterPanel, (GridBagConstraints)gbc, (String)"Quantize class value", (JComponent)this.doClassValQuantization);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)rasterPanel, (GridBagConstraints)gbc, (String)"Min class value", (JComponent)this.minClassValue);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)rasterPanel, (GridBagConstraints)gbc, (String)"Class value step size", (JComponent)this.classValStepSize);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)rasterPanel, (GridBagConstraints)gbc, (String)"Class levels", (JComponent)this.classLevels);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)rasterPanel, (GridBagConstraints)gbc, (String)"Max class value", (JComponent)this.maxClassValue);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)rasterPanel, (GridBagConstraints)gbc, (String)"Training band:", (JComponent)new JScrollPane(this.trainingBands));
        DialogUtils.fillPanel((JPanel)rasterPanel, (GridBagConstraints)gbc);
        return rasterPanel;
    }

    private JPanel createVectorPanel() {
        JPanel vectorPanel = new JPanel();
        vectorPanel.setLayout(new GridBagLayout());
        vectorPanel.setBorder(new TitledBorder("Vector Training"));
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)vectorPanel, (GridBagConstraints)gbc, (String)"Training vectors:     ", (JComponent)new JScrollPane(this.trainingVectors));
        ++gbc.gridy;
        gbc.gridx = 0;
        vectorPanel.add((Component)new JLabel("Labels:"), gbc);
        ButtonGroup group3 = new ButtonGroup();
        group3.add(this.labelSourceVectorName);
        group3.add(this.labelSourceAttribute);
        JPanel radioPanel = new JPanel(new FlowLayout());
        radioPanel.add(this.labelSourceVectorName);
        radioPanel.add(this.labelSourceAttribute);
        gbc.gridx = 1;
        vectorPanel.add((Component)radioPanel, gbc);
        DialogUtils.fillPanel((JPanel)vectorPanel, (GridBagConstraints)gbc);
        return vectorPanel;
    }

    private JPanel createFeaturePanel() {
        JPanel featurePanel = new JPanel();
        featurePanel.setBorder(new TitledBorder("Feature Selection"));
        featurePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        DialogUtils.addComponent((JPanel)featurePanel, (GridBagConstraints)gbc, (String)"Feature bands:       ", (JComponent)new JScrollPane(this.featureBandNames));
        DialogUtils.fillPanel((JPanel)featurePanel, (GridBagConstraints)gbc);
        return featurePanel;
    }

    private String[] getPolygons() {
        ArrayList<String> geometryNames = new ArrayList<String>(5);
        if (this.sourceProducts != null) {
            if (this.sourceProducts.length > 1) {
                for (String name : this.sourceProducts[0].getMaskGroup().getNodeNames()) {
                    geometryNames.add(name + "::" + this.sourceProducts[0].getName());
                }
            } else {
                geometryNames.addAll(Arrays.asList(this.sourceProducts[0].getMaskGroup().getNodeNames()));
            }
        }
        return geometryNames.toArray(new String[geometryNames.size()]);
    }

    private String[] getTrainingBands() {
        ArrayList<String> bandNames = new ArrayList<String>(5);
        if (this.sourceProducts != null) {
            if (this.sourceProducts.length > 1) {
                for (String name : this.sourceProducts[0].getBandNames()) {
                    bandNames.add(name + "::" + this.sourceProducts[0].getName());
                }
            } else {
                bandNames.addAll(Arrays.asList(this.sourceProducts[0].getBandNames()));
            }
        }
        return bandNames.toArray(new String[bandNames.size()]);
    }

    private String[] getFeatures() {
        ArrayList<String> featureNames = new ArrayList<String>(5);
        if (this.sourceProducts != null) {
            for (Product prod : this.sourceProducts) {
                for (String name : prod.getBandNames()) {
                    if (BaseClassifier.excludeBand((String)name)) continue;
                    if (this.sourceProducts.length > 1) {
                        featureNames.add(name + "::" + prod.getName());
                        continue;
                    }
                    featureNames.add(name);
                }
            }
        }
        return featureNames.toArray(new String[featureNames.size()]);
    }
}

