/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.watermask.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.common.reproject.ReprojectionOp;

public class ModisProductHandler {
    private final List<Product> products = new ArrayList<Product>();
    private final List<Product> reprojectedProducts = new ArrayList<Product>();
    private final String[] args;

    ModisProductHandler(String[] args) {
        this.args = args;
        GPF.getDefaultInstance().getOperatorSpiRegistry().loadOperatorSpis();
    }

    public static void main(String[] args) throws IOException {
        ModisProductHandler modisProductHandler = new ModisProductHandler(args);
        modisProductHandler.getProducts();
        modisProductHandler.reproject();
        modisProductHandler.write();
        modisProductHandler.printTargetLocations();
    }

    private void printTargetLocations() throws IOException {
        String source = "C:\\dev\\MODIS_reproj";
        String[] files = new File("C:\\dev\\MODIS_reproj").list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".dim");
            }
        });
        ArrayList<String> southProducts = new ArrayList<String>();
        ArrayList<String> northProducts = new ArrayList<String>();
        for (String file : files) {
            Product product = ProductIO.readProduct((File)new File("C:\\dev\\MODIS_reproj", file));
            GeoCoding geoCoding = product.getSceneGeoCoding();
            PixelPos sceneLL = new PixelPos(0.5, (double)((float)(product.getSceneRasterHeight() - 1) + 0.5f));
            PixelPos sceneLR = new PixelPos((double)((float)(product.getSceneRasterWidth() - 1) + 0.5f), (double)((float)(product.getSceneRasterHeight() - 1) + 0.5f));
            GeoPos gp1 = new GeoPos();
            GeoPos gp2 = new GeoPos();
            geoCoding.getGeoPos(sceneLL, gp1);
            geoCoding.getGeoPos(sceneLR, gp2);
            if (gp1.getLat() <= -60.0 || gp2.getLat() <= -60.0) {
                southProducts.add(product.getFileLocation().getAbsolutePath());
                continue;
            }
            PixelPos sceneUL = new PixelPos(0.5, 0.5);
            PixelPos sceneUR = new PixelPos((double)((float)(product.getSceneRasterWidth() - 1) + 0.5f), 0.5);
            geoCoding.getGeoPos(sceneUL, gp1);
            geoCoding.getGeoPos(sceneUR, gp2);
            if (!(gp1.getLat() >= 60.0) && !(gp2.getLat() >= 60.0)) continue;
            northProducts.add(product.getFileLocation().getAbsolutePath());
        }
        System.out.println("South:");
        for (String southProduct : southProducts) {
            System.out.println(southProduct);
        }
        System.out.println("North:");
        System.out.println("\n####################\n");
        for (String northProduct : northProducts) {
            System.out.println(northProduct);
        }
    }

    private void getProducts() throws IOException {
        String inputPath = this.args[0];
        File[] products = new File(inputPath).listFiles();
        GeoPos gp = new GeoPos();
        for (File file : products) {
            Product product = ProductIO.readProduct((File)file);
            PixelPos sceneLL = new PixelPos(0.5, (double)((float)(product.getSceneRasterHeight() - 1) + 0.5f));
            GeoCoding geoCoding = product.getSceneGeoCoding();
            geoCoding.getGeoPos(sceneLL, gp);
            if (gp.getLat() <= -60.0) {
                this.products.add(product);
                System.out.println(MessageFormat.format("Added product ''{0}'' to products because lower left lat is ''{1}''.", product.toString(), gp.getLat()));
                continue;
            }
            PixelPos sceneLR = new PixelPos((double)((float)(product.getSceneRasterWidth() - 1) + 0.5f), (double)((float)(product.getSceneRasterHeight() - 1) + 0.5f));
            geoCoding.getGeoPos(sceneLR, gp);
            if (gp.getLat() <= -60.0) {
                System.out.println(MessageFormat.format("Added product ''{0}'' to products because lower right lat is ''{1}''.", product.toString(), gp.getLat()));
                this.products.add(product);
                continue;
            }
            PixelPos sceneUL = new PixelPos(0.5, 0.5);
            geoCoding.getGeoPos(sceneUL, gp);
            if (gp.getLat() >= 60.0) {
                System.out.println(MessageFormat.format("Added product ''{0}'' to products because upper left lat is ''{1}''.", product.toString(), gp.getLat()));
                this.products.add(product);
                continue;
            }
            PixelPos sceneUR = new PixelPos((double)((float)(product.getSceneRasterWidth() - 1) + 0.5f), 0.5);
            geoCoding.getGeoPos(sceneUR, gp);
            if (!(gp.getLat() >= 60.0)) continue;
            System.out.println(MessageFormat.format("Added product ''{0}'' to products because upper right lat is ''{1}''.", product.toString(), gp.getLat()));
            this.products.add(product);
        }
    }

    private void reproject() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("crs", "EPSG:4326");
        for (Product belowSixtyProduct : this.products) {
            System.out.println("Reprojecting product '" + belowSixtyProduct + "'.");
            Product reprojectedProduct = GPF.createProduct((String)OperatorSpi.getOperatorAlias(ReprojectionOp.class), params, (Product)belowSixtyProduct);
            this.reprojectedProducts.add(reprojectedProduct);
        }
    }

    private void write() throws IOException {
        for (Product reprojectedProduct : this.reprojectedProducts) {
            System.out.println("Writing product '" + reprojectedProduct + "'.");
            reprojectedProduct.removeBand(reprojectedProduct.getBand("water_mask_QA"));
            ProductIO.writeProduct((Product)reprojectedProduct, (File)new File(this.args[1], this.getProductName(reprojectedProduct)), (String)"BEAM-DIMAP", (boolean)false);
        }
    }

    private String getProductName(Product reprojectedProduct) {
        return reprojectedProduct.getName();
    }
}

