/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.watermask.util;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Properties;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.image.ImageHeader;
import org.esa.snap.watermask.util.TemporaryMODISImage;

public class ModisMosaicer {
    static final int MODIS_IMAGE_WIDTH = 155520;
    static final int MODIS_IMAGE_HEIGHT = 12960;
    private static final int MODIS_TILE_WIDTH = 576;
    private static final int MODIS_TILE_HEIGHT = 480;
    static final int NORTH_MODE = 0;

    public static void main(String[] args) throws IOException {
        GPF.getDefaultInstance().getOperatorSpiRegistry().loadOperatorSpis();
        int mode = Integer.parseInt(args[0]);
        String pathname = mode == 0 ? "C:\\dev\\projects\\beam-watermask\\MODIS\\north" : "C:\\dev\\projects\\beam-watermask\\MODIS\\south";
        File[] files = new File(pathname).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".dim");
            }
        });
        Product[] products = new Product[files.length];
        int filesLength = files.length;
        for (int i = 0; i < filesLength; ++i) {
            Product product;
            products[i] = product = ProductIO.readProduct((File)files[i]);
        }
        int width = 155520;
        int height = 12960;
        Properties properties = new Properties();
        properties.setProperty("width", String.valueOf(width));
        properties.setProperty("dataType", "0");
        properties.setProperty("height", String.valueOf(height));
        properties.setProperty("tileWidth", String.valueOf(576));
        properties.setProperty("tileHeight", String.valueOf(480));
        ImageHeader imageHeader = ImageHeader.load((Properties)properties, null);
        TemporaryMODISImage temporaryMODISImage = new TemporaryMODISImage(imageHeader, products, mode);
        Product product = new Product("MODIS_lw", "lw", 155520, 12960);
        Band band = product.addBand("lw-mask", 20);
        band.setSourceImage((RenderedImage)((Object)temporaryMODISImage));
        String filePath = mode == 0 ? "C:\\temp\\modis_north.dim" : "C:\\temp\\modis_south.dim";
        ProductIO.writeProduct((Product)product, (String)filePath, (String)"BEAM-DIMAP");
    }
}

