/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.watermask.operator;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.esa.snap.core.dataop.downloadable.StatusProgressMonitor;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.watermask.operator.WatermaskConstants;

public class WatermaskUtils {
    private WatermaskUtils() {
    }

    public static int computeSideLength(int resolution) {
        int pixelXCount = 40024000 / resolution;
        int pixelXCountPerTile = pixelXCount / 360;
        int temp = pixelXCountPerTile / 8;
        return temp * 8;
    }

    public static String createImgFileName(float lat, float lon) {
        boolean geoPosIsWest = lon < 0.0f;
        boolean geoPosIsSouth = lat < 0.0f;
        StringBuilder result = new StringBuilder();
        String eastOrWest = geoPosIsWest ? "w" : "e";
        result.append(eastOrWest);
        int positiveLon = (int)Math.abs(Math.floor(lon));
        if (positiveLon >= 10 && positiveLon < 100) {
            result.append("0");
        } else if (positiveLon < 10) {
            result.append("00");
        }
        result.append(positiveLon);
        String northOrSouth = geoPosIsSouth ? "s" : "n";
        result.append(northOrSouth);
        int positiveLat = (int)Math.abs(Math.floor(lat));
        if (positiveLat < 10) {
            result.append("0");
        }
        result.append(positiveLat);
        result.append(".img");
        return result.toString();
    }

    public static boolean installRemoteHttpFiles(String baseUrl) throws IOException {
        for (String remoteFileName : WatermaskConstants.AUXDATA_FILENAMES) {
            File localZipFile = new File(WatermaskConstants.LOCAL_AUXDATA_PATH.toString(), remoteFileName);
            String remotePath = baseUrl + localZipFile.getName();
            SystemUtils.LOG.info("Checking for '" + localZipFile.getName() + "' ...");
            try {
                URL fileUrl = new URL(remotePath);
                URLConnection urlConnection = fileUrl.openConnection();
                if (!localZipFile.exists() || localZipFile.length() != (long)urlConnection.getContentLength()) {
                    SystemUtils.LOG.info("http retrieving " + remotePath);
                    WatermaskUtils.downloadHttpFile(fileUrl, urlConnection, localZipFile);
                    continue;
                }
                SystemUtils.LOG.info("Found '" + localZipFile.getName() + "'.");
            }
            catch (Exception e) {
                String message = "Mandatory auxdata file '" + localZipFile.getName() + "' could not be downloaded.";
                throw new OperatorException(message);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File downloadHttpFile(URL fileUrl, URLConnection urlConnection, File localZipFile) throws IOException {
        BufferedOutputStream os;
        File outputFile = new File(localZipFile.getParentFile(), new File(fileUrl.getFile()).getName());
        File parentFolder = localZipFile.getParentFile();
        if (!parentFolder.exists()) {
            parentFolder.mkdirs();
        }
        int contentLength = urlConnection.getContentLength();
        BufferedInputStream is = new BufferedInputStream(urlConnection.getInputStream(), contentLength);
        try {
            os = new BufferedOutputStream(new FileOutputStream(outputFile));
        }
        catch (IOException e) {
            ((InputStream)is).close();
            throw e;
        }
        try {
            int b;
            int n;
            StatusProgressMonitor status = new StatusProgressMonitor(StatusProgressMonitor.TYPE.DATA_TRANSFER);
            status.beginTask("Downloading " + localZipFile.getName() + "... ", contentLength);
            int size = 32768;
            byte[] buf = new byte[32768];
            while ((n = ((InputStream)is).read(buf, 0, 32768)) > -1) {
                ((OutputStream)os).write(buf, 0, n);
                status.worked(n);
            }
            status.done();
            while ((b = ((InputStream)is).read()) != -1) {
                ((OutputStream)os).write(b);
            }
        }
        catch (IOException e) {
            outputFile.delete();
            throw e;
        }
        finally {
            try {
                ((OutputStream)os).close();
            }
            finally {
                ((InputStream)is).close();
            }
        }
        return outputFile;
    }
}

