/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.watermask.operator;

import com.bc.ceres.core.Assert;
import java.awt.Point;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.media.jai.JAI;
import javax.media.jai.SourcelessOpImage;
import org.esa.snap.core.image.ImageHeader;
import org.esa.snap.core.util.ImageUtils;
import org.esa.snap.watermask.operator.WatermaskUtils;

public class SRTMOpImage
extends SourcelessOpImage {
    private ZipFile zipFile;
    private Properties missingTiles;
    private SampleModel rawImgSampleModel;
    private WritableRaster landRaster;
    private WritableRaster waterRaster;
    private WritableRaster invalidRaster;

    public static SRTMOpImage create(Properties defaultImageProperties, File zipFile) throws IOException {
        ImageHeader imageHeader = ImageHeader.load((Properties)defaultImageProperties, null);
        return new SRTMOpImage(imageHeader, zipFile);
    }

    private SRTMOpImage(ImageHeader imageHeader, File zipFile) throws IOException {
        super(imageHeader.getImageLayout(), null, ImageUtils.createSingleBandedSampleModel((int)0, (int)imageHeader.getImageLayout().getSampleModel(null).getWidth(), (int)imageHeader.getImageLayout().getSampleModel(null).getHeight()), imageHeader.getImageLayout().getMinX(null), imageHeader.getImageLayout().getMinY(null), imageHeader.getImageLayout().getWidth(null), imageHeader.getImageLayout().getHeight(null));
        this.zipFile = new ZipFile(zipFile);
        this.missingTiles = new Properties();
        this.missingTiles.load(((Object)((Object)this)).getClass().getResourceAsStream("MissingTiles.properties"));
        this.setTileCache(JAI.createTileCache((long)0x3200000L));
        this.rawImgSampleModel = imageHeader.getImageLayout().getSampleModel(null);
    }

    public Raster computeTile(int tileX, int tileY) {
        try {
            return this.readRawDataTile(tileX, tileY);
        }
        catch (IOException e) {
            String msg = MessageFormat.format("Failed to read image tile ''{0} | {1}''.", tileX, tileY);
            throw new RuntimeException(msg, e);
        }
    }

    public synchronized void dispose() {
        try {
            this.zipFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Raster readRawDataTile(int tileX, int tileY) throws IOException {
        boolean tileIsMissing;
        Point location = new Point(this.tileXToX(tileX), this.tileYToY(tileY));
        String imgFileName = WatermaskUtils.createImgFileName(89 - tileY, tileX - 180);
        String missingTileValue = this.missingTiles.getProperty(imgFileName.substring(0, imgFileName.indexOf(46)));
        boolean bl = tileIsMissing = missingTileValue != null;
        if (tileIsMissing) {
            byte tileValue = Byte.parseByte(missingTileValue);
            switch (tileValue) {
                case 0: {
                    return this.getLandRaster(location, tileValue);
                }
                case 1: {
                    return this.getWaterRaster(location, tileValue);
                }
            }
            return this.getInvalidRaster(location, tileValue);
        }
        WritableRaster targetRaster = this.createWritableRaster(this.rawImgSampleModel, location);
        byte[] data = ((DataBufferByte)targetRaster.getDataBuffer()).getData();
        try (InputStream inputStream = this.createInputStream(imgFileName);){
            int count;
            int amount = data.length;
            for (count = 0; count < data.length; count += inputStream.read(data, count, amount)) {
                if (count + amount <= data.length) continue;
                amount = data.length - count;
            }
            Assert.state((count == data.length ? 1 : 0) != 0, (String)"Not all data have been read.");
        }
        return targetRaster;
    }

    private Raster getLandRaster(Point location, byte tileValue) {
        if (this.landRaster == null) {
            this.landRaster = this.createRaster(tileValue);
        }
        return this.landRaster.createTranslatedChild(location.x, location.y);
    }

    private Raster getWaterRaster(Point location, byte tileValue) {
        if (this.waterRaster == null) {
            this.waterRaster = this.createRaster(tileValue);
        }
        return this.waterRaster.createTranslatedChild(location.x, location.y);
    }

    private Raster getInvalidRaster(Point location, byte tileValue) {
        if (this.invalidRaster == null) {
            this.invalidRaster = this.createRaster(tileValue);
        }
        return this.invalidRaster.createTranslatedChild(location.x, location.y);
    }

    private WritableRaster createRaster(byte tileValue) {
        WritableRaster raster = this.createWritableRaster(this.sampleModel, new Point(0, 0));
        byte[] data = ((DataBufferByte)raster.getDataBuffer()).getData();
        Arrays.fill(data, tileValue);
        return raster;
    }

    private InputStream createInputStream(String imgFileName) throws IOException {
        ZipEntry entry = this.zipFile.getEntry(imgFileName);
        return this.zipFile.getInputStream(entry);
    }
}

