/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.smart.configurator.ui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.smart.configurator.ui.PerformanceOptionsPanelController;
import org.esa.snap.smart.configurator.ui.PerformancePanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SmartConfigurator
extends JFrame
implements PropertyChangeListener {
    private PerformancePanel performancePanel;
    PerformanceOptionsPanelController controller;
    JButton okButton;

    public SmartConfigurator() {
        this.initComponents();
    }

    private void initComponents() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            SystemUtils.LOG.warning("Could not set up look&feel: " + e.getMessage());
        }
        JPanel jPanel1 = new JPanel();
        this.okButton = new JButton();
        JButton cancelButton = new JButton();
        this.controller = new PerformanceOptionsPanelController();
        this.controller.addPropertyChangeListener(this);
        this.performancePanel = new PerformancePanel(this.controller);
        this.performancePanel.load();
        jPanel1.setLayout(new FlowLayout(2));
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)NbBundle.getMessage(SmartConfigurator.class, (String)"SmartConfigurator.okButton.text"));
        this.okButton.addActionListener(this::okButtonActionPerformed);
        jPanel1.add(this.okButton);
        Mnemonics.setLocalizedText((AbstractButton)cancelButton, (String)NbBundle.getMessage(SmartConfigurator.class, (String)"SmartConfigurator.cancelButton.text"));
        cancelButton.addActionListener(this::cancelButtonActionPerformed);
        jPanel1.add(cancelButton);
        this.getContentPane().add((Component)jPanel1, "South");
        this.getContentPane().add((Component)this.performancePanel, "Center");
        this.setDefaultCloseOperation(3);
        this.setIconImage(new ImageIcon(this.getClass().getResource("SnapSmall.gif")).getImage());
        this.setTitle("SNAP Performance Configuration Optimisation");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.performancePanel.store();
        System.exit(0);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.performancePanel.valid()) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(() -> new SmartConfigurator().setVisible(true));
    }
}

