/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.arcbin;

import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.esa.snap.dataio.arcbin.TileIndex;

class RasterDataFile {
    static final String FILE_NAME = "w001001.adf";
    private final ImageInputStream imageInputStream;

    private RasterDataFile(ImageInputStream imageInputStream) {
        this.imageInputStream = imageInputStream;
    }

    void close() throws IOException {
        this.imageInputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] loadRawTileData(TileIndex.IndexEntry indexEntry) throws IOException {
        byte[] bytes = new byte[indexEntry.size + 2];
        ImageInputStream imageInputStream = this.imageInputStream;
        synchronized (imageInputStream) {
            this.imageInputStream.seek(indexEntry.offset);
            this.imageInputStream.read(bytes);
        }
        return bytes;
    }

    static RasterDataFile create(File file) throws IOException {
        FileImageInputStream imageInputStream = new FileImageInputStream(file);
        imageInputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
        return new RasterDataFile(imageInputStream);
    }
}

