/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.arcbin;

import com.bc.ceres.binio.util.ByteArrayCodec;
import com.sun.media.imageioimpl.plugins.tiff.TIFFFaxDecompressor;
import com.sun.media.jai.codec.ByteArraySeekableStream;
import java.awt.Dimension;
import java.awt.image.DataBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.text.MessageFormat;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.esa.snap.core.dataio.ProductIOException;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.dataio.arcbin.GridTileProvider;
import org.esa.snap.dataio.arcbin.RasterDataFile;
import org.esa.snap.dataio.arcbin.TileIndex;

class IntegerGridTileProvider
implements GridTileProvider {
    private static final ByteArrayCodec byteArrayCodec = ByteArrayCodec.getInstance((ByteOrder)ByteOrder.BIG_ENDIAN);
    private final RasterDataFile rasterDataFile;
    private final TileIndex tileIndex;
    private final int nodataValue;
    private final int size;
    private final int productDataType;
    private final Dimension gridTileSize;

    IntegerGridTileProvider(RasterDataFile rasterDataFile, TileIndex tileIndex, int nodataValue, Dimension gridTileSize, int productDataType) {
        this.rasterDataFile = rasterDataFile;
        this.tileIndex = tileIndex;
        this.nodataValue = nodataValue;
        this.gridTileSize = gridTileSize;
        this.size = gridTileSize.width * gridTileSize.height;
        this.productDataType = productDataType;
    }

    @Override
    public ProductData getData(int currentTileIndex) {
        ProductData dataBuffer = ProductData.createInstance((int)this.productDataType, (int)this.size);
        TileIndex.IndexEntry indexEntry = this.tileIndex.getIndexEntry(currentTileIndex);
        if (indexEntry == null) {
            this.fillBuffer(dataBuffer, this.nodataValue);
        } else {
            try {
                byte[] rawTileData = this.rasterDataFile.loadRawTileData(indexEntry);
                int tileType = rawTileData[2] & 0xFF;
                int minSize = this.getMinSize(rawTileData);
                int min = 0;
                if (minSize > 0) {
                    min = this.getMin(minSize, rawTileData);
                }
                int tileDataSize = indexEntry.size - 2 - minSize;
                int tileOffset = 4 + minSize;
                switch (tileType) {
                    case 0: {
                        this.fillBuffer(dataBuffer, min);
                        break;
                    }
                    case 1: {
                        this.handleRaw1Bit(dataBuffer, rawTileData, min, tileOffset);
                        break;
                    }
                    case 4: {
                        this.handleRaw4Bit(dataBuffer, rawTileData, min, tileOffset);
                        break;
                    }
                    case 8: {
                        this.handleRaw8Bit(dataBuffer, rawTileData, min, tileOffset);
                        break;
                    }
                    case 16: {
                        this.handleRaw16Bit(dataBuffer, rawTileData, min, tileOffset);
                        break;
                    }
                    case 32: {
                        this.handleRaw32Bit(dataBuffer, rawTileData, min, tileOffset);
                        break;
                    }
                    case 248: 
                    case 252: {
                        this.handleRle8Bit(dataBuffer, rawTileData, min, tileOffset);
                        break;
                    }
                    case 240: {
                        this.handleRle16Bit(dataBuffer, rawTileData, min, tileOffset);
                        break;
                    }
                    case 224: {
                        this.handleRle32Bit(dataBuffer, rawTileData, min, tileOffset);
                        break;
                    }
                    case 223: {
                        this.handleRunMin(dataBuffer, rawTileData, min, tileOffset);
                        break;
                    }
                    case 215: {
                        this.handleRun8Bit(dataBuffer, rawTileData, min, tileOffset);
                        break;
                    }
                    case 207: {
                        this.handleRun16Bit(dataBuffer, rawTileData, min, tileOffset);
                        break;
                    }
                    case 255: {
                        this.handleCCITT(dataBuffer, rawTileData, min, tileDataSize, tileOffset);
                        break;
                    }
                    default: {
                        this.fillBuffer(dataBuffer, this.nodataValue);
                        break;
                    }
                }
            }
            catch (IOException ignored) {
                this.fillBuffer(dataBuffer, this.nodataValue);
            }
        }
        return dataBuffer;
    }

    private void handleCCITT(ProductData dataBuffer, byte[] rawTileData, int min, int tileDataSize, int tileOffset) throws IOException {
        byte[] buffer = this.decompressCCITT(rawTileData, tileOffset, tileDataSize);
        this.handleRaw1Bit(dataBuffer, buffer, min, 0);
    }

    private void handleRunMin(ProductData dataBuffer, byte[] rawTileData, int min, int tileOffset) {
        int count = 0;
        int value = 0;
        for (int i = 0; i < this.size; ++i) {
            if (count == 0) {
                if ((count = rawTileData[tileOffset++] & 0xFF) < 128) {
                    value = min;
                } else {
                    count = 256 - count;
                    value = this.nodataValue;
                }
            }
            dataBuffer.setElemIntAt(i, value);
            --count;
        }
    }

    private void handleRun8Bit(ProductData dataBuffer, byte[] rawTileData, int min, int tileOffset) {
        int count = 0;
        int value = 0;
        boolean readData = true;
        for (int i = 0; i < this.size; ++i) {
            if (count == 0) {
                if ((count = rawTileData[tileOffset++] & 0xFF) < 128) {
                    readData = true;
                } else {
                    count = 256 - count;
                    value = this.nodataValue;
                    readData = false;
                }
            }
            if (readData) {
                value = (rawTileData[tileOffset++] & 0xFF) + min;
            }
            dataBuffer.setElemIntAt(i, value);
            --count;
        }
    }

    private void handleRun16Bit(ProductData dataBuffer, byte[] rawTileData, int min, int tileOffset) {
        int count = 0;
        int value = 0;
        boolean readData = true;
        for (int i = 0; i < this.size; ++i) {
            if (count == 0) {
                if ((count = rawTileData[tileOffset++] & 0xFF) < 128) {
                    readData = true;
                } else {
                    count = 256 - count;
                    value = this.nodataValue;
                    readData = false;
                }
            }
            if (readData) {
                value = byteArrayCodec.getByte(rawTileData, tileOffset) + min;
                tileOffset += 2;
            }
            dataBuffer.setElemIntAt(i, value);
            --count;
        }
    }

    private void handleRle32Bit(ProductData dataBuffer, byte[] rawTileData, int min, int tileOffset) {
        int count = 0;
        int value = 0;
        for (int i = 0; i < this.size; ++i) {
            if (count == 0) {
                count = rawTileData[tileOffset++] & 0xFF;
                value = byteArrayCodec.getInt(rawTileData, tileOffset) + min;
                tileOffset += 4;
            }
            dataBuffer.setElemIntAt(i, value);
            --count;
        }
    }

    private void handleRle16Bit(ProductData dataBuffer, byte[] rawTileData, int min, int tileOffset) {
        int count = 0;
        int value = 0;
        for (int i = 0; i < this.size; ++i) {
            if (count == 0) {
                count = rawTileData[tileOffset++] & 0xFF;
                value = byteArrayCodec.getShort(rawTileData, tileOffset) + min;
                tileOffset += 2;
            }
            dataBuffer.setElemIntAt(i, value);
            --count;
        }
    }

    private void handleRle8Bit(ProductData dataBuffer, byte[] rawTileData, int min, int tileOffset) {
        int count = 0;
        int value = 0;
        for (int i = 0; i < this.size; ++i) {
            if (count == 0) {
                count = rawTileData[tileOffset++] & 0xFF;
                value = (rawTileData[tileOffset++] & 0xFF) + min;
            }
            dataBuffer.setElemIntAt(i, value);
            --count;
        }
    }

    private void handleRaw32Bit(ProductData dataBuffer, byte[] rawTileData, int min, int tileOffset) {
        for (int i = 0; i < this.size; ++i) {
            int value = byteArrayCodec.getInt(rawTileData, tileOffset);
            tileOffset += 4;
            dataBuffer.setElemIntAt(i, value + min);
        }
    }

    private void handleRaw16Bit(ProductData dataBuffer, byte[] rawTileData, int min, int tileOffset) {
        for (int i = 0; i < this.size; ++i) {
            short value = byteArrayCodec.getShort(rawTileData, tileOffset);
            tileOffset += 2;
            dataBuffer.setElemIntAt(i, value + min);
        }
    }

    private void handleRaw8Bit(ProductData dataBuffer, byte[] rawTileData, int min, int tileOffset) {
        for (int i = 0; i < this.size; ++i) {
            dataBuffer.setElemIntAt(i, rawTileData[tileOffset++] + min);
        }
    }

    private void handleRaw4Bit(ProductData dataBuffer, byte[] rawTileData, int min, int tileOffset) {
        int rawValue = 0;
        for (int i = 0; i < this.size; ++i) {
            int value;
            if (i % 2 == 0) {
                rawValue = rawTileData[tileOffset++] & 0xFF;
                value = (rawValue & 0xF0) >> 4;
            } else {
                value = rawValue & 0xF;
            }
            dataBuffer.setElemIntAt(i, value + min);
        }
    }

    private void handleRaw1Bit(ProductData dataBuffer, byte[] rawTileData, int min, int tileOffset) {
        for (int i = 0; i < this.size; ++i) {
            if ((rawTileData[tileOffset + (i >> 3)] & 128 >> (i & 7)) != 0) {
                dataBuffer.setElemIntAt(i, min + 1);
                continue;
            }
            dataBuffer.setElemIntAt(i, min);
        }
    }

    @Override
    public void transferData(ProductData data, int sourceIndex, DataBuffer dataBuffer, int targetIndex) {
        int value = data.getElemIntAt(sourceIndex);
        dataBuffer.setElem(targetIndex, value);
    }

    int getMinSize(byte[] bytes) {
        return bytes[3];
    }

    int getMin(int minSize, byte[] bytes) throws ProductIOException {
        if (minSize > 4) {
            throw new ProductIOException(MessageFormat.format("Corrupt 'minsize' of %d in block header.  Read aborted.", minSize));
        }
        int min = 0;
        if (minSize == 4) {
            min = byteArrayCodec.getInt(bytes, 4);
        } else {
            for (int i = 0; i < minSize; ++i) {
                min = min * 256 + bytes[4 + i];
            }
            if (bytes[4] > 127) {
                if (minSize == 2) {
                    min -= 65536;
                } else if (minSize == 1) {
                    min -= 256;
                } else if (minSize == 3) {
                    min -= 0x1000000;
                }
            }
        }
        return min;
    }

    private void fillBuffer(ProductData data, int value) {
        for (int i = 0; i < this.size; ++i) {
            data.setElemIntAt(i, value);
        }
    }

    private byte[] decompressCCITT(byte[] rawTileData, int tileOffset, int tileDataSize) throws IOException {
        ByteArraySeekableStream stream = new ByteArraySeekableStream(rawTileData, tileOffset, tileDataSize);
        TIFFFaxDecompressorExtension decompressor = new TIFFFaxDecompressorExtension(tileOffset, tileDataSize);
        MemoryCacheImageInputStream imageInputStream = new MemoryCacheImageInputStream((InputStream)stream);
        decompressor.setStream(imageInputStream);
        byte[] buffer = new byte[this.size / 8];
        decompressor.decodeRaw(buffer, 0, 1, this.gridTileSize.width / 8);
        return buffer;
    }

    private static final class TIFFFaxDecompressorExtension
    extends TIFFFaxDecompressor {
        TIFFFaxDecompressorExtension(int tileOffset, int tileDataSize) {
            this.compression = 2;
            this.fillOrder = 1;
            this.srcHeight = 4;
            this.srcWidth = 256;
            this.byteCount = tileDataSize;
            this.offset = tileOffset;
        }
    }
}

