/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.arcbin;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.WritableRaster;
import javax.media.jai.PlanarImage;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.image.ResolutionLevel;
import org.esa.snap.core.image.SingleBandedOpImage;
import org.esa.snap.dataio.arcbin.GridTileProvider;
import org.esa.snap.dataio.arcbin.Header;

class GridTileOpImage
extends SingleBandedOpImage {
    private final Header header;
    private final Dimension gridTileSize;
    private final GridTileProvider gridTileProvider;

    GridTileOpImage(int sourceWidth, int sourceHeight, Dimension imageTileSize, int databufferType, ResolutionLevel level, Header header, Dimension gridTileSize, GridTileProvider gridTileProvider) {
        super(databufferType, sourceWidth, sourceHeight, imageTileSize, null, level);
        this.header = header;
        this.gridTileSize = gridTileSize;
        this.gridTileProvider = gridTileProvider;
    }

    protected final void computeRect(PlanarImage[] planarImages, WritableRaster targetRaster, Rectangle rectangle) {
        DataBuffer dataBuffer = targetRaster.getDataBuffer();
        int tileXStart = this.xToGridTileX(targetRaster.getMinX());
        int tileXEnd = this.xToGridTileX(targetRaster.getMinX() + targetRaster.getWidth() - 1);
        int tileYStart = this.yToGridTileY(targetRaster.getMinY());
        int tileYEnd = this.yToGridTileY(targetRaster.getMinY() + targetRaster.getHeight() - 1);
        int subsampling = (int)this.getScale();
        double tileStepY = Math.ceil((double)subsampling / (double)this.gridTileSize.height);
        double tileStepX = Math.ceil((double)subsampling / (double)this.gridTileSize.width);
        int tileY = tileYStart;
        while (tileY <= tileYEnd) {
            int sourceY = this.gridTileYToY(tileY);
            int tileIndexY = sourceY / this.header.tileYSize * this.header.tilesPerRow;
            int numTilesY = tileY - tileYStart;
            int numLines = (int)Math.ceil((double)(numTilesY * this.gridTileSize.height) / (double)subsampling);
            int rasterOffsetY = numLines * targetRaster.getWidth();
            int tileX = tileXStart;
            while (tileX <= tileXEnd) {
                int sourceX = this.gridTileXToX(tileX);
                int gridTileIndex = sourceX / this.header.tileXSize + tileIndexY;
                ProductData data = this.gridTileProvider.getData(gridTileIndex);
                int numTilesX = tileX - tileXStart;
                int rasterOffset = rasterOffsetY + numTilesX * this.gridTileSize.width / subsampling;
                int writtenLines = 0;
                for (int y = 0; y < this.gridTileSize.height; y += subsampling) {
                    int targetIndex = rasterOffset + writtenLines * targetRaster.getWidth();
                    for (int x = 0; x < this.gridTileSize.width; x += subsampling) {
                        int sourceIndex = x + y * this.gridTileSize.width;
                        this.gridTileProvider.transferData(data, sourceIndex, dataBuffer, targetIndex);
                        ++targetIndex;
                    }
                    ++writtenLines;
                }
                tileX = (int)((double)tileX + tileStepX);
            }
            tileY = (int)((double)tileY + tileStepY);
        }
    }

    private int gridTileXToX(int tileX) {
        return tileX * this.gridTileSize.width;
    }

    private int gridTileYToY(int tileY) {
        return tileY * this.gridTileSize.height;
    }

    private int yToGridTileY(int targetY) {
        return this.getSourceY(targetY) / this.gridTileSize.height;
    }

    private int xToGridTileX(int targetX) {
        return this.getSourceX(targetX) / this.gridTileSize.width;
    }
}

