/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.arcbin;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.CompoundMember;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.DataFormat;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.TypeBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;

public class GeorefBounds {
    public static final String FILE_NAME = "dblbnd.adf";
    private static final CompoundType TYPE = TypeBuilder.COMPOUND((String)"GeorefBounds", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"D_LLX", (Type)TypeBuilder.DOUBLE), TypeBuilder.MEMBER((String)"D_LLY", (Type)TypeBuilder.DOUBLE), TypeBuilder.MEMBER((String)"D_URX", (Type)TypeBuilder.DOUBLE), TypeBuilder.MEMBER((String)"D_URY", (Type)TypeBuilder.DOUBLE)});
    public final double lowerLeftX;
    public final double lowerLeftY;
    public final double upperRightX;
    public final double upperRightY;

    private GeorefBounds(double lowerLeftX, double lowerLeftY, double upperRightX, double upperRightY) {
        this.lowerLeftX = lowerLeftX;
        this.lowerLeftY = lowerLeftY;
        this.upperRightX = upperRightX;
        this.upperRightY = upperRightY;
    }

    public static GeorefBounds create(File file) throws IOException {
        DataFormat dataFormat = new DataFormat(TYPE, ByteOrder.BIG_ENDIAN);
        DataContext context = dataFormat.createContext(file, "r");
        CompoundData data = context.createData();
        GeorefBounds georefBounds = new GeorefBounds(data.getDouble(0), data.getDouble(1), data.getDouble(2), data.getDouble(3));
        context.dispose();
        return georefBounds;
    }
}

