/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.arcbin;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.dataio.arcbin.RasterStatistics;

class ColorPalette {
    private ColorPalette() {
    }

    static File findColorPaletteFile(File gridDir) {
        ColorPaletteFilenameFilter filter = new ColorPaletteFilenameFilter();
        File result = ColorPalette.findFileInDir(gridDir, filter);
        if (result == null) {
            result = ColorPalette.findFileInDir(gridDir.getParentFile(), filter);
        }
        return result;
    }

    private static File findFileInDir(File dir, FilenameFilter filter) {
        File[] fileList = dir.listFiles(filter);
        if (fileList.length > 0) {
            return fileList[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ColorPaletteDef createColorPalette(File file, RasterStatistics statistics) {
        BufferedReader reader = null;
        ArrayList<ColorPaletteDef.Point> pointList = new ArrayList<ColorPaletteDef.Point>();
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            while (line != null) {
                String[] lineElems;
                if (!(line = line.trim()).startsWith("#") && !line.isEmpty() && (lineElems = line.split("\\s+")).length == 4) {
                    try {
                        int sample = Integer.valueOf(lineElems[0]);
                        if (statistics != null && (double)sample >= statistics.min && (double)sample <= statistics.max) {
                            int red = Integer.valueOf(lineElems[1]);
                            int green = Integer.valueOf(lineElems[2]);
                            int blue = Integer.valueOf(lineElems[3]);
                            ColorPaletteDef.Point point = new ColorPaletteDef.Point();
                            point.setSample((double)sample);
                            point.setLabel("class_" + sample);
                            point.setColor(new Color(red, green, blue));
                            pointList.add(point);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                line = reader.readLine();
            }
        }
        catch (IOException ignored) {
            ColorPaletteDef lineElems = null;
            return lineElems;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        if (!pointList.isEmpty()) {
            int numPoints = pointList.size();
            ColorPaletteDef.Point[] points = pointList.toArray(new ColorPaletteDef.Point[numPoints]);
            return new ColorPaletteDef(points);
        }
        return null;
    }

    static IndexCoding createIndexCoding(ColorPaletteDef colorPaletteDef, Map<Integer, String> descriptionMap) {
        ColorPaletteDef.Point[] points;
        IndexCoding indexCoding = new IndexCoding("index_coding");
        for (ColorPaletteDef.Point point : points = colorPaletteDef.getPoints()) {
            int sample = (int)point.getSample();
            String name = "class_ " + sample;
            indexCoding.addIndex(name, sample, descriptionMap.get(sample));
        }
        return indexCoding;
    }

    private static final class ColorPaletteFilenameFilter
    implements FilenameFilter {
        private ColorPaletteFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".clr") || name.endsWith(".CLR");
        }
    }
}

