/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.arcbin;

import java.io.File;
import java.util.Locale;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.dataio.arcbin.ArcBinGridReader;

public class ArcBinGridReaderPlugIn
implements ProductReaderPlugIn {
    private static final String DESCRIPTION = "ArcInfo Binary Grids";
    private static final String[] FILE_EXTENSIONS = new String[]{""};
    private static final String FORMAT_NAME = "ARC_INFO_BIN_GRID";
    private static final String[] FORMAT_NAMES = new String[]{"ARC_INFO_BIN_GRID"};
    private static final Class[] INPUT_TYPES = new Class[]{String.class, File.class};
    private static final SnapFileFilter FILE_FILTER = new ArcBinGridFileFilter();

    public DecodeQualification getDecodeQualification(Object input) {
        File file = new File(String.valueOf(input));
        if (ArcBinGridReaderPlugIn.isGridDirectory(file.getParentFile())) {
            return DecodeQualification.INTENDED;
        }
        return DecodeQualification.UNABLE;
    }

    public Class[] getInputTypes() {
        return INPUT_TYPES;
    }

    public ProductReader createReaderInstance() {
        return new ArcBinGridReader(this);
    }

    public String[] getFormatNames() {
        return FORMAT_NAMES;
    }

    public String[] getDefaultFileExtensions() {
        return FILE_EXTENSIONS;
    }

    public String getDescription(Locale locale) {
        return DESCRIPTION;
    }

    public SnapFileFilter getProductFileFilter() {
        return FILE_FILTER;
    }

    static boolean isGridDirectory(File dir) {
        if (dir == null) {
            return false;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        if (ArcBinGridReader.getCaseInsensitiveFile(dir, "hdr.adf") == null) {
            return false;
        }
        if (ArcBinGridReader.getCaseInsensitiveFile(dir, "dblbnd.adf") == null) {
            return false;
        }
        if (ArcBinGridReader.getCaseInsensitiveFile(dir, "w001001x.adf") == null) {
            return false;
        }
        return ArcBinGridReader.getCaseInsensitiveFile(dir, "w001001.adf") != null;
    }

    private static class ArcBinGridFileFilter
    extends SnapFileFilter {
        private ArcBinGridFileFilter() {
            this.setFormatName(FORMAT_NAMES[0]);
            this.setDescription(ArcBinGridReaderPlugIn.DESCRIPTION);
        }

        public boolean accept(File file) {
            return file.isDirectory() || ArcBinGridReaderPlugIn.isGridDirectory(file.getParentFile());
        }
    }
}

