/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio.srtm3_geotiff;

import java.io.File;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.dataop.dem.BaseElevationModel;
import org.esa.snap.core.dataop.dem.ElevationFile;
import org.esa.snap.core.dataop.dem.ElevationModelDescriptor;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.dem.dataio.srtm3_geotiff.SRTM3GeoTiffElevationModelDescriptor;
import org.esa.snap.dem.dataio.srtm3_geotiff.SRTM3GeoTiffFile;

public final class SRTM3GeoTiffElevationModel
extends BaseElevationModel {
    private static final String DB_FILE_SUFFIX = ".tif";
    private static final ProductReaderPlugIn productReaderPlugIn = SRTM3GeoTiffElevationModel.getReaderPlugIn((String)"GeoTIFF");

    public SRTM3GeoTiffElevationModel(SRTM3GeoTiffElevationModelDescriptor descriptor, Resampling resamplingMethod) {
        super((ElevationModelDescriptor)descriptor, resamplingMethod);
        this.setMaxCacheSize(12);
    }

    public double getIndexX(GeoPos geoPos) {
        return (geoPos.lon + 180.0) * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILEinv;
    }

    public double getIndexY(GeoPos geoPos) {
        return (60.0 - geoPos.lat) * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILEinv;
    }

    public GeoPos getGeoPos(PixelPos pixelPos) {
        double pixelLat = ((double)this.RASTER_HEIGHT - pixelPos.y) * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE - 60.0;
        double pixelLon = pixelPos.x * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE - 180.0;
        return new GeoPos(pixelLat, pixelLon);
    }

    protected void createElevationFile(ElevationFile[][] elevationFiles, int x, int y, File demInstallDir) {
        String fileName = this.createTileFilename(x + 1, y + 1);
        File localFile = new File(demInstallDir, fileName);
        elevationFiles[x][y] = new SRTM3GeoTiffFile(this, localFile, productReaderPlugIn.createReaderInstance());
    }

    private String createTileFilename(int tileX, int tileY) {
        StringBuilder name = new StringBuilder("srtm_");
        if (tileX < 10) {
            name.append('0');
        }
        name.append(tileX);
        name.append('_');
        if (tileY < 10) {
            name.append('0');
        }
        name.append(tileY);
        name.append(DB_FILE_SUFFIX);
        return name.toString();
    }
}

