/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio.srtm1_hgt;

import java.io.File;
import java.io.IOException;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.dataop.dem.ElevationFile;
import org.esa.snap.core.dataop.dem.ElevationTile;
import org.esa.snap.dem.dataio.srtm1_hgt.SRTM1HgtElevationModel;
import org.esa.snap.dem.dataio.srtm1_hgt.SRTM1HgtElevationTile;
import org.esa.snap.engine_utilities.util.Settings;

public final class SRTM1HgtFile
extends ElevationFile {
    private final SRTM1HgtElevationModel demModel;
    private static final String remoteHTTP = Settings.instance().get("DEM.srtm1HgtDEM_HTTP", "http://step.esa.int/auxdata/dem/SRTMGL1/");

    public SRTM1HgtFile(SRTM1HgtElevationModel model, File localFile, ProductReader reader) {
        super(localFile, reader);
        this.demModel = model;
    }

    protected ElevationTile createTile(Product product) throws IOException {
        SRTM1HgtElevationTile tile = new SRTM1HgtElevationTile(this.demModel, product);
        this.demModel.updateCache((ElevationTile)tile);
        return tile;
    }

    protected Boolean getRemoteFile() throws IOException {
        return this.getRemoteHttpFile(remoteHTTP);
    }
}

