/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio.aster;

import org.esa.snap.core.dataop.dem.AbstractElevationModelDescriptor;
import org.esa.snap.core.dataop.dem.ElevationModel;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.dem.dataio.aster.AsterElevationModel;

public class AsterElevationModelDescriptor
extends AbstractElevationModelDescriptor {
    private static final String NAME = "ASTER 1sec GDEM";
    private static final int NUM_X_TILES = 360;
    private static final int NUM_Y_TILES = 166;
    private static final int DEGREE_RES = 1;
    private static final int PIXEL_RES = 3600;
    private static final int NO_DATA_VALUE = -9999;
    private static final int RASTER_WIDTH = 1296000;
    private static final int RASTER_HEIGHT = 597600;

    public String getName() {
        return NAME;
    }

    public int getNumXTiles() {
        return 360;
    }

    public int getNumYTiles() {
        return 166;
    }

    public float getNoDataValue() {
        return -9999.0f;
    }

    public int getRasterWidth() {
        return 1296000;
    }

    public int getRasterHeight() {
        return 597600;
    }

    public int getTileWidthInDegrees() {
        return 1;
    }

    public int getTileWidth() {
        return 3600;
    }

    public boolean canBeDownloaded() {
        return false;
    }

    public ElevationModel createDem(Resampling resamplingMethod) {
        try {
            return new AsterElevationModel(this, resamplingMethod);
        }
        catch (Exception e) {
            return null;
        }
    }
}

