/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio.ace2_5min;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.io.FileUtils;

public class ACE2_5MinFileInfo {
    private static final EastingNorthingParser PARSER = new EastingNorthingParser();
    private String _fileName;
    private long _fileSize;
    private float _easting;
    private float _northing;
    private float _pixelSizeX;
    private float _pixelSizeY;
    private int _width;
    private int _height;
    private float _noDataValue;

    private ACE2_5MinFileInfo() {
    }

    public String getFileName() {
        return this._fileName;
    }

    public long getFileSize() {
        return this._fileSize;
    }

    public float getEasting() {
        return this._easting;
    }

    public float getNorthing() {
        return this._northing;
    }

    public float getPixelSizeX() {
        return this._pixelSizeX;
    }

    public float getPixelSizeY() {
        return this._pixelSizeY;
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public float getNoDataValue() {
        return this._noDataValue;
    }

    public static ACE2_5MinFileInfo create(File file) throws IOException {
        return ACE2_5MinFileInfo.createFromDataFile(file);
    }

    private static ACE2_5MinFileInfo createFromDataFile(File dataFile) throws IOException {
        ACE2_5MinFileInfo fileInfo = new ACE2_5MinFileInfo();
        fileInfo.setFromData(dataFile);
        return fileInfo;
    }

    private static ZipEntry getZipEntryIgnoreCase(ZipFile zipFile, String name) {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!zipEntry.getName().equalsIgnoreCase(name)) continue;
            return zipEntry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFromData(File dataFile) throws IOException {
        String ext = FileUtils.getExtension((String)dataFile.getName());
        if (ext != null && ext.equalsIgnoreCase(".zip")) {
            String baseName = FileUtils.getFilenameWithoutExtension((String)dataFile.getName()) + ".ACE2";
            try (ZipFile zipFile = new ZipFile(dataFile);){
                ZipEntry zipEntry = ACE2_5MinFileInfo.getZipEntryIgnoreCase(zipFile, baseName);
                if (zipEntry == null) {
                    throw new IOException("Entry '" + baseName + "' not found in zip file.");
                }
                this.setFromData(baseName, zipEntry.getSize());
            }
        } else {
            this.setFromData(dataFile.getName(), dataFile.length());
        }
    }

    void setFromData(String fileName, long fileSize) throws IOException {
        int[] eastingNorthing;
        this._fileName = fileName;
        this._fileSize = fileSize;
        try {
            eastingNorthing = ACE2_5MinFileInfo.parseEastingNorthing(fileName);
        }
        catch (ParseException e) {
            throw new IOException("Illegal file name format: " + fileName);
        }
        this._easting = eastingNorthing[0];
        this._northing = eastingNorthing[1];
        this._height = this._width = (int)Math.sqrt(fileSize / 4L);
        this._pixelSizeY = this._pixelSizeX = 0.083333336f;
        this._noDataValue = -500.0f;
    }

    private static int[] parseEastingNorthing(String text) throws ParseException {
        Guardian.assertNotNullOrEmpty((String)"text", (String)text);
        if (text.length() == 0) {
            return null;
        }
        return ACE2_5MinFileInfo.PARSER.parse(text);
    }

    private static class EastingNorthingParser {
        private static final int ILLEGAL_DIRECTION_VALUE = -999;
        private final int directionWest = 0;
        private final int directionEast = 1;
        private final int directionNorth = 2;
        private final int directionSouth = 3;
        private final int indexEasting = 0;
        private final int indexNorthing = 1;
        private String text;
        private int pos;
        private static final char EOF = '\uffff';

        private int[] parse(String text) throws ParseException {
            this.initParser(text);
            return this.parseImpl();
        }

        private void initParser(String text) {
            this.text = text;
            this.pos = -1;
        }

        private int[] parseImpl() throws ParseException {
            int[] eastingNorthing = new int[]{-999, -999};
            this.parseDirectionValueAndAssign(eastingNorthing);
            this.parseDirectionValueAndAssign(eastingNorthing);
            this.validateThatValuesAreAssigned(eastingNorthing);
            this.validateCorrectSuffix();
            return eastingNorthing;
        }

        private void validateThatValuesAreAssigned(int[] eastingNorthing) throws ParseException {
            if (eastingNorthing[0] == -999) {
                throw new ParseException("Easting value not available.", -1);
            }
            if (eastingNorthing[1] == -999) {
                throw new ParseException("Northing value not available.", -1);
            }
        }

        private void validateCorrectSuffix() throws ParseException {
            String suffix;
            if (!(suffix = this.text.substring(++this.pos)).matches("_5M.ACE2")) {
                throw new ParseException("Illegal string format.", this.pos);
            }
        }

        private void parseDirectionValueAndAssign(int[] eastingNorthing) throws ParseException {
            int value = this.readNumber();
            int direction = this.getDirection();
            value = this.correctValueByDirection(value, direction);
            this.assignValueByDirection(eastingNorthing, value, direction);
        }

        private void assignValueByDirection(int[] eastingNorthing, int value, int direction) {
            if (this.isWest(direction) || this.isEast(direction)) {
                eastingNorthing[0] = value;
            } else {
                eastingNorthing[1] = value;
            }
        }

        private int correctValueByDirection(int value, int direction) throws ParseException {
            if (this.isWest(direction) && ((value *= this.isWest(direction) || this.isSouth(direction) ? -1 : 1) > 0 || value < -180)) {
                throw new ParseException("The value '" + value + "' for west direction is out of the range -180 ... 0.", this.pos);
            }
            if (this.isEast(direction) && (value < 0 || value > 180)) {
                throw new ParseException("The value '" + value + "' for east direction is out of the range 0 ... 180.", this.pos);
            }
            if (this.isSouth(direction) && (value > 0 || value < -90)) {
                throw new ParseException("The value '" + value + "' for south direction is out of the range -90 ... 0.", this.pos);
            }
            if (this.isNorth(direction) && (value < 0 || value > 90)) {
                throw new ParseException("The value '" + value + "' for north direction is out of the range 0 ... 90.", this.pos);
            }
            return value;
        }

        private boolean isNorth(int direction) {
            return EastingNorthingParser.compareDirection(2, direction);
        }

        private boolean isEast(int direction) {
            return EastingNorthingParser.compareDirection(1, direction);
        }

        private boolean isSouth(int direction) {
            return EastingNorthingParser.compareDirection(3, direction);
        }

        private boolean isWest(int direction) {
            return EastingNorthingParser.compareDirection(0, direction);
        }

        private static boolean compareDirection(int expected, int direction) {
            return expected == direction;
        }

        private int getDirection() throws ParseException {
            char c = this.nextChar();
            if (c == 'w' || c == 'W') {
                return 0;
            }
            if (c == 'e' || c == 'E') {
                return 1;
            }
            if (c == 'n' || c == 'N') {
                return 2;
            }
            if (c == 's' || c == 'S') {
                return 3;
            }
            throw new ParseException("Illegal direction character. " + c, this.pos);
        }

        private int readNumber() throws ParseException {
            char c = this.nextChar();
            if (!Character.isDigit(c)) {
                throw new ParseException("Digit character expected.", this.pos);
            }
            int value = 0;
            while (Character.isDigit(c)) {
                value *= 10;
                value += c - 48;
                c = this.nextChar();
            }
            --this.pos;
            return value;
        }

        private char nextChar() {
            ++this.pos;
            return this.pos < this.text.length() ? this.text.charAt(this.pos) : (char)'\uffff';
        }

        private EastingNorthingParser() {
        }
    }
}

