/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio.ace;

import java.io.File;
import java.util.Locale;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.dem.dataio.ace.ACEReader;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;

public class ACEReaderPlugIn
implements ProductReaderPlugIn {
    public static final String FORMAT_NAME = "ACE";
    private static final String[] FILE_EXTENSIONS = new String[]{".ACE"};
    private static final Class[] INPUT_TYPES = new Class[]{String.class, File.class};
    private static final String DESCRIPTION = "ACE Data Product Tile";

    public DecodeQualification getDecodeQualification(Object input) {
        String fileName;
        File file = ReaderUtils.getFileFromInput((Object)input);
        if (file != null && (fileName = file.getName().toUpperCase()).endsWith(".ACE")) {
            return DecodeQualification.INTENDED;
        }
        return DecodeQualification.UNABLE;
    }

    public Class[] getInputTypes() {
        return INPUT_TYPES;
    }

    public ProductReader createReaderInstance() {
        return new ACEReader(this);
    }

    public SnapFileFilter getProductFileFilter() {
        return new SnapFileFilter(FORMAT_NAME, FILE_EXTENSIONS, DESCRIPTION);
    }

    public String[] getFormatNames() {
        return new String[]{FORMAT_NAME};
    }

    public String[] getDefaultFileExtensions() {
        return FILE_EXTENSIONS;
    }

    public String getDescription(Locale locale) {
        return DESCRIPTION;
    }
}

