/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio.ace;

import java.io.File;
import java.io.IOException;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.dataop.dem.BaseElevationModel;
import org.esa.snap.core.dataop.dem.ElevationFile;
import org.esa.snap.core.dataop.dem.ElevationModelDescriptor;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.dem.dataio.ace.ACEElevationModelDescriptor;
import org.esa.snap.dem.dataio.ace.ACEFile;

public class ACEElevationModel
extends BaseElevationModel {
    private static final ProductReaderPlugIn productReaderPlugIn = ACEElevationModel.getReaderPlugIn((String)"ACE");
    private static final String DB_FILE_SUFFIX = ".ACE";

    public ACEElevationModel(ACEElevationModelDescriptor descriptor, Resampling resamplingMethod) throws IOException {
        super((ElevationModelDescriptor)descriptor, resamplingMethod);
    }

    public double getIndexX(GeoPos geoPos) {
        return (geoPos.lon + 180.0) / this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE;
    }

    public double getIndexY(GeoPos geoPos) {
        return (double)this.RASTER_HEIGHT - (geoPos.lat + 90.0) / this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE;
    }

    public GeoPos getGeoPos(PixelPos pixelPos) {
        double pixelLat = ((double)this.RASTER_HEIGHT - pixelPos.y) * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE - 90.0;
        double pixelLon = pixelPos.x * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE - 180.0;
        return new GeoPos(pixelLat, pixelLon);
    }

    protected void createElevationFile(ElevationFile[][] elevationFiles, int x, int y, File demInstallDir) {
        int minLon = x * this.DEGREE_RES - 180;
        int minLat = y * this.DEGREE_RES - 90;
        String fileName = this.createTileFilename(minLat, minLon);
        File localFile = new File(demInstallDir, fileName);
        elevationFiles[x][this.NUM_Y_TILES - 1 - y] = new ACEFile(this, localFile, productReaderPlugIn.createReaderInstance());
    }

    String createTileFilename(int minLat, int minLon) {
        String lonString;
        String latString;
        String string = latString = minLat < 0 ? Math.abs(minLat) + "S" : minLat + "N";
        while (latString.length() < 3) {
            latString = '0' + latString;
        }
        String string2 = lonString = minLon < 0 ? Math.abs(minLon) + "W" : minLon + "E";
        while (lonString.length() < 4) {
            lonString = '0' + lonString;
        }
        return latString + lonString + DB_FILE_SUFFIX;
    }
}

