/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.dataop.dem.ElevationModel;
import org.esa.snap.core.dataop.dem.ElevationModelDescriptor;
import org.esa.snap.core.dataop.dem.ElevationModelRegistry;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.core.dataop.resamp.ResamplingFactory;
import org.esa.snap.dem.dataio.EarthGravitationalModel96;
import org.esa.snap.engine_utilities.gpf.TileGeoreferencing;

public class DEMFactory {
    public static final String LAST_EXTERNAL_DEM_DIR_KEY = "snap.externalDEMDir";
    public static final String AUTODEM = " (Auto Download)";
    static final String DELAUNAY_INTERPOLATION = "DELAUNAY_INTERPOLATION";
    private static final ElevationModelDescriptor[] descriptors = ElevationModelRegistry.getInstance().getAllDescriptors();
    private static final String[] demNameList;
    private static final String[] demResamplingList;

    public static String[] getDEMNameList() {
        return demNameList;
    }

    public static String[] getDEMResamplingMethods() {
        return demResamplingList;
    }

    public static String getProperDEMName(String name) {
        return name.replace(AUTODEM, "");
    }

    public static ElevationModel createElevationModel(String demName, String demResamplingMethod) throws IOException {
        ElevationModel dem;
        ElevationModelDescriptor demDescriptor = DEMFactory.getDemDescriptor(demName);
        Resampling resampleMethod = null;
        if (!demResamplingMethod.equals(DELAUNAY_INTERPOLATION)) {
            resampleMethod = ResamplingFactory.createResampling((String)demResamplingMethod);
        }
        if ((dem = demDescriptor.createDem(resampleMethod)) == null) {
            throw new IOException("The DEM '" + demName + "' has not been installed.");
        }
        return dem;
    }

    public static void checkIfDEMInstalled(String demName) throws IOException {
    }

    public static void validateDEM(String demName, Product srcProduct) throws IOException {
        if (demName.contains("SRTM")) {
            GeoCoding geocoding = srcProduct.getSceneGeoCoding();
            int w = srcProduct.getSceneRasterWidth();
            int h = srcProduct.getSceneRasterHeight();
            GeoPos geo1 = geocoding.getGeoPos(new PixelPos(0.0, 0.0), null);
            GeoPos geo2 = geocoding.getGeoPos(new PixelPos((double)w, 0.0), null);
            GeoPos geo3 = geocoding.getGeoPos(new PixelPos((double)w, (double)h), null);
            GeoPos geo4 = geocoding.getGeoPos(new PixelPos(0.0, (double)h), null);
            if (geo1.getLat() > 60.0 && geo2.getLat() > 60.0 && geo3.getLat() > 60.0 && geo4.getLat() > 60.0 || geo1.getLat() < -60.0 && geo2.getLat() < -60.0 && geo3.getLat() < -60.0 && geo4.getLat() < -60.0) {
                throw new IOException("Entire image is outside of SRTM valid area.\nPlease use another DEM.");
            }
        }
    }

    public static void fillDEM(double[][] localDEM, double alt) {
        for (double[] row : localDEM) {
            Arrays.fill(row, alt);
        }
    }

    public static String getDEMDisplayName(ElevationModelDescriptor descriptor) {
        if (descriptor.canBeDownloaded()) {
            return descriptor.getName() + AUTODEM;
        }
        return descriptor.getName();
    }

    public static boolean getLocalDEM(ElevationModel dem, double demNoDataValue, String demResamplingMethod, TileGeoreferencing tileGeoRef, int x0, int y0, int tileWidth, int tileHeight, Product sourceProduct, boolean nodataValueAtSea, double[][] localDEM) throws Exception {
        if (demResamplingMethod == null || demResamplingMethod.equals(DELAUNAY_INTERPOLATION)) {
            // empty if block
        }
        int maxY = y0 + tileHeight + 1;
        int maxX = x0 + tileWidth + 1;
        GeoPos geoPos = new GeoPos();
        boolean valid = false;
        double[][] v = new double[4][4];
        for (int y = y0 - 1; y < maxY; ++y) {
            int yy = y - y0 + 1;
            for (int x = x0 - 1; x < maxX; ++x) {
                tileGeoRef.getGeoPos(x, y, geoPos);
                double alt = dem.getElevation(geoPos);
                if (alt == demNoDataValue && !nodataValueAtSea) {
                    alt = EarthGravitationalModel96.instance().getEGM(geoPos.lat, geoPos.lon, v);
                }
                if (!valid && alt != demNoDataValue) {
                    valid = true;
                }
                localDEM[yy][x - x0 + 1] = alt;
            }
        }
        return valid;
    }

    private static ElevationModelDescriptor getDemDescriptor(String demName) throws IOException {
        ElevationModelRegistry elevationModelRegistry = ElevationModelRegistry.getInstance();
        ElevationModelDescriptor demDescriptor = elevationModelRegistry.getDescriptor(demName);
        if (demDescriptor == null) {
            throw new IOException("The DEM '" + demName + "' is not supported.");
        }
        return demDescriptor;
    }

    private static GeoPos[] extendCorners(GeoPos extraGeo, GeoPos[] inGeo) {
        if (inGeo.length != 2) {
            throw new IllegalArgumentException("Input GeoPos[] array has to have exactly 2 elements");
        }
        GeoPos[] outGeo = new GeoPos[inGeo.length];
        outGeo[0] = new GeoPos();
        outGeo[0].lat = inGeo[0].lat + extraGeo.lat;
        outGeo[0].lon = inGeo[0].lon - extraGeo.lon;
        outGeo[1] = new GeoPos();
        outGeo[1].lat = inGeo[1].lat - extraGeo.lat;
        outGeo[1].lon = inGeo[1].lon + extraGeo.lon;
        return outGeo;
    }

    static {
        demResamplingList = new String[ResamplingFactory.resamplingNames.length + 1];
        ArrayList<String> sortedDEMNames = new ArrayList<String>(descriptors.length);
        for (ElevationModelDescriptor descriptor : descriptors) {
            sortedDEMNames.add(DEMFactory.getDEMDisplayName(descriptor));
        }
        sortedDEMNames.sort((o1, o2) -> o1.compareTo((String)o2));
        demNameList = sortedDEMNames.toArray(new String[sortedDEMNames.size()]);
        int i = 0;
        for (String resampleName : ResamplingFactory.resamplingNames) {
            DEMFactory.demResamplingList[i++] = resampleName;
        }
        DEMFactory.demResamplingList[i] = DELAUNAY_INTERPOLATION;
    }
}

