/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.type;

import java.lang.reflect.Modifier;

public abstract class JavaType {
    protected final Class<?> _class;
    protected int _hashCode;
    protected Object _valueHandler;
    protected Object _typeHandler;

    protected JavaType(Class<?> clazz) {
        this._class = clazz;
        String string = clazz.getName();
        this._hashCode = string.hashCode();
    }

    public final JavaType narrowBy(Class<?> clazz) {
        if (clazz == this._class) {
            return this;
        }
        this._assertSubclass(clazz, this._class);
        JavaType javaType = this._narrow(clazz);
        if (this._valueHandler != null) {
            javaType.setValueHandler(this._valueHandler);
        }
        if (this._typeHandler != null) {
            javaType.setTypeHandler(this._typeHandler);
        }
        return javaType;
    }

    public final JavaType forcedNarrowBy(Class<?> clazz) {
        if (clazz == this._class) {
            return this;
        }
        JavaType javaType = this._narrow(clazz);
        if (this._valueHandler != null) {
            javaType.setValueHandler(this._valueHandler);
        }
        if (this._typeHandler != null) {
            javaType.setTypeHandler(this._typeHandler);
        }
        return javaType;
    }

    public final JavaType widenBy(Class<?> clazz) {
        if (clazz == this._class) {
            return this;
        }
        this._assertSubclass(this._class, clazz);
        return this._widen(clazz);
    }

    protected abstract JavaType _narrow(Class<?> var1);

    protected JavaType _widen(Class<?> clazz) {
        return this._narrow(clazz);
    }

    public abstract JavaType narrowContentsBy(Class<?> var1);

    public void setValueHandler(Object object) {
        if (object != null && this._valueHandler != null) {
            throw new IllegalStateException("Trying to reset value handler for type [" + this.toString() + "]; old handler of type " + this._valueHandler.getClass().getName() + ", new handler of type " + object.getClass().getName());
        }
        this._valueHandler = object;
    }

    public void setTypeHandler(Object object) {
        if (object != null && this._typeHandler != null) {
            throw new IllegalStateException("Trying to reset type handler for type [" + this.toString() + "]; old handler of type " + this._typeHandler.getClass().getName() + ", new handler of type " + object.getClass().getName());
        }
        this._typeHandler = object;
    }

    public final Class<?> getRawClass() {
        return this._class;
    }

    public final boolean hasRawClass(Class<?> clazz) {
        return this._class == clazz;
    }

    public abstract boolean isContainerType();

    public boolean isAbstract() {
        return Modifier.isAbstract(this._class.getModifiers());
    }

    public boolean isConcrete() {
        int n = this._class.getModifiers();
        if ((n & 0x600) == 0) {
            return true;
        }
        return this._class.isPrimitive();
    }

    public boolean isThrowable() {
        return Throwable.class.isAssignableFrom(this._class);
    }

    public boolean isArrayType() {
        return false;
    }

    public final boolean isEnumType() {
        return this._class.isEnum();
    }

    public final boolean isInterface() {
        return this._class.isInterface();
    }

    public final boolean isPrimitive() {
        return this._class.isPrimitive();
    }

    public final boolean isFinal() {
        return Modifier.isFinal(this._class.getModifiers());
    }

    public JavaType getKeyType() {
        return null;
    }

    public JavaType getContentType() {
        return null;
    }

    public int containedTypeCount() {
        return 0;
    }

    public JavaType containedType(int n) {
        return null;
    }

    public String containedTypeName(int n) {
        return null;
    }

    public <T> T getValueHandler() {
        return (T)this._valueHandler;
    }

    public <T> T getTypeHandler() {
        return (T)this._typeHandler;
    }

    public abstract String toCanonical();

    protected void _assertSubclass(Class<?> clazz, Class<?> clazz2) {
        if (!this._class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is not assignable to " + this._class.getName());
        }
    }

    public abstract String toString();

    public abstract boolean equals(Object var1);

    public final int hashCode() {
        return this._hashCode;
    }
}

