/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view.firstperson;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.view.BasicView;
import gov.nasa.worldwind.view.BasicViewPropertyLimits;
import gov.nasa.worldwind.view.ViewPropertyLimits;
import gov.nasa.worldwind.view.ViewUtil;
import gov.nasa.worldwind.view.firstperson.FlyViewInputHandler;
import gov.nasa.worldwind.view.firstperson.FlyViewLimits;
import java.awt.Rectangle;

public class BasicFlyView
extends BasicView {
    protected static final double DEFAULT_MIN_ELEVATION = 0.0;
    protected static final double DEFAULT_MAX_ELEVATION = 4000000.0;
    protected static final Angle DEFAULT_MIN_PITCH = Angle.ZERO;
    protected static final Angle DEFAULT_MAX_PITCH = Angle.fromDegrees(180.0);

    public BasicFlyView() {
        this.viewInputHandler = new FlyViewInputHandler();
        this.viewLimits = new FlyViewLimits();
        this.viewLimits.setPitchLimits(DEFAULT_MIN_PITCH, DEFAULT_MAX_PITCH);
        this.viewLimits.setEyeElevationLimits(0.0, 4000000.0);
        this.loadConfigurationValues();
    }

    protected void loadConfigurationValues() {
        Double d;
        Double d2;
        Double d3 = Configuration.getDoubleValue("gov.nasa.worldwind.avkey.InitialLatitude");
        Double d4 = Configuration.getDoubleValue("gov.nasa.worldwind.avkey.InitialLongitude");
        double d5 = 50000.0;
        Double d6 = Configuration.getDoubleValue("gov.nasa.worldwind.avkey.InitialAltitude");
        if (d6 != null) {
            d5 = d6;
        }
        if (d3 != null && d4 != null) {
            d5 = ((FlyViewLimits)this.viewLimits).limitEyeElevation(d5);
            this.setEyePosition(Position.fromDegrees(d3, d4, d5));
        } else if (d3 != null) {
            this.setEyePosition(Position.fromDegrees(d3, this.eyePosition.getLongitude().degrees, d5));
        } else if (d4 != null) {
            this.setEyePosition(Position.fromDegrees(this.eyePosition.getLatitude().degrees, d4, d5));
        }
        Double d7 = Configuration.getDoubleValue("gov.nasa.worldwind.avkey.InitialHeading");
        if (d7 != null) {
            this.setHeading(Angle.fromDegrees(d7));
        }
        if ((d2 = Configuration.getDoubleValue("gov.nasa.worldwind.avkey.InitialPitch")) != null) {
            this.setPitch(Angle.fromDegrees(d2));
        }
        if ((d = Configuration.getDoubleValue("gov.nasa.worldwind.avkey.FieldOfView")) != null) {
            this.setFieldOfView(Angle.fromDegrees(d));
        }
    }

    @Override
    public void setEyePosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.getGlobe() != null) {
            double d = ((FlyViewLimits)this.viewLimits).limitEyeElevation(position, this.getGlobe());
            LatLon latLon = BasicViewPropertyLimits.limitEyePositionLocation(position.getLatitude(), position.getLongitude(), this.viewLimits);
            this.eyePosition = new Position(latLon, d);
        } else {
            LatLon latLon = BasicViewPropertyLimits.limitEyePositionLocation(position.getLatitude(), position.getLongitude(), this.viewLimits);
            this.eyePosition = new Position(latLon, position.getElevation());
            this.eyePosition = position;
        }
        this.updateModelViewStateID();
    }

    public Matrix getModelViewMatrix(Position position, Position position2) {
        Matrix matrix;
        Object object;
        if (position == null || position2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.globe == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Vec4 vec4 = this.globe.computePointFromPosition(position);
        Vec4 vec42 = this.globe.computePointFromPosition(position2);
        if (vec4 == null || vec42 == null) {
            String string = Logging.getMessage("View.ErrorSettingOrientation", position, position2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec43 = this.globe.computeSurfaceNormalAtPoint(vec42);
        Vec4 vec44 = vec42.subtract3(vec4).normalize3();
        if (vec44.cross3(vec43).getLength3() < 0.001 && (object = ViewUtil.computeTransformMatrix(this.globe, position, this.heading, Angle.ZERO, Angle.ZERO)) != null && (matrix = ((Matrix)object).getInverse()) != null) {
            vec43 = Vec4.UNIT_Y.transformBy4(matrix);
        }
        if (vec43 == null) {
            object = Logging.getMessage("View.ErrorSettingOrientation", position, position2);
            Logging.logger().severe((String)object);
            throw new IllegalArgumentException((String)object);
        }
        object = ViewUtil.computeModelViewMatrix(this.globe, vec4, vec42, vec43);
        return object;
    }

    public ViewUtil.ViewState getViewState(Position position, Position position2) {
        Matrix matrix;
        Object object;
        if (position == null || position2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.globe == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Vec4 vec4 = this.globe.computePointFromPosition(position);
        Vec4 vec42 = this.globe.computePointFromPosition(position2);
        if (vec4 == null || vec42 == null) {
            String string = Logging.getMessage("View.ErrorSettingOrientation", position, position2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec43 = this.globe.computeSurfaceNormalAtPoint(vec42);
        Vec4 vec44 = vec42.subtract3(vec4).normalize3();
        if (vec44.cross3(vec43).getLength3() < 0.001 && (object = ViewUtil.computeTransformMatrix(this.globe, position, this.heading, Angle.ZERO, Angle.ZERO)) != null && (matrix = ((Matrix)object).getInverse()) != null) {
            vec43 = Vec4.UNIT_Y.transformBy4(matrix);
        }
        if (vec43 == null) {
            object = Logging.getMessage("View.ErrorSettingOrientation", position, position2);
            Logging.logger().severe((String)object);
            throw new IllegalArgumentException((String)object);
        }
        object = ViewUtil.computeViewState(this.globe, vec4, vec42, vec43);
        return object;
    }

    @Override
    protected void doApply(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGL() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGlobe() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.dc = drawContext;
        this.globe = this.dc.getGlobe();
        this.modelview = ViewUtil.computeTransformMatrix(this.globe, this.eyePosition, this.heading, this.pitch, this.roll);
        if (this.modelview == null) {
            this.modelview = Matrix.IDENTITY;
        }
        this.modelviewInv = this.modelview.getInverse();
        if (this.modelviewInv == null) {
            this.modelviewInv = Matrix.IDENTITY;
        }
        int[] nArray = new int[4];
        this.dc.getGL().glGetIntegerv(2978, nArray, 0);
        this.viewport = new Rectangle(nArray[0], nArray[1], nArray[2], nArray[3]);
        this.nearClipDistance = this.computeNearClipDistance();
        this.farClipDistance = this.computeFarClipDistance();
        double d = this.viewport.getWidth() <= 0.0 ? 1.0 : this.viewport.getWidth();
        double d2 = this.viewport.getHeight() <= 0.0 ? 1.0 : this.viewport.getHeight();
        this.projection = Matrix.fromPerspective(this.fieldOfView, d, d2, this.nearClipDistance, this.farClipDistance);
        this.frustum = Frustum.fromPerspective(this.fieldOfView, (int)d, (int)d2, this.nearClipDistance, this.farClipDistance);
        BasicFlyView.loadGLViewState(drawContext, this.modelview, this.projection);
        this.afterDoApply();
    }

    protected void afterDoApply() {
        this.lastEyePosition = this.computeEyePositionFromModelview();
        this.horizonDistance = this.computeHorizonDistance();
        this.lastEyePoint = null;
        this.lastUpVector = null;
        this.lastForwardVector = null;
        this.lastFrustumInModelCoords = null;
    }

    @Override
    protected void setViewState(ViewUtil.ViewState viewState) {
        if (viewState == null) {
            String string = Logging.getMessage("nullValue.ViewStateIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (viewState.getPosition() != null) {
            Position position = ViewUtil.normalizedEyePosition(viewState.getPosition());
            LatLon latLon = BasicViewPropertyLimits.limitEyePositionLocation(this.eyePosition.getLatitude(), this.eyePosition.getLongitude(), this.getViewPropertyLimits());
            this.eyePosition = new Position(latLon, position.getElevation());
        }
        this.setHeading(viewState.getHeading());
        this.setPitch(viewState.getPitch());
        this.setRoll(viewState.getRoll());
    }

    @Override
    public void setHeading(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.heading = ViewUtil.normalizedHeading(angle);
        this.heading = BasicViewPropertyLimits.limitHeading(this.heading, this.getViewPropertyLimits());
        this.updateModelViewStateID();
    }

    @Override
    public void setPitch(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.pitch = ViewUtil.normalizedPitch(angle);
        this.pitch = BasicViewPropertyLimits.limitPitch(this.pitch, this.getViewPropertyLimits());
        this.updateModelViewStateID();
    }

    public void setViewPropertyLimits(ViewPropertyLimits viewPropertyLimits) {
        this.viewLimits = viewPropertyLimits;
        this.setViewState(new ViewUtil.ViewState(this.getEyePosition(), this.getHeading(), this.getPitch(), Angle.ZERO));
    }
}

