/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.xml.xal;

import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import gov.nasa.worldwind.util.xml.xal.XALAbstractObject;
import gov.nasa.worldwind.util.xml.xal.XALAddressLine;
import gov.nasa.worldwind.util.xml.xal.XALAdministrativeArea;
import gov.nasa.worldwind.util.xml.xal.XALCountryName;
import gov.nasa.worldwind.util.xml.xal.XALCountryNameCode;
import gov.nasa.worldwind.util.xml.xal.XALLocality;
import gov.nasa.worldwind.util.xml.xal.XALThoroughfare;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class XALCountry
extends XALAbstractObject {
    protected List<XALAddressLine> addressLines;
    protected List<XALCountryNameCode> countryNameCodes;
    protected List<XALCountryName> countryNames;

    public XALCountry(String string) {
        super(string);
    }

    @Override
    protected void doAddEventContent(Object object, XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (object instanceof XALAddressLine) {
            this.addAddressLine((XALAddressLine)object);
        } else if (object instanceof XALCountryNameCode) {
            this.addCountryNameCode((XALCountryNameCode)object);
        } else if (object instanceof XALCountryName) {
            this.addCountryName((XALCountryName)object);
        } else {
            super.doAddEventContent(object, xMLEventParserContext, xMLEvent, objectArray);
        }
    }

    public List<XALAddressLine> getAddressLines() {
        return this.addressLines;
    }

    protected void addAddressLine(XALAddressLine xALAddressLine) {
        if (this.addressLines == null) {
            this.addressLines = new ArrayList<XALAddressLine>();
        }
        this.addressLines.add(xALAddressLine);
    }

    public List<XALCountryNameCode> getCountryNameCodes() {
        return this.countryNameCodes;
    }

    protected void addCountryNameCode(XALCountryNameCode xALCountryNameCode) {
        if (this.countryNameCodes == null) {
            this.countryNameCodes = new ArrayList<XALCountryNameCode>();
        }
        this.countryNameCodes.add(xALCountryNameCode);
    }

    public List<XALCountryName> getCountryNames() {
        return this.countryNames;
    }

    protected void addCountryName(XALCountryName xALCountryName) {
        if (this.countryNames == null) {
            this.countryNames = new ArrayList<XALCountryName>();
        }
        this.countryNames.add(xALCountryName);
    }

    public XALAdministrativeArea getAdministrativeArea() {
        return (XALAdministrativeArea)this.getField("AdministrativeArea");
    }

    public XALLocality getLocality() {
        return (XALLocality)this.getField("Locality");
    }

    public XALThoroughfare getThoroughfare() {
        return (XALThoroughfare)this.getField("Thoroughfare");
    }
}

