/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.tree;

import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.util.tree.Tree;
import gov.nasa.worldwind.util.tree.TreeLayout;
import gov.nasa.worldwind.util.tree.TreeModel;
import gov.nasa.worldwind.util.tree.TreeNode;
import gov.nasa.worldwind.util.tree.TreePath;
import java.awt.Point;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class BasicTree
extends WWObjectImpl
implements Tree,
PreRenderable {
    protected TreeLayout layout;
    protected TreeModel model;
    protected Set<TreePath> expandedNodes = new HashSet<TreePath>();

    @Override
    public void makeVisible(TreePath treePath) {
        TreeLayout treeLayout = this.getLayout();
        if (treeLayout != null) {
            treeLayout.makeVisible(treePath);
        }
    }

    @Override
    public void expandPath(TreePath treePath) {
        this.expandedNodes.add(treePath);
        this.firePropertyChange("gov.nasa.worldwind.avkey.Tree", null, this);
    }

    @Override
    public void collapsePath(TreePath treePath) {
        this.expandedNodes.remove(treePath);
        this.firePropertyChange("gov.nasa.worldwind.avkey.Tree", null, this);
    }

    @Override
    public TreeNode getNode(TreePath treePath) {
        TreeNode treeNode = this.getModel().getRoot();
        if (!treeNode.getText().equals(treePath.get(0))) {
            return null;
        }
        Iterator iterator = treePath.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            boolean bl = false;
            for (TreeNode treeNode2 : treeNode.getChildren()) {
                if (!treeNode2.getText().equals(string)) continue;
                treeNode = treeNode2;
                bl = true;
                break;
            }
            if (bl) continue;
            return null;
        }
        return treeNode;
    }

    @Override
    public void togglePath(TreePath treePath) {
        if (this.isPathExpanded(treePath)) {
            this.collapsePath(treePath);
        } else {
            this.expandPath(treePath);
        }
    }

    @Override
    public boolean isPathExpanded(TreePath treePath) {
        return this.expandedNodes.contains(treePath);
    }

    @Override
    public boolean isNodeExpanded(TreeNode treeNode) {
        return this.expandedNodes.contains(treeNode.getPath());
    }

    @Override
    public void preRender(DrawContext drawContext) {
        TreeLayout treeLayout = this.getLayout();
        if (treeLayout instanceof PreRenderable) {
            ((PreRenderable)((Object)treeLayout)).preRender(drawContext);
        }
    }

    @Override
    public void render(DrawContext drawContext) {
        TreeLayout treeLayout = this.getLayout();
        if (treeLayout != null) {
            if (!drawContext.isOrderedRenderingMode()) {
                drawContext.addOrderedRenderable(this);
            } else {
                treeLayout.render(drawContext);
            }
        }
    }

    @Override
    public void pick(DrawContext drawContext, Point point) {
        TreeLayout treeLayout = this.getLayout();
        if (treeLayout != null) {
            treeLayout.render(drawContext);
        }
    }

    @Override
    public double getDistanceFromEye() {
        return 1.0;
    }

    @Override
    public TreeLayout getLayout() {
        return this.layout;
    }

    @Override
    public void setLayout(TreeLayout treeLayout) {
        if (this.layout != null) {
            this.layout.removePropertyChangeListener(this);
        }
        this.layout = treeLayout;
        if (this.layout != null) {
            this.layout.addPropertyChangeListener(this);
        }
    }

    @Override
    public TreeModel getModel() {
        return this.model;
    }

    @Override
    public void setModel(TreeModel treeModel) {
        if (this.model != null) {
            this.model.removePropertyChangeListener(this);
        }
        this.model = treeModel;
        if (this.model != null) {
            this.model.addPropertyChangeListener(this);
        }
    }
}

