/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.layertree;

import gov.nasa.worldwind.ogc.kml.KMLAbstractContainer;
import gov.nasa.worldwind.ogc.kml.KMLAbstractFeature;
import gov.nasa.worldwind.ogc.kml.KMLNetworkLink;
import gov.nasa.worldwind.ogc.kml.KMLSnippet;
import gov.nasa.worldwind.util.EntityMap;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.layertree.KMLContainerTreeNode;
import gov.nasa.worldwind.util.layertree.KMLNetworkLinkTreeNode;
import gov.nasa.worldwind.util.tree.BasicTreeNode;
import gov.nasa.worldwind.util.tree.Tree;
import gov.nasa.worldwind.util.tree.TreeNode;

public class KMLFeatureTreeNode
extends BasicTreeNode {
    protected KMLAbstractFeature feature;

    public KMLFeatureTreeNode(KMLAbstractFeature kMLAbstractFeature) {
        super("");
        if (kMLAbstractFeature == null) {
            String string = Logging.getMessage("nullValue.FeatureIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.feature = kMLAbstractFeature;
        this.initialize();
    }

    protected void initialize() {
        this.setValue("gov.nasa.worldwind.avkey.Context", this.getFeature());
    }

    public static KMLFeatureTreeNode fromKMLFeature(KMLAbstractFeature kMLAbstractFeature) {
        if (kMLAbstractFeature == null) {
            String string = Logging.getMessage("nullValue.FeatureIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (kMLAbstractFeature instanceof KMLNetworkLink) {
            return new KMLNetworkLinkTreeNode((KMLNetworkLink)kMLAbstractFeature);
        }
        if (kMLAbstractFeature instanceof KMLAbstractContainer) {
            return new KMLContainerTreeNode((KMLAbstractContainer)kMLAbstractFeature);
        }
        return new KMLFeatureTreeNode(kMLAbstractFeature);
    }

    public KMLAbstractFeature getFeature() {
        return this.feature;
    }

    @Override
    public boolean isSelected() {
        Boolean bl = this.feature.getVisibility();
        return bl == null || bl != false;
    }

    @Override
    public void setSelected(boolean bl) {
        super.setSelected(bl);
        this.getFeature().setVisibility(bl);
    }

    public void expandOpenContainers(Tree tree) {
        if (tree == null) {
            String string = Logging.getMessage("nullValue.TreeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.mustExpandNode()) {
            tree.expandPath(this.getPath());
        }
        for (TreeNode treeNode : this.getChildren()) {
            if (!(treeNode instanceof KMLFeatureTreeNode)) continue;
            ((KMLFeatureTreeNode)treeNode).expandOpenContainers(tree);
        }
    }

    protected boolean mustExpandNode() {
        return Boolean.TRUE.equals(this.getFeature().getOpen());
    }

    @Override
    public String getText() {
        String string = this.feature.getName();
        return string != null ? this.stripHtmlTags(string) : this.feature.getClass().getSimpleName();
    }

    @Override
    public String getDescription() {
        return this.makeFeatureDescription();
    }

    protected String makeFeatureDescription() {
        KMLSnippet kMLSnippet;
        Integer n;
        Object object = this.getFeature().getSnippet();
        String string = object instanceof KMLSnippet ? ((n = (kMLSnippet = (KMLSnippet)object).getMaxLines()) == null || n > 0 ? kMLSnippet.getCharacters() : null) : this.getFeature().getDescription();
        return EntityMap.replaceAll(this.stripHtmlTags(string));
    }

    protected String stripHtmlTags(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) {
                bl2 = true;
                continue;
            }
            if (!bl && bl2 && stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            bl2 = false;
            if (c == '<') {
                bl = true;
                continue;
            }
            if (c == '>') {
                bl = false;
                continue;
            }
            if (bl) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }
}

