/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import com.jogamp.common.nio.Buffers;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class WWMath {
    public static final double SECOND_TO_MILLIS = 1000.0;
    public static final double MINUTE_TO_MILLIS = 60000.0;
    public static final double HOUR_TO_MILLIS = 3600000.0;
    public static final double DAY_TO_MILLIS = 8.64E7;
    public static final double METERS_TO_KILOMETERS = 0.001;
    public static final double METERS_TO_MILES = 6.21371192E-4;
    public static final double METERS_TO_NAUTICAL_MILES = 5.39956803E-4;
    public static final double METERS_TO_YARDS = 1.0936133;
    public static final double METERS_TO_FEET = 3.280839895;
    public static final double SQUARE_METERS_TO_SQUARE_KILOMETERS = 1.0E-6;
    public static final double SQUARE_METERS_TO_SQUARE_MILES = 3.86102159E-7;
    public static final double SQUARE_METERS_TO_SQUARE_YARDS = 1.19599005;
    public static final double SQUARE_METERS_TO_SQUARE_FEET = 10.7639104;
    public static final double SQUARE_METERS_TO_HECTARES = 1.0E-4;
    public static final double SQUARE_METERS_TO_ACRES = 2.47105381E-4;
    public static final LatLon LONGITUDE_OFFSET_180 = LatLon.fromDegrees(0.0, 180.0);

    public static double logBase2(double d) {
        return Math.log(d) / Math.log(2.0);
    }

    public static boolean isPowerOfTwo(int n) {
        return n == WWMath.powerOfTwoCeiling(n);
    }

    public static int powerOfTwoCeiling(int n) {
        int n2 = (int)Math.ceil(Math.log(n) / Math.log(2.0));
        return (int)Math.pow(2.0, n2);
    }

    public static int powerOfTwoFloor(int n) {
        int n2 = (int)Math.floor(Math.log(n) / Math.log(2.0));
        return (int)Math.pow(2.0, n2);
    }

    protected static int[] computePowers(int n, int n2) {
        int[] nArray = new int[n2];
        nArray[0] = 1;
        for (int i = 1; i < n2; ++i) {
            int n3 = i;
            nArray[n3] = nArray[n3] + n * nArray[i - 1];
        }
        return nArray;
    }

    public static double clamp(double d, double d2, double d3) {
        return d < d2 ? d2 : (d > d3 ? d3 : d);
    }

    public static int clamp(int n, int n2, int n3) {
        return n < n2 ? n2 : (n > n3 ? n3 : n);
    }

    public static double computeInterpolationFactor(double d, double d2, double d3) {
        return WWMath.clamp((d - d2) / (d3 - d2), 0.0, 1.0);
    }

    public static double mix(double d, double d2, double d3) {
        double d4 = WWMath.clamp(d, 0.0, 1.0);
        return d2 + d4 * (d3 - d2);
    }

    public static double mixSmooth(double d, double d2, double d3) {
        double d4 = WWMath.clamp(d, 0.0, 1.0);
        d4 = d4 * d4 * (3.0 - 2.0 * d4);
        return d2 + d4 * (d3 - d2);
    }

    public static double convertMetersToFeet(double d) {
        return d * 3.280839895;
    }

    public static double convertMetersToMiles(double d) {
        return d * 6.21371192E-4;
    }

    public static double convertFeetToMeters(double d) {
        return d / 3.280839895;
    }

    public static double convertSecondsToMillis(double d) {
        return d * 1000.0;
    }

    public static double convertMillisToSeconds(double d) {
        return d / 1000.0;
    }

    public static double convertMinutesToMillis(double d) {
        return d * 60000.0;
    }

    public static double convertMillisToMinutes(double d) {
        return d / 60000.0;
    }

    public static double convertHoursToMillis(double d) {
        return d * 3600000.0;
    }

    public static double convertMillisToHours(double d) {
        return d / 3600000.0;
    }

    public static double convertDaysToMillis(double d) {
        return d * 8.64E7;
    }

    public static double convertMillisToDays(double d) {
        return d / 8.64E7;
    }

    public static double computeDistanceFromEye(DrawContext drawContext, Extent extent) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (extent == null) {
            String string = Logging.getMessage("nullValue.ExtentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = drawContext.getView().getEyePoint().distanceTo3(extent.getCenter()) - extent.getRadius();
        return d < 0.0 ? 0.0 : d;
    }

    public static double computeSizeInWindowCoordinates(DrawContext drawContext, Extent extent) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (extent == null) {
            String string = Logging.getMessage("nullValue.ExtentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = drawContext.getView().getEyePoint().distanceTo3(extent.getCenter());
        double d2 = drawContext.getView().computePixelSizeAtDistance(d);
        return 2.0 * extent.getRadius() / d2;
    }

    public static double computeSphereProjectedArea(View view, Vec4 vec4, double d) {
        if (view == null) {
            String string = Logging.getMessage("nullValue.ViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.CenterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            String string = Logging.getMessage("Geom.RadiusIsNegative", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d == 0.0) {
            return 0.0;
        }
        double d2 = Math.abs(vec4.transformBy4((Matrix)view.getModelviewMatrix()).z);
        double d3 = d / view.computePixelSizeAtDistance(d2);
        return Math.PI * d3 * d3;
    }

    public static Vec4 computeBufferNormal(FloatBuffer floatBuffer, int n) {
        Vec4[] vec4Array = WWMath.findThreeIndependentVertices(floatBuffer, n);
        return vec4Array != null ? WWMath.computeTriangleNormal(vec4Array[0], vec4Array[1], vec4Array[2]) : null;
    }

    public static Vec4 computeArrayNormal(Vec4[] vec4Array) {
        Vec4[] vec4Array2 = WWMath.findThreeIndependentVertices(vec4Array);
        return vec4Array2 != null ? WWMath.computeTriangleNormal(vec4Array2[0], vec4Array2[1], vec4Array2[2]) : null;
    }

    public static Vec4[] findThreeIndependentVertices(FloatBuffer floatBuffer, int n) {
        Vec4[] vec4Array;
        int n2;
        int n3;
        int n4 = n3 = n > 0 ? n : 3;
        if (floatBuffer == null || floatBuffer.limit() < 3 * n3) {
            return null;
        }
        Vec4 vec4 = new Vec4(floatBuffer.get(0), floatBuffer.get(1), floatBuffer.get(2));
        Vec4 vec42 = null;
        Vec4 vec43 = null;
        for (n2 = n3; n2 < floatBuffer.limit(); n2 += n3) {
            vec42 = new Vec4(floatBuffer.get(n2), floatBuffer.get(n2 + 1), floatBuffer.get(n2 + 2));
            if (vec42.x != vec4.x || vec42.y != vec4.y || vec42.z != vec4.z) break;
            vec42 = null;
        }
        if (vec42 == null) {
            return null;
        }
        n2 += n3;
        while (n2 < floatBuffer.limit()) {
            vec43 = new Vec4(floatBuffer.get(n2), floatBuffer.get(n2 + 1), floatBuffer.get(n2 + 2));
            if (!(vec43.x == vec4.x && vec43.y == vec4.y && vec43.z == vec4.z || vec43.x == vec42.x && vec43.y == vec42.y && vec43.z == vec42.z || Vec4.areColinear(vec4, vec42, vec43))) break;
            vec43 = null;
            n2 += n3;
        }
        if (vec43 != null) {
            Vec4[] vec4Array2 = new Vec4[3];
            vec4Array2[0] = vec4;
            vec4Array2[1] = vec42;
            vec4Array = vec4Array2;
            vec4Array2[2] = vec43;
        } else {
            vec4Array = null;
        }
        return vec4Array;
    }

    public static Vec4[] findThreeIndependentVertices(Vec4[] vec4Array) {
        Vec4[] vec4Array2;
        int n;
        if (vec4Array == null || vec4Array.length < 3) {
            return null;
        }
        Vec4 vec4 = vec4Array[0];
        Vec4 vec42 = null;
        Vec4 vec43 = null;
        for (n = 1; n < vec4Array.length; ++n) {
            vec42 = vec4Array[n];
            if (vec42.x != vec4.x || vec42.y != vec4.y || vec42.z != vec4.z) break;
            vec42 = null;
        }
        if (vec42 == null) {
            return null;
        }
        while (n < vec4Array.length) {
            vec43 = vec4Array[n];
            if (!(vec43.x == vec4.x && vec43.y == vec4.y && vec43.z == vec4.z || vec43.x == vec42.x && vec43.y == vec42.y && vec43.z == vec42.z || Vec4.areColinear(vec4, vec42, vec43))) break;
            vec43 = null;
            ++n;
        }
        if (vec43 != null) {
            Vec4[] vec4Array3 = new Vec4[3];
            vec4Array3[0] = vec4;
            vec4Array3[1] = vec42;
            vec4Array2 = vec4Array3;
            vec4Array3[2] = vec43;
        } else {
            vec4Array2 = null;
        }
        return vec4Array2;
    }

    public static Vec4 computeTriangleNormal(Vec4 vec4, Vec4 vec42, Vec4 vec43) {
        if (vec4 == null || vec42 == null || vec43 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = (vec42.y - vec4.y) * (vec43.z - vec4.z) - (vec42.z - vec4.z) * (vec43.y - vec4.y);
        double d2 = (vec42.z - vec4.z) * (vec43.x - vec4.x) - (vec42.x - vec4.x) * (vec43.z - vec4.z);
        double d3 = (vec42.x - vec4.x) * (vec43.y - vec4.y) - (vec42.y - vec4.y) * (vec43.x - vec4.x);
        double d4 = d * d + d2 * d2 + d3 * d3;
        if (d4 == 0.0) {
            return new Vec4(d, d2, d3);
        }
        d4 = Math.sqrt(d4);
        return new Vec4(d / d4, d2 / d4, d3 / d4);
    }

    public static double computePolygonAreaFromVertices(Iterable<? extends Vec4> iterable) {
        Vec4 vec4;
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterator<? extends Vec4> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return 0.0;
        }
        double d = 0.0;
        Vec4 vec42 = vec4 = iterator.next();
        while (iterator.hasNext()) {
            Vec4 vec43 = iterator.next();
            d += vec42.x * vec43.y;
            d -= vec43.x * vec42.y;
            vec42 = vec43;
        }
        if (!vec42.equals(vec4)) {
            d += vec42.x * vec4.y;
            d -= vec4.x * vec42.y;
        }
        return d /= 2.0;
    }

    public static String computeWindingOrderOfLocations(Iterable<? extends LatLon> iterable) {
        LatLon latLon;
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterator<? extends LatLon> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return "gov.nasa.worldwind.avkey.CounterClockWise";
        }
        if (LatLon.locationsCrossDateLine(iterable)) {
            iterator = LatLon.makeDatelineCrossingLocationsPositive(iterable).iterator();
        }
        double d = 0.0;
        LatLon latLon2 = latLon = iterator.next();
        while (iterator.hasNext()) {
            LatLon latLon3 = iterator.next();
            d += latLon2.getLongitude().degrees * latLon3.getLatitude().degrees;
            d -= latLon3.getLongitude().degrees * latLon2.getLatitude().degrees;
            latLon2 = latLon3;
        }
        if (!latLon2.equals(latLon)) {
            d += latLon2.getLongitude().degrees * latLon.getLatitude().degrees;
            d -= latLon.getLongitude().degrees * latLon2.getLatitude().degrees;
        }
        return d < 0.0 ? "gov.nasa.worldwind.avkey.ClockWise" : "gov.nasa.worldwind.avkey.CounterClockWise";
    }

    public static String computeWindingOrderOfVertices(Iterable<? extends Vec4> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = WWMath.computePolygonAreaFromVertices(iterable);
        return d < 0.0 ? "gov.nasa.worldwind.avkey.ClockWise" : "gov.nasa.worldwind.avkey.CounterClockWise";
    }

    public static Vec4[] computePrincipalAxes(Iterable<? extends Vec4> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix = Matrix.fromCovarianceOfVertices(iterable);
        if (matrix == null) {
            return null;
        }
        final double[] dArray = new double[3];
        Vec4[] vec4Array = new Vec4[3];
        Matrix.computeEigensystemFromSymmetricMatrix3(matrix, dArray, vec4Array);
        Integer[] integerArray = new Integer[]{0, 1, 2};
        Arrays.sort(integerArray, new Comparator<Integer>(){

            @Override
            public int compare(Integer n, Integer n2) {
                return Double.compare(dArray[n], dArray[n2]);
            }
        });
        return new Vec4[]{vec4Array[integerArray[2]].normalize3(), vec4Array[integerArray[1]].normalize3(), vec4Array[integerArray[0]].normalize3()};
    }

    public static Vec4[] computePrincipalAxes(BufferWrapper bufferWrapper, int n) {
        if (bufferWrapper == null) {
            String string = Logging.getMessage("nullValue.CoordinatesAreNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 3) {
            String string = Logging.getMessage("generic.StrideIsInvalid");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix = Matrix.fromCovarianceOfVertices(bufferWrapper, n);
        if (matrix == null) {
            return null;
        }
        final double[] dArray = new double[3];
        Vec4[] vec4Array = new Vec4[3];
        Matrix.computeEigensystemFromSymmetricMatrix3(matrix, dArray, vec4Array);
        Integer[] integerArray = new Integer[]{0, 1, 2};
        Arrays.sort(integerArray, new Comparator<Integer>(){

            @Override
            public int compare(Integer n, Integer n2) {
                return Double.compare(dArray[n], dArray[n2]);
            }
        });
        return new Vec4[]{vec4Array[integerArray[2]].normalize3(), vec4Array[integerArray[1]].normalize3(), vec4Array[integerArray[0]].normalize3()};
    }

    public static boolean isPolygonClosed(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterator<? extends LatLon> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        LatLon latLon = iterator.next();
        LatLon latLon2 = null;
        while (iterator.hasNext()) {
            latLon2 = iterator.next();
        }
        return latLon2 != null && latLon2.equals(latLon);
    }

    public static boolean isPolygonClosed2(Iterable<? extends Vec4> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterator<? extends Vec4> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        Vec4 vec4 = iterator.next();
        Vec4 vec42 = null;
        while (iterator.hasNext()) {
            vec42 = iterator.next();
        }
        return vec42 != null && vec42.x == vec4.x && vec42.y == vec4.y;
    }

    public static boolean isLocationInside(LatLon latLon, Iterable<? extends LatLon> iterable) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterator<? extends LatLon> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        boolean bl = false;
        LatLon latLon2 = iterator.next();
        while (iterator.hasNext()) {
            LatLon latLon3 = iterator.next();
            if ((latLon3.getLatitude().degrees <= latLon.getLatitude().degrees && latLon.getLatitude().degrees < latLon2.getLatitude().degrees || latLon2.getLatitude().degrees <= latLon.getLatitude().degrees && latLon.getLatitude().degrees < latLon3.getLatitude().degrees) && latLon.getLongitude().degrees < (latLon2.getLongitude().degrees - latLon3.getLongitude().degrees) * (latLon.getLatitude().degrees - latLon3.getLatitude().degrees) / (latLon2.getLatitude().degrees - latLon3.getLatitude().degrees) + latLon3.getLongitude().degrees) {
                bl = !bl;
            }
            latLon2 = latLon3;
        }
        return bl;
    }

    public static boolean computeCircleThroughPoints(Vec4 vec4, Vec4 vec42, Vec4 vec43, Vec4[] vec4Array, Vec4[] vec4Array2, double[] dArray) {
        if (vec4 == null || vec42 == null || vec43 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec44 = vec42.subtract3(vec4);
        Vec4 vec45 = vec43.subtract3(vec42);
        Vec4 vec46 = vec43.subtract3(vec4);
        double d = vec44.dot3(vec46);
        double d2 = -vec44.dot3(vec45);
        double d3 = vec45.dot3(vec46);
        double d4 = d2 + d3;
        double d5 = d + d3;
        double d6 = d + d2;
        double d7 = d * d4;
        double d8 = d2 * d5;
        double d9 = d3 * d6;
        double d10 = Math.max(Math.max(d7, d8), d9);
        double d11 = Math.min(Math.min(d7, d8), d9);
        double d12 = d7 + d8 + d9;
        double d13 = 1.0E-6;
        if (Math.abs(d12) <= d13 * (d10 - d11)) {
            return false;
        }
        double d14 = 0.5 * d4 * d5 * d6 / d12;
        if (d14 < 0.0) {
            return false;
        }
        double d15 = Math.sqrt(d14);
        Vec4 vec47 = vec4.multiply3(d7 / d12);
        vec47 = vec47.add3(vec42.multiply3(d8 / d12));
        vec47 = vec47.add3(vec43.multiply3(d9 / d12));
        Vec4 vec48 = vec46.cross3(vec44);
        vec48 = vec48.normalize3();
        if (vec4Array != null) {
            vec4Array[0] = vec47;
        }
        if (vec4Array2 != null) {
            vec4Array2[0] = vec48;
        }
        if (dArray != null) {
            dArray[0] = d15;
        }
        return true;
    }

    public static Intersection[] polytopeIntersect(Line line, Plane[] planeArray) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = -1.7976931348623157E308;
        double d2 = Double.MAX_VALUE;
        boolean bl = false;
        Vec4 vec4 = line.getDirection();
        Vec4 vec42 = line.getOrigin();
        for (Plane plane : planeArray) {
            double d3;
            Vec4 vec43 = plane.getNormal();
            double d4 = -plane.getDistance();
            double d5 = vec4.dot3(vec43);
            if (d5 == 0.0) {
                d3 = vec42.dot3(vec43);
                if (d3 > d4) {
                    return null;
                }
                if (d3 != d4) continue;
                bl = true;
                continue;
            }
            d3 = (d4 - vec42.dot3(vec43)) / d5;
            if (vec4.dot3(vec43) < 0.0) {
                if (!(d3 > d)) continue;
                if (d3 > d2) {
                    return null;
                }
                d = d3;
                continue;
            }
            if (!(d3 < d2)) continue;
            if (d3 < 0.0 || d3 < d) {
                return null;
            }
            d2 = d3;
        }
        if (d >= 0.0) {
            return new Intersection[]{new Intersection(vec42.add3(vec4.multiply3(d)), bl), new Intersection(vec42.add3(vec4.multiply3(d2)), bl)};
        }
        return new Intersection[]{new Intersection(vec42.add3(vec4.multiply3(d2)), bl)};
    }

    public static IntBuffer computeIndicesForGridInterior(int n, int n2) {
        if (n <= 0) {
            String string = Logging.getMessage("Geom.WidthInvalid", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 <= 0) {
            String string = Logging.getMessage("Geom.HeightInvalid", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n3 = (n2 - 1) * (2 * n) + 2 * (n2 - 2);
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)n3);
        for (int i = 0; i < n2 - 1; ++i) {
            if (i != 0) {
                intBuffer.put(n - 1 + (i - 1) * n);
                intBuffer.put(n + i * n);
            }
            for (int j = 0; j < n; ++j) {
                int n4 = j + i * n;
                intBuffer.put(n4 + n);
                intBuffer.put(n4);
            }
        }
        intBuffer.rewind();
        return intBuffer;
    }

    public static IntBuffer computeIndicesForGridOutline(int n, int n2) {
        int n3;
        if (n <= 0) {
            String string = Logging.getMessage("Geom.WidthInvalid", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 <= 0) {
            String string = Logging.getMessage("Geom.HeightInvalid", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n4 = 2 * (n + n2 - 2);
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)n4);
        for (n3 = 0; n3 < n; ++n3) {
            intBuffer.put(n3);
        }
        for (n3 = 1; n3 < n2 - 1; ++n3) {
            intBuffer.put(n - 1 + n3 * n);
        }
        for (n3 = n - 1; n3 >= 0; --n3) {
            intBuffer.put(n3 + (n2 - 1) * n);
        }
        for (n3 = n2 - 2; n3 >= 1; --n3) {
            intBuffer.put(n3 * n);
        }
        intBuffer.rewind();
        return intBuffer;
    }

    public static FloatBuffer computeNormalsForIndexedTriangleStrip(IntBuffer intBuffer, FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        int n;
        if (intBuffer == null) {
            String string = Logging.getMessage("nullValue.IndexBufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer == null) {
            String string = Logging.getMessage("nullValue.VertexBufferNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = intBuffer.remaining();
        int n3 = floatBuffer.remaining() / 3;
        if (floatBuffer2 == null) {
            floatBuffer2 = Buffers.newDirectFloatBuffer((int)(3 * n3));
        } else {
            for (int i = 0; i < n3; ++i) {
                floatBuffer2.put(0.0f);
                floatBuffer2.put(0.0f);
                floatBuffer2.put(0.0f);
            }
            floatBuffer2.rewind();
        }
        int[] nArray = new int[3];
        for (n = 2; n < n2; ++n) {
            intBuffer.position(n - 2);
            intBuffer.get(nArray);
            if (n % 2 != 0) {
                int n4 = nArray[0];
                nArray[0] = nArray[1];
                nArray[1] = n4;
            }
            WWMath.addTriangleNormal(3 * nArray[0], 3 * nArray[1], 3 * nArray[2], floatBuffer, floatBuffer2);
        }
        intBuffer.rewind();
        floatBuffer.rewind();
        floatBuffer2.rewind();
        for (n = 0; n < n3; ++n) {
            WWMath.normalize3(floatBuffer2);
        }
        floatBuffer2.rewind();
        return floatBuffer2;
    }

    protected static void addTriangleNormal(int n, int n2, int n3, FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        floatBuffer.position(n);
        float f = floatBuffer.get();
        float f2 = floatBuffer.get();
        float f3 = floatBuffer.get();
        floatBuffer.position(n2);
        float f4 = floatBuffer.get();
        float f5 = floatBuffer.get();
        float f6 = floatBuffer.get();
        floatBuffer.position(n3);
        float f7 = floatBuffer.get();
        float f8 = floatBuffer.get();
        float f9 = floatBuffer.get();
        float f10 = (f5 - f2) * (f9 - f3) - (f6 - f3) * (f8 - f2);
        float f11 = (f6 - f3) * (f7 - f) - (f4 - f) * (f9 - f3);
        float f12 = (f4 - f) * (f8 - f2) - (f5 - f2) * (f7 - f);
        float f13 = f10 * f10 + f11 * f11 + f12 * f12;
        if ((double)f13 > 0.0) {
            f13 = (float)Math.sqrt(f13);
            f10 /= f13;
            f11 /= f13;
            f12 /= f13;
        }
        floatBuffer2.position(n);
        float f14 = floatBuffer2.get();
        float f15 = floatBuffer2.get();
        float f16 = floatBuffer2.get();
        floatBuffer2.position(n);
        floatBuffer2.put(f14 + f10);
        floatBuffer2.put(f15 + f11);
        floatBuffer2.put(f16 + f12);
        floatBuffer2.position(n2);
        f14 = floatBuffer2.get();
        f15 = floatBuffer2.get();
        f16 = floatBuffer2.get();
        floatBuffer2.position(n2);
        floatBuffer2.put(f14 + f10);
        floatBuffer2.put(f15 + f11);
        floatBuffer2.put(f16 + f12);
        floatBuffer2.position(n3);
        f14 = floatBuffer2.get();
        f15 = floatBuffer2.get();
        f16 = floatBuffer2.get();
        floatBuffer2.position(n3);
        floatBuffer2.put(f14 + f10);
        floatBuffer2.put(f15 + f11);
        floatBuffer2.put(f16 + f12);
    }

    protected static void normalize3(FloatBuffer floatBuffer) {
        float f;
        float f2;
        int n = floatBuffer.position();
        float f3 = floatBuffer.get();
        float f4 = f3 * f3 + (f2 = floatBuffer.get()) * f2 + (f = floatBuffer.get()) * f;
        if ((double)f4 > 0.0) {
            f4 = (float)Math.sqrt(f4);
            f3 /= f4;
            f2 /= f4;
            f /= f4;
        }
        floatBuffer.position(n);
        floatBuffer.put(f3);
        floatBuffer.put(f2);
        floatBuffer.put(f);
    }

    public static List<Point> bresenham(int n, int n2, int n3, int n4) {
        int n5;
        boolean bl;
        ArrayList<Point> arrayList = new ArrayList<Point>(Math.abs(n3 - n + 1));
        boolean bl2 = bl = Math.abs(n4 - n2) > Math.abs(n3 - n);
        if (bl) {
            n5 = n;
            n = n2;
            n2 = n5;
            n5 = n3;
            n3 = n4;
            n4 = n5;
        }
        if (n > n3) {
            n5 = n;
            n = n3;
            n3 = n5;
            n5 = n2;
            n2 = n4;
            n4 = n5;
        }
        n5 = n3 - n;
        int n6 = Math.abs(n4 - n2);
        int n7 = n5 / 2;
        int n8 = n2 < n4 ? 1 : -1;
        int n9 = n2;
        for (int i = n; i <= n3; ++i) {
            if (bl) {
                arrayList.add(new Point(n9, i));
            } else {
                arrayList.add(new Point(i, n9));
            }
            if ((n7 -= n6) >= 0) continue;
            n9 += n8;
            n7 += n5;
        }
        return arrayList;
    }

    public static void generateParallelLines(List<Position> list, List<Position> list2, List<Position> list3, double d, Globe globe) {
        if (list == null || list2 == null || list3 == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list.size() < 2) {
            String string = Logging.getMessage("generic.LengthIsInvalid");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterator<Position> iterator = list.iterator();
        Position position = iterator.next();
        Position position2 = iterator.next();
        Vec4 vec4 = globe.computePointFromLocation(position2);
        Vec4 vec42 = globe.computePointFromLocation(position);
        Vec4 vec43 = null;
        vec43 = WWMath.generateParallelPoints(vec42, null, vec4, list2, list3, d, position.getElevation(), globe, vec43);
        while (iterator.hasNext()) {
            double d2 = position2.getElevation();
            position2 = iterator.next();
            Vec4 vec44 = vec42;
            vec42 = vec4;
            vec4 = globe.computePointFromLocation(position2);
            vec43 = WWMath.generateParallelPoints(vec42, vec44, vec4, list2, list3, d, d2, globe, vec43);
        }
        WWMath.generateParallelPoints(vec4, vec42, null, list2, list3, d, position2.getElevation(), globe, vec43);
    }

    public static Vec4 generateParallelPoints(Vec4 vec4, Vec4 vec42, Vec4 vec43, List<Position> list, List<Position> list2, double d, double d2, Globe globe, Vec4 vec44) {
        Object object;
        Vec4 vec45;
        Vec4 vec46;
        if (vec4 == null || vec42 == null && vec43 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null || list2 == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec47 = globe.computeSurfaceNormalAtPoint(vec4);
        Vec4 vec48 = vec42 != null ? vec42.subtract3(vec4) : vec4.subtract3(vec43);
        Vec4 vec49 = vec48.cross3(vec47);
        if (vec4.equals(vec42) || vec4.equals(vec43) && vec44 != null) {
            vec46 = vec44;
        } else if (vec43 != null && vec42 != null && !Vec4.areColinear(vec42, vec4, vec43)) {
            vec45 = vec43.subtract3(vec4);
            vec46 = vec45.normalize3().add3(vec48.normalize3());
            vec46 = vec46.normalize3();
            object = vec48.angleBetween3(vec46);
            double d3 = ((Angle)object).degrees > 0.1 ? d / ((Angle)object).sin() : d;
            double d4 = vec49.dot3(vec46);
            if (d4 < 0.0) {
                vec46 = vec46.multiply3(-1.0);
            }
            vec46 = vec46.multiply3(d3);
        } else {
            vec46 = vec49.normalize3();
            vec46 = vec46.multiply3(d);
        }
        vec45 = vec4.add3(vec46);
        object = vec4.subtract3(vec46);
        Position position = new Position(globe.computePositionFromPoint((Vec4)object), d2);
        Position position2 = new Position(globe.computePositionFromPoint(vec45), d2);
        list.add(position);
        list2.add(position2);
        return vec46;
    }
}

