/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwind.util.Logging;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.media.opengl.GL2;

public class VecBuffer {
    protected int coordsPerVec;
    protected BufferWrapper buffer;

    public VecBuffer(int n, BufferWrapper bufferWrapper) {
        if (n < 1) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "coordsPerVec < 1");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (bufferWrapper == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.coordsPerVec = n;
        this.buffer = bufferWrapper;
    }

    public static VecBuffer emptyVecBuffer(int n) {
        return new VecBuffer(n, BufferWrapper.emptyBufferWrapper());
    }

    public int getCoordsPerVec() {
        return this.coordsPerVec;
    }

    public int getSize() {
        return this.buffer.length() / this.coordsPerVec;
    }

    public BufferWrapper getBufferWrapper() {
        return this.buffer;
    }

    public double[] get(int n, double[] dArray) {
        if (n < 0 || n >= this.getSize()) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "position < 0 or position >= size");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = this.indexFromVectorPosition(n);
        int n3 = dArray.length;
        if (n3 > this.coordsPerVec) {
            n3 = this.coordsPerVec;
        }
        this.buffer.getDouble(n2, dArray, 0, n3);
        return dArray;
    }

    public float[] getFloat(int n, float[] fArray) {
        if (n < 0 || n >= this.getSize()) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "position < 0 or position >= size");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = this.indexFromVectorPosition(n);
        int n3 = fArray.length;
        if (n3 > this.coordsPerVec) {
            n3 = this.coordsPerVec;
        }
        this.buffer.getFloat(n2, fArray, 0, n3);
        return fArray;
    }

    public void put(int n, double[] dArray) {
        if (n < 0 || n >= this.getSize()) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "position < 0 or position >= size");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = this.indexFromVectorPosition(n);
        int n3 = dArray.length;
        if (n3 > this.coordsPerVec) {
            n3 = this.coordsPerVec;
        }
        this.buffer.putDouble(n2, dArray, 0, n3);
    }

    public void putFloat(int n, float[] fArray) {
        if (n < 0 || n >= this.getSize()) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "position < 0 or position >= size");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = this.indexFromVectorPosition(n);
        int n3 = fArray.length;
        if (n3 > this.coordsPerVec) {
            n3 = this.coordsPerVec;
        }
        this.buffer.putFloat(n2, fArray, 0, n3);
    }

    public void putAll(int n, double[] dArray, int n2) {
        if (n < 0 || n + n2 > this.getSize()) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "position < 0 or position + count >= size");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n3 = this.indexFromVectorPosition(n);
        int n4 = this.indexFromVectorPosition(n2);
        if (dArray.length < n4) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", dArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.buffer.putDouble(n3, dArray, 0, n4);
    }

    public VecBuffer getSubBuffer(int n, int n2) {
        if (n < 0 || n >= this.getSize()) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "position < 0 or position >= size");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n3 = this.indexFromVectorPosition(n);
        int n4 = this.indexFromVectorPosition(n2);
        BufferWrapper bufferWrapper = this.buffer.getSubBuffer(n3, n4);
        return new VecBuffer(this.coordsPerVec, bufferWrapper);
    }

    public void putSubBuffer(int n, VecBuffer vecBuffer) {
        if (n < 0 || n >= this.getSize()) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "position < 0 or position >= size");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vecBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.putSubBuffer(n, vecBuffer, 0, vecBuffer.getSize());
    }

    public void putSubBuffer(int n, VecBuffer vecBuffer, int n2, int n3) {
        if (n < 0 || n >= this.getSize()) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "position < 0 or position >= size");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vecBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vecBuffer.getSize() < n2 + n3) {
            String string = Logging.getMessage("generic.BufferOverflow", vecBuffer.getSize(), n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.coordsPerVec != vecBuffer.coordsPerVec) {
            String string = Logging.getMessage("generic.BufferIncompatible", vecBuffer);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n4 = n + n3;
        if (this.getSize() < n4) {
            String string = Logging.getMessage("generic.BufferOverflow", this.getSize(), n4);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n5 = this.indexFromVectorPosition(n);
        int n6 = this.indexFromVectorPosition(n2);
        int n7 = this.indexFromVectorPosition(n3);
        this.buffer.putSubBuffer(n5, vecBuffer.getBufferWrapper(), n6, n7);
    }

    public Vec4 getVector(int n) {
        if (n < 0 || n >= this.getSize()) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "position < 0 or position >= size");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.coordsPerVec != 2 && this.coordsPerVec != 3 && this.coordsPerVec != 4) {
            String string = Logging.getMessage("generic.BufferIncompatible", this);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[this.coordsPerVec];
        this.get(n, dArray);
        return Vec4.fromDoubleArray(dArray, 0, this.coordsPerVec);
    }

    public void putVector(int n, Vec4 vec4) {
        if (n < 0 || n >= this.getSize()) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "position < 0 or position >= size");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.coordsPerVec != 2 && this.coordsPerVec != 3 && this.coordsPerVec != 4) {
            String string = Logging.getMessage("generic.BufferIncompatible", this);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[this.coordsPerVec];
        vec4.toDoubleArray(dArray, 0, this.coordsPerVec);
        this.put(n, dArray);
    }

    public LatLon getLocation(int n) {
        if (n < 0 || n >= this.getSize()) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "position < 0 or position >= size");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.coordsPerVec < 2) {
            String string = Logging.getMessage("generic.BufferIncompatible", this);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[2];
        this.get(n, dArray);
        return LatLon.fromDegrees(dArray[1], dArray[0]);
    }

    public void putLocation(int n, LatLon latLon) {
        if (n < 0 || n >= this.getSize()) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "position < 0 or position >= size");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.coordsPerVec < 2) {
            String string = Logging.getMessage("generic.BufferIncompatible", this);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[2];
        dArray[1] = latLon.getLatitude().degrees;
        dArray[0] = latLon.getLongitude().degrees;
        this.put(n, dArray);
    }

    public Position getPosition(int n) {
        if (n < 0 || n >= this.getSize()) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "position < 0 or position >= size");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.coordsPerVec < 2) {
            String string = Logging.getMessage("generic.BufferIncompatible", this);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[this.coordsPerVec];
        this.get(n, dArray);
        return Position.fromDegrees(dArray[1], dArray[0], this.coordsPerVec > 2 ? dArray[2] : 0.0);
    }

    public void putPosition(int n, Position position) {
        if (n < 0 || n >= this.getSize()) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "position < 0 or position >= size");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.coordsPerVec < 2) {
            String string = Logging.getMessage("generic.BufferIncompatible", this);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[3];
        dArray[1] = position.getLatitude().degrees;
        dArray[0] = position.getLongitude().degrees;
        dArray[2] = position.getElevation();
        this.put(n, dArray);
    }

    public VecBuffer copyOf(int n) {
        if (n < this.getSize()) {
            String string = Logging.getMessage("generic.SizeOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        BufferWrapper bufferWrapper = this.buffer.copyOf(this.coordsPerVec * n);
        return new VecBuffer(this.coordsPerVec, bufferWrapper);
    }

    public Iterable<double[]> getCoords() {
        return this.getCoords(this.coordsPerVec);
    }

    public Iterable<double[]> getCoords(final int n) {
        return new Iterable<double[]>(){

            @Override
            public Iterator<double[]> iterator() {
                return new BasicIterator<double[]>(new CoordAccessor(n));
            }
        };
    }

    public Iterable<double[]> getReverseCoords(final int n) {
        return new Iterable<double[]>(){

            @Override
            public Iterator<double[]> iterator() {
                return new ReverseIterator<double[]>(new CoordAccessor(n));
            }
        };
    }

    public void putCoords(int n, Iterable<double[]> iterable) {
        if (n < 0 || n >= this.getSize()) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "position < 0 or position >= size");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = n;
        for (double[] dArray : iterable) {
            this.put(n2, dArray);
            if (++n2 < this.getSize()) continue;
            break;
        }
    }

    public Iterable<Vec4> getVectors() {
        return new Iterable<Vec4>(){

            @Override
            public Iterator<Vec4> iterator() {
                return new BasicIterator<Vec4>(new VectorAccessor());
            }
        };
    }

    public Iterable<Vec4> getReverseVectors() {
        return new Iterable<Vec4>(){

            @Override
            public Iterator<Vec4> iterator() {
                return new ReverseIterator<Vec4>(new VectorAccessor());
            }
        };
    }

    public void putVectors(int n, Iterable<? extends Vec4> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = n;
        for (Vec4 vec4 : iterable) {
            this.putVector(n2, vec4);
            if (++n2 < this.getSize()) continue;
            break;
        }
    }

    public Iterable<LatLon> getLocations() {
        return new Iterable<LatLon>(){

            @Override
            public Iterator<LatLon> iterator() {
                return new BasicIterator<LatLon>(new LocationAccessor());
            }
        };
    }

    public Iterable<LatLon> getReverseLocations() {
        return new Iterable<LatLon>(){

            @Override
            public Iterator<LatLon> iterator() {
                return new ReverseIterator<LatLon>(new LocationAccessor());
            }
        };
    }

    public void putLocations(int n, Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = n;
        for (LatLon latLon : iterable) {
            this.putLocation(n2, latLon);
            if (++n2 < this.getSize()) continue;
            break;
        }
    }

    public Iterable<Position> getPositions() {
        return new Iterable<Position>(){

            @Override
            public Iterator<Position> iterator() {
                return new BasicIterator<Position>(new PositionAccessor());
            }
        };
    }

    public Iterable<Position> getReversePositions() {
        return new Iterable<Position>(){

            @Override
            public Iterator<Position> iterator() {
                return new ReverseIterator<Position>(new PositionAccessor());
            }
        };
    }

    public void putPositions(int n, Iterable<? extends Position> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = n;
        for (Position position : iterable) {
            this.putPosition(n2, position);
            if (++n2 < this.getSize()) continue;
            break;
        }
    }

    public void bindAsColorBuffer(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.coordsPerVec != 3 && this.coordsPerVec != 4) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "coordinates per vertex = " + this.coordsPerVec);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glColorPointer(this.coordsPerVec, this.buffer.getGLDataType(), 0, this.buffer.getBackingBuffer());
    }

    public void bindAsNormalBuffer(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.coordsPerVec != 3) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "coordinates per vertex = " + this.coordsPerVec);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glNormalPointer(this.buffer.getGLDataType(), 0, this.buffer.getBackingBuffer());
    }

    public void bindAsVertexBuffer(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.coordsPerVec != 2 && this.coordsPerVec != 3 && this.coordsPerVec != 4) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "coordinates per vertex = " + this.coordsPerVec);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glVertexPointer(this.coordsPerVec, this.buffer.getGLDataType(), 0, this.buffer.getBackingBuffer());
    }

    public void bindAsTexCoordBuffer(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.coordsPerVec != 1 && this.coordsPerVec != 2 && this.coordsPerVec != 3 && this.coordsPerVec != 4) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "coordinates per vertex = " + this.coordsPerVec);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glTexCoordPointer(this.coordsPerVec, this.buffer.getGLDataType(), 0, this.buffer.getBackingBuffer());
    }

    public void drawArrays(DrawContext drawContext, int n) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        drawContext.getGL().glDrawArrays(n, 0, this.getSize());
    }

    protected int indexFromVectorPosition(int n) {
        return this.coordsPerVec * n;
    }

    protected int vectorPositionFromIndex(int n) {
        return n / this.coordsPerVec;
    }

    protected class PositionAccessor
    implements ElementAccessor<Position> {
        protected PositionAccessor() {
        }

        @Override
        public Position getElement(int n) {
            return VecBuffer.this.getPosition(n);
        }
    }

    protected class LocationAccessor
    implements ElementAccessor<LatLon> {
        protected LocationAccessor() {
        }

        @Override
        public LatLon getElement(int n) {
            return VecBuffer.this.getLocation(n);
        }
    }

    protected class VectorAccessor
    implements ElementAccessor<Vec4> {
        protected VectorAccessor() {
        }

        @Override
        public Vec4 getElement(int n) {
            return VecBuffer.this.getVector(n);
        }
    }

    protected class CoordAccessor
    implements ElementAccessor<double[]> {
        private int numCoords;

        public CoordAccessor(int n) {
            this.numCoords = VecBuffer.this.coordsPerVec;
            if (this.numCoords < n) {
                this.numCoords = n;
            }
        }

        @Override
        public double[] getElement(int n) {
            double[] dArray = new double[this.numCoords];
            VecBuffer.this.get(n, dArray);
            return dArray;
        }
    }

    protected static interface ElementAccessor<T> {
        public T getElement(int var1);
    }

    protected class ReverseIterator<T>
    implements Iterator<T> {
        protected int position;
        protected ElementAccessor<T> accessor;

        public ReverseIterator(ElementAccessor<T> elementAccessor) {
            this.position = VecBuffer.this.getSize();
            this.accessor = elementAccessor;
        }

        @Override
        public boolean hasNext() {
            return this.position > 0;
        }

        @Override
        public T next() {
            --this.position;
            if (this.position >= 0) {
                return this.accessor.getElement(this.position);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class BasicIterator<T>
    implements Iterator<T> {
        protected int position = -1;
        protected final int size;
        protected ElementAccessor<T> accessor;

        public BasicIterator(ElementAccessor<T> elementAccessor) {
            this.size = VecBuffer.this.getSize();
            this.accessor = elementAccessor;
        }

        @Override
        public boolean hasNext() {
            return this.position < this.size - 1;
        }

        @Override
        public T next() {
            ++this.position;
            if (this.position < this.size) {
                return this.accessor.getElement(this.position);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

