/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUtessellator;
import javax.media.opengl.glu.GLUtessellatorCallback;
import javax.media.opengl.glu.GLUtessellatorCallbackAdapter;

public class GLUTessellatorSupport {
    protected GLUtessellator tess;

    public GLUtessellator getGLUtessellator() {
        return this.tess;
    }

    public void beginTessellation(GLUtessellatorCallback gLUtessellatorCallback, Vec4 vec4) {
        if (gLUtessellatorCallback == null) {
            String string = Logging.getMessage("nullValue.CallbackIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.NormalIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.tess = GLU.gluNewTess();
        GLU.gluTessNormal((GLUtessellator)this.tess, (double)vec4.x, (double)vec4.y, (double)vec4.z);
        GLU.gluTessCallback((GLUtessellator)this.tess, (int)100100, (GLUtessellatorCallback)gLUtessellatorCallback);
        GLU.gluTessCallback((GLUtessellator)this.tess, (int)100101, (GLUtessellatorCallback)gLUtessellatorCallback);
        GLU.gluTessCallback((GLUtessellator)this.tess, (int)100102, (GLUtessellatorCallback)gLUtessellatorCallback);
        GLU.gluTessCallback((GLUtessellator)this.tess, (int)100105, (GLUtessellatorCallback)gLUtessellatorCallback);
    }

    public void endTessellation() {
        GLU.gluTessCallback((GLUtessellator)this.tess, (int)100100, null);
        GLU.gluTessCallback((GLUtessellator)this.tess, (int)100101, null);
        GLU.gluTessCallback((GLUtessellator)this.tess, (int)100102, null);
        GLU.gluTessCallback((GLUtessellator)this.tess, (int)100105, null);
        this.tess = null;
    }

    public static GLUtessellatorCallback createOGLDrawPrimitivesCallback(GL2 gL2) {
        if (gL2 == null) {
            String string = Logging.getMessage("nullValue.GLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new OGLDrawPrimitivesCallback(gL2);
    }

    public static class CollectIndexListsCallback
    extends GLUtessellatorCallbackAdapter {
        protected int numIndices;
        protected int currentType;
        protected List<Integer> currentPrim;
        protected List<List<Integer>> prims = new ArrayList<List<Integer>>();
        protected List<Integer> primTypes = new ArrayList<Integer>();

        public List<List<Integer>> getPrims() {
            return this.prims;
        }

        public List<Integer> getPrimTypes() {
            return this.primTypes;
        }

        public int getNumIndices() {
            return this.numIndices;
        }

        public void begin(int n) {
            this.currentType = n;
            this.currentPrim = new ArrayList<Integer>();
        }

        public void vertex(Object object) {
            this.currentPrim.add((Integer)object);
            ++this.numIndices;
        }

        public void end() {
            this.primTypes.add(this.currentType);
            this.prims.add(this.currentPrim);
            this.currentPrim = null;
        }

        public void combine(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2) {
            objectArray2[0] = objectArray[0];
        }
    }

    protected static class OGLDrawPrimitivesCallback
    extends GLUtessellatorCallbackAdapter {
        protected final GL2 gl;

        public OGLDrawPrimitivesCallback(GL2 gL2) {
            if (gL2 == null) {
                String string = Logging.getMessage("nullValue.GLIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.gl = gL2;
        }

        public void begin(int n) {
            this.gl.glBegin(n);
        }

        public void vertex(Object object) {
            double[] dArray = (double[])object;
            this.gl.glVertex3f((float)dArray[0], (float)dArray[1], (float)dArray[2]);
        }

        public void end() {
            this.gl.glEnd();
        }

        public void combine(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2) {
            objectArray2[0] = dArray;
        }
    }
}

