/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EntityMap {
    protected static final List<Pattern> patterns = new ArrayList<Pattern>();
    protected static final HashMap<String, String> map;
    protected static String[] entityKeys;
    protected static final String[] entityReplacements;

    public static String replaceAll(String string) {
        int n = 0;
        String string2 = EntityMap.getNextEntity(string, n);
        while (string2 != null) {
            String string3 = EntityMap.get(string2);
            if (string3 == null) {
                n += string2.length();
            } else {
                string = string.replace(string2, string3);
                n += string3.length();
            }
            string2 = EntityMap.getNextEntity(string, n);
        }
        return string;
    }

    protected static String getNextEntity(String string, int n) {
        if (string == null) {
            return null;
        }
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(string);
            matcher.region(n, string.length());
            if (!matcher.find()) continue;
            return matcher.group();
        }
        return null;
    }

    public static String get(String string) {
        if (string == null) {
            return null;
        }
        return map.get(string);
    }

    /*
     * Opcode count of 17226 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        patterns.add(Pattern.compile("&[^;]+;"));
        map = new HashMap();
        entityKeys = new String[]{"&#x1fbf;", "&#x1ffe;", "&#x2d8;", "&#x2db;", "&#x2dd;", "&#x2f3;", "&#x309;", "&#x30a;", "&#x30f;", "&#x311;", "&#x31b;", "&#x483;", "&AElig;", "&AMP;", "&Aacute;", "&Abreve;", "&Acirc;", "&Acy;", "&Afr;", "&Agrave;", "&Alpha;", "&Amacr;", "&And;", "&Aogon;", "&Aopf;", "&ApplyFunction;", "&Aring;", "&Ascr;", "&Assign;", "&Atilde;", "&Auml;", "&Backslash;", "&Barv;", "&Barwed;", "&Bcy;", "&Because;", "&Bernoullis;", "&Beta;", "&Bfr;", "&Bopf;", "&Breve;", "&Bscr;", "&Bumpeq;", "&CHcy;", "&COPY;", "&Cacute;", "&Cap;", "&CapitalDifferentialD;", "&Cayleys;", "&Ccaron;", "&Ccedil;", "&Ccirc;", "&Cconint;", "&Cdot;", "&Cedilla;", "&CenterDot;", "&Cfr;", "&Chi;", "&CircleDot;", "&CircleMinus;", "&CirclePlus;", "&CircleTimes;", "&ClockwiseContourIntegral;", "&CloseCurlyDoubleQuote;", "&CloseCurlyQuote;", "&Colon;", "&Colone;", "&Congruent;", "&Conint;", "&ContourIntegral;", "&Copf;", "&Coproduct;", "&CounterClockwiseContourIntegral;", "&Cross;", "&Cscr;", "&Cup;", "&CupCap;", "&DD;", "&DDotrahd;", "&DJcy;", "&DScy;", "&DZcy;", "&Dagger;", "&Darr;", "&Dashv;", "&Dcaron;", "&Dcy;", "&Del;", "&Delta;", "&Dfr;", "&DiacriticalAcute;", "&DiacriticalDot;", "&DiacriticalDoubleAcute;", "&DiacriticalGrave;", "&DiacriticalTilde;", "&Diamond;", "&DifferentialD;", "&Dopf;", "&Dot;", "&DotDot;", "&DotEqual;", "&DoubleContourIntegral;", "&DoubleDot;", "&DoubleDownArrow;", "&DoubleLeftArrow;", "&DoubleLeftRightArrow;", "&DoubleLeftTee;", "&DoubleLongLeftArrow;", "&DoubleLongLeftRightArrow;", "&DoubleLongRightArrow;", "&DoubleRightArrow;", "&DoubleRightTee;", "&DoubleUpArrow;", "&DoubleUpDownArrow;", "&DoubleVerticalBar;", "&DownArrow;", "&DownArrowBar;", "&DownArrowUpArrow;", "&DownBreve;", "&DownLeftRightVector;", "&DownLeftTeeVector;", "&DownLeftVector;", "&DownLeftVectorBar;", "&DownRightTeeVector;", "&DownRightVector;", "&DownRightVectorBar;", "&DownTee;", "&DownTeeArrow;", "&Downarrow;", "&Dscr;", "&Dstrok;", "&ENG;", "&ETH;", "&Eacute;", "&Ecaron;", "&Ecirc;", "&Ecy;", "&Edot;", "&Efr;", "&Egrave;", "&Element;", "&Emacr;", "&EmptySmallSquare;", "&EmptyVerySmallSquare;", "&Eogon;", "&Eopf;", "&Epsilon;", "&Equal;", "&EqualTilde;", "&Equilibrium;", "&Escr;", "&Esim;", "&Eta;", "&Euml;", "&Exists;", "&ExponentialE;", "&Fcy;", "&Ffr;", "&FilledSmallSquare;", "&FilledVerySmallSquare;", "&Fopf;", "&ForAll;", "&Fouriertrf;", "&Fscr;", "&GJcy;", "&GT;", "&Gamma;", "&Gammad;", "&Gbreve;", "&Gcedil;", "&Gcirc;", "&Gcy;", "&Gdot;", "&Gfr;", "&Gg;", "&Gopf;", "&GreaterEqual;", "&GreaterEqualLess;", "&GreaterFullEqual;", "&GreaterGreater;", "&GreaterLess;", "&GreaterSlantEqual;", "&GreaterTilde;", "&Gscr;", "&Gt;", "&HARDcy;", "&Hacek;", "&Hat;", "&Hcirc;", "&Hfr;", "&HilbertSpace;", "&Hopf;", "&HorizontalLine;", "&Hscr;", "&Hstrok;", "&HumpDownHump;", "&HumpEqual;", "&IEcy;", "&IJlig;", "&IOcy;", "&Iacute;", "&Icirc;", "&Icy;", "&Idot;", "&Ifr;", "&Igrave;", "&Im;", "&Imacr;", "&ImaginaryI;", "&Implies;", "&Integral;", "&Intersection;", "&InvisibleComma;", "&InvisibleTimes;", "&Iogon;", "&Iopf;", "&Iota;", "&Iscr;", "&Itilde;", "&Iukcy;", "&Iuml;", "&Jcirc;", "&Jcy;", "&Jfr;", "&Jopf;", "&Jscr;", "&Jsercy;", "&Jukcy;", "&KHcy;", "&KJcy;", "&Kappa;", "&Kcedil;", "&Kcy;", "&Kfr;", "&Kopf;", "&Kscr;", "&LJcy;", "&LT;", "&Lacute;", "&Lambda;", "&Lang;", "&Laplacetrf;", "&Larr;", "&Lcaron;", "&Lcedil;", "&Lcy;", "&LeftAngleBracket;", "&LeftArrow;", "&LeftArrowBar;", "&LeftArrowRightArrow;", "&LeftCeiling;", "&LeftDoubleBracket;", "&LeftDownTeeVector;", "&LeftDownVector;", "&LeftDownVectorBar;", "&LeftFloor;", "&LeftRightArrow;", "&LeftRightVector;", "&LeftTee;", "&LeftTeeArrow;", "&LeftTeeVector;", "&LeftTriangle;", "&LeftTriangleBar;", "&LeftTriangleEqual;", "&LeftUpDownVector;", "&LeftUpTeeVector;", "&LeftUpVector;", "&LeftUpVectorBar;", "&LeftVector;", "&LeftVectorBar;", "&Leftarrow;", "&Leftrightarrow;", "&LessEqualGreater;", "&LessFullEqual;", "&LessGreater;", "&LessLess;", "&LessSlantEqual;", "&LessTilde;", "&Lfr;", "&Ll;", "&Lleftarrow;", "&Lmidot;", "&LongLeftArrow;", "&LongLeftRightArrow;", "&LongRightArrow;", "&Longleftarrow;", "&Longleftrightarrow;", "&Longrightarrow;", "&Lopf;", "&LowerLeftArrow;", "&LowerRightArrow;", "&Lscr;", "&Lsh;", "&Lstrok;", "&Lt;", "&Map;", "&Mcy;", "&MediumSpace;", "&Mellintrf;", "&Mfr;", "&MinusPlus;", "&Mopf;", "&Mscr;", "&Mu;", "&NJcy;", "&Nacute;", "&Ncaron;", "&Ncedil;", "&Ncy;", "&NegativeMediumSpace;", "&NegativeThickSpace;", "&NegativeThinSpace;", "&NegativeVeryThinSpace;", "&NestedGreaterGreater;", "&NestedLessLess;", "&NewLine;", "&Nfr;", "&NoBreak;", "&NonBreakingSpace;", "&Nopf;", "&Not;", "&NotCongruent;", "&NotCupCap;", "&NotDoubleVerticalBar;", "&NotElement;", "&NotEqual;", "&NotEqualTilde;", "&NotExists;", "&NotGreater;", "&NotGreaterEqual;", "&NotGreaterFullEqual;", "&NotGreaterGreater;", "&NotGreaterLess;", "&NotGreaterSlantEqual;", "&NotGreaterTilde;", "&NotHumpDownHump;", "&NotHumpEqual;", "&NotLeftTriangle;", "&NotLeftTriangleBar;", "&NotLeftTriangleEqual;", "&NotLess;", "&NotLessEqual;", "&NotLessGreater;", "&NotLessLess;", "&NotLessSlantEqual;", "&NotLessTilde;", "&NotNestedGreaterGreater;", "&NotNestedLessLess;", "&NotPrecedes;", "&NotPrecedesEqual;", "&NotPrecedesSlantEqual;", "&NotReverseElement;", "&NotRightTriangle;", "&NotRightTriangleBar;", "&NotRightTriangleEqual;", "&NotSquareSubset;", "&NotSquareSubsetEqual;", "&NotSquareSuperset;", "&NotSquareSupersetEqual;", "&NotSubset;", "&NotSubsetEqual;", "&NotSucceeds;", "&NotSucceedsEqual;", "&NotSucceedsSlantEqual;", "&NotSucceedsTilde;", "&NotSuperset;", "&NotSupersetEqual;", "&NotTilde;", "&NotTildeEqual;", "&NotTildeFullEqual;", "&NotTildeTilde;", "&NotVerticalBar;", "&Nscr;", "&Ntilde;", "&Nu;", "&OElig;", "&Oacute;", "&Ocirc;", "&Ocy;", "&Odblac;", "&Ofr;", "&Ograve;", "&Omacr;", "&Omega;", "&Omicron;", "&Oopf;", "&OpenCurlyDoubleQuote;", "&OpenCurlyQuote;", "&Or;", "&Oscr;", "&Oslash;", "&Otilde;", "&Otimes;", "&Ouml;", "&OverBar;", "&OverBrace;", "&OverBracket;", "&OverParenthesis;", "&PartialD;", "&Pcy;", "&Pfr;", "&Phi;", "&Pi;", "&PlusMinus;", "&Poincareplane;", "&Popf;", "&Pr;", "&Precedes;", "&PrecedesEqual;", "&PrecedesSlantEqual;", "&PrecedesTilde;", "&Prime;", "&Product;", "&Proportion;", "&Proportional;", "&Pscr;", "&Psi;", "&QUOT;", "&Qfr;", "&Qopf;", "&Qscr;", "&RBarr;", "&REG;", "&Racute;", "&Rang;", "&Rarr;", "&Rarrtl;", "&Rcaron;", "&Rcedil;", "&Rcy;", "&Re;", "&ReverseElement;", "&ReverseEquilibrium;", "&ReverseUpEquilibrium;", "&Rfr;", "&Rho;", "&RightAngleBracket;", "&RightArrow;", "&RightArrowBar;", "&RightArrowLeftArrow;", "&RightCeiling;", "&RightDoubleBracket;", "&RightDownTeeVector;", "&RightDownVector;", "&RightDownVectorBar;", "&RightFloor;", "&RightTee;", "&RightTeeArrow;", "&RightTeeVector;", "&RightTriangle;", "&RightTriangleBar;", "&RightTriangleEqual;", "&RightUpDownVector;", "&RightUpTeeVector;", "&RightUpVector;", "&RightUpVectorBar;", "&RightVector;", "&RightVectorBar;", "&Rightarrow;", "&Ropf;", "&RoundImplies;", "&Rrightarrow;", "&Rscr;", "&Rsh;", "&RuleDelayed;", "&SHCHcy;", "&SHcy;", "&SOFTcy;", "&Sacute;", "&Sc;", "&Scaron;", "&Scedil;", "&Scirc;", "&Scy;", "&Sfr;", "&ShortDownArrow;", "&ShortLeftArrow;", "&ShortRightArrow;", "&ShortUpArrow;", "&Sigma;", "&SmallCircle;", "&Sopf;", "&Sqrt;", "&Square;", "&SquareIntersection;", "&SquareSubset;", "&SquareSubsetEqual;", "&SquareSuperset;", "&SquareSupersetEqual;", "&SquareUnion;", "&Sscr;", "&Star;", "&Sub;", "&Subset;", "&SubsetEqual;", "&Succeeds;", "&SucceedsEqual;", "&SucceedsSlantEqual;", "&SucceedsTilde;", "&SuchThat;", "&Sum;", "&Sup;", "&Superset;", "&SupersetEqual;", "&Supset;", "&THORN;", "&TRADE;", "&TSHcy;", "&TScy;", "&Tab;", "&Tau;", "&Tcaron;", "&Tcedil;", "&Tcy;", "&Tfr;", "&Therefore;", "&Theta;", "&ThickSpace;", "&ThinSpace;", "&Tilde;", "&TildeEqual;", "&TildeFullEqual;", "&TildeTilde;", "&Topf;", "&TripleDot;", "&Tscr;", "&Tstrok;", "&Uacute;", "&Uarr;", "&Uarrocir;", "&Ubrcy;", "&Ubreve;", "&Ucirc;", "&Ucy;", "&Udblac;", "&Ufr;", "&Ugrave;", "&Umacr;", "&UnderBar;", "&UnderBrace;", "&UnderBracket;", "&UnderParenthesis;", "&Union;", "&UnionPlus;", "&Uogon;", "&Uopf;", "&UpArrow;", "&UpArrowBar;", "&UpArrowDownArrow;", "&UpDownArrow;", "&UpEquilibrium;", "&UpTee;", "&UpTeeArrow;", "&Uparrow;", "&Updownarrow;", "&UpperLeftArrow;", "&UpperRightArrow;", "&Upsi;", "&Upsilon;", "&Uring;", "&Uscr;", "&Utilde;", "&Uuml;", "&VDash;", "&Vbar;", "&Vcy;", "&Vdash;", "&Vdashl;", "&Vee;", "&Verbar;", "&Vert;", "&VerticalBar;", "&VerticalLine;", "&VerticalSeparator;", "&VerticalTilde;", "&VeryThinSpace;", "&Vfr;", "&Vopf;", "&Vscr;", "&Vvdash;", "&Wcirc;", "&Wedge;", "&Wfr;", "&Wopf;", "&Wscr;", "&Xfr;", "&Xi;", "&Xopf;", "&Xscr;", "&YAcy;", "&YIcy;", "&YUcy;", "&Yacute;", "&Ycirc;", "&Ycy;", "&Yfr;", "&Yopf;", "&Yscr;", "&Yuml;", "&ZHcy;", "&Zacute;", "&Zcaron;", "&Zcy;", "&Zdot;", "&ZeroWidthSpace;", "&Zeta;", "&Zfr;", "&Zopf;", "&Zscr;", "&aacute;", "&abreve;", "&ac;", "&acE;", "&acd;", "&acirc;", "&acute;", "&acy;", "&aelig;", "&af;", "&afr;", "&agrave;", "&alefsym;", "&aleph;", "&alpha;", "&amacr;", "&amalg;", "&amp;", "&and;", "&andand;", "&andd;", "&andslope;", "&andv;", "&ang;", "&ange;", "&angle;", "&angmsd;", "&angmsdaa;", "&angmsdab;", "&angmsdac;", "&angmsdad;", "&angmsdae;", "&angmsdaf;", "&angmsdag;", "&angmsdah;", "&angrt;", "&angrtvb;", "&angrtvbd;", "&angsph;", "&angst;", "&angzarr;", "&aogon;", "&aopf;", "&ap;", "&apE;", "&apacir;", "&ape;", "&apid;", "&apos;", "&approx;", "&approxeq;", "&aring;", "&ascr;", "&ast;", "&asymp;", "&asympeq;", "&atilde;", "&auml;", "&awconint;", "&awint;", "&bNot;", "&backcong;", "&backepsilon;", "&backprime;", "&backsim;", "&backsimeq;", "&barvee;", "&barwed;", "&barwedge;", "&bbrk;", "&bbrktbrk;", "&bcong;", "&bcy;", "&bdquo;", "&becaus;", "&because;", "&bemptyv;", "&bepsi;", "&bernou;", "&beta;", "&beth;", "&between;", "&bfr;", "&bigcap;", "&bigcirc;", "&bigcup;", "&bigodot;", "&bigoplus;", "&bigotimes;", "&bigsqcup;", "&bigstar;", "&bigtriangledown;", "&bigtriangleup;", "&biguplus;", "&bigvee;", "&bigwedge;", "&bkarow;", "&blacklozenge;", "&blacksquare;", "&blacktriangle;", "&blacktriangledown;", "&blacktriangleleft;", "&blacktriangleright;", "&blank;", "&blk12;", "&blk14;", "&blk34;", "&block;", "&bne;", "&bnequiv;", "&bnot;", "&bopf;", "&bot;", "&bottom;", "&bowtie;", "&boxDL;", "&boxDR;", "&boxDl;", "&boxDr;", "&boxH;", "&boxHD;", "&boxHU;", "&boxHd;", "&boxHu;", "&boxUL;", "&boxUR;", "&boxUl;", "&boxUr;", "&boxV;", "&boxVH;", "&boxVL;", "&boxVR;", "&boxVh;", "&boxVl;", "&boxVr;", "&boxbox;", "&boxdL;", "&boxdR;", "&boxdl;", "&boxdr;", "&boxh;", "&boxhD;", "&boxhU;", "&boxhd;", "&boxhu;", "&boxminus;", "&boxplus;", "&boxtimes;", "&boxuL;", "&boxuR;", "&boxul;", "&boxur;", "&boxv;", "&boxvH;", "&boxvL;", "&boxvR;", "&boxvh;", "&boxvl;", "&boxvr;", "&bprime;", "&breve;", "&brvbar;", "&bscr;", "&bsemi;", "&bsim;", "&bsime;", "&bsol;", "&bsolb;", "&bsolhsub;", "&bull;", "&bullet;", "&bump;", "&bumpE;", "&bumpe;", "&bumpeq;", "&cacute;", "&cap;", "&capand;", "&capbrcup;", "&capcap;", "&capcup;", "&capdot;", "&caps;", "&caret;", "&caron;", "&ccaps;", "&ccaron;", "&ccedil;", "&ccirc;", "&ccups;", "&ccupssm;", "&cdot;", "&cedil;", "&cemptyv;", "&cent;", "&centerdot;", "&cfr;", "&chcy;", "&check;", "&checkmark;", "&chi;", "&cir;", "&cirE;", "&circ;", "&circeq;", "&circlearrowleft;", "&circlearrowright;", "&circledR;", "&circledS;", "&circledast;", "&circledcirc;", "&circleddash;", "&cire;", "&cirfnint;", "&cirmid;", "&cirscir;", "&clubs;", "&clubsuit;", "&colon;", "&colone;", "&coloneq;", "&comma;", "&commat;", "&comp;", "&compfn;", "&complement;", "&complexes;", "&cong;", "&congdot;", "&conint;", "&copf;", "&coprod;", "&copy;", "&copysr;", "&crarr;", "&cross;", "&cscr;", "&csub;", "&csube;", "&csup;", "&csupe;", "&ctdot;", "&cudarrl;", "&cudarrr;", "&cuepr;", "&cuesc;", "&cularr;", "&cularrp;", "&cup;", "&cupbrcap;", "&cupcap;", "&cupcup;", "&cupdot;", "&cupor;", "&cups;", "&curarr;", "&curarrm;", "&curlyeqprec;", "&curlyeqsucc;", "&curlyvee;", "&curlywedge;", "&curren;", "&curvearrowleft;", "&curvearrowright;", "&cuvee;", "&cuwed;", "&cwconint;", "&cwint;", "&cylcty;", "&dArr;", "&dHar;", "&dagger;", "&daleth;", "&darr2;", "&darr;", "&dash;", "&dashv;", "&dbkarow;", "&dblac;", "&dcaron;", "&dcy;", "&dd;", "&ddagger;", "&ddarr;", "&ddotseq;", "&deg;", "&delta;", "&demptyv;", "&dfisht;", "&dfr;", "&dharl;", "&dharr;", "&diam;", "&diamond;", "&diamondsuit;", "&diams;", "&die;", "&digamma;", "&disin;", "&div;", "&divide;", "&divideontimes;", "&divonx;", "&djcy;", "&dlarr;", "&dlcorn;", "&dlcrop;", "&dollar;", "&dopf;", "&dot;", "&doteq;", "&doteqdot;", "&dotminus;", "&dotplus;", "&dotsquare;", "&doublebarwedge;", "&downarrow;", "&downdownarrows;", "&downharpoonleft;", "&downharpoonright;", "&drarr;", "&drbkarow;", "&drcorn;", "&drcrop;", "&dscr;", "&dscy;", "&dsol;", "&dstrok;", "&dtdot;", "&dtri;", "&dtrif;", "&duarr;", "&duhar;", "&dwangle;", "&dzcy;", "&dzigrarr;", "&eDDot;", "&eDot;", "&eacute;", "&easter;", "&ecaron;", "&ecir;", "&ecirc;", "&ecolon;", "&ecy;", "&edot;", "&ee;", "&efDot;", "&efr;", "&eg;", "&egrave;", "&egs;", "&egsdot;", "&el;", "&elinters;", "&ell;", "&els;", "&elsdot;", "&emacr;", "&empty;", "&emptyset;", "&emptyv;", "&emsp13;", "&emsp14;", "&emsp;", "&eng;", "&ensp;", "&eogon;", "&eopf;", "&epar;", "&eparsl;", "&eplus;", "&epsi;", "&epsilon;", "&epsiv;", "&eqcirc;", "&eqcolon;", "&eqsim;", "&eqslantgtr;", "&eqslantless;", "&equals;", "&equest;", "&equiv;", "&equivDD;", "&eqvparsl;", "&erDot;", "&erarr;", "&escr;", "&esdot;", "&esim;", "&eta;", "&eth;", "&euml;", "&euro;", "&excl;", "&exist;", "&expectation;", "&exponentiale;", "&fallingdotseq;", "&fcy;", "&female;", "&ffilig;", "&fflig;", "&ffllig;", "&ffr;", "&filig;", "&fjlig;", "&flat;", "&fllig;", "&fltns;", "&fnof;", "&fopf;", "&forall;", "&fork;", "&forkv;", "&fpartint;", "&frac12;", "&frac13;", "&frac14;", "&frac15;", "&frac16;", "&frac18;", "&frac23;", "&frac25;", "&frac34;", "&frac35;", "&frac38;", "&frac45;", "&frac56;", "&frac58;", "&frac78;", "&frasl;", "&frown;", "&fscr;", "&gE;", "&gEl;", "&gacute;", "&gamma;", "&gammad;", "&gap;", "&gbreve;", "&gcirc;", "&gcy;", "&gdot;", "&ge;", "&gel;", "&geq;", "&geqq;", "&geqslant;", "&ges;", "&gescc;", "&gesdot;", "&gesdoto;", "&gesdotol;", "&gesl;", "&gesles;", "&gfr;", "&gg;", "&ggg;", "&gimel;", "&gjcy;", "&gl;", "&glE;", "&gla;", "&glj;", "&gnE;", "&gnap;", "&gnapprox;", "&gne;", "&gneq;", "&gneqq;", "&gnsim;", "&gopf;", "&grave;", "&gscr;", "&gsim;", "&gsime;", "&gsiml;", "&gt;", "&gtcc;", "&gtcir;", "&gtdot;", "&gtlPar;", "&gtquest;", "&gtrapprox;", "&gtrarr;", "&gtrdot;", "&gtreqless;", "&gtreqqless;", "&gtrless;", "&gtrsim;", "&gvertneqq;", "&gvnE;", "&hArr;", "&hairsp;", "&half;", "&hamilt;", "&hardcy;", "&harr;", "&harrcir;", "&harrw;", "&hbar;", "&hcirc;", "&hearts;", "&heartsuit;", "&hellip;", "&hercon;", "&hfr;", "&hksearow;", "&hkswarow;", "&hoarr;", "&homtht;", "&hookleftarrow;", "&hookrightarrow;", "&hopf;", "&horbar;", "&hscr;", "&hslash;", "&hstrok;", "&hybull;", "&hyphen;", "&iacute;", "&ic;", "&icirc;", "&icy;", "&iecy;", "&iexcl;", "&iff;", "&ifr;", "&igrave;", "&ii;", "&iiiint;", "&iiint;", "&iinfin;", "&iiota;", "&ijlig;", "&imacr;", "&image;", "&imagline;", "&imagpart;", "&imath;", "&imof;", "&imped;", "&in;", "&incare;", "&infin;", "&infintie;", "&inodot;", "&int;", "&intcal;", "&integers;", "&intercal;", "&intlarhk;", "&intprod;", "&iocy;", "&iogon;", "&iopf;", "&iota;", "&iprod;", "&iquest;", "&iscr;", "&isin;", "&isinE;", "&isindot;", "&isins;", "&isinsv;", "&isinv;", "&it;", "&itilde;", "&iukcy;", "&iuml;", "&jcirc;", "&jcy;", "&jfr;", "&jmath;", "&jopf;", "&jscr;", "&jsercy;", "&jukcy;", "&kappa;", "&kappav;", "&kcedil;", "&kcy;", "&kfr;", "&kgreen;", "&khcy;", "&kjcy;", "&kopf;", "&kscr;", "&lAarr;", "&lArr;", "&lAtail;", "&lBarr;", "&lE;", "&lEg;", "&lHar;", "&lacute;", "&laemptyv;", "&lagran;", "&lambda;", "&lang;", "&langd;", "&langle;", "&lap;", "&laquo;", "&larr2;", "&larr;", "&larrb;", "&larrbfs;", "&larrfs;", "&larrhk;", "&larrlp;", "&larrpl;", "&larrsim;", "&larrtl;", "&lat;", "&latail;", "&late;", "&lates;", "&lbarr;", "&lbbrk;", "&lbrace;", "&lbrack;", "&lbrke;", "&lbrksld;", "&lbrkslu;", "&lcaron;", "&lcedil;", "&lceil;", "&lcub;", "&lcy;", "&ldca;", "&ldquo;", "&ldquor;", "&ldrdhar;", "&ldrushar;", "&ldsh;", "&le;", "&leftarrow;", "&leftarrowtail;", "&leftharpoondown;", "&leftharpoonup;", "&leftleftarrows;", "&leftrightarrow;", "&leftrightarrows;", "&leftrightharpoons;", "&leftrightsquigarrow;", "&leftthreetimes;", "&leg;", "&leq;", "&leqq;", "&leqslant;", "&les;", "&lescc;", "&lesdot;", "&lesdoto;", "&lesdotor;", "&lesg;", "&lesges;", "&lessapprox;", "&lessdot;", "&lesseqgtr;", "&lesseqqgtr;", "&lessgtr;", "&lesssim;", "&lfisht;", "&lfloor;", "&lfr;", "&lg;", "&lgE;", "&lhard;", "&lharu;", "&lharul;", "&lhblk;", "&ljcy;", "&ll;", "&llarr;", "&llcorner;", "&llhard;", "&lltri;", "&lmidot;", "&lmoust;", "&lmoustache;", "&lnE;", "&lnap;", "&lnapprox;", "&lne;", "&lneq;", "&lneqq;", "&lnsim;", "&loang;", "&loarr;", "&lobrk;", "&longleftarrow;", "&longleftrightarrow;", "&longmapsto;", "&longrightarrow;", "&looparrowleft;", "&looparrowright;", "&lopar;", "&lopf;", "&loplus;", "&lotimes;", "&lowast;", "&lowbar;", "&loz;", "&lozenge;", "&lozf;", "&lpar;", "&lparlt;", "&lrarr2;", "&lrarr;", "&lrcorner;", "&lrhar2;", "&lrhar;", "&lrhard;", "&lrm;", "&lrtri;", "&lsaquo;", "&lscr;", "&lsh;", "&lsim;", "&lsime;", "&lsimg;", "&lsqb;", "&lsquo;", "&lsquor;", "&lstrok;", "&lt;", "&ltcc;", "&ltcir;", "&ltdot;", "&lthree;", "&ltimes;", "&ltlarr;", "&ltquest;", "&ltrPar;", "&ltri;", "&ltrie;", "&ltrif;", "&lurdshar;", "&luruhar;", "&lvertneqq;", "&lvnE;", "&mDDot;", "&macr;", "&male;", "&malt;", "&maltese;", "&map;", "&mapsto;", "&mapstodown;", "&mapstoleft;", "&mapstoup;", "&marker;", "&mcomma;", "&mcy;", "&mdash;", "&measuredangle;", "&mfr;", "&mho;", "&micro;", "&mid;", "&midast;", "&midcir;", "&middot;", "&minus;", "&minusb;", "&minusd;", "&minusdu;", "&mlcp;", "&mldr;", "&mnplus;", "&models;", "&mopf;", "&mp;", "&mscr;", "&mstpos;", "&mu;", "&multimap;", "&mumap;", "&nGg;", "&nGt;", "&nGtv;", "&nLeftarrow;", "&nLeftrightarrow;", "&nLl;", "&nLt;", "&nLtv;", "&nRightarrow;", "&nVDash;", "&nVdash;", "&nabla;", "&nacute;", "&nang;", "&nap;", "&napE;", "&napid;", "&napos;", "&napprox;", "&natur;", "&natural;", "&naturals;", "&nbsp;", "&nbump;", "&nbumpe;", "&ncap;", "&ncaron;", "&ncedil;", "&ncong;", "&ncongdot;", "&ncup;", "&ncy;", "&ndash;", "&ne;", "&neArr;", "&nearhk;", "&nearr;", "&nearrow;", "&nedot;", "&nequiv;", "&nesear;", "&nesim;", "&nexist;", "&nexists;", "&nfr;", "&ngE;", "&nge;", "&ngeq;", "&ngeqq;", "&ngeqslant;", "&nges;", "&ngsim;", "&ngt;", "&ngtr;", "&nhArr;", "&nharr;", "&nhpar;", "&ni;", "&nis;", "&nisd;", "&niv;", "&njcy;", "&nlArr;", "&nlE;", "&nlarr;", "&nldr;", "&nle;", "&nleftarrow;", "&nleftrightarrow;", "&nleq;", "&nleqq;", "&nleqslant;", "&nles;", "&nless;", "&nlsim;", "&nlt;", "&nltri;", "&nltrie;", "&nmid;", "&nopf;", "&not;", "&notin;", "&notinE;", "&notindot;", "&notinva;", "&notinvb;", "&notinvc;", "&notni;", "&notniva;", "&notnivb;", "&notnivc;", "&npar;", "&nparallel;", "&nparsl;", "&npart;", "&npolint;", "&npr;", "&nprcue;", "&npre;", "&nprec;", "&npreceq;", "&nrArr;", "&nrarr;", "&nrarrc;", "&nrarrw;", "&nrightarrow;", "&nrtri;", "&nrtrie;", "&nsc;", "&nsccue;", "&nsce;", "&nscr;", "&nshortmid;", "&nshortparallel;", "&nsim;", "&nsime;", "&nsimeq;", "&nsmid;", "&nspar;", "&nsqsube;", "&nsqsupe;", "&nsub;", "&nsubE;", "&nsube;", "&nsubset;", "&nsubseteq;", "&nsubseteqq;", "&nsucc;", "&nsucceq;", "&nsup;", "&nsupE;", "&nsupe;", "&nsupset;", "&nsupseteq;", "&nsupseteqq;", "&ntgl;", "&ntilde;", "&ntlg;", "&ntriangleleft;", "&ntrianglelefteq;", "&ntriangleright;", "&ntrianglerighteq;", "&nu;", "&num;", "&numero;", "&numsp;", "&nvDash;", "&nvHarr;", "&nvap;", "&nvdash;", "&nvge;", "&nvgt;", "&nvinfin;", "&nvlArr;", "&nvle;", "&nvlt;", "&nvltrie;", "&nvrArr;", "&nvrtrie;", "&nvsim;", "&nwArr;", "&nwarhk;", "&nwarr;", "&nwarrow;", "&nwnear;", "&oS;", "&oacute;", "&oast;", "&ocir;", "&ocirc;", "&ocy;", "&odash;", "&odblac;", "&odiv;", "&odot;", "&odsold;", "&oelig;", "&ofcir;", "&ofr;", "&ogon;", "&ograve;", "&ogt;", "&ohbar;", "&ohm;", "&oint;", "&olarr;", "&olcir;", "&olcross;", "&oline;", "&olt;", "&omacr;", "&omega;", "&omicron;", "&omid;", "&ominus;", "&oopf;", "&opar;", "&operp;", "&oplus;", "&or;", "&orarr;", "&ord;", "&order;", "&orderof;", "&ordf;", "&ordm;", "&origof;", "&oror;", "&orslope;", "&orv;", "&oscr;", "&oslash;", "&osol;", "&otilde;", "&otimes;", "&otimesas;", "&ouml;", "&ovbar;", "&par;", "&para;", "&parallel;", "&parsim;", "&parsl;", "&part;", "&pcy;", "&percnt;", "&period;", "&permil;", "&perp;", "&pertenk;", "&pfr;", "&phi;", "&phiv;", "&phmmat;", "&phone;", "&pi;", "&pitchfork;", "&piv;", "&planck;", "&planckh;", "&plankv;", "&plus;", "&plusacir;", "&plusb;", "&pluscir;", "&plusdo;", "&plusdu;", "&pluse;", "&plusmn;", "&plussim;", "&plustwo;", "&pm;", "&pointint;", "&popf;", "&pound;", "&pr;", "&prE;", "&prap;", "&prcue;", "&pre;", "&prec;", "&precapprox;", "&preccurlyeq;", "&preceq;", "&precnapprox;", "&precneqq;", "&precnsim;", "&precsim;", "&prime;", "&primes;", "&prnE;", "&prnap;", "&prnsim;", "&prod;", "&profalar;", "&profline;", "&profsurf;", "&prop;", "&propto;", "&prsim;", "&prurel;", "&pscr;", "&psi;", "&puncsp;", "&qfr;", "&qint;", "&qopf;", "&qprime;", "&qscr;", "&quaternions;", "&quatint;", "&quest;", "&questeq;", "&quot;", "&rAarr;", "&rArr;", "&rAtail;", "&rBarr;", "&rHar;", "&race;", "&racute;", "&radic;", "&raemptyv;", "&rang;", "&rangd;", "&range;", "&rangle;", "&raquo;", "&rarr2;", "&rarr;", "&rarrap;", "&rarrb;", "&rarrbfs;", "&rarrc;", "&rarrfs;", "&rarrhk;", "&rarrlp;", "&rarrpl;", "&rarrsim;", "&rarrtl;", "&rarrw;", "&ratail;", "&ratio;", "&rationals;", "&rbarr;", "&rbbrk;", "&rbrace;", "&rbrack;", "&rbrke;", "&rbrksld;", "&rbrkslu;", "&rcaron;", "&rcedil;", "&rceil;", "&rcub;", "&rcy;", "&rdca;", "&rdldhar;", "&rdquo;", "&rdquor;", "&rdsh;", "&real;", "&realine;", "&realpart;", "&reals;", "&rect;", "&reg;", "&rfisht;", "&rfloor;", "&rfr;", "&rhard;", "&rharu;", "&rharul;", "&rho;", "&rhov;", "&rightarrow;", "&rightarrowtail;", "&rightharpoondown;", "&rightharpoonup;", "&rightleftarrows;", "&rightleftharpoons;", "&rightrightarrows;", "&rightsquigarrow;", "&rightthreetimes;", "&ring;", "&risingdotseq;", "&rlarr2;", "&rlarr;", "&rlhar2;", "&rlhar;", "&rlm;", "&rmoust;", "&rmoustache;", "&rnmid;", "&roang;", "&roarr;", "&robrk;", "&ropar;", "&ropf;", "&roplus;", "&rotimes;", "&rpar;", "&rpargt;", "&rppolint;", "&rrarr;", "&rsaquo;", "&rscr;", "&rsh;", "&rsqb;", "&rsquo;", "&rsquor;", "&rthree;", "&rtimes;", "&rtri;", "&rtrie;", "&rtrif;", "&rtriltri;", "&ruluhar;", "&rx;", "&sacute;", "&sbquo;", "&sc;", "&scE;", "&scap;", "&scaron;", "&sccue;", "&sce;", "&scedil;", "&scirc;", "&scnE;", "&scnap;", "&scnsim;", "&scpolint;", "&scsim;", "&scy;", "&sdot;", "&sdotb;", "&sdote;", "&seArr;", "&searhk;", "&searr;", "&searrow;", "&sect;", "&semi;", "&seswar;", "&setminus;", "&setmn;", "&sext;", "&sfr;", "&sfrown;", "&sharp;", "&shchcy;", "&shcy;", "&shortmid;", "&shortparallel;", "&shy;", "&sigma;", "&sigmaf;", "&sigmav;", "&sim;", "&simdot;", "&sime;", "&simeq;", "&simg;", "&simgE;", "&siml;", "&simlE;", "&simne;", "&simplus;", "&simrarr;", "&slarr;", "&smallsetminus;", "&smashp;", "&smeparsl;", "&smid;", "&smile;", "&smt;", "&smte;", "&smtes;", "&softcy;", "&sol;", "&solb;", "&solbar;", "&sopf;", "&spades;", "&spadesuit;", "&spar;", "&sqcap;", "&sqcaps;", "&sqcup;", "&sqcups;", "&sqsub;", "&sqsube;", "&sqsubset;", "&sqsubseteq;", "&sqsup;", "&sqsupe;", "&sqsupset;", "&sqsupseteq;", "&squ;", "&square;", "&squarf;", "&squf;", "&srarr;", "&sscr;", "&ssetmn;", "&ssmile;", "&sstarf;", "&star;", "&starf;", "&straightepsilon;", "&straightphi;", "&strns;", "&sub;", "&subE;", "&subdot;", "&sube;", "&subedot;", "&submult;", "&subnE;", "&subne;", "&subplus;", "&subrarr;", "&subset;", "&subseteq;", "&subseteqq;", "&subsetneq;", "&subsetneqq;", "&subsim;", "&subsub;", "&subsup;", "&succ;", "&succapprox;", "&succcurlyeq;", "&succeq;", "&succnapprox;", "&succneqq;", "&succnsim;", "&succsim;", "&sum;", "&sung;", "&sup1;", "&sup2;", "&sup3;", "&sup;", "&supE;", "&supdot;", "&supdsub;", "&supe;", "&supedot;", "&suphsol;", "&suphsub;", "&suplarr;", "&supmult;", "&supnE;", "&supne;", "&supplus;", "&supset;", "&supseteq;", "&supseteqq;", "&supsetneq;", "&supsetneqq;", "&supsim;", "&supsub;", "&supsup;", "&swArr;", "&swarhk;", "&swarr;", "&swarrow;", "&swnwar;", "&szlig;", "&target;", "&tau;", "&tbrk;", "&tcaron;", "&tcedil;", "&tcy;", "&tdot;", "&telrec;", "&tfr;", "&there4;", "&therefore;", "&theta;", "&thetasym;", "&thetav;", "&thickapprox;", "&thicksim;", "&thinsp;", "&thkap;", "&thksim;", "&thorn;", "&tilde;", "&times;", "&timesb;", "&timesbar;", "&timesd;", "&tint;", "&toea;", "&top;", "&topbot;", "&topcir;", "&topf;", "&topfork;", "&tosa;", "&tprime;", "&trade;", "&triangle;", "&triangledown;", "&triangleleft;", "&trianglelefteq;", "&triangleq;", "&triangleright;", "&trianglerighteq;", "&tridot;", "&trie;", "&triminus;", "&triplus;", "&trisb;", "&tritime;", "&trpezium;", "&tscr;", "&tscy;", "&tshcy;", "&tstrok;", "&twixt;", "&twoheadleftarrow;", "&twoheadrightarrow;", "&uArr;", "&uHar;", "&uacute;", "&uarr2;", "&uarr;", "&ubrcy;", "&ubreve;", "&ucirc;", "&ucy;", "&udarr;", "&udblac;", "&udhar;", "&ufisht;", "&ufr;", "&ugrave;", "&uharl;", "&uharr;", "&uhblk;", "&ulcorn;", "&ulcorner;", "&ulcrop;", "&ultri;", "&umacr;", "&uml;", "&uogon;", "&uopf;", "&uparrow;", "&updownarrow;", "&upharpoonleft;", "&upharpoonright;", "&uplus;", "&upsi;", "&upsih;", "&upsilon;", "&upuparrows;", "&urcorn;", "&urcorner;", "&urcrop;", "&uring;", "&urtri;", "&uscr;", "&utdot;", "&utilde;", "&utri;", "&utrif;", "&uuarr;", "&uuml;", "&uwangle;", "&vArr;", "&vBar;", "&vBarv;", "&vDash;", "&vangrt;", "&varepsilon;", "&varkappa;", "&varnothing;", "&varphi;", "&varpi;", "&varpropto;", "&varr;", "&varrho;", "&varsigma;", "&varsubsetneq;", "&varsubsetneqq;", "&varsupsetneq;", "&varsupsetneqq;", "&vartheta;", "&vartriangleleft;", "&vartriangleright;", "&vcy;", "&vdash;", "&vee;", "&veebar;", "&veeeq;", "&vellip;", "&verbar;", "&vert;", "&vfr;", "&vltri;", "&vnsub;", "&vnsup;", "&vopf;", "&vprop;", "&vrtri;", "&vscr;", "&vsubnE;", "&vsubne;", "&vsupnE;", "&vsupne;", "&vzigzag;", "&wcirc;", "&wedbar;", "&wedge;", "&wedgeq;", "&weierp;", "&wfr;", "&wopf;", "&wp;", "&wr;", "&wreath;", "&wscr;", "&xcap;", "&xcirc;", "&xcup;", "&xdtri;", "&xfr;", "&xhArr;", "&xharr;", "&xi;", "&xlArr;", "&xlarr;", "&xmap;", "&xnis;", "&xodot;", "&xopf;", "&xoplus;", "&xotime;", "&xrArr;", "&xrarr;", "&xscr;", "&xsqcup;", "&xuplus;", "&xutri;", "&xvee;", "&xwedge;", "&yacute;", "&yacy;", "&ycirc;", "&ycy;", "&yen;", "&yfr;", "&yicy;", "&yopf;", "&yscr;", "&yucy;", "&yuml;", "&zacute;", "&zcaron;", "&zcy;", "&zdot;", "&zeetrf;", "&zeta;", "&zfr;", "&zhcy;", "&zigrarr;", "&zopf;", "&zscr;", "&zwj;", "&zwnj;"};
        entityReplacements = new String[]{"\u1fbf", "\u1ffe", "\u02d8", "\u02db", "\u02dd", "\u02f3", "\u0309", "\u030a", "\u030f", "\u0311", "\u031b", "\u0483", "\u00c6", "&", "\u00c1", "\u0102", "\u00c2", "\u0410", "\ud504", "\u00c0", "\u0391", "\u0100", "\u2a53", "\u0104", "\ud538", "\u2061", "\u00c5", "\ud49c", "\u2254", "\u00c3", "\u00c4", "\u2216", "\u2ae7", "\u2306", "\u0411", "\u2235", "\u212c", "\u0392", "\ud505", "\ud539", "\u02d8", "\u212c", "\u224e", "\u0427", "\u00a9", "\u0106", "\u22d2", "\u2145", "\u212d", "\u010c", "\u00c7", "\u0108", "\u2230", "\u010a", "\u00b8", "\u00b7", "\u212d", "\u03a7", "\u2299", "\u2296", "\u2295", "\u2297", "\u2232", "\u201d", "\u2019", "\u2237", "\u2a74", "\u2261", "\u222f", "\u222e", "\u2102", "\u2210", "\u2233", "\u2a2f", "\ud49e", "\u22d3", "\u224d", "\u2145", "\u2911", "\u0402", "\u0405", "\u040f", "\u2021", "\u21a1", "\u2ae4", "\u010e", "\u0414", "\u2207", "\u0394", "\ud507", "\u00b4", "\u02d9", "\u02dd", "`", "\u02dc", "\u22c4", "\u2146", "\ud53b", "\u00a8", "\u20dc", "\u2250", "\u222f", "\u00a8", "\u21d3", "\u21d0", "\u21d4", "\u2ae4", "\u27f8", "\u27fa", "\u27f9", "\u21d2", "\u22a8", "\u21d1", "\u21d5", "\u2225", "\u2193", "\u2913", "\u21f5", "\u0311", "\u2950", "\u295e", "\u21bd", "\u2956", "\u295f", "\u21c1", "\u2957", "\u22a4", "\u21a7", "\u21d3", "\ud49f", "\u0110", "\u014a", "\u00d0", "\u00c9", "\u011a", "\u00ca", "\u042d", "\u0116", "\ud508", "\u00c8", "\u2208", "\u0112", "\u25fb", "\u25ab", "\u0118", "\ud53c", "\u0395", "\u2a75", "\u2242", "\u21cc", "\u2130", "\u2a73", "\u0397", "\u00cb", "\u2203", "\u2147", "\u0424", "\ud509", "\u25fc", "\u25aa", "\ud53d", "\u2200", "\u2131", "\u2131", "\u0403", ">", "\u0393", "\u03dc", "\u011e", "\u0122", "\u011c", "\u0413", "\u0120", "\ud50a", "\u22d9", "\ud53e", "\u2265", "\u22db", "\u2267", "\u2aa2", "\u2277", "\u2a7e", "\u2273", "\ud4a2", "\u226b", "\u042a", "\u02c7", "^", "\u0124", "\u210c", "\u210b", "\u210d", "\u2500", "\u210b", "\u0126", "\u224e", "\u224f", "\u0415", "\u0132", "\u0401", "\u00cd", "\u00ce", "\u0418", "\u0130", "\u2111", "\u00cc", "\u2111", "\u012a", "\u2148", "\u21d2", "\u222b", "\u22c2", "\u2063", "\u2062", "\u012e", "\ud540", "\u0399", "\u2110", "\u0128", "\u0406", "\u00cf", "\u0134", "\u0419", "\ud50d", "\ud541", "\ud4a5", "\u0408", "\u0404", "\u0425", "\u040c", "\u039a", "\u0136", "\u041a", "\ud50e", "\ud542", "\ud4a6", "\u0409", "<", "\u0139", "\u039b", "\u27ea", "\u2112", "\u219e", "\u013d", "\u013b", "\u041b", "\u27e8", "\u2190", "\u21e4", "\u21c6", "\u2308", "\u27e6", "\u2961", "\u21c3", "\u2959", "\u230a", "\u2194", "\u294e", "\u22a3", "\u21a4", "\u295a", "\u22b2", "\u29cf", "\u22b4", "\u2951", "\u2960", "\u21bf", "\u2958", "\u21bc", "\u2952", "\u21d0", "\u21d4", "\u22da", "\u2266", "\u2276", "\u2aa1", "\u2a7d", "\u2272", "\ud50f", "\u22d8", "\u21da", "\u013f", "\u27f5", "\u27f7", "\u27f6", "\u27f8", "\u27fa", "\u27f9", "\ud543", "\u2199", "\u2198", "\u2112", "\u21b0", "\u0141", "\u226a", "\u2905", "\u041c", "\u205f", "\u2133", "\ud510", "\u2213", "\ud544", "\u2133", "\u039c", "\u040a", "\u0143", "\u0147", "\u0145", "\u041d", "\u200b", "\u200b", "\u200b", "\u200b", "\u226b", "\u226a", "\\u000a", "\ud511", "\u2060", "\u00a0", "\u2115", "\u2aec", "\u2262", "\u226d", "\u2226", "\u2209", "\u2260", "\u2242", "\u2204", "\u226f", "\u2271", "\u2267", "\u226b", "\u2279", "\u2a7e", "\u2275", "\u224e", "\u224f", "\u22ea", "\u29cf", "\u22ec", "\u226e", "\u2270", "\u2278", "\u226a", "\u2a7d", "\u2274", "\u2aa2", "\u2aa1", "\u2280", "\u2aaf", "\u22e0", "\u220c", "\u22eb", "\u29d0", "\u22ed", "\u228f", "\u22e2", "\u2290", "\u22e3", "\u2282", "\u2288", "\u2281", "\u2ab0", "\u22e1", "\u227f", "\u2283", "\u2289", "\u2241", "\u2244", "\u2247", "\u2249", "\u2224", "\ud4a9", "\u00d1", "\u039d", "\u0152", "\u00d3", "\u00d4", "\u041e", "\u0150", "\ud512", "\u00d2", "\u014c", "\u03a9", "\u039f", "\ud546", "\u201c", "\u2018", "\u2a54", "\ud4aa", "\u00d8", "\u00d5", "\u2a37", "\u00d6", "\u203e", "\u23de", "\u23b4", "\u23dc", "\u2202", "\u041f", "\ud513", "\u03a6", "\u03a0", "\u00b1", "\u210c", "\u2119", "\u2abb", "\u227a", "\u2aaf", "\u227c", "\u227e", "\u2033", "\u220f", "\u2237", "\u221d", "\ud4ab", "\u03a8", "\"", "\ud514", "\u211a", "\ud4ac", "\u2910", "\u00ae", "\u0154", "\u27eb", "\u21a0", "\u2916", "\u0158", "\u0156", "\u0420", "\u211c", "\u220b", "\u21cb", "\u296f", "\u211c", "\u03a1", "\u27e9", "\u2192", "\u21e5", "\u21c4", "\u2309", "\u27e7", "\u295d", "\u21c2", "\u2955", "\u230b", "\u22a2", "\u21a6", "\u295b", "\u22b3", "\u29d0", "\u22b5", "\u294f", "\u295c", "\u21be", "\u2954", "\u21c0", "\u2953", "\u21d2", "\u211d", "\u2970", "\u21db", "\u211b", "\u21b1", "\u29f4", "\u0429", "\u0428", "\u042c", "\u015a", "\u2abc", "\u0160", "\u015e", "\u015c", "\u0421", "\ud516", "\u2193", "\u2190", "\u2192", "\u2191", "\u03a3", "\u2218", "\ud54a", "\u221a", "\u25a1", "\u2293", "\u228f", "\u2291", "\u2290", "\u2292", "\u2294", "\ud4ae", "\u22c6", "\u22d0", "\u22d0", "\u2286", "\u227b", "\u2ab0", "\u227d", "\u227f", "\u220b", "\u2211", "\u22d1", "\u2283", "\u2287", "\u22d1", "\u00de", "\u2122", "\u040b", "\u0426", "\t", "\u03a4", "\u0164", "\u0162", "\u0422", "\ud517", "\u2234", "\u0398", "\u205f", "\u2009", "\u223c", "\u2243", "\u2245", "\u2248", "\ud54b", "\u20db", "\ud4af", "\u0166", "\u00da", "\u219f", "\u2949", "\u040e", "\u016c", "\u00db", "\u0423", "\u0170", "\ud518", "\u00d9", "\u016a", "_", "\u23df", "\u23b5", "\u23dd", "\u22c3", "\u228e", "\u0172", "\ud54c", "\u2191", "\u2912", "\u21c5", "\u2195", "\u296e", "\u22a5", "\u21a5", "\u21d1", "\u21d5", "\u2196", "\u2197", "\u03d2", "\u03a5", "\u016e", "\ud4b0", "\u0168", "\u00dc", "\u22ab", "\u2aeb", "\u0412", "\u22a9", "\u2ae6", "\u22c1", "\u2016", "\u2016", "\u2223", "|", "\u2758", "\u2240", "\u200a", "\ud519", "\ud54d", "\ud4b1", "\u22aa", "\u0174", "\u22c0", "\ud51a", "\ud54e", "\ud4b2", "\ud51b", "\u039e", "\ud54f", "\ud4b3", "\u042f", "\u0407", "\u042e", "\u00dd", "\u0176", "\u042b", "\ud51c", "\ud550", "\ud4b4", "\u0178", "\u0416", "\u0179", "\u017d", "\u0417", "\u017b", "\u200b", "\u0396", "\u2128", "\u2124", "\ud4b5", "\u00e1", "\u0103", "\u223e", "\u223e", "\u223f", "\u00e2", "\u00b4", "\u0430", "\u00e6", "\u2061", "\ud51e", "\u00e0", "\u2135", "\u2135", "\u03b1", "\u0101", "\u2a3f", "&", "\u2227", "\u2a55", "\u2a5c", "\u2a58", "\u2a5a", "\u2220", "\u29a4", "\u2220", "\u2221", "\u29a8", "\u29a9", "\u29aa", "\u29ab", "\u29ac", "\u29ad", "\u29ae", "\u29af", "\u221f", "\u22be", "\u299d", "\u2222", "\u00c5", "\u237c", "\u0105", "\ud552", "\u2248", "\u2a70", "\u2a6f", "\u224a", "\u224b", "'", "\u2248", "\u224a", "\u00e5", "\ud4b6", "*", "\u2248", "\u224d", "\u00e3", "\u00e4", "\u2233", "\u2a11", "\u2aed", "\u224c", "\u03f6", "\u2035", "\u223d", "\u22cd", "\u22bd", "\u2305", "\u2305", "\u23b5", "\u23b6", "\u224c", "\u0431", "\u201e", "\u2235", "\u2235", "\u29b0", "\u03f6", "\u212c", "\u03b2", "\u2136", "\u226c", "\ud51f", "\u22c2", "\u25ef", "\u22c3", "\u2a00", "\u2a01", "\u2a02", "\u2a06", "\u2605", "\u25bd", "\u25b3", "\u2a04", "\u22c1", "\u22c0", "\u290d", "\u29eb", "\u25aa", "\u25b4", "\u25be", "\u25c2", "\u25b8", "\u2423", "\u2592", "\u2591", "\u2593", "\u2588", "=", "\u2261", "\u2310", "\ud553", "\u22a5", "\u22a5", "\u22c8", "\u2557", "\u2554", "\u2556", "\u2553", "\u2550", "\u2566", "\u2569", "\u2564", "\u2567", "\u255d", "\u255a", "\u255c", "\u2559", "\u2551", "\u256c", "\u2563", "\u2560", "\u256b", "\u2562", "\u255f", "\u29c9", "\u2555", "\u2552", "\u2510", "\u250c", "\u2500", "\u2565", "\u2568", "\u252c", "\u2534", "\u229f", "\u229e", "\u22a0", "\u255b", "\u2558", "\u2518", "\u2514", "\u2502", "\u256a", "\u2561", "\u255e", "\u253c", "\u2524", "\u251c", "\u2035", "\u02d8", "\u00a6", "\ud4b7", "\u204f", "\u223d", "\u22cd", "\\", "\u29c5", "\u27c8", "\u2022", "\u2022", "\u224e", "\u2aae", "\u224f", "\u224f", "\u0107", "\u2229", "\u2a44", "\u2a49", "\u2a4b", "\u2a47", "\u2a40", "\u2229", "\u2041", "\u02c7", "\u2a4d", "\u010d", "\u00e7", "\u0109", "\u2a4c", "\u2a50", "\u010b", "\u00b8", "\u29b2", "\u00a2", "\u00b7", "\ud520", "\u0447", "\u2713", "\u2713", "\u03c7", "\u25cb", "\u29c3", "\u02c6", "\u2257", "\u21ba", "\u21bb", "\u00ae", "\u24c8", "\u229b", "\u229a", "\u229d", "\u2257", "\u2a10", "\u2aef", "\u29c2", "\u2663", "\u2663", ":", "\u2254", "\u2254", ",", "@", "\u2201", "\u2218", "\u2201", "\u2102", "\u2245", "\u2a6d", "\u222e", "\ud554", "\u2210", "\u00a9", "\u2117", "\u21b5", "\u2717", "\ud4b8", "\u2acf", "\u2ad1", "\u2ad0", "\u2ad2", "\u22ef", "\u2938", "\u2935", "\u22de", "\u22df", "\u21b6", "\u293d", "\u222a", "\u2a48", "\u2a46", "\u2a4a", "\u228d", "\u2a45", "\u222a", "\u21b7", "\u293c", "\u22de", "\u22df", "\u22ce", "\u22cf", "\u00a4", "\u21b6", "\u21b7", "\u22ce", "\u22cf", "\u2232", "\u2231", "\u232d", "\u21d3", "\u2965", "\u2020", "\u2138", "\u21ca", "\u2193", "\u2010", "\u22a3", "\u290f", "\u02dd", "\u010f", "\u0434", "\u2146", "\u2021", "\u21ca", "\u2a77", "\u00b0", "\u03b4", "\u29b1", "\u297f", "\ud521", "\u21c3", "\u21c2", "\u22c4", "\u22c4", "\u2666", "\u2666", "\u00a8", "\u03dd", "\u22f2", "\u00f7", "\u00f7", "\u22c7", "\u22c7", "\u0452", "\u2199", "\u231e", "\u230d", "$", "\ud555", "\u02d9", "\u2250", "\u2251", "\u2238", "\u2214", "\u22a1", "\u2306", "\u2193", "\u21ca", "\u21c3", "\u21c2", "\u2198", "\u2910", "\u231f", "\u230c", "\ud4b9", "\u0455", "\u29f6", "\u0111", "\u22f1", "\u25bf", "\u25be", "\u21f5", "\u296f", "\u29a6", "\u045f", "\u27ff", "\u2a77", "\u2251", "\u00e9", "\u2a6e", "\u011b", "\u2256", "\u00ea", "\u2255", "\u044d", "\u0117", "\u2147", "\u2252", "\ud522", "\u2a9a", "\u00e8", "\u2a96", "\u2a98", "\u2a99", "\u23e7", "\u2113", "\u2a95", "\u2a97", "\u0113", "\u2205", "\u2205", "\u2205", "\u2004", "\u2005", "\u2003", "\u014b", "\u2002", "\u0119", "\ud556", "\u22d5", "\u29e3", "\u2a71", "\u03b5", "\u03b5", "\u03f5", "\u2256", "\u2255", "\u2242", "\u2a96", "\u2a95", "=", "\u225f", "\u2261", "\u2a78", "\u29e5", "\u2253", "\u2971", "\u212f", "\u2250", "\u2242", "\u03b7", "\u00f0", "\u00eb", "\u20ac", "!", "\u2203", "\u2130", "\u2147", "\u2252", "\u0444", "\u2640", "\ufb03", "\ufb00", "\ufb04", "\ud523", "\ufb01", "f", "\u266d", "\ufb02", "\u25b1", "\u0192", "\ud557", "\u2200", "\u22d4", "\u2ad9", "\u2a0d", "\u00bd", "\u2153", "\u00bc", "\u2155", "\u2159", "\u215b", "\u2154", "\u2156", "\u00be", "\u2157", "\u215c", "\u2158", "\u215a", "\u215d", "\u215e", "\u2044", "\u2322", "\ud4bb", "\u2267", "\u2a8c", "\u01f5", "\u03b3", "\u03dd", "\u2a86", "\u011f", "\u011d", "\u0433", "\u0121", "\u2265", "\u22db", "\u2265", "\u2267", "\u2a7e", "\u2a7e", "\u2aa9", "\u2a80", "\u2a82", "\u2a84", "\u22db", "\u2a94", "\ud524", "\u226b", "\u22d9", "\u2137", "\u0453", "\u2277", "\u2a92", "\u2aa5", "\u2aa4", "\u2269", "\u2a8a", "\u2a8a", "\u2a88", "\u2a88", "\u2269", "\u22e7", "\ud558", "`", "\u210a", "\u2273", "\u2a8e", "\u2a90", ">", "\u2aa7", "\u2a7a", "\u22d7", "\u2995", "\u2a7c", "\u2a86", "\u2978", "\u22d7", "\u22db", "\u2a8c", "\u2277", "\u2273", "\u2269", "\u2269", "\u21d4", "\u200a", "\u00bd", "\u210b", "\u044a", "\u2194", "\u2948", "\u21ad", "\u210f", "\u0125", "\u2665", "\u2665", "\u2026", "\u22b9", "\ud525", "\u2925", "\u2926", "\u21ff", "\u223b", "\u21a9", "\u21aa", "\ud559", "\u2015", "\ud4bd", "\u210f", "\u0127", "\u2043", "\u2010", "\u00ed", "\u2063", "\u00ee", "\u0438", "\u0435", "\u00a1", "\u21d4", "\ud526", "\u00ec", "\u2148", "\u2a0c", "\u222d", "\u29dc", "\u2129", "\u0133", "\u012b", "\u2111", "\u2110", "\u2111", "\u0131", "\u22b7", "\u01b5", "\u2208", "\u2105", "\u221e", "\u29dd", "\u0131", "\u222b", "\u22ba", "\u2124", "\u22ba", "\u2a17", "\u2a3c", "\u0451", "\u012f", "\ud55a", "\u03b9", "\u2a3c", "\u00bf", "\ud4be", "\u2208", "\u22f9", "\u22f5", "\u22f4", "\u22f3", "\u2208", "\u2062", "\u0129", "\u0456", "\u00ef", "\u0135", "\u0439", "\ud527", "\u0237", "\ud55b", "\ud4bf", "\u0458", "\u0454", "\u03ba", "\u03f0", "\u0137", "\u043a", "\ud528", "\u0138", "\u0445", "\u045c", "\ud55c", "\ud4c0", "\u21da", "\u21d0", "\u291b", "\u290e", "\u2266", "\u2a8b", "\u2962", "\u013a", "\u29b4", "\u2112", "\u03bb", "\u2329", "\u27e8", "\u2991", "\u2a85", "\u00ab", "\u21c7", "\u2190", "\u21e4", "\u291f", "\u291d", "\u21a9", "\u21ab", "\u2939", "\u2973", "\u21a2", "\u2aab", "\u2919", "\u2aad", "\u2aad", "\u290c", "\u2772", "{", "[", "\u298b", "\u298f", "\u298d", "\u013e", "\u013c", "\u2308", "{", "\u043b", "\u2936", "\u201c", "\u201e", "\u2967", "\u294b", "\u21b2", "\u2264", "\u2190", "\u21a2", "\u21bd", "\u21bc", "\u21c7", "\u2194", "\u21c6", "\u21cb", "\u21ad", "\u22cb", "\u22da", "\u2264", "\u2266", "\u2a7d", "\u2a7d", "\u2aa8", "\u2a7f", "\u2a81", "\u2a83", "\u22da", "\u2a93", "\u2a85", "\u22d6", "\u22da", "\u2a8b", "\u2276", "\u2272", "\u297c", "\u230a", "\ud529", "\u2276", "\u2a91", "\u21bd", "\u21bc", "\u296a", "\u2584", "\u0459", "\u226a", "\u21c7", "\u231e", "\u296b", "\u25fa", "\u0140", "\u23b0", "\u23b0", "\u2268", "\u2a89", "\u2a89", "\u2a87", "\u2a87", "\u2268", "\u22e6", "\u27ec", "\u21fd", "\u27e6", "\u27f5", "\u27f7", "\u27fc", "\u27f6", "\u21ab", "\u21ac", "\u2985", "\ud55d", "\u2a2d", "\u2a34", "\u2217", "_", "\u25ca", "\u25ca", "\u29eb", "(", "\u2993", "\u21c6", "\u21c6", "\u231f", "\u21cb", "\u21cb", "\u296d", "\u200e", "\u22bf", "\u2039", "\ud4c1", "\u21b0", "\u2272", "\u2a8d", "\u2a8f", "[", "\u2018", "\u201a", "\u0142", "<", "\u2aa6", "\u2a79", "\u22d6", "\u22cb", "\u22c9", "\u2976", "\u2a7b", "\u2996", "\u25c3", "\u22b4", "\u25c2", "\u294a", "\u2966", "\u2268", "\u2268", "\u223a", "\u00af", "\u2642", "\u2720", "\u2720", "\u21a6", "\u21a6", "\u21a7", "\u21a4", "\u21a5", "\u25ae", "\u2a29", "\u043c", "\u2014", "\u2221", "\ud52a", "\u2127", "\u00b5", "\u2223", "*", "\u2af0", "\u00b7", "\u2212", "\u229f", "\u2238", "\u2a2a", "\u2adb", "\u2026", "\u2213", "\u22a7", "\ud55e", "\u2213", "\ud4c2", "\u223e", "\u03bc", "\u22b8", "\u22b8", "\u22d9", "\u226b", "\u226b", "\u21cd", "\u21ce", "\u22d8", "\u226a", "\u226a", "\u21cf", "\u22af", "\u22ae", "\u2207", "\u0144", "\u2220", "\u2249", "\u2a70", "\u224b", "\u0149", "\u2249", "\u266e", "\u266e", "\u2115", "\u00a0", "\u224e", "\u224f", "\u2a43", "\u0148", "\u0146", "\u2247", "\u2a6d", "\u2a42", "\u043d", "\u2013", "\u2260", "\u21d7", "\u2924", "\u2197", "\u2197", "\u2250", "\u2262", "\u2928", "\u2242", "\u2204", "\u2204", "\ud52b", "\u2267", "\u2271", "\u2271", "\u2267", "\u2a7e", "\u2a7e", "\u2275", "\u226f", "\u226f", "\u21ce", "\u21ae", "\u2af2", "\u220b", "\u22fc", "\u22fa", "\u220b", "\u045a", "\u21cd", "\u2266", "\u219a", "\u2025", "\u2270", "\u219a", "\u21ae", "\u2270", "\u2266", "\u2a7d", "\u2a7d", "\u226e", "\u2274", "\u226e", "\u22ea", "\u22ec", "\u2224", "\ud55f", "\u00ac", "\u2209", "\u22f9", "\u22f5", "\u2209", "\u22f7", "\u22f6", "\u220c", "\u220c", "\u22fe", "\u22fd", "\u2226", "\u2226", "\u2afd", "\u2202", "\u2a14", "\u2280", "\u22e0", "\u2aaf", "\u2280", "\u2aaf", "\u21cf", "\u219b", "\u2933", "\u219d", "\u219b", "\u22eb", "\u22ed", "\u2281", "\u22e1", "\u2ab0", "\ud4c3", "\u2224", "\u2226", "\u2241", "\u2244", "\u2244", "\u2224", "\u2226", "\u22e2", "\u22e3", "\u2284", "\u2ac5", "\u2288", "\u2282", "\u2288", "\u2ac5", "\u2281", "\u2ab0", "\u2285", "\u2ac6", "\u2289", "\u2283", "\u2289", "\u2ac6", "\u2279", "\u00f1", "\u2278", "\u22ea", "\u22ec", "\u22eb", "\u22ed", "\u03bd", "#", "\u2116", "\u2007", "\u22ad", "\u2904", "\u224d", "\u22ac", "\u2265", ">", "\u29de", "\u2902", "\u2264", "<", "\u22b4", "\u2903", "\u22b5", "\u223c", "\u21d6", "\u2923", "\u2196", "\u2196", "\u2927", "\u24c8", "\u00f3", "\u229b", "\u229a", "\u00f4", "\u043e", "\u229d", "\u0151", "\u2a38", "\u2299", "\u29bc", "\u0153", "\u29bf", "\ud52c", "\u02db", "\u00f2", "\u29c1", "\u29b5", "\u03a9", "\u222e", "\u21ba", "\u29be", "\u29bb", "\u203e", "\u29c0", "\u014d", "\u03c9", "\u03bf", "\u29b6", "\u2296", "\ud560", "\u29b7", "\u29b9", "\u2295", "\u2228", "\u21bb", "\u2a5d", "\u2134", "\u2134", "\u00aa", "\u00ba", "\u22b6", "\u2a56", "\u2a57", "\u2a5b", "\u2134", "\u00f8", "\u2298", "\u00f5", "\u2297", "\u2a36", "\u00f6", "\u233d", "\u2225", "\u00b6", "\u2225", "\u2af3", "\u2afd", "\u2202", "\u043f", "%", ".", "\u2030", "\u22a5", "\u2031", "\ud52d", "\u03c6", "\u03d5", "\u2133", "\u260e", "\u03c0", "\u22d4", "\u03d6", "\u210f", "\u210e", "\u210f", "+", "\u2a23", "\u229e", "\u2a22", "\u2214", "\u2a25", "\u2a72", "\u00b1", "\u2a26", "\u2a27", "\u00b1", "\u2a15", "\ud561", "\u00a3", "\u227a", "\u2ab3", "\u2ab7", "\u227c", "\u2aaf", "\u227a", "\u2ab7", "\u227c", "\u2aaf", "\u2ab9", "\u2ab5", "\u22e8", "\u227e", "\u2032", "\u2119", "\u2ab5", "\u2ab9", "\u22e8", "\u220f", "\u232e", "\u2312", "\u2313", "\u221d", "\u221d", "\u227e", "\u22b0", "\ud4c5", "\u03c8", "\u2008", "\ud52e", "\u2a0c", "\ud562", "\u2057", "\ud4c6", "\u210d", "\u2a16", "?", "\u225f", "\"", "\u21db", "\u21d2", "\u291c", "\u290f", "\u2964", "\u223d", "\u0155", "\u221a", "\u29b3", "\u232a", "\u27e9", "\u2992", "\u29a5", "\u00bb", "\u21c9", "\u2192", "\u2975", "\u21e5", "\u2920", "\u2933", "\u291e", "\u21aa", "\u21ac", "\u2945", "\u2974", "\u21a3", "\u219d", "\u291a", "\u2236", "\u211a", "\u290d", "\u2773", "}", "]", "\u298c", "\u298e", "\u2990", "\u0159", "\u0157", "\u2309", "}", "\u0440", "\u2937", "\u2969", "\u201d", "\u201d", "\u21b3", "\u211c", "\u211b", "\u211c", "\u211d", "\u25ad", "\u00ae", "\u297d", "\u230b", "\ud52f", "\u21c1", "\u21c0", "\u296c", "\u03c1", "\u03f1", "\u2192", "\u21a3", "\u21c1", "\u21c0", "\u21c4", "\u21cc", "\u21c9", "\u219d", "\u22cc", "\u02da", "\u2253", "\u21c4", "\u21c4", "\u21cc", "\u21cc", "\u200f", "\u23b1", "\u23b1", "\u2aee", "\u27ed", "\u21fe", "\u27e7", "\u2986", "\ud563", "\u2a2e", "\u2a35", ")", "\u2994", "\u2a12", "\u21c9", "\u203a", "\ud4c7", "\u21b1", "]", "\u2019", "\u2019", "\u22cc", "\u22ca", "\u25b9", "\u22b5", "\u25b8", "\u29ce", "\u2968", "\u211e", "\u015b", "\u201a", "\u227b", "\u2ab4", "\u2ab8", "\u0161", "\u227d", "\u2ab0", "\u015f", "\u015d", "\u2ab6", "\u2aba", "\u22e9", "\u2a13", "\u227f", "\u0441", "\u22c5", "\u22a1", "\u2a66", "\u21d8", "\u2925", "\u2198", "\u2198", "\u00a7", ";", "\u2929", "\u2216", "\u2216", "\u2736", "\ud530", "\u2322", "\u266f", "\u0449", "\u0448", "\u2223", "\u2225", "\u00ad", "\u03c3", "\u03c2", "\u03c2", "\u223c", "\u2a6a", "\u2243", "\u2243", "\u2a9e", "\u2aa0", "\u2a9d", "\u2a9f", "\u2246", "\u2a24", "\u2972", "\u2190", "\u2216", "\u2a33", "\u29e4", "\u2223", "\u2323", "\u2aaa", "\u2aac", "\u2aac", "\u044c", "/", "\u29c4", "\u233f", "\ud564", "\u2660", "\u2660", "\u2225", "\u2293", "\u2293", "\u2294", "\u2294", "\u228f", "\u2291", "\u228f", "\u2291", "\u2290", "\u2292", "\u2290", "\u2292", "\u25a1", "\u25a1", "\u25aa", "\u25aa", "\u2192", "\ud4c8", "\u2216", "\u2323", "\u22c6", "\u2606", "\u2605", "\u03f5", "\u03d5", "\u00af", "\u2282", "\u2ac5", "\u2abd", "\u2286", "\u2ac3", "\u2ac1", "\u2acb", "\u228a", "\u2abf", "\u2979", "\u2282", "\u2286", "\u2ac5", "\u228a", "\u2acb", "\u2ac7", "\u2ad5", "\u2ad3", "\u227b", "\u2ab8", "\u227d", "\u2ab0", "\u2aba", "\u2ab6", "\u22e9", "\u227f", "\u2211", "\u266a", "\u00b9", "\u00b2", "\u00b3", "\u2283", "\u2ac6", "\u2abe", "\u2ad8", "\u2287", "\u2ac4", "\u27c9", "\u2ad7", "\u297b", "\u2ac2", "\u2acc", "\u228b", "\u2ac0", "\u2283", "\u2287", "\u2ac6", "\u228b", "\u2acc", "\u2ac8", "\u2ad4", "\u2ad6", "\u21d9", "\u2926", "\u2199", "\u2199", "\u292a", "\u00df", "\u2316", "\u03c4", "\u23b4", "\u0165", "\u0163", "\u0442", "\u20db", "\u2315", "\ud531", "\u2234", "\u2234", "\u03b8", "\u03d1", "\u03d1", "\u2248", "\u223c", "\u2009", "\u2248", "\u223c", "\u00fe", "\u02dc", "\u00d7", "\u22a0", "\u2a31", "\u2a30", "\u222d", "\u2928", "\u22a4", "\u2336", "\u2af1", "\ud565", "\u2ada", "\u2929", "\u2034", "\u2122", "\u25b5", "\u25bf", "\u25c3", "\u22b4", "\u225c", "\u25b9", "\u22b5", "\u25ec", "\u225c", "\u2a3a", "\u2a39", "\u29cd", "\u2a3b", "\u23e2", "\ud4c9", "\u0446", "\u045b", "\u0167", "\u226c", "\u219e", "\u21a0", "\u21d1", "\u2963", "\u00fa", "\u21c8", "\u2191", "\u045e", "\u016d", "\u00fb", "\u0443", "\u21c5", "\u0171", "\u296e", "\u297e", "\ud532", "\u00f9", "\u21bf", "\u21be", "\u2580", "\u231c", "\u231c", "\u230f", "\u25f8", "\u016b", "\u00a8", "\u0173", "\ud566", "\u2191", "\u2195", "\u21bf", "\u21be", "\u228e", "\u03c5", "\u03d2", "\u03c5", "\u21c8", "\u231d", "\u231d", "\u230e", "\u016f", "\u25f9", "\ud4ca", "\u22f0", "\u0169", "\u25b5", "\u25b4", "\u21c8", "\u00fc", "\u29a7", "\u21d5", "\u2ae8", "\u2ae9", "\u22a8", "\u299c", "\u03f5", "\u03f0", "\u2205", "\u03d5", "\u03d6", "\u221d", "\u2195", "\u03f1", "\u03c2", "\u228a", "\u2acb", "\u228b", "\u2acc", "\u03d1", "\u22b2", "\u22b3", "\u0432", "\u22a2", "\u2228", "\u22bb", "\u225a", "\u22ee", "|", "|", "\ud533", "\u22b2", "\u2282", "\u2283", "\ud567", "\u221d", "\u22b3", "\ud4cb", "\u2acb", "\u228a", "\u2acc", "\u228b", "\u299a", "\u0175", "\u2a5f", "\u2227", "\u2259", "\u2118", "\ud534", "\ud568", "\u2118", "\u2240", "\u2240", "\ud4cc", "\u22c2", "\u25ef", "\u22c3", "\u25bd", "\ud535", "\u27fa", "\u27f7", "\u03be", "\u27f8", "\u27f5", "\u27fc", "\u22fb", "\u2a00", "\ud569", "\u2a01", "\u2a02", "\u27f9", "\u27f6", "\ud4cd", "\u2a06", "\u2a04", "\u25b3", "\u22c1", "\u22c0", "\u00fd", "\u044f", "\u0177", "\u044b", "\u00a5", "\ud536", "\u0457", "\ud56a", "\ud4ce", "\u044e", "\u00ff", "\u017a", "\u017e", "\u0437", "\u017c", "\u2128", "\u03b6", "\ud537", "\u0436", "\u21dd", "\ud56b", "\ud4cf", "\u200d", "\u200c", "'", "@", "^", "`", "~"};
        for (int i = 0; i < entityKeys.length; ++i) {
            map.put(entityKeys[i], entityReplacements[i]);
        }
    }
}

