/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.util.Logging;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;

public class BasicNamespaceContext
implements NamespaceContext {
    public static final String XLINK_NS_PREFIX = "xlink";
    public static final String XLINK_NS_URI = "http://www.w3.org/1999/xlink";
    private Map<String, String> urisByPrefix = new HashMap<String, String>();
    private Map<String, Set<String>> prefixesByURI = new HashMap<String, Set<String>>();

    public BasicNamespaceContext() {
        this.addNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.addNamespace("xmlns", "http://www.w3.org/2000/xmlns/");
        this.addNamespace(XLINK_NS_PREFIX, XLINK_NS_URI);
    }

    public synchronized void addNamespace(String string, String string2) {
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.PrefixIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string2 == null) {
            String string4 = Logging.getMessage("nullValue.NamespaceURIIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        this.urisByPrefix.put(string, string2);
        if (this.prefixesByURI.containsKey(string2)) {
            this.prefixesByURI.get(string2).add(string);
        } else {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(string);
            this.prefixesByURI.put(string2, hashSet);
        }
    }

    @Override
    public String getNamespaceURI(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.PrefixIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (this.urisByPrefix.containsKey(string)) {
            return this.urisByPrefix.get(string);
        }
        return "";
    }

    @Override
    public String getPrefix(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.NamespaceURIIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return (String)this.getPrefixes(string).next();
    }

    public Iterator getPrefixes(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.NamespaceURIIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (this.prefixesByURI.containsKey(string)) {
            return Collections.unmodifiableSet(this.prefixesByURI.get(string)).iterator();
        }
        return Collections.EMPTY_SET.iterator();
    }
}

