/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.areas;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.BasicArea;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class GroupOfTargets
extends BasicArea {
    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-F-ATG--------");
    }

    public GroupOfTargets(String string) {
        super(string);
    }

    @Override
    protected Position determineMainLabelPosition(DrawContext drawContext) {
        LatLon latLon;
        Iterable<? extends LatLon> iterable = this.polygon.getLocations();
        if (iterable == null) {
            return null;
        }
        Iterator<? extends LatLon> iterator = iterable.iterator();
        LatLon latLon2 = latLon = iterator.next();
        while (iterator.hasNext()) {
            LatLon latLon3 = latLon;
            latLon = iterator.next();
            LatLon latLon4 = LatLon.interpolateGreatCircle(0.5, latLon, latLon3);
            if (latLon4.latitude.compareTo(latLon2.latitude) <= 0) continue;
            latLon2 = latLon4;
        }
        return new Position(latLon2, 0.0);
    }
}

