/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.BasicWWTexture;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.SurfacePolylines;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.util.CompoundVecBuffer;
import gov.nasa.worldwind.util.GLUTessellatorSupport;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.SurfaceTileDrawContext;
import gov.nasa.worldwind.util.VecBuffer;
import gov.nasa.worldwind.util.WWMath;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUtessellator;
import javax.media.opengl.glu.GLUtessellatorCallback;

public class SurfacePolygons
extends SurfacePolylines {
    protected int[] polygonRingGroups;
    protected String windingRule = "gov.nasa.worldwind.avkey.ClockWise";
    protected boolean needsInteriorTessellation = true;
    protected WWTexture texture;
    protected Object interiorDisplayListCacheKey = new Object();

    public SurfacePolygons(CompoundVecBuffer compoundVecBuffer) {
        super(compoundVecBuffer);
    }

    public SurfacePolygons(Sector sector, CompoundVecBuffer compoundVecBuffer) {
        super(sector, compoundVecBuffer);
    }

    public int[] getPolygonRingGroups() {
        return (int[])this.polygonRingGroups.clone();
    }

    public void setPolygonRingGroups(int[] nArray) {
        this.polygonRingGroups = (int[])nArray.clone();
        this.onGeometryChanged();
    }

    public String getWindingRule() {
        return this.windingRule;
    }

    public void setWindingRule(String string) {
        this.windingRule = string;
        this.onGeometryChanged();
    }

    @Override
    protected void onGeometryChanged() {
        this.needsInteriorTessellation = true;
        super.onGeometryChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drawInterior(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        if (this.buffer.size() == 0) {
            return;
        }
        Position position = this.getReferencePosition();
        if (position == null) {
            return;
        }
        int[] nArray = (int[])drawContext.getGpuResourceCache().get(this.interiorDisplayListCacheKey);
        if (nArray == null || this.needsInteriorTessellation) {
            nArray = this.tessellateInterior(drawContext, position);
        }
        if (nArray == null) {
            return;
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        this.applyInteriorState(drawContext, surfaceTileDrawContext, this.getActiveAttributes(), this.getTexture(), position);
        gL2.glCallList(nArray[0]);
        if (this.crossesDateLine) {
            gL2.glPushMatrix();
            try {
                double d = Math.signum(position.getLongitude().degrees);
                gL2.glTranslated(360.0 * d, 0.0, 0.0);
                gL2.glCallList(nArray[0]);
            }
            finally {
                gL2.glPopMatrix();
            }
        }
    }

    protected WWTexture getTexture() {
        if (this.getActiveAttributes().getImageSource() == null) {
            return null;
        }
        if (this.texture == null && this.getActiveAttributes().getImageSource() != null) {
            this.texture = new BasicWWTexture(this.getActiveAttributes().getImageSource(), true);
        }
        return this.texture;
    }

    protected int[] tessellateInterior(DrawContext drawContext, LatLon latLon) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            return this.doTessellateInterior(drawContext, latLon);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            String string = Logging.getMessage("generic.ExceptionWhileTessellating", this);
            Logging.logger().log(Level.SEVERE, string, outOfMemoryError);
            drawContext.addRenderingException(new WWRuntimeException(string, outOfMemoryError));
            this.handleUnsuccessfulInteriorTessellation(drawContext);
            return null;
        }
    }

    protected int[] doTessellateInterior(DrawContext drawContext, LatLon latLon) {
        GL2 gL2 = drawContext.getGL().getGL2();
        GLUtessellatorCallback gLUtessellatorCallback = GLUTessellatorSupport.createOGLDrawPrimitivesCallback(gL2);
        int[] nArray = new int[]{gL2.glGenLists(1), 1};
        GLUTessellatorSupport gLUTessellatorSupport = new GLUTessellatorSupport();
        try {
            gLUTessellatorSupport.beginTessellation(gLUtessellatorCallback, new Vec4(0.0, 0.0, 1.0));
            gL2.glNewList(nArray[0], 4864);
            int n = this.tessellateInteriorVertices(gLUTessellatorSupport.getGLUtessellator(), latLon);
            gLUTessellatorSupport.endTessellation();
            gL2.glEndList();
            this.needsInteriorTessellation = false;
            drawContext.getGpuResourceCache().put(this.interiorDisplayListCacheKey, nArray, "gov.nasa.worldwind.cache.GpuResourceCache.DisplayList", n);
            return nArray;
        }
        catch (Throwable throwable) {
            gL2.glEndList();
            gLUTessellatorSupport.endTessellation();
            gL2.glDeleteLists(nArray[0], nArray[1]);
            String string = Logging.getMessage("generic.ExceptionWhileTessellating", this);
            Logging.logger().log(Level.SEVERE, string, throwable);
            drawContext.addRenderingException(new WWRuntimeException(string, throwable));
            this.handleUnsuccessfulInteriorTessellation(drawContext);
            return null;
        }
    }

    @Override
    protected void handleUnsuccessfulInteriorTessellation(DrawContext drawContext) {
        this.buffer = CompoundVecBuffer.emptyCompoundVecBuffer(2);
        this.onGeometryChanged();
    }

    protected int tessellateInteriorVertices(GLUtessellator gLUtessellator, LatLon latLon) {
        GLU.gluTessProperty((GLUtessellator)gLUtessellator, (int)100140, (double)(this.windingRule.equals("gov.nasa.worldwind.avkey.ClockWise") ? 100133.0 : 100132.0));
        this.crossesDateLine = false;
        int n = 0;
        int n2 = this.buffer.size();
        if (this.polygonRingGroups == null) {
            boolean bl = false;
            for (int i = 0; i < n2; ++i) {
                VecBuffer vecBuffer = this.buffer.subBuffer(i);
                n += vecBuffer.getSize() * 3 * 4;
                if (WWMath.computeWindingOrderOfLocations(vecBuffer.getLocations()).equals(this.getWindingRule())) {
                    if (bl) {
                        GLU.gluTessEndPolygon((GLUtessellator)gLUtessellator);
                    }
                    GLU.gluTessBeginPolygon((GLUtessellator)gLUtessellator, null);
                    bl = true;
                }
                if (!this.tessellateRing(gLUtessellator, vecBuffer, latLon)) continue;
                this.crossesDateLine = true;
            }
            if (bl) {
                GLU.gluTessEndPolygon((GLUtessellator)gLUtessellator);
            }
        } else {
            int n3 = this.polygonRingGroups.length;
            for (int i = 0; i < n3; ++i) {
                int n4 = this.polygonRingGroups[i];
                int n5 = i == n3 - 1 ? n2 - n4 : this.polygonRingGroups[i + 1] - n4;
                GLU.gluTessBeginPolygon((GLUtessellator)gLUtessellator, null);
                for (int j = 0; j < n5; ++j) {
                    VecBuffer vecBuffer = this.buffer.subBuffer(n4 + j);
                    n += vecBuffer.getSize() * 3 * 4;
                    if (!this.tessellateRing(gLUtessellator, vecBuffer, latLon)) continue;
                    this.crossesDateLine = true;
                }
                GLU.gluTessEndPolygon((GLUtessellator)gLUtessellator);
            }
        }
        return n;
    }

    protected boolean tessellateRing(GLUtessellator gLUtessellator, VecBuffer vecBuffer, LatLon latLon) {
        List<double[]> list = this.computeDateLineCrossingPoints(vecBuffer);
        int n = this.computePole(list);
        double[] dArray = this.computePoleWrappingPoint(n, list);
        GLU.gluTessBeginContour((GLUtessellator)gLUtessellator);
        Iterable<double[]> iterable = vecBuffer.getCoords(3);
        boolean bl = false;
        int n2 = 0;
        double[] dArray2 = null;
        for (double[] dArray3 : iterable) {
            if (dArray != null && dArray2 != null && dArray[0] == dArray2[0] && dArray[1] == dArray2[1]) {
                dArray2 = (double[])dArray3.clone();
                double[] dArray4 = this.computeDateLineEntryPoint(dArray, dArray3);
                double[] dArray5 = new double[]{180.0 * Math.signum(dArray[0]), 90.0 * (double)n, 0.0};
                double[] dArray6 = (double[])dArray4.clone();
                double[] dArray7 = (double[])dArray5.clone();
                dArray6[0] = dArray6[0] * -1.0;
                dArray7[0] = dArray7[0] * -1.0;
                SurfacePolygons.tessVertex(gLUtessellator, dArray4, latLon);
                SurfacePolygons.tessVertex(gLUtessellator, dArray5, latLon);
                SurfacePolygons.tessVertex(gLUtessellator, dArray7, latLon);
                SurfacePolygons.tessVertex(gLUtessellator, dArray6, latLon);
                SurfacePolygons.tessVertex(gLUtessellator, dArray3, latLon);
                bl = true;
                continue;
            }
            if (dArray2 != null && Math.abs((double)(dArray2[0] - dArray3[0])) > 180.0) {
                n2 += (int)Math.signum(dArray2[0]);
                bl = true;
            }
            dArray2 = (double[])dArray3.clone();
            dArray3[0] = dArray3[0] + (double)(n2 * 360);
            SurfacePolygons.tessVertex(gLUtessellator, dArray3, latLon);
        }
        GLU.gluTessEndContour((GLUtessellator)gLUtessellator);
        return bl;
    }

    private static void tessVertex(GLUtessellator gLUtessellator, double[] dArray, LatLon latLon) {
        double[] dArray2 = new double[3];
        dArray2[0] = dArray[0] - latLon.getLongitude().degrees;
        dArray2[1] = dArray[1] - latLon.getLatitude().degrees;
        GLU.gluTessVertex((GLUtessellator)gLUtessellator, (double[])dArray2, (int)0, (Object)dArray2);
    }

    protected List<double[]> computeDateLineCrossingPoints(VecBuffer vecBuffer) {
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        Iterable<double[]> iterable = vecBuffer.getCoords(3);
        double[] dArray = null;
        for (double[] dArray2 : iterable) {
            if (dArray != null && Math.abs(dArray[0] - dArray2[0]) > 180.0) {
                arrayList.add(dArray);
            }
            dArray = dArray2;
        }
        return arrayList;
    }

    protected int computePole(List<double[]> list) {
        int n = 0;
        for (double[] dArray : list) {
            n = (int)((double)n + Math.signum(dArray[0]));
        }
        if (n == 0) {
            return 0;
        }
        return this.getWindingRule().equals("gov.nasa.worldwind.avkey.ClockWise") && n < 0 ? 1 : -1;
    }

    protected double[] computePoleWrappingPoint(int n, List<double[]> list) {
        if (n == 0) {
            return null;
        }
        int n2 = -1;
        double d = n < 0 ? 90.0 : -90.0;
        for (int i = 0; i < list.size(); ++i) {
            double[] dArray = list.get(i);
            if (n < 0 && dArray[1] < d) {
                n2 = i;
                d = dArray[1];
            }
            if (n <= 0 || !(dArray[1] > d)) continue;
            n2 = i;
            d = dArray[1];
        }
        return list.get(n2);
    }

    protected double[] computeDateLineEntryPoint(double[] dArray, double[] dArray2) {
        double d = dArray2[1] - dArray[1];
        double d2 = 360.0 - Math.abs(dArray2[0] - dArray[0]);
        double d3 = Math.abs(180.0 * Math.signum(dArray[0]) - dArray[0]) / d2;
        double d4 = dArray[1] + d * d3;
        double d5 = 180.0 * Math.signum(dArray[0]);
        return new double[]{d5, d4, 0.0};
    }
}

