/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.jogamp.opengl.util.awt.TextRenderer;
import gov.nasa.worldwind.Exportable;
import gov.nasa.worldwind.Locatable;
import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.ogc.kml.impl.KMLExportUtil;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.BasicWWTexture;
import gov.nasa.worldwind.render.Declutterable;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Highlightable;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.PointPlacemarkAttributes;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.OGLTextRenderer;
import gov.nasa.worldwind.util.OGLUtil;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class PointPlacemark
extends WWObjectImpl
implements OrderedRenderable,
Locatable,
Movable,
Highlightable,
Exportable,
Declutterable {
    protected static final Double DEFAULT_HIGHLIGHT_SCALE = 1.3;
    protected static final Offset DEFAULT_LABEL_OFFSET_IF_UNSPECIFIED = new Offset(1.0, 0.6, "gov.nasa.worldwind.avkey.Fraction", "gov.nasa.worldwind.avkey.Fraction");
    protected static final Double DEFAULT_POINT_SIZE = 5.0;
    protected static final PointPlacemarkAttributes defaultAttributes = new PointPlacemarkAttributes();
    protected Position position;
    protected String labelText;
    protected PointPlacemarkAttributes normalAttrs;
    protected PointPlacemarkAttributes highlightAttrs;
    protected PointPlacemarkAttributes activeAttributes = new PointPlacemarkAttributes();
    protected Map<String, WWTexture> textures = new HashMap<String, WWTexture>();
    protected WWTexture activeTexture;
    protected boolean highlighted;
    protected boolean visible = true;
    protected int altitudeMode = 1;
    protected boolean lineEnabled;
    protected boolean applyVerticalExaggeration = true;
    protected int linePickWidth = 10;
    protected boolean enableBatchRendering = true;
    protected boolean enableBatchPicking = true;
    protected Object delegateOwner;
    protected boolean clipToHorizon = true;
    protected boolean enableDecluttering = false;
    protected long frameNumber = -1L;
    protected Vec4 placePoint;
    protected Vec4 terrainPoint;
    protected Vec4 screenPoint;
    protected double eyeDistance;
    protected double dx;
    protected double dy;
    protected Layer pickLayer;
    protected Rectangle2D labelBounds;
    protected Font boundsFont;
    protected PickSupport pickSupport = new PickSupport();

    public PointPlacemark(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.position = position;
    }

    public void setPosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.position = position;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public int getAltitudeMode() {
        return this.altitudeMode;
    }

    public void setAltitudeMode(int n) {
        this.altitudeMode = n;
    }

    @Override
    public double getDistanceFromEye() {
        return this.eyeDistance;
    }

    public boolean isLineEnabled() {
        return this.lineEnabled;
    }

    public void setLineEnabled(boolean bl) {
        this.lineEnabled = bl;
    }

    public void setAttributes(PointPlacemarkAttributes pointPlacemarkAttributes) {
        if (this.normalAttrs != null && this.normalAttrs.getImageAddress() != null) {
            this.textures.remove(this.normalAttrs.getImageAddress());
        }
        this.normalAttrs = pointPlacemarkAttributes;
    }

    public PointPlacemarkAttributes getAttributes() {
        return this.normalAttrs;
    }

    public void setHighlightAttributes(PointPlacemarkAttributes pointPlacemarkAttributes) {
        if (this.highlightAttrs != null && this.highlightAttrs.getImageAddress() != null) {
            this.textures.remove(this.highlightAttrs.getImageAddress());
        }
        this.highlightAttrs = pointPlacemarkAttributes;
    }

    public PointPlacemarkAttributes getHighlightAttributes() {
        return this.highlightAttrs;
    }

    public PointPlacemarkAttributes getDefaultAttributes() {
        return defaultAttributes;
    }

    @Override
    public boolean isHighlighted() {
        return this.highlighted;
    }

    @Override
    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
    }

    public String getLabelText() {
        return this.labelText;
    }

    public void setLabelText(String string) {
        this.labelText = string != null ? string.trim() : null;
    }

    public boolean isApplyVerticalExaggeration() {
        return this.applyVerticalExaggeration;
    }

    public void setApplyVerticalExaggeration(boolean bl) {
        this.applyVerticalExaggeration = bl;
    }

    public int getLinePickWidth() {
        return this.linePickWidth;
    }

    public void setLinePickWidth(int n) {
        this.linePickWidth = n;
    }

    public boolean isEnableBatchRendering() {
        return this.enableBatchRendering;
    }

    public void setEnableBatchRendering(boolean bl) {
        this.enableBatchRendering = bl;
    }

    public boolean isEnableBatchPicking() {
        return this.enableBatchPicking;
    }

    public Object getDelegateOwner() {
        return this.delegateOwner;
    }

    public void setDelegateOwner(Object object) {
        this.delegateOwner = object;
    }

    protected PointPlacemarkAttributes getActiveAttributes() {
        return this.activeAttributes;
    }

    public void setEnableBatchPicking(boolean bl) {
        this.enableBatchPicking = bl;
    }

    public boolean isClipToHorizon() {
        return this.clipToHorizon;
    }

    public void setClipToHorizon(boolean bl) {
        this.clipToHorizon = bl;
    }

    @Override
    public boolean isEnableDecluttering() {
        return this.enableDecluttering;
    }

    public void setEnableDecluttering(boolean bl) {
        this.enableDecluttering = bl;
    }

    protected boolean isDrawPoint(DrawContext drawContext) {
        return this.activeTexture == null && this.getActiveAttributes().isUsePointAsDefaultImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pick(DrawContext drawContext, Point point) {
        this.pickSupport.clearPickList();
        try {
            this.pickSupport.beginPicking(drawContext);
            this.render(drawContext);
        }
        finally {
            this.pickSupport.endPicking(drawContext);
            this.pickSupport.resolvePick(drawContext, point, this.pickLayer);
        }
    }

    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getSurfaceGeometry() == null) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        if (drawContext.isOrderedRenderingMode()) {
            this.drawOrderedRenderable(drawContext);
        } else {
            this.makeOrderedRenderable(drawContext);
        }
    }

    protected void makeOrderedRenderable(DrawContext drawContext) {
        double d;
        if (drawContext.getFrameTimeStamp() != this.frameNumber) {
            this.computePlacemarkPoints(drawContext);
            if (this.placePoint == null || this.screenPoint == null) {
                return;
            }
            this.determineActiveAttributes();
            if (this.activeTexture == null && !this.getActiveAttributes().isUsePointAsDefaultImage()) {
                return;
            }
            this.computeImageOffset(drawContext);
            this.frameNumber = drawContext.getFrameTimeStamp();
        }
        if (this.isClipToHorizon() && this.eyeDistance > (d = drawContext.getView().getHorizonDistance())) {
            return;
        }
        if (this.intersectsFrustum(drawContext) || this.isDrawLine(drawContext)) {
            drawContext.addOrderedRenderable(this);
        }
        if (drawContext.isPickingMode()) {
            this.pickLayer = drawContext.getCurrentLayer();
        }
    }

    protected boolean intersectsFrustum(DrawContext drawContext) {
        View view = drawContext.getView();
        if (this.placePoint != null && (view.getFrustumInModelCoordinates().getNear().distanceTo(this.placePoint) < 0.0 || view.getFrustumInModelCoordinates().getFar().distanceTo(this.placePoint) < 0.0)) {
            return false;
        }
        Rectangle rectangle = this.computeImageRectangle(drawContext);
        if (drawContext.isPickingMode()) {
            return drawContext.getPickFrustums().intersectsAny(rectangle);
        }
        if (rectangle.width > 0) {
            return view.getViewport().intersects(rectangle);
        }
        if (this.mustDrawLabel()) {
            return view.getViewport().contains((int)this.screenPoint.x, (int)this.screenPoint.y);
        }
        return false;
    }

    protected void beginDrawing(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        int n = 63749;
        gL2.glPushAttrib(n);
        if (!drawContext.isPickingMode()) {
            gL2.glEnable(3042);
            OGLUtil.applyBlending(gL2, false);
        }
    }

    protected void endDrawing(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glBindTexture(3553, 0);
        gL2.glPopAttrib();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawOrderedRenderable(DrawContext drawContext) {
        this.beginDrawing(drawContext);
        try {
            this.doDrawOrderedRenderable(drawContext, this.pickSupport);
            if (this.isEnableBatchRendering()) {
                this.drawBatched(drawContext);
            }
        }
        finally {
            this.endDrawing(drawContext);
        }
    }

    protected void drawBatched(DrawContext drawContext) {
        block3: {
            PointPlacemark pointPlacemark;
            OrderedRenderable orderedRenderable;
            block2: {
                PointPlacemark pointPlacemark2;
                orderedRenderable = drawContext.peekOrderedRenderables();
                if (drawContext.isPickingMode()) break block2;
                while (orderedRenderable != null && orderedRenderable instanceof PointPlacemark && (pointPlacemark2 = (PointPlacemark)orderedRenderable).isEnableBatchRendering()) {
                    drawContext.pollOrderedRenderables();
                    pointPlacemark2.doDrawOrderedRenderable(drawContext, this.pickSupport);
                    orderedRenderable = drawContext.peekOrderedRenderables();
                }
                break block3;
            }
            if (!this.isEnableBatchPicking()) break block3;
            while (orderedRenderable != null && orderedRenderable instanceof PointPlacemark && (pointPlacemark = (PointPlacemark)orderedRenderable).isEnableBatchRendering() && pointPlacemark.isEnableBatchPicking() && pointPlacemark.pickLayer == this.pickLayer) {
                drawContext.pollOrderedRenderables();
                pointPlacemark.doDrawOrderedRenderable(drawContext, this.pickSupport);
                orderedRenderable = drawContext.peekOrderedRenderables();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDrawOrderedRenderable(DrawContext drawContext, PickSupport pickSupport) {
        if (this.isDrawLine(drawContext)) {
            this.drawLine(drawContext, pickSupport);
        }
        if (this.activeTexture == null) {
            if (this.isDrawPoint(drawContext)) {
                this.drawPoint(drawContext, pickSupport);
            }
            return;
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        try {
            Color color;
            if (drawContext.isPickingMode()) {
                gL2.glEnable(3553);
                gL2.glTexEnvf(8960, 8704, 34160.0f);
                gL2.glTexEnvf(8960, 34176, 34168.0f);
                gL2.glTexEnvf(8960, 34161, 7681.0f);
                color = drawContext.getUniquePickColor();
                pickSupport.addPickableObject(this.createPickedObject(drawContext, color));
                gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
            } else {
                gL2.glEnable(3553);
                color = this.getActiveAttributes().getImageColor();
                if (color == null) {
                    color = PointPlacemarkAttributes.DEFAULT_IMAGE_COLOR;
                }
                gL2.glColor4ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue(), (byte)color.getAlpha());
            }
            oGLStackHandler.pushProjectionIdentity(gL2);
            gL2.glOrtho(0.0, (double)drawContext.getView().getViewport().width, 0.0, (double)drawContext.getView().getViewport().height, -1.0, 1.0);
            if (!drawContext.isDeepPickingEnabled()) {
                gL2.glEnable(2929);
            }
            gL2.glDepthMask(false);
            gL2.glEnable(3008);
            gL2.glAlphaFunc(516, 0.001f);
            double d = this.screenPoint.z - 0.00391006472;
            d = d < 0.0 ? 0.0 : (d > 1.0 ? 1.0 : d);
            gL2.glDepthFunc(513);
            gL2.glDepthRange(d, d);
            oGLStackHandler.pushModelviewIdentity(gL2);
            gL2.glTranslated(this.screenPoint.x + this.dx, this.screenPoint.y + this.dy, 0.0);
            Double d2 = this.getActiveAttributes().getScale();
            double d3 = d2 != null ? d2 * (double)this.activeTexture.getWidth(drawContext) : (double)this.activeTexture.getWidth(drawContext);
            double d4 = d2 != null ? d2 * (double)this.activeTexture.getHeight(drawContext) : (double)this.activeTexture.getHeight(drawContext);
            Double d5 = this.getActiveAttributes().getHeading();
            Double d6 = this.getActiveAttributes().getPitch();
            if (d5 != null) {
                d5 = "gov.nasa.worldwind.avkey.RelativeToGlobe".equals(this.getActiveAttributes().getHeadingReference()) ? Double.valueOf(drawContext.getView().getHeading().degrees - d5) : Double.valueOf(-d5.doubleValue());
            }
            if (d5 != null || d6 != null) {
                gL2.glTranslated(d3 / 2.0, d4 / 2.0, 0.0);
                if (d6 != null) {
                    gL2.glRotated(d6.doubleValue(), 1.0, 0.0, 0.0);
                }
                if (d5 != null) {
                    gL2.glRotated(d5.doubleValue(), 0.0, 0.0, 1.0);
                }
                gL2.glTranslated(-d3 / 2.0, -d4 / 2.0, 0.0);
            }
            gL2.glScaled(d3, d4, 1.0);
            if (this.activeTexture.bind(drawContext)) {
                drawContext.drawUnitQuad(this.activeTexture.getTexCoords());
            }
            gL2.glDepthRange(0.0, 1.0);
            if (this.mustDrawLabel() && !drawContext.isPickingMode()) {
                this.drawLabel(drawContext);
            }
        }
        finally {
            if (drawContext.isPickingMode()) {
                gL2.glTexEnvf(8960, 8704, 8448.0f);
                gL2.glTexEnvf(8960, 34176, 5890.0f);
                gL2.glTexEnvf(8960, 34161, 8448.0f);
            }
            gL2.glDisable(3553);
            oGLStackHandler.pop(gL2);
        }
    }

    protected PickedObject createPickedObject(DrawContext drawContext, Color color) {
        Object object = this.getDelegateOwner();
        return new PickedObject(color.getRGB(), object != null ? object : this);
    }

    protected boolean mustDrawLabel() {
        return this.labelText != null;
    }

    @Override
    public Rectangle2D getBounds(DrawContext drawContext) {
        return this.getLabelBounds(drawContext);
    }

    protected Rectangle2D getLabelBounds(DrawContext drawContext) {
        Object object;
        Rectangle2D rectangle2D;
        if (this.labelText == null) {
            return null;
        }
        double d = (float)(this.screenPoint.x + this.dx);
        double d2 = (float)(this.screenPoint.y + this.dy);
        Double d3 = this.getActiveAttributes().getScale();
        Offset offset = this.getActiveAttributes().getLabelOffset();
        if (offset == null) {
            offset = DEFAULT_LABEL_OFFSET_IF_UNSPECIFIED;
        }
        double d4 = this.activeTexture != null ? (double)this.activeTexture.getWidth(drawContext) : 1.0;
        double d5 = this.activeTexture != null ? (double)this.activeTexture.getHeight(drawContext) : 1.0;
        Point2D.Double double_ = offset.computeOffset(d4, d5, d3, d3);
        d += double_.x;
        d2 += double_.y;
        Font font = this.getActiveAttributes().getLabelFont();
        if (font == null) {
            font = PointPlacemarkAttributes.DEFAULT_LABEL_FONT;
        }
        if (this.labelBounds != null && font == this.boundsFont) {
            rectangle2D = new Rectangle2D.Double(d, d2, this.labelBounds.getWidth(), this.labelBounds.getHeight());
        } else {
            object = OGLTextRenderer.getOrCreateTextRenderer(drawContext.getTextRendererCache(), font);
            rectangle2D = object.getBounds(this.labelText);
            this.boundsFont = font;
            this.labelBounds = rectangle2D;
        }
        object = this.getActiveAttributes().getLabelScale();
        if (object != null) {
            double d6 = (Double)object * rectangle2D.getWidth();
            double d7 = (Double)object * rectangle2D.getHeight();
            rectangle2D = new Rectangle2D.Double(d, d2, d6, d7);
        } else {
            rectangle2D = new Rectangle2D.Double(d, d2, rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        return rectangle2D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawLabel(DrawContext drawContext) {
        if (this.labelText == null) {
            return;
        }
        Color color = this.getActiveAttributes().getLabelColor();
        if (color == null) {
            color = PointPlacemarkAttributes.DEFAULT_LABEL_COLOR;
        }
        if (color.getAlpha() <= 0) {
            return;
        }
        Color color2 = color.getAlpha() < 255 ? new Color(0, 0, 0, color.getAlpha()) : Color.BLACK;
        Font font = this.getActiveAttributes().getLabelFont();
        if (font == null) {
            font = PointPlacemarkAttributes.DEFAULT_LABEL_FONT;
        }
        float f = (float)(this.screenPoint.x + this.dx);
        float f2 = (float)(this.screenPoint.y + this.dy);
        Double d = this.getActiveAttributes().getScale();
        Offset offset = this.getActiveAttributes().getLabelOffset();
        if (offset == null) {
            offset = DEFAULT_LABEL_OFFSET_IF_UNSPECIFIED;
        }
        double d2 = this.activeTexture != null ? (double)this.activeTexture.getWidth(drawContext) : 1.0;
        double d3 = this.activeTexture != null ? (double)this.activeTexture.getHeight(drawContext) : 1.0;
        Point2D.Double double_ = offset.computeOffset(d2, d3, d, d);
        f = (float)((double)f + double_.x);
        f2 = (float)((double)f2 + double_.y);
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glMatrixMode(5888);
        gL2.glLoadIdentity();
        Double d4 = this.getActiveAttributes().getLabelScale();
        if (d4 != null) {
            gL2.glTranslatef(f, f2, 0.0f);
            gL2.glScaled(d4.doubleValue(), d4.doubleValue(), 1.0);
            gL2.glTranslatef(-f, -f2, 0.0f);
        }
        gL2.glDisable(2929);
        gL2.glDepthMask(false);
        TextRenderer textRenderer = OGLTextRenderer.getOrCreateTextRenderer(drawContext.getTextRendererCache(), font);
        try {
            textRenderer.begin3DRendering();
            textRenderer.setColor(color2);
            textRenderer.draw3D(this.labelText, f + 1.0f, f2 - 1.0f, 0.0f, 1.0f);
            textRenderer.setColor(color);
            textRenderer.draw3D(this.labelText, f, f2, 0.0f, 1.0f);
        }
        finally {
            textRenderer.end3DRendering();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawLine(DrawContext drawContext, PickSupport pickSupport) {
        GL2 gL2 = drawContext.getGL().getGL2();
        if (!drawContext.isDeepPickingEnabled()) {
            gL2.glEnable(2929);
        }
        gL2.glDepthFunc(515);
        gL2.glDepthMask(true);
        try {
            drawContext.getView().pushReferenceCenter(drawContext, this.placePoint);
            this.setLineWidth(drawContext);
            this.setLineColor(drawContext, pickSupport);
            gL2.glBegin(3);
            gL2.glVertex3d(Vec4.ZERO.x, Vec4.ZERO.y, Vec4.ZERO.z);
            gL2.glVertex3d(this.terrainPoint.x - this.placePoint.x, this.terrainPoint.y - this.placePoint.y, this.terrainPoint.z - this.placePoint.z);
            gL2.glEnd();
        }
        finally {
            drawContext.getView().popReferenceCenter(drawContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawPoint(DrawContext drawContext, PickSupport pickSupport) {
        GL2 gL2 = drawContext.getGL().getGL2();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        try {
            oGLStackHandler.pushAttrib(gL2, 2);
            this.setLineColor(drawContext, pickSupport);
            this.setPointSize(drawContext);
            oGLStackHandler.pushProjectionIdentity(gL2);
            gL2.glOrtho(0.0, (double)drawContext.getView().getViewport().width, 0.0, (double)drawContext.getView().getViewport().height, -1.0, 1.0);
            oGLStackHandler.pushModelviewIdentity(gL2);
            if (!drawContext.isDeepPickingEnabled()) {
                gL2.glEnable(2929);
            }
            gL2.glDepthMask(false);
            gL2.glEnable(3008);
            gL2.glAlphaFunc(516, 0.001f);
            double d = this.screenPoint.z - 0.00391006472;
            d = d < 0.0 ? 0.0 : (d > 1.0 ? 1.0 : d);
            gL2.glDepthFunc(513);
            gL2.glDepthRange(d, d);
            gL2.glBegin(0);
            gL2.glVertex3d(this.screenPoint.x, this.screenPoint.y, 0.0);
            gL2.glEnd();
            gL2.glDepthRange(0.0, 1.0);
            if (!drawContext.isPickingMode()) {
                this.drawLabel(drawContext);
            }
        }
        finally {
            oGLStackHandler.pop(gL2);
        }
    }

    protected boolean isDrawLine(DrawContext drawContext) {
        if (!this.isLineEnabled() || this.getAltitudeMode() == 1 || this.terrainPoint == null) {
            return false;
        }
        if (drawContext.isPickingMode()) {
            return drawContext.getPickFrustums().intersectsAny(this.placePoint, this.terrainPoint);
        }
        return drawContext.getView().getFrustumInModelCoordinates().intersectsSegment(this.placePoint, this.terrainPoint);
    }

    protected void setLineWidth(DrawContext drawContext) {
        Double d = this.getActiveAttributes().getLineWidth();
        if (d != null) {
            GL gL = drawContext.getGL();
            if (drawContext.isPickingMode()) {
                gL.glLineWidth(d.floatValue() + (float)this.getLinePickWidth());
            } else {
                gL.glLineWidth(d.floatValue());
            }
            if (!drawContext.isPickingMode()) {
                gL.glHint(3154, this.getActiveAttributes().getAntiAliasHint());
                gL.glEnable(2848);
            }
        }
    }

    protected void setPointSize(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        Double d = this.getActiveAttributes().getScale();
        if (d == null) {
            d = DEFAULT_POINT_SIZE;
        }
        if (drawContext.isPickingMode()) {
            gL2.glPointSize(d.floatValue() + (float)this.getLinePickWidth());
        } else {
            gL2.glPointSize(d.floatValue());
        }
        if (!drawContext.isPickingMode()) {
            gL2.glEnable(2832);
            gL2.glHint(3153, 4354);
        }
    }

    protected void setLineColor(DrawContext drawContext, PickSupport pickSupport) {
        GL2 gL2 = drawContext.getGL().getGL2();
        if (!drawContext.isPickingMode()) {
            Color color = this.getActiveAttributes().getLineColor();
            if (color == null) {
                color = PointPlacemarkAttributes.DEFAULT_LINE_COLOR;
            }
            gL2.glColor4ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue(), (byte)color.getAlpha());
        } else {
            Color color = drawContext.getUniquePickColor();
            pickSupport.addPickableObject(color.getRGB(), this, this.getPosition());
            gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
        }
    }

    protected void determineActiveAttributes() {
        PointPlacemarkAttributes pointPlacemarkAttributes = this.getActiveAttributes();
        if (this.isHighlighted()) {
            if (this.getHighlightAttributes() != null) {
                pointPlacemarkAttributes.copy(this.getHighlightAttributes());
                if (WWUtil.isEmpty(pointPlacemarkAttributes.getImageAddress()) && this.getAttributes() != null && !WWUtil.isEmpty(this.getAttributes().getImageAddress())) {
                    pointPlacemarkAttributes.setImageAddress(this.getAttributes().getImageAddress());
                    if (this.getAttributes().getScale() != null) {
                        pointPlacemarkAttributes.setScale(DEFAULT_HIGHLIGHT_SCALE * this.getAttributes().getScale());
                    } else {
                        pointPlacemarkAttributes.setScale(DEFAULT_HIGHLIGHT_SCALE);
                    }
                }
            } else if (this.getAttributes() != null) {
                pointPlacemarkAttributes.copy(this.getAttributes());
                if (this.getAttributes().getScale() != null) {
                    pointPlacemarkAttributes.setScale(DEFAULT_HIGHLIGHT_SCALE * this.getAttributes().getScale());
                } else {
                    pointPlacemarkAttributes.setScale(DEFAULT_HIGHLIGHT_SCALE);
                }
            } else {
                pointPlacemarkAttributes.copy(defaultAttributes);
                if (defaultAttributes.getScale() != null) {
                    pointPlacemarkAttributes.setScale(DEFAULT_HIGHLIGHT_SCALE * defaultAttributes.getScale());
                } else {
                    pointPlacemarkAttributes.setScale(DEFAULT_HIGHLIGHT_SCALE);
                }
            }
        } else if (this.getAttributes() != null) {
            pointPlacemarkAttributes.copy(this.getAttributes());
        } else {
            pointPlacemarkAttributes.copy(defaultAttributes);
            if (this.activeTexture == null && pointPlacemarkAttributes.isUsePointAsDefaultImage()) {
                pointPlacemarkAttributes.setImageAddress(null);
                pointPlacemarkAttributes.setScale(DEFAULT_POINT_SIZE);
            }
        }
        this.activeTexture = this.chooseTexture(pointPlacemarkAttributes);
        if (this.activeTexture == null && pointPlacemarkAttributes.isUsePointAsDefaultImage()) {
            pointPlacemarkAttributes.setImageAddress(null);
            pointPlacemarkAttributes.setImageOffset(null);
            if (pointPlacemarkAttributes.getScale() == null) {
                pointPlacemarkAttributes.setScale(DEFAULT_POINT_SIZE);
            }
        }
    }

    protected WWTexture chooseTexture(PointPlacemarkAttributes pointPlacemarkAttributes) {
        URL uRL;
        WWTexture wWTexture;
        if (!WWUtil.isEmpty(pointPlacemarkAttributes.getImageAddress())) {
            wWTexture = this.textures.get(pointPlacemarkAttributes.getImageAddress());
            if (wWTexture != null) {
                return wWTexture;
            }
            wWTexture = this.initializeTexture(pointPlacemarkAttributes.getImageAddress());
            if (wWTexture != null) {
                this.textures.put(pointPlacemarkAttributes.getImageAddress(), wWTexture);
                return wWTexture;
            }
        }
        if (this.getActiveAttributes().usePointAsDefaultImage) {
            return null;
        }
        wWTexture = this.textures.get(defaultAttributes.getImageAddress());
        this.getActiveAttributes().setImageOffset(defaultAttributes.getImageOffset());
        if (pointPlacemarkAttributes.getScale() != null) {
            this.getActiveAttributes().setScale(defaultAttributes.getScale() * pointPlacemarkAttributes.getScale());
        } else {
            this.getActiveAttributes().setScale(defaultAttributes.getScale());
        }
        if (wWTexture == null && (uRL = WorldWind.getDataFileStore().requestFile(defaultAttributes.getImageAddress())) != null) {
            wWTexture = new BasicWWTexture(uRL, true);
            this.textures.put(defaultAttributes.getImageAddress(), wWTexture);
        }
        return wWTexture;
    }

    protected WWTexture initializeTexture(String string) {
        URL uRL = WorldWind.getDataFileStore().requestFile(string);
        if (uRL != null) {
            return new BasicWWTexture(uRL, true);
        }
        return null;
    }

    protected void computePlacemarkPoints(DrawContext drawContext) {
        this.placePoint = null;
        this.terrainPoint = null;
        this.screenPoint = null;
        Position position = this.getPosition();
        if (position == null) {
            return;
        }
        if (this.altitudeMode == 1) {
            this.placePoint = drawContext.computeTerrainPoint(position.getLatitude(), position.getLongitude(), 0.0);
        } else if (this.altitudeMode == 2) {
            this.placePoint = drawContext.computeTerrainPoint(position.getLatitude(), position.getLongitude(), position.getAltitude());
        } else {
            double d = position.getElevation() * (this.isApplyVerticalExaggeration() ? drawContext.getVerticalExaggeration() : 1.0);
            this.placePoint = drawContext.getGlobe().computePointFromPosition(position.getLatitude(), position.getLongitude(), d);
        }
        if (this.placePoint == null) {
            return;
        }
        if (this.isLineEnabled() && this.altitudeMode != 1) {
            this.terrainPoint = drawContext.computeTerrainPoint(position.getLatitude(), position.getLongitude(), 0.0);
        }
        this.screenPoint = drawContext.getView().project(this.placePoint);
        this.eyeDistance = this.placePoint.distanceTo3(drawContext.getView().getEyePoint());
    }

    protected Rectangle computeImageRectangle(DrawContext drawContext) {
        double d = this.getActiveAttributes().getScale() != null ? this.getActiveAttributes().getScale() : 1.0;
        double d2 = d * (double)(this.activeTexture != null ? this.activeTexture.getWidth(drawContext) : 1);
        double d3 = d * (double)(this.activeTexture != null ? this.activeTexture.getHeight(drawContext) : 1);
        double d4 = this.screenPoint.x + (this.isDrawPoint(drawContext) ? -0.5 * d : this.dx);
        double d5 = this.screenPoint.y + (this.isDrawPoint(drawContext) ? -0.5 * d : this.dy);
        return new Rectangle((int)d4, (int)d5, (int)Math.ceil(d2), (int)Math.ceil(d3));
    }

    protected void computeImageOffset(DrawContext drawContext) {
        this.dx = 0.0;
        this.dy = 0.0;
        if (this.isDrawPoint(drawContext)) {
            return;
        }
        Offset offset = this.getActiveAttributes().getImageOffset();
        if (offset == null) {
            return;
        }
        double d = this.activeTexture != null ? (double)this.activeTexture.getWidth(drawContext) : 1.0;
        double d2 = this.activeTexture != null ? (double)this.activeTexture.getHeight(drawContext) : 1.0;
        Point2D.Double double_ = offset.computeOffset(d, d2, this.getActiveAttributes().getScale(), this.getActiveAttributes().getScale());
        this.dx = -double_.x;
        this.dy = -double_.y;
    }

    @Override
    public String isExportFormatSupported(String string) {
        if ("application/vnd.google-earth.kml+xml".equalsIgnoreCase(string)) {
            return "Export.FormatSupported";
        }
        return "Export.FormatNotSupported";
    }

    @Override
    public Position getReferencePosition() {
        return this.getPosition();
    }

    @Override
    public void move(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = this.getReferencePosition();
        if (position2 == null) {
            return;
        }
        this.moveTo(position2.add(position));
    }

    @Override
    public void moveTo(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setPosition(position);
    }

    @Override
    public void export(String string, Object object) throws IOException {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.Format");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (object == null) {
            String string3 = Logging.getMessage("nullValue.OutputBufferIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if ("application/vnd.google-earth.kml+xml".equalsIgnoreCase(string)) {
            try {
                this.exportAsKML(object);
            }
            catch (XMLStreamException xMLStreamException) {
                Logging.logger().throwing(this.getClass().getName(), "export", xMLStreamException);
                throw new IOException(xMLStreamException);
            }
        } else {
            String string4 = Logging.getMessage("Export.UnsupportedFormat", string);
            Logging.logger().warning(string4);
            throw new UnsupportedOperationException(string4);
        }
    }

    protected void exportAsKML(Object object) throws IOException, XMLStreamException {
        String string;
        XMLStreamWriter xMLStreamWriter = null;
        XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
        boolean bl = true;
        if (object instanceof XMLStreamWriter) {
            xMLStreamWriter = (XMLStreamWriter)object;
            bl = false;
        } else if (object instanceof Writer) {
            xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter((Writer)object);
        } else if (object instanceof OutputStream) {
            xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter((OutputStream)object);
        }
        if (xMLStreamWriter == null) {
            String string2 = Logging.getMessage("Export.UnsupportedOutputObject");
            Logging.logger().warning(string2);
            throw new IllegalArgumentException(string2);
        }
        xMLStreamWriter.writeStartElement("Placemark");
        xMLStreamWriter.writeStartElement("name");
        xMLStreamWriter.writeCharacters(this.getLabelText());
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("visibility");
        xMLStreamWriter.writeCharacters(KMLExportUtil.kmlBoolean(this.isVisible()));
        xMLStreamWriter.writeEndElement();
        String string3 = (String)this.getValue("gov.nasa.worldwind.avkey.Server.ShortDescription");
        if (string3 != null) {
            xMLStreamWriter.writeStartElement("Snippet");
            xMLStreamWriter.writeCharacters(string3);
            xMLStreamWriter.writeEndElement();
        }
        if ((string = (String)this.getValue("gov.nasa.worldwind.avkey.BalloonText")) != null) {
            xMLStreamWriter.writeStartElement("description");
            xMLStreamWriter.writeCharacters(string);
            xMLStreamWriter.writeEndElement();
        }
        PointPlacemarkAttributes pointPlacemarkAttributes = this.getAttributes();
        PointPlacemarkAttributes pointPlacemarkAttributes2 = this.getHighlightAttributes();
        if (pointPlacemarkAttributes != null || pointPlacemarkAttributes2 != null) {
            xMLStreamWriter.writeStartElement("StyleMap");
            this.exportAttributesAsKML(xMLStreamWriter, "normal", pointPlacemarkAttributes);
            this.exportAttributesAsKML(xMLStreamWriter, "highlight", pointPlacemarkAttributes2);
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeStartElement("Point");
        xMLStreamWriter.writeStartElement("extrude");
        xMLStreamWriter.writeCharacters(KMLExportUtil.kmlBoolean(this.isLineEnabled()));
        xMLStreamWriter.writeEndElement();
        String string4 = KMLExportUtil.kmlAltitudeMode(this.getAltitudeMode());
        xMLStreamWriter.writeStartElement("altitudeMode");
        xMLStreamWriter.writeCharacters(string4);
        xMLStreamWriter.writeEndElement();
        String string5 = String.format(Locale.US, "%f,%f,%f", this.position.getLongitude().getDegrees(), this.position.getLatitude().getDegrees(), this.position.getElevation());
        xMLStreamWriter.writeStartElement("coordinates");
        xMLStreamWriter.writeCharacters(string5);
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.flush();
        if (bl) {
            xMLStreamWriter.close();
        }
    }

    private void exportAttributesAsKML(XMLStreamWriter xMLStreamWriter, String string, PointPlacemarkAttributes pointPlacemarkAttributes) throws XMLStreamException, IOException {
        if (pointPlacemarkAttributes != null) {
            xMLStreamWriter.writeStartElement("Pair");
            xMLStreamWriter.writeStartElement("key");
            xMLStreamWriter.writeCharacters(string);
            xMLStreamWriter.writeEndElement();
            pointPlacemarkAttributes.export("application/vnd.google-earth.kml+xml", xMLStreamWriter);
            xMLStreamWriter.writeEndElement();
        }
    }

    static {
        defaultAttributes.setImageAddress(PointPlacemarkAttributes.DEFAULT_IMAGE_PATH);
        defaultAttributes.setImageOffset(PointPlacemarkAttributes.DEFAULT_IMAGE_OFFSET);
        defaultAttributes.setLabelOffset(PointPlacemarkAttributes.DEFAULT_LABEL_OFFSET);
        defaultAttributes.setScale(PointPlacemarkAttributes.DEFAULT_IMAGE_SCALE);
        defaultAttributes.setLabelScale(PointPlacemarkAttributes.DEFAULT_LABEL_SCALE);
    }
}

