/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.AbstractBrowserBalloon;
import gov.nasa.worldwind.render.BalloonAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.GlobeBalloon;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.media.opengl.GL;

public class GlobeBrowserBalloon
extends AbstractBrowserBalloon
implements GlobeBalloon {
    protected Position position;
    protected int altitudeMode;
    protected Vec4 placePoint;
    protected Vec4 screenPlacePoint;

    public GlobeBrowserBalloon(String string, Position position) {
        super(string);
        if (position == null) {
            String string2 = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.position = position;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.position = position;
    }

    @Override
    public int getAltitudeMode() {
        return this.altitudeMode;
    }

    @Override
    public void setAltitudeMode(int n) {
        this.altitudeMode = n;
    }

    @Override
    protected void computeBalloonPoints(DrawContext drawContext) {
        this.placePoint = null;
        this.screenPlacePoint = null;
        this.screenOffset = null;
        this.screenRect = null;
        this.screenExtent = null;
        this.screenPickExtent = null;
        this.webViewRect = null;
        this.eyeDistance = 0.0;
        if (this.altitudeMode == 1) {
            this.placePoint = drawContext.computeTerrainPoint(this.position.getLatitude(), this.position.getLongitude(), 0.0);
        } else if (this.altitudeMode == 2) {
            this.placePoint = drawContext.computeTerrainPoint(this.position.getLatitude(), this.position.getLongitude(), this.position.getAltitude());
        } else {
            double d = this.position.getElevation() * drawContext.getVerticalExaggeration();
            this.placePoint = drawContext.getGlobe().computePointFromPosition(this.position.getLatitude(), this.position.getLongitude(), d);
        }
        if (this.placePoint == null) {
            return;
        }
        BalloonAttributes balloonAttributes = this.getActiveAttributes();
        Dimension dimension = this.computeSize(drawContext, balloonAttributes);
        this.screenPlacePoint = drawContext.getView().project(this.placePoint);
        this.screenOffset = this.computeOffset(drawContext, balloonAttributes, dimension.width, dimension.height);
        this.screenRect = new Rectangle((int)(this.screenPlacePoint.x - (double)this.screenOffset.x), (int)(this.screenPlacePoint.y - (double)this.screenOffset.y), dimension.width, dimension.height);
        this.screenExtent = new Rectangle(this.screenRect);
        this.screenExtent.add(this.screenPlacePoint.x, this.screenPlacePoint.y);
        this.screenPickExtent = this.computeFramePickRect(this.screenExtent);
        this.webViewRect = this.computeWebViewRectForFrameRect(balloonAttributes, this.screenRect);
        this.eyeDistance = this.isAlwaysOnTop() ? 0.0 : drawContext.getView().getEyePoint().distanceTo3(this.placePoint);
    }

    @Override
    protected void setupDepthTest(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        if (!this.isAlwaysOnTop() && this.screenPlacePoint != null && drawContext.getView().getEyePosition().getElevation() < drawContext.getGlobe().getMaxElevation() * drawContext.getVerticalExaggeration()) {
            gL.glEnable(2929);
            gL.glDepthMask(false);
            double d = this.screenPlacePoint.z - 0.00391006472;
            d = d < 0.0 ? 0.0 : (d > 1.0 ? 1.0 : d);
            gL.glDepthFunc(513);
            gL.glDepthRange(d, d);
        } else {
            gL.glDisable(2929);
        }
    }

    @Override
    protected boolean intersectsFrustum(DrawContext drawContext) {
        View view = drawContext.getView();
        Frustum frustum = view.getFrustumInModelCoordinates();
        if (this.placePoint != null && (frustum.getNear().distanceTo(this.placePoint) < 0.0 || frustum.getFar().distanceTo(this.placePoint) < 0.0)) {
            return false;
        }
        return super.intersectsFrustum(drawContext);
    }

    @Override
    protected PickedObject createPickedObject(DrawContext drawContext, Color color) {
        PickedObject pickedObject = super.createPickedObject(drawContext, color);
        pickedObject.setPosition(this.position);
        return pickedObject;
    }
}

