/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.AbstractAnnotationLayout;
import gov.nasa.worldwind.render.Annotation;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Iterator;
import javax.media.opengl.GL2;

public class AnnotationFlowLayout
extends AbstractAnnotationLayout {
    private String orientation;
    private String alignment;
    private int hgap;
    private int vgap;

    public AnnotationFlowLayout(String string, String string2, int n, int n2) {
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.AlignmentIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.orientation = string;
        this.alignment = string2;
        this.hgap = n;
        this.vgap = n2;
    }

    public AnnotationFlowLayout(String string, int n, int n2) {
        this(string, null, n, n2);
    }

    protected static String getDefaultAlignment(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.OrientationIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == "gov.nasa.worldwind.avkey.Horizontal") {
            return "gov.nasa.worldwind.avkey.Bottom";
        }
        if (string == "gov.nasa.worldwind.avkey.Vertical") {
            return "gov.nasa.worldwind.avkey.Left";
        }
        return null;
    }

    public AnnotationFlowLayout(String string) {
        this(string, 0, 0);
    }

    public AnnotationFlowLayout() {
        this("gov.nasa.worldwind.avkey.Horizontal");
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.OrientationIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.orientation = string;
    }

    public String getAlignment() {
        return this.alignment;
    }

    public void setAlignment(String string) {
        this.alignment = string;
    }

    public int getHorizontalGap() {
        return this.hgap;
    }

    public void setHorizontalGap(int n) {
        this.hgap = n;
    }

    public int getVerticalGap() {
        return this.vgap;
    }

    public void setVerticalGap(int n) {
        this.vgap = n;
    }

    @Override
    public Dimension getPreferredSize(DrawContext drawContext, Iterable<? extends Annotation> iterable) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.orientation == "gov.nasa.worldwind.avkey.Horizontal") {
            return this.horizontalPreferredSize(drawContext, iterable);
        }
        if (this.orientation == "gov.nasa.worldwind.avkey.Vertical") {
            return this.verticalPerferredSize(drawContext, iterable);
        }
        return null;
    }

    @Override
    public void drawAnnotations(DrawContext drawContext, Rectangle rectangle, Iterable<? extends Annotation> iterable, double d, Position position) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rectangle == null) {
            String string = Logging.getMessage("nullValue.RectangleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.orientation == "gov.nasa.worldwind.avkey.Horizontal") {
            this.drawHorizontal(drawContext, rectangle, iterable, d, position);
        } else if (this.orientation == "gov.nasa.worldwind.avkey.Vertical") {
            this.drawVertical(drawContext, rectangle, iterable, d, position);
        }
    }

    @Override
    public void beginDrawAnnotations(DrawContext drawContext, Rectangle rectangle) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rectangle == null) {
            String string = Logging.getMessage("nullValue.RectangleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        super.beginDrawAnnotations(drawContext, rectangle);
        if (this.orientation == "gov.nasa.worldwind.avkey.Horizontal") {
            this.beginHorizontal(drawContext, rectangle);
        } else if (this.orientation == "gov.nasa.worldwind.avkey.Vertical") {
            this.beginVertical(drawContext, rectangle);
        }
    }

    protected Dimension horizontalPreferredSize(DrawContext drawContext, Iterable<? extends Annotation> iterable) {
        int n = 0;
        int n2 = 0;
        Iterator<? extends Annotation> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return new Dimension(n, n2);
        }
        while (iterator.hasNext()) {
            Annotation annotation = iterator.next();
            Dimension dimension = this.getAnnotationSize(drawContext, annotation);
            if (dimension == null) continue;
            n += dimension.width;
            if (n2 < dimension.height) {
                n2 = dimension.height;
            }
            if (!iterator.hasNext()) continue;
            n += this.hgap;
        }
        return new Dimension(n, n2);
    }

    protected Dimension verticalPerferredSize(DrawContext drawContext, Iterable<? extends Annotation> iterable) {
        int n = 0;
        int n2 = 0;
        Iterator<? extends Annotation> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return new Dimension(n, n2);
        }
        while (iterator.hasNext()) {
            Annotation annotation = iterator.next();
            Dimension dimension = this.getAnnotationSize(drawContext, annotation);
            if (dimension == null) continue;
            n2 += dimension.height;
            if (n < dimension.width) {
                n = dimension.width;
            }
            if (!iterator.hasNext()) continue;
            n2 += this.vgap;
        }
        return new Dimension(n, n2);
    }

    protected void drawHorizontal(DrawContext drawContext, Rectangle rectangle, Iterable<? extends Annotation> iterable, double d, Position position) {
        String string = this.getAlignment();
        if (string == null) {
            string = AnnotationFlowLayout.getDefaultAlignment("gov.nasa.worldwind.avkey.Horizontal");
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        for (Annotation annotation : iterable) {
            Dimension dimension = annotation.getPreferredSize(drawContext);
            oGLStackHandler.pushModelview(gL2);
            this.alignHorizontal(drawContext, rectangle, dimension, string);
            this.drawAnnotation(drawContext, annotation, dimension.width, dimension.height, d, position);
            oGLStackHandler.pop(gL2);
            gL2.glTranslated((double)dimension.width, 0.0, 0.0);
            gL2.glTranslated((double)this.hgap, 0.0, 0.0);
        }
    }

    protected void drawVertical(DrawContext drawContext, Rectangle rectangle, Iterable<? extends Annotation> iterable, double d, Position position) {
        String string = this.getAlignment();
        if (string == null) {
            string = AnnotationFlowLayout.getDefaultAlignment("gov.nasa.worldwind.avkey.Vertical");
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        for (Annotation annotation : iterable) {
            Dimension dimension = annotation.getPreferredSize(drawContext);
            gL2.glTranslated(0.0, (double)(-dimension.height), 0.0);
            oGLStackHandler.pushModelview(gL2);
            this.alignVertical(drawContext, rectangle, dimension, string);
            this.drawAnnotation(drawContext, annotation, dimension.width, dimension.height, d, position);
            oGLStackHandler.pop(gL2);
            gL2.glTranslated(0.0, (double)(-this.vgap), 0.0);
        }
    }

    protected void alignHorizontal(DrawContext drawContext, Rectangle rectangle, Dimension dimension, String string) {
        GL2 gL2 = drawContext.getGL().getGL2();
        if (string != "gov.nasa.worldwind.avkey.Bottom") {
            if (string == "gov.nasa.worldwind.avkey.Top") {
                int n = rectangle.height - dimension.height;
                gL2.glTranslated(0.0, (double)n, 0.0);
            } else if (string == "gov.nasa.worldwind.avkey.Center") {
                int n = rectangle.height / 2 - dimension.height / 2;
                gL2.glTranslated(0.0, (double)n, 0.0);
            }
        }
    }

    protected void alignVertical(DrawContext drawContext, Rectangle rectangle, Dimension dimension, String string) {
        GL2 gL2 = drawContext.getGL().getGL2();
        if (string == "gov.nasa.worldwind.avkey.Left") {
            // empty if block
        }
        if (string == "gov.nasa.worldwind.avkey.Right") {
            int n = rectangle.width - dimension.width;
            gL2.glTranslated((double)n, 0.0, 0.0);
        } else if (string == "gov.nasa.worldwind.avkey.Center") {
            int n = rectangle.width / 2 - dimension.width / 2;
            gL2.glTranslated((double)n, 0.0, 0.0);
        }
    }

    protected void beginHorizontal(DrawContext drawContext, Rectangle rectangle) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glTranslated(rectangle.getMinX(), rectangle.getMinY(), 0.0);
    }

    protected void beginVertical(DrawContext drawContext, Rectangle rectangle) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glTranslated(rectangle.getMinX(), rectangle.getMaxY(), 0.0);
    }
}

