/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.wms;

import gov.nasa.worldwind.ogc.OGCServiceInformation;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class WMSServiceInformation
extends OGCServiceInformation {
    protected QName MAX_WIDTH;
    protected QName MAX_HEIGHT;
    protected QName LAYER_LIMIT;
    protected int maxWidth;
    protected int maxHeight;
    protected int layerLimit;

    public WMSServiceInformation(String string) {
        super(string);
        this.initialize();
    }

    private void initialize() {
        this.MAX_WIDTH = new QName(this.getNamespaceURI(), "MaxWidth");
        this.MAX_HEIGHT = new QName(this.getNamespaceURI(), "MaxHeight");
        this.LAYER_LIMIT = new QName(this.getNamespaceURI(), "LayerLimit");
    }

    @Override
    protected void doParseEventContent(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (xMLEventParserContext.isStartElement(xMLEvent, this.MAX_WIDTH)) {
            Double d = xMLEventParserContext.getDoubleParser().parseDouble(xMLEventParserContext, xMLEvent, new Object[0]);
            if (d != null) {
                this.maxWidth = d.intValue();
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.MAX_HEIGHT)) {
            Double d = xMLEventParserContext.getDoubleParser().parseDouble(xMLEventParserContext, xMLEvent, new Object[0]);
            if (d != null) {
                this.maxHeight = d.intValue();
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.LAYER_LIMIT)) {
            Double d = xMLEventParserContext.getDoubleParser().parseDouble(xMLEventParserContext, xMLEvent, new Object[0]);
            if (d != null) {
                this.layerLimit = d.intValue();
            }
        } else {
            super.doParseEventContent(xMLEventParserContext, xMLEvent, objectArray);
        }
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    protected void setMaxWidth(int n) {
        this.maxWidth = n;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    protected void setMaxHeight(int n) {
        this.maxHeight = n;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("Max width = ").append(this.getMaxWidth());
        stringBuilder.append(" Max height = ").append(this.getMaxHeight()).append("\n");
        return stringBuilder.toString();
    }
}

