/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.wms;

import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.ogc.OGCBoundingBox;
import gov.nasa.worldwind.ogc.wms.WMSAuthorityURL;
import gov.nasa.worldwind.ogc.wms.WMSCapabilityInformation;
import gov.nasa.worldwind.ogc.wms.WMSLayerAttribution;
import gov.nasa.worldwind.ogc.wms.WMSLayerDimension;
import gov.nasa.worldwind.ogc.wms.WMSLayerExtent;
import gov.nasa.worldwind.ogc.wms.WMSLayerIdentifier;
import gov.nasa.worldwind.ogc.wms.WMSLayerInfoURL;
import gov.nasa.worldwind.ogc.wms.WMSLayerStyle;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.StringSetXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public class WMSLayerCapabilities
extends AbstractXMLEventParser {
    protected QName ABSTRACT;
    protected QName ATTRIBUTION;
    protected QName AUTHORITY_URL;
    protected QName BOUNDING_BOX;
    protected QName CRS;
    protected QName DATA_URL;
    protected QName DIMENSION;
    protected QName EXTENT;
    protected QName EXTREME_ELEVATIONS;
    protected QName FEATURE_LIST_URL;
    protected QName GEOGRAPHIC_BOUNDING_BOX;
    protected QName IDENTIFIER;
    protected QName KEYWORD_LIST;
    protected QName KEYWORD;
    protected QName LAST_UPDATE;
    protected QName LAT_LON_BOUNDING_BOX;
    protected QName LAYER;
    protected QName MAX_SCALE_DENOMINATOR;
    protected QName METADATA_URL;
    protected QName MIN_SCALE_DENOMINATOR;
    protected QName NAME;
    protected QName SCALE_HINT;
    protected QName SRS;
    protected QName STYLE;
    protected QName TITLE;
    protected Set<WMSLayerAttribution> attributions;
    protected Set<WMSAuthorityURL> authorityURLs;
    protected Set<OGCBoundingBox> boundingBoxes;
    protected Boolean cascaded;
    protected Set<String> crs;
    protected Set<WMSLayerInfoURL> dataURLs;
    protected Set<WMSLayerDimension> dimensions;
    protected Set<WMSLayerExtent> extents;
    protected Double extremeElevationMin;
    protected Double extremeElevationMax;
    protected Set<WMSLayerInfoURL> featureListURLs;
    protected Integer fixedHeight;
    protected Integer fixedWidth;
    protected Sector geographicBoundingBox;
    protected Set<WMSLayerIdentifier> identifiers;
    protected Set<String> keywords;
    protected String lastUpdate;
    protected String layerAbstract;
    protected List<WMSLayerCapabilities> layers;
    protected Double maxScaleDenominator;
    protected Double maxScaleHint;
    protected Set<WMSLayerInfoURL> metadataURLs;
    protected Double minScaleDenominator;
    protected Double minScaleHint;
    protected String name;
    protected Boolean noSubsets;
    protected Boolean opaque;
    protected Boolean queryable;
    protected Set<String> srs;
    protected Set<WMSLayerStyle> styles;
    protected String title;
    protected WMSLayerCapabilities parent;
    protected WMSCapabilityInformation enclosingCapabilityInformation;

    public WMSLayerCapabilities(String string) {
        super(string);
        this.initialize();
    }

    private void initialize() {
        this.ABSTRACT = new QName(this.getNamespaceURI(), "Abstract");
        this.ATTRIBUTION = new QName(this.getNamespaceURI(), "Attribution");
        this.AUTHORITY_URL = new QName(this.getNamespaceURI(), "AuthorityURL");
        this.BOUNDING_BOX = new QName(this.getNamespaceURI(), "BoundingBox");
        this.CRS = new QName(this.getNamespaceURI(), "CRS");
        this.DATA_URL = new QName(this.getNamespaceURI(), "DataURL");
        this.DIMENSION = new QName(this.getNamespaceURI(), "Dimension");
        this.EXTENT = new QName(this.getNamespaceURI(), "Extent");
        this.EXTREME_ELEVATIONS = new QName(this.getNamespaceURI(), "ExtremeElevations");
        this.FEATURE_LIST_URL = new QName(this.getNamespaceURI(), "FeatureListURL");
        this.GEOGRAPHIC_BOUNDING_BOX = new QName(this.getNamespaceURI(), "EX_GeographicBoundingBox");
        this.IDENTIFIER = new QName(this.getNamespaceURI(), "Identifier");
        this.KEYWORD_LIST = new QName(this.getNamespaceURI(), "KeywordList");
        this.KEYWORD = new QName(this.getNamespaceURI(), "Keyword");
        this.LAST_UPDATE = new QName(this.getNamespaceURI(), "LastUpdate");
        this.LAT_LON_BOUNDING_BOX = new QName(this.getNamespaceURI(), "LatLonBoundingBox");
        this.LAYER = new QName(this.getNamespaceURI(), "Layer");
        this.MAX_SCALE_DENOMINATOR = new QName(this.getNamespaceURI(), "MaxScaleDenominator");
        this.METADATA_URL = new QName(this.getNamespaceURI(), "MetadataURL");
        this.MIN_SCALE_DENOMINATOR = new QName(this.getNamespaceURI(), "MinScaleDenominator");
        this.NAME = new QName(this.getNamespaceURI(), "Name");
        this.SCALE_HINT = new QName(this.getNamespaceURI(), "ScaleHint");
        this.SRS = new QName(this.getNamespaceURI(), "SRS");
        this.STYLE = new QName(this.getNamespaceURI(), "Style");
        this.TITLE = new QName(this.getNamespaceURI(), "Title");
    }

    @Override
    public XMLEventParser allocate(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent) {
        AbstractXMLEventParser abstractXMLEventParser = null;
        XMLEventParser xMLEventParser = super.allocate(xMLEventParserContext, xMLEvent);
        if (xMLEventParser != null) {
            return xMLEventParser;
        }
        if (xMLEventParserContext.isStartElement(xMLEvent, this.LAYER)) {
            abstractXMLEventParser = new WMSLayerCapabilities(this.getNamespaceURI());
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.STYLE)) {
            abstractXMLEventParser = new WMSLayerStyle(this.getNamespaceURI());
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.KEYWORD_LIST)) {
            abstractXMLEventParser = new StringSetXMLEventParser(this.getNamespaceURI(), this.KEYWORD);
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.BOUNDING_BOX)) {
            abstractXMLEventParser = new OGCBoundingBox(this.getNamespaceURI());
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.ATTRIBUTION)) {
            abstractXMLEventParser = new WMSLayerAttribution(this.getNamespaceURI());
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.IDENTIFIER)) {
            abstractXMLEventParser = new WMSLayerIdentifier(this.getNamespaceURI());
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.DIMENSION)) {
            abstractXMLEventParser = new WMSLayerDimension(this.getNamespaceURI());
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.EXTENT)) {
            abstractXMLEventParser = new WMSLayerExtent(this.getNamespaceURI());
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.AUTHORITY_URL)) {
            abstractXMLEventParser = new WMSAuthorityURL(this.getNamespaceURI());
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.DATA_URL)) {
            abstractXMLEventParser = new WMSLayerInfoURL(this.getNamespaceURI());
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.FEATURE_LIST_URL)) {
            abstractXMLEventParser = new WMSLayerInfoURL(this.getNamespaceURI());
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.METADATA_URL)) {
            abstractXMLEventParser = new WMSLayerInfoURL(this.getNamespaceURI());
        }
        return xMLEventParserContext.allocate(xMLEvent, abstractXMLEventParser);
    }

    public boolean isLeaf() {
        return this.getLayers().size() == 0;
    }

    public void setEnclosingCapabilityInformation(WMSCapabilityInformation wMSCapabilityInformation) {
        this.enclosingCapabilityInformation = wMSCapabilityInformation;
        for (WMSLayerCapabilities wMSLayerCapabilities : this.getLayers()) {
            wMSLayerCapabilities.setEnclosingCapabilityInformation(wMSCapabilityInformation);
        }
    }

    public WMSCapabilityInformation getEnclosingCapabilityInformation() {
        return this.enclosingCapabilityInformation;
    }

    public void resolveAttributes(WMSLayerCapabilities wMSLayerCapabilities) {
        this.parent = wMSLayerCapabilities;
        if (this.getCascaded() == null) {
            this.setCascaded(this.parent != null ? this.parent.getCascaded() : false);
        }
        if (this.queryable == null) {
            this.setQueryable(this.parent != null ? this.parent.isQueryable() : false);
        }
        if (this.noSubsets == null) {
            this.setNoSubsets(this.parent != null ? this.parent.isNoSubsets() : false);
        }
        if (this.opaque == null) {
            this.setOpaque(this.parent != null ? this.parent.isOpaque() : false);
        }
        if (this.getFixedWidth() == null) {
            this.setFixedWidth(this.parent != null ? this.parent.getFixedWidth() : 0);
        }
        if (this.getFixedHeight() == null) {
            this.setFixedHeight(this.parent != null ? this.parent.getFixedHeight() : 0);
        }
        if (this.parent != null) {
            if (this.getGeographicBoundingBox() == null) {
                this.setGeographicBoundingBox(this.parent.getGeographicBoundingBox());
            }
            if (this.getMinScaleDenominator() == null) {
                this.setMinScaleDenominator(this.parent.getMinScaleDenominator());
            }
            if (this.getMaxScaleDenominator() == null) {
                this.setMaxScaleDenominator(this.parent.getMaxScaleDenominator());
            }
            if (this.getExtremeElevationMin() == null) {
                this.setExtremeElevationMin(this.parent.getExtremeElevationMin());
            }
            if (this.getExtremeElevationMax() == null) {
                this.setExtremeElevationMax(this.parent.getExtremeElevationMax());
            }
            this.addStyles(this.parent.getStyles());
            this.addCRS(this.parent.getCRS());
            this.addAuthorityURLs(this.parent.getAuthorityURLs());
            this.addBoundingBoxes(this.parent.getBoundingBoxes());
            this.addDimensions(this.parent.getDimensions());
            this.addAttributions(this.parent.getAttributions());
        }
        for (WMSLayerCapabilities wMSLayerCapabilities2 : this.getLayers()) {
            wMSLayerCapabilities2.resolveAttributes(this);
        }
    }

    @Override
    protected void doParseEventContent(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        Object object;
        XMLEventParser xMLEventParser;
        if (xMLEventParserContext.isStartElement(xMLEvent, this.LAYER)) {
            Object object2;
            XMLEventParser xMLEventParser2 = this.allocate(xMLEventParserContext, xMLEvent);
            if (xMLEventParser2 != null && (object2 = xMLEventParser2.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object2 instanceof WMSLayerCapabilities) {
                this.addLayer((WMSLayerCapabilities)object2);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.TITLE)) {
            String string = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]);
            if (!WWUtil.isEmpty(string)) {
                this.setTitle(string);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.NAME)) {
            String string = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]);
            if (!WWUtil.isEmpty(string)) {
                this.setName(string);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.STYLE)) {
            Object object3;
            XMLEventParser xMLEventParser3 = this.allocate(xMLEventParserContext, xMLEvent);
            if (xMLEventParser3 != null && (object3 = xMLEventParser3.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object3 instanceof WMSLayerStyle) {
                this.addStyle((WMSLayerStyle)object3);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.SRS)) {
            String string = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]);
            if (!WWUtil.isEmpty(string)) {
                this.addSRS(string);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.CRS)) {
            String string = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]);
            if (!WWUtil.isEmpty(string)) {
                this.addCRS(string);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.GEOGRAPHIC_BOUNDING_BOX)) {
            this.parseGeographicBoundingBox(xMLEventParserContext, xMLEvent);
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.LAT_LON_BOUNDING_BOX)) {
            this.parseGeographicBoundingBoxV111(xMLEventParserContext, xMLEvent);
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.ABSTRACT)) {
            String string = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]);
            if (!WWUtil.isEmpty(string)) {
                this.setLayerAbstract(string);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.LAST_UPDATE)) {
            String string = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]);
            if (!WWUtil.isEmpty(string)) {
                this.setLastUpdate(string);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.MAX_SCALE_DENOMINATOR)) {
            Double d = xMLEventParserContext.getDoubleParser().parseDouble(xMLEventParserContext, xMLEvent, new Object[0]);
            if (d != null) {
                this.setMaxScaleDenominator(d);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.MIN_SCALE_DENOMINATOR)) {
            Double d = xMLEventParserContext.getDoubleParser().parseDouble(xMLEventParserContext, xMLEvent, new Object[0]);
            if (d != null) {
                this.setMinScaleDenominator(d);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.EXTREME_ELEVATIONS)) {
            this.parseExtremeElevations(xMLEventParserContext, xMLEvent);
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.SCALE_HINT)) {
            this.parseScaleHint(xMLEventParserContext, xMLEvent);
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.BOUNDING_BOX)) {
            Object object4;
            XMLEventParser xMLEventParser4 = this.allocate(xMLEventParserContext, xMLEvent);
            if (xMLEventParser4 != null && (object4 = xMLEventParser4.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object4 instanceof OGCBoundingBox) {
                this.addBoundingBox((OGCBoundingBox)object4);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.ATTRIBUTION)) {
            Object object5;
            XMLEventParser xMLEventParser5 = this.allocate(xMLEventParserContext, xMLEvent);
            if (xMLEventParser5 != null && (object5 = xMLEventParser5.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object5 instanceof WMSLayerAttribution) {
                this.addAttribution((WMSLayerAttribution)object5);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.KEYWORD_LIST)) {
            Object object6;
            XMLEventParser xMLEventParser6 = this.allocate(xMLEventParserContext, xMLEvent);
            if (xMLEventParser6 != null && (object6 = xMLEventParser6.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object6 instanceof StringSetXMLEventParser) {
                this.setKeywords(((StringSetXMLEventParser)object6).getStrings());
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.IDENTIFIER)) {
            Object object7;
            XMLEventParser xMLEventParser7 = this.allocate(xMLEventParserContext, xMLEvent);
            if (xMLEventParser7 != null && (object7 = xMLEventParser7.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object7 instanceof WMSLayerIdentifier) {
                this.addIdentifer((WMSLayerIdentifier)object7);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.DIMENSION)) {
            Object object8;
            XMLEventParser xMLEventParser8 = this.allocate(xMLEventParserContext, xMLEvent);
            if (xMLEventParser8 != null && (object8 = xMLEventParser8.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object8 instanceof WMSLayerDimension) {
                this.addDimension((WMSLayerDimension)object8);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.EXTENT)) {
            Object object9;
            XMLEventParser xMLEventParser9 = this.allocate(xMLEventParserContext, xMLEvent);
            if (xMLEventParser9 != null && (object9 = xMLEventParser9.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object9 instanceof WMSLayerExtent) {
                this.addExtent((WMSLayerExtent)object9);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.AUTHORITY_URL)) {
            Object object10;
            XMLEventParser xMLEventParser10 = this.allocate(xMLEventParserContext, xMLEvent);
            if (xMLEventParser10 != null && (object10 = xMLEventParser10.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object10 instanceof WMSAuthorityURL) {
                this.addAuthorityURL((WMSAuthorityURL)object10);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.DATA_URL)) {
            Object object11;
            XMLEventParser xMLEventParser11 = this.allocate(xMLEventParserContext, xMLEvent);
            if (xMLEventParser11 != null && (object11 = xMLEventParser11.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object11 instanceof WMSLayerInfoURL) {
                this.addDataURL((WMSLayerInfoURL)object11);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.FEATURE_LIST_URL)) {
            Object object12;
            XMLEventParser xMLEventParser12 = this.allocate(xMLEventParserContext, xMLEvent);
            if (xMLEventParser12 != null && (object12 = xMLEventParser12.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object12 instanceof WMSLayerInfoURL) {
                this.addFeatureListURL((WMSLayerInfoURL)object12);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.METADATA_URL) && (xMLEventParser = this.allocate(xMLEventParserContext, xMLEvent)) != null && (object = xMLEventParser.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object instanceof WMSLayerInfoURL) {
            this.addMetadataURL((WMSLayerInfoURL)object);
        }
    }

    @Override
    protected void doParseEventAttributes(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) {
        Iterator<Attribute> iterator = xMLEvent.asStartElement().getAttributes();
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            Comparable<Boolean> comparable;
            Attribute attribute = iterator.next();
            if (attribute.getName().getLocalPart().equals("queryable") && attribute.getValue() != null) {
                comparable = this.parseBooleanLayerAttribute(attribute.getValue());
                if (comparable == null) continue;
                this.setQueryable((Boolean)comparable);
                continue;
            }
            if (attribute.getName().getLocalPart().equals("cascaded") && attribute.getValue() != null) {
                comparable = this.parseBooleanLayerAttribute(attribute.getValue());
                if (comparable == null) continue;
                this.setCascaded((Boolean)comparable);
                continue;
            }
            if (attribute.getName().getLocalPart().equals("opaque") && attribute.getValue() != null) {
                comparable = this.parseBooleanLayerAttribute(attribute.getValue());
                if (comparable == null) continue;
                this.setOpaque((Boolean)comparable);
                continue;
            }
            if (attribute.getName().getLocalPart().equals("noSubsets") && attribute.getValue() != null) {
                comparable = this.parseBooleanLayerAttribute(attribute.getValue());
                if (comparable == null) continue;
                this.setNoSubsets((Boolean)comparable);
                continue;
            }
            if (attribute.getName().getLocalPart().equals("fixedWidth") && attribute.getValue() != null) {
                comparable = WWUtil.convertStringToDouble(attribute.getValue());
                if (comparable == null) continue;
                this.setFixedWidth(((Double)comparable).intValue());
                continue;
            }
            if (!attribute.getName().getLocalPart().equals("fixedHeight") || attribute.getValue() == null || (comparable = WWUtil.convertStringToDouble(attribute.getValue())) == null) continue;
            this.setFixedHeight(((Double)comparable).intValue());
        }
    }

    protected Boolean parseBooleanLayerAttribute(String string) {
        if (WWUtil.isEmpty(string)) {
            return false;
        }
        if (string.equalsIgnoreCase("false")) {
            return false;
        }
        if (string.equalsIgnoreCase("true")) {
            return true;
        }
        Boolean bl = WWUtil.convertStringToBoolean(string);
        return bl != null && bl != false;
    }

    protected void parseExtremeElevations(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent) {
        Iterator<Attribute> iterator = xMLEvent.asStartElement().getAttributes();
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            Double d;
            Attribute attribute = iterator.next();
            if (attribute.getName().getLocalPart().equals("min") && attribute.getValue() != null) {
                d = WWUtil.convertStringToDouble(attribute.getValue());
                if (d == null) continue;
                this.setExtremeElevationMin(d);
                continue;
            }
            if (!attribute.getName().getLocalPart().equals("max") || attribute.getValue() == null || (d = WWUtil.convertStringToDouble(attribute.getValue())) == null) continue;
            this.setExtremeElevationMax(d);
        }
    }

    protected void parseGeographicBoundingBox(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent) throws XMLStreamException {
        Double d = null;
        Double d2 = null;
        Double d3 = null;
        Double d4 = null;
        XMLEvent xMLEvent2 = xMLEventParserContext.nextEvent();
        while (xMLEvent2 != null) {
            if (xMLEventParserContext.isEndElement(xMLEvent2, xMLEvent)) {
                if (d != null && d2 != null && d3 != null && d4 != null) {
                    this.setGeographicBoundingBox(Sector.fromDegrees(d, d3, d2, d4));
                }
                return;
            }
            if (xMLEvent2.isStartElement()) {
                Double d5;
                if (xMLEvent2.asStartElement().getName().getLocalPart().equals("westBoundLongitude")) {
                    d5 = xMLEventParserContext.getDoubleParser().parseDouble(xMLEventParserContext, xMLEvent2, new Object[0]);
                    if (d5 != null) {
                        d2 = d5;
                    }
                } else if (xMLEvent2.asStartElement().getName().getLocalPart().equals("eastBoundLongitude")) {
                    d5 = xMLEventParserContext.getDoubleParser().parseDouble(xMLEventParserContext, xMLEvent2, new Object[0]);
                    if (d5 != null) {
                        d4 = d5;
                    }
                } else if (xMLEvent2.asStartElement().getName().getLocalPart().equals("southBoundLatitude")) {
                    d5 = xMLEventParserContext.getDoubleParser().parseDouble(xMLEventParserContext, xMLEvent2, new Object[0]);
                    if (d5 != null) {
                        d = d5;
                    }
                } else if (xMLEvent2.asStartElement().getName().getLocalPart().equals("northBoundLatitude") && (d5 = xMLEventParserContext.getDoubleParser().parseDouble(xMLEventParserContext, xMLEvent2, new Object[0])) != null) {
                    d3 = d5;
                }
            }
            xMLEvent2 = xMLEventParserContext.nextEvent();
        }
    }

    protected void parseGeographicBoundingBoxV111(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent) throws XMLStreamException {
        Double d = null;
        Double d2 = null;
        Double d3 = null;
        Double d4 = null;
        Iterator<Attribute> iterator = xMLEvent.asStartElement().getAttributes();
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            Double d5;
            Attribute attribute = iterator.next();
            if (attribute.getName().getLocalPart().equals("minx") && attribute.getValue() != null) {
                d5 = WWUtil.convertStringToDouble(attribute.getValue());
                if (d5 == null) continue;
                d2 = d5;
                continue;
            }
            if (attribute.getName().getLocalPart().equals("miny") && attribute.getValue() != null) {
                d5 = WWUtil.convertStringToDouble(attribute.getValue());
                if (d5 == null) continue;
                d = d5;
                continue;
            }
            if (attribute.getName().getLocalPart().equals("maxx") && attribute.getValue() != null) {
                d5 = WWUtil.convertStringToDouble(attribute.getValue());
                if (d5 == null) continue;
                d4 = d5;
                continue;
            }
            if (!attribute.getName().getLocalPart().equals("maxy") || attribute.getValue() == null || (d5 = WWUtil.convertStringToDouble(attribute.getValue())) == null) continue;
            d3 = d5;
        }
        if (d != null && d2 != null && d3 != null && d4 != null) {
            this.setGeographicBoundingBox(Sector.fromDegrees(d, d3, d2, d4));
        }
    }

    protected void parseScaleHint(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent) throws XMLStreamException {
        Iterator<Attribute> iterator = xMLEvent.asStartElement().getAttributes();
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            Double d;
            Attribute attribute = iterator.next();
            if (attribute.getName().getLocalPart().equals("min") && attribute.getValue() != null) {
                d = WWUtil.convertStringToDouble(attribute.getValue());
                if (d == null) continue;
                this.setMinScaleHint(d);
                continue;
            }
            if (!attribute.getName().getLocalPart().equals("max") || attribute.getValue() == null || (d = WWUtil.convertStringToDouble(attribute.getValue())) == null) continue;
            this.setMaxScaleHint(d);
        }
    }

    public List<WMSLayerCapabilities> getNamedLayers() {
        ArrayList<WMSLayerCapabilities> arrayList = new ArrayList<WMSLayerCapabilities>();
        if (this.getName() != null) {
            arrayList.add(this);
        }
        for (WMSLayerCapabilities wMSLayerCapabilities : this.getLayers()) {
            arrayList.addAll(wMSLayerCapabilities.getNamedLayers());
        }
        return arrayList;
    }

    public WMSLayerCapabilities getLayerByName(String string) {
        if (WWUtil.isEmpty(string)) {
            return null;
        }
        if (this.getName() != null && this.getName().equals(string)) {
            return this;
        }
        for (WMSLayerCapabilities wMSLayerCapabilities : this.getLayers()) {
            if (wMSLayerCapabilities.getName() == null || !wMSLayerCapabilities.getName().equals(string)) continue;
            return wMSLayerCapabilities;
        }
        return null;
    }

    public WMSLayerStyle getStyleByName(String string) {
        if (WWUtil.isEmpty(string)) {
            return null;
        }
        for (WMSLayerStyle wMSLayerStyle : this.getStyles()) {
            if (!wMSLayerStyle.getName().equals(string)) continue;
            return wMSLayerStyle;
        }
        return null;
    }

    public Double getExtremeElevationMin() {
        return this.extremeElevationMin;
    }

    protected void setExtremeElevationMin(Double d) {
        this.extremeElevationMin = d;
    }

    public Double getExtremeElevationMax() {
        return this.extremeElevationMax;
    }

    protected void setExtremeElevationMax(Double d) {
        this.extremeElevationMax = d;
    }

    public String getLastUpdate() {
        return this.lastUpdate;
    }

    protected void setLastUpdate(String string) {
        this.lastUpdate = string;
    }

    public Double getMinScaleHint() {
        return this.minScaleHint;
    }

    protected void setMinScaleHint(Double d) {
        this.minScaleHint = d;
    }

    public Double getMaxScaleHint() {
        return this.maxScaleHint;
    }

    protected void setMaxScaleHint(Double d) {
        this.maxScaleHint = d;
    }

    public Set<WMSLayerDimension> getDimensions() {
        if (this.dimensions != null) {
            return this.dimensions;
        }
        return Collections.emptySet();
    }

    protected void addDimension(WMSLayerDimension wMSLayerDimension) {
        if (this.dimensions == null) {
            this.dimensions = new HashSet<WMSLayerDimension>();
        }
        this.getDimensions().add(wMSLayerDimension);
    }

    protected void addDimensions(Set<WMSLayerDimension> set) {
        if (set.size() == 0) {
            return;
        }
        for (WMSLayerDimension wMSLayerDimension : set) {
            this.addDimension(wMSLayerDimension);
        }
    }

    protected void setDimensions(Set<WMSLayerDimension> set) {
        this.dimensions = set;
    }

    public Set<WMSLayerExtent> getExtents() {
        if (this.extents != null) {
            return this.extents;
        }
        return Collections.emptySet();
    }

    protected void addExtent(WMSLayerExtent wMSLayerExtent) {
        if (this.extents == null) {
            this.extents = new HashSet<WMSLayerExtent>();
        }
        this.getExtents().add(wMSLayerExtent);
    }

    protected void addExtents(Set<WMSLayerExtent> set) {
        if (set.size() == 0) {
            return;
        }
        for (WMSLayerExtent wMSLayerExtent : set) {
            this.addExtent(wMSLayerExtent);
        }
    }

    public Boolean getCascaded() {
        return this.cascaded;
    }

    protected void setCascaded(Boolean bl) {
        this.cascaded = bl;
    }

    public Integer getFixedHeight() {
        return this.fixedHeight;
    }

    protected void setFixedHeight(Integer n) {
        this.fixedHeight = n;
    }

    public Integer getFixedWidth() {
        return this.fixedWidth;
    }

    protected void setFixedWidth(Integer n) {
        this.fixedWidth = n;
    }

    public Boolean isNoSubsets() {
        return this.noSubsets;
    }

    protected void setNoSubsets(Boolean bl) {
        this.noSubsets = bl;
    }

    public Boolean isOpaque() {
        return this.opaque;
    }

    protected void setOpaque(Boolean bl) {
        this.opaque = bl;
    }

    public Boolean isQueryable() {
        return this.queryable;
    }

    protected void setQueryable(Boolean bl) {
        this.queryable = bl;
    }

    public Set<WMSLayerAttribution> getAttributions() {
        if (this.attributions != null) {
            return this.attributions;
        }
        return Collections.emptySet();
    }

    protected void setAttributions(Set<WMSLayerAttribution> set) {
        this.attributions = set;
    }

    protected void addAttribution(WMSLayerAttribution wMSLayerAttribution) {
        if (this.attributions == null) {
            this.attributions = new HashSet<WMSLayerAttribution>();
        }
        this.getAttributions().add(wMSLayerAttribution);
    }

    protected void addAttributions(Set<WMSLayerAttribution> set) {
        for (WMSLayerAttribution wMSLayerAttribution : set) {
            this.addAttribution(wMSLayerAttribution);
        }
    }

    public Set<WMSAuthorityURL> getAuthorityURLs() {
        if (this.authorityURLs != null) {
            return this.authorityURLs;
        }
        return Collections.emptySet();
    }

    protected void setAuthorityURLs(Set<WMSAuthorityURL> set) {
        this.authorityURLs = set;
    }

    protected void addAuthorityURL(WMSAuthorityURL wMSAuthorityURL) {
        if (this.authorityURLs == null) {
            this.authorityURLs = new HashSet<WMSAuthorityURL>();
        }
        this.getAuthorityURLs().add(wMSAuthorityURL);
    }

    protected void addAuthorityURLs(Set<WMSAuthorityURL> set) {
        for (WMSAuthorityURL wMSAuthorityURL : set) {
            this.addAuthorityURL(wMSAuthorityURL);
        }
    }

    public Set<WMSLayerIdentifier> getIdentifiers() {
        if (this.identifiers != null) {
            return this.identifiers;
        }
        return Collections.emptySet();
    }

    protected void addIdentifer(WMSLayerIdentifier wMSLayerIdentifier) {
        if (this.identifiers == null) {
            this.identifiers = new HashSet<WMSLayerIdentifier>();
        }
        this.getIdentifiers().add(wMSLayerIdentifier);
    }

    protected void addIdentifiers(Set<WMSLayerIdentifier> set) {
        for (WMSLayerIdentifier wMSLayerIdentifier : set) {
            this.addIdentifer(wMSLayerIdentifier);
        }
    }

    public Set<WMSLayerInfoURL> getMetadataURLs() {
        if (this.metadataURLs != null) {
            return this.metadataURLs;
        }
        return Collections.emptySet();
    }

    protected void addMetadataURL(WMSLayerInfoURL wMSLayerInfoURL) {
        if (this.metadataURLs == null) {
            this.metadataURLs = new HashSet<WMSLayerInfoURL>();
        }
        this.getMetadataURLs().add(wMSLayerInfoURL);
    }

    protected void addMetadataURLs(Set<WMSLayerInfoURL> set) {
        for (WMSLayerInfoURL wMSLayerInfoURL : set) {
            this.addMetadataURL(wMSLayerInfoURL);
        }
    }

    public Set<WMSLayerInfoURL> getFeatureListURLs() {
        if (this.featureListURLs != null) {
            return this.featureListURLs;
        }
        return Collections.emptySet();
    }

    protected void addFeatureListURL(WMSLayerInfoURL wMSLayerInfoURL) {
        if (this.featureListURLs == null) {
            this.featureListURLs = new HashSet<WMSLayerInfoURL>();
        }
        this.getFeatureListURLs().add(wMSLayerInfoURL);
    }

    protected void addFeatureListURLs(Set<WMSLayerInfoURL> set) {
        for (WMSLayerInfoURL wMSLayerInfoURL : set) {
            this.addFeatureListURL(wMSLayerInfoURL);
        }
    }

    public Set<WMSLayerInfoURL> getDataURLs() {
        if (this.dataURLs != null) {
            return this.dataURLs;
        }
        return Collections.emptySet();
    }

    protected void addDataURL(WMSLayerInfoURL wMSLayerInfoURL) {
        if (this.dataURLs == null) {
            this.dataURLs = new HashSet<WMSLayerInfoURL>();
        }
        this.getDataURLs().add(wMSLayerInfoURL);
    }

    protected void addDataURLs(Set<WMSLayerInfoURL> set) {
        for (WMSLayerInfoURL wMSLayerInfoURL : set) {
            this.addDataURL(wMSLayerInfoURL);
        }
    }

    public List<WMSLayerCapabilities> getLayers() {
        if (this.layers != null) {
            return this.layers;
        }
        return Collections.emptyList();
    }

    protected void addLayer(WMSLayerCapabilities wMSLayerCapabilities) {
        if (this.layers == null) {
            this.layers = new ArrayList<WMSLayerCapabilities>();
        }
        this.getLayers().add(wMSLayerCapabilities);
    }

    protected void addLayers(Set<WMSLayerCapabilities> set) {
        for (WMSLayerCapabilities wMSLayerCapabilities : set) {
            this.addLayer(wMSLayerCapabilities);
        }
    }

    public Set<WMSLayerStyle> getStyles() {
        if (this.styles != null) {
            return this.styles;
        }
        return Collections.emptySet();
    }

    protected void setStyles(Set<WMSLayerStyle> set) {
        this.styles = set;
    }

    protected void addStyle(WMSLayerStyle wMSLayerStyle) {
        if (this.styles == null) {
            this.styles = new HashSet<WMSLayerStyle>();
        }
        this.getStyles().add(wMSLayerStyle);
    }

    protected void addStyles(Set<WMSLayerStyle> set) {
        for (WMSLayerStyle wMSLayerStyle : set) {
            this.addStyle(wMSLayerStyle);
        }
    }

    public Set<OGCBoundingBox> getBoundingBoxes() {
        if (this.boundingBoxes != null) {
            return this.boundingBoxes;
        }
        return Collections.emptySet();
    }

    protected void setBoundingBoxes(Set<OGCBoundingBox> set) {
        this.boundingBoxes = set;
    }

    protected void addBoundingBox(OGCBoundingBox oGCBoundingBox) {
        if (this.boundingBoxes == null) {
            this.boundingBoxes = new HashSet<OGCBoundingBox>();
        }
        this.getBoundingBoxes().add(oGCBoundingBox);
    }

    protected void addBoundingBoxes(Set<OGCBoundingBox> set) {
        for (OGCBoundingBox oGCBoundingBox : set) {
            this.addBoundingBox(oGCBoundingBox);
        }
    }

    public Sector getGeographicBoundingBox() {
        return this.geographicBoundingBox;
    }

    protected void setGeographicBoundingBox(Sector sector) {
        this.geographicBoundingBox = sector;
    }

    public Set<String> getKeywords() {
        if (this.keywords != null) {
            return this.keywords;
        }
        return Collections.emptySet();
    }

    protected void setKeywords(Set<String> set) {
        this.keywords = set;
    }

    public String getLayerAbstract() {
        return this.layerAbstract;
    }

    protected void setLayerAbstract(String string) {
        this.layerAbstract = string;
    }

    public Double getMaxScaleDenominator() {
        return this.maxScaleDenominator;
    }

    protected void setMaxScaleDenominator(Double d) {
        this.maxScaleDenominator = d;
    }

    public Double getMinScaleDenominator() {
        return this.minScaleDenominator;
    }

    protected void setMinScaleDenominator(Double d) {
        this.minScaleDenominator = d;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String string) {
        this.name = string;
    }

    public String getTitle() {
        return this.title;
    }

    protected void setTitle(String string) {
        this.title = string;
    }

    public Set<String> getSRS() {
        if (this.srs != null) {
            return this.srs;
        }
        return Collections.emptySet();
    }

    protected void setSRS(Set<String> set) {
        this.srs = set;
    }

    protected void addSRS(String string) {
        if (this.srs == null) {
            this.srs = new HashSet<String>();
        }
        this.srs.add(string);
    }

    protected void addSRS(Set<String> set) {
        for (String string : set) {
            this.addSRS(string);
        }
    }

    public Set<String> getCRS() {
        if (this.crs != null) {
            return this.crs;
        }
        return Collections.emptySet();
    }

    protected void setCRS(Set<String> set) {
        this.crs = set;
    }

    protected void addCRS(String string) {
        if (this.crs == null) {
            this.crs = new HashSet<String>();
        }
        this.crs.add(string);
    }

    protected void addCRS(Set<String> set) {
        for (String string : set) {
            this.addCRS(string);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("LAYER ");
        if (!WWUtil.isEmpty(this.getName())) {
            stringBuilder.append(this.getName()).append(": ");
        }
        stringBuilder.append("queryable = ").append(this.isQueryable());
        return stringBuilder.toString();
    }
}

