/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml;

import gov.nasa.worldwind.ogc.kml.KMLAbstractGeometry;
import gov.nasa.worldwind.ogc.kml.KMLAbstractObject;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class KMLMultiGeometry
extends KMLAbstractGeometry {
    protected List<KMLAbstractGeometry> geometries = new ArrayList<KMLAbstractGeometry>();

    public KMLMultiGeometry(String string) {
        super(string);
    }

    @Override
    protected void doAddEventContent(Object object, XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (object instanceof KMLAbstractGeometry) {
            this.addGeometry((KMLAbstractGeometry)object);
        } else {
            super.doAddEventContent(object, xMLEventParserContext, xMLEvent, objectArray);
        }
    }

    protected void addGeometry(KMLAbstractGeometry kMLAbstractGeometry) {
        this.geometries.add(kMLAbstractGeometry);
    }

    public List<KMLAbstractGeometry> getGeometries() {
        return this.geometries;
    }

    @Override
    public void applyChange(KMLAbstractObject kMLAbstractObject) {
        if (!(kMLAbstractObject instanceof KMLMultiGeometry)) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().warning(string);
            throw new IllegalArgumentException(string);
        }
        KMLMultiGeometry kMLMultiGeometry = (KMLMultiGeometry)kMLAbstractObject;
        if (kMLMultiGeometry.getGeometries() != null && kMLMultiGeometry.getGeometries().size() > 0) {
            this.mergeGeometries(kMLMultiGeometry);
        }
        super.applyChange(kMLAbstractObject);
    }

    protected void mergeGeometries(KMLMultiGeometry kMLMultiGeometry) {
        ArrayList arrayList = new ArrayList(this.getGeometries().size());
        Collections.copy(arrayList, this.getGeometries());
        for (KMLAbstractGeometry kMLAbstractGeometry : kMLMultiGeometry.getGeometries()) {
            String string = kMLAbstractGeometry.getId();
            if (!WWUtil.isEmpty(string)) {
                for (KMLAbstractGeometry kMLAbstractGeometry2 : arrayList) {
                    String string2 = kMLAbstractGeometry2.getId();
                    if (WWUtil.isEmpty(string2) || !string2.equals(string)) continue;
                    this.getGeometries().remove(kMLAbstractGeometry2);
                }
            }
            this.getGeometries().add(kMLAbstractGeometry);
        }
    }
}

