/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml;

import gov.nasa.worldwind.event.Message;
import gov.nasa.worldwind.event.MessageListener;
import gov.nasa.worldwind.ogc.kml.KMLRoot;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParser;
import java.util.Map;

public abstract class KMLAbstractObject
extends AbstractXMLEventParser
implements MessageListener {
    public static final String MSG_BOX_CHANGED = "KMLAbstractObject.BoxChanged";
    public static final String MSG_GEOMETRY_CHANGED = "KMLAbstractObject.GeometryChanged";
    public static final String MSG_LINK_CHANGED = "KMLAbstractObject.LinkChanged";
    public static final String MSG_STYLE_CHANGED = "KMLAbstractObject.StyleChanged";
    public static final String MSG_TIME_CHANGED = "KMLAbstractObject.TimeChanged";
    public static final String MSG_VIEW_CHANGED = "KMLAbstractObject.ViewChanged";

    protected KMLAbstractObject() {
    }

    protected KMLAbstractObject(String string) {
        super(string);
    }

    public String getId() {
        return (String)this.getField("id");
    }

    public String getTargetId() {
        return (String)this.getField("targetId");
    }

    @Override
    public KMLRoot getRoot() {
        XMLEventParser xMLEventParser = super.getRoot();
        return xMLEventParser instanceof KMLRoot ? (KMLRoot)xMLEventParser : null;
    }

    @Override
    public void onMessage(Message message) {
    }

    public void onChange(Message message) {
        if (this.getParent() != null) {
            ((KMLAbstractObject)this.getParent()).onChange(message);
        }
    }

    public void applyChange(KMLAbstractObject kMLAbstractObject) {
        if (kMLAbstractObject == null) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().warning(string);
            throw new IllegalArgumentException(string);
        }
        for (Map.Entry<String, Object> entry : kMLAbstractObject.getFields().getEntries()) {
            this.setField(entry.getKey(), entry.getValue());
        }
    }
}

