/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import com.jogamp.opengl.util.awt.TextRenderer;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.PositionEvent;
import gov.nasa.worldwind.event.PositionListener;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLTextRenderer;
import gov.nasa.worldwind.view.orbit.OrbitView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.media.opengl.GL2;

public class TerrainProfileLayer
extends AbstractLayer
implements PositionListener,
SelectListener {
    public static final String UNIT_METRIC = "gov.nasa.worldwind.TerrainProfileLayer.Metric";
    public static final String UNIT_IMPERIAL = "gov.nasa.worldwind.TerrainProfileLayer.Imperial";
    public static final double METER_TO_FEET = 3.280839895;
    public static final String FOLLOW_VIEW = "gov.nasa.worldwind.TerrainProfileLayer.FollowView";
    public static final String FOLLOW_EYE = "gov.nasa.worldwind.TerrainProfileLayer.FollowEye";
    public static final String FOLLOW_CURSOR = "gov.nasa.worldwind.TerrainProfileLayer.FollowCursor";
    public static final String FOLLOW_NONE = "gov.nasa.worldwind.TerrainProfileLayer.FollowNone";
    public static final String FOLLOW_OBJECT = "gov.nasa.worldwind.TerrainProfileLayer.FollowObject";
    public static final String FOLLOW_PATH = "gov.nasa.worldwind.TerrainProfileLayer.FollowPath";
    protected static final int MINIMIZED_SIZE = 32;
    protected final String buttonMinimize = "gov.nasa.worldwind.TerrainProfileLayer.ButtonMinimize";
    protected final String buttonMaximize = "gov.nasa.worldwind.TerrainProfileLayer.ButtonMaximize";
    protected Dimension size = new Dimension(250, 100);
    protected Color color = Color.white;
    protected int borderWidth = 20;
    protected String position = "gov.nasa.worldwind.layers.ViewControlsLayer.SouthWest";
    protected String resizeBehavior = "gov.nasa.worldwind.CompassLayer.ResizeShrinkOnly";
    protected String unit = "gov.nasa.worldwind.TerrainProfileLayer.Metric";
    protected Font defaultFont = Font.decode("Arial-PLAIN-12");
    protected double toViewportScale = 1.0;
    protected Point locationCenter = null;
    protected Vec4 locationOffset = null;
    protected PickSupport pickSupport = new PickSupport();
    protected boolean initialized = false;
    protected boolean isMinimized = false;
    protected boolean isMaximized = false;
    protected boolean showProfileLine = true;
    protected boolean showPickedLine = true;
    protected int pickedSample = -1;
    Polyline selectionShape;
    Polyline pickedShape;
    protected boolean keepProportions = false;
    protected boolean zeroBased = true;
    protected String follow = "gov.nasa.worldwind.TerrainProfileLayer.FollowView";
    protected boolean showEyePosition = false;
    protected double profileLengthFactor = 1.0;
    protected LatLon startLatLon;
    protected LatLon endLatLon;
    protected Position objectPosition;
    protected Angle objectHeading;
    protected ArrayList<? extends LatLon> pathPositions;
    protected int pathType = 0;
    protected int samples = 250;
    protected double minElevation;
    protected double maxElevation;
    protected double length;
    protected Position[] positions;
    protected WorldWindow wwd;
    protected OrderedIcon orderedImage = new OrderedIcon();

    public boolean getIsMinimized() {
        return this.isMinimized;
    }

    public void setIsMinimized(boolean bl) {
        this.isMinimized = bl;
        this.pickedSample = -1;
    }

    public boolean getIsMaximized() {
        return this.isMaximized;
    }

    public void setIsMaximized(boolean bl) {
        this.isMaximized = bl;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension dimension) {
        if (dimension == null) {
            String string = Logging.getMessage("nullValue.DimensionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.size = dimension;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.color = color;
    }

    @Override
    public void setOpacity(double d) {
        super.setOpacity(d);
    }

    @Override
    public double getOpacity() {
        return super.getOpacity();
    }

    public double getToViewportScale() {
        return this.toViewportScale;
    }

    public void setToViewportScale(double d) {
        this.toViewportScale = d;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.position = string;
    }

    public Point getLocationCenter() {
        return this.locationCenter;
    }

    public void setLocationCenter(Point point) {
        this.locationCenter = point;
    }

    public Vec4 getLocationOffset() {
        return this.locationOffset;
    }

    public void setLocationOffset(Vec4 vec4) {
        this.locationOffset = vec4;
    }

    public String getResizeBehavior() {
        return this.resizeBehavior;
    }

    public void setResizeBehavior(String string) {
        this.resizeBehavior = string;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int n) {
        this.borderWidth = n;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String string) {
        this.unit = string;
    }

    public Font getFont() {
        return this.defaultFont;
    }

    public void setFont(Font font) {
        if (font == null) {
            String string = Logging.getMessage("nullValue.FontIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.defaultFont = font;
    }

    public boolean getKeepProportions() {
        return this.keepProportions;
    }

    public void setKeepProportions(boolean bl) {
        this.keepProportions = bl;
    }

    public String getFollow() {
        return this.follow;
    }

    public void setFollow(String string) {
        this.follow = string;
    }

    public boolean getShowEyePosition() {
        return this.showEyePosition;
    }

    public void setShowEyePosition(Boolean bl) {
        this.showEyePosition = bl;
    }

    public void setProfileLengthFactor(double d) {
        this.profileLengthFactor = d;
    }

    public double getProfileLenghtFactor() {
        return this.profileLengthFactor;
    }

    public LatLon getStartLatLon() {
        return this.startLatLon;
    }

    public void setStartLatLon(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.startLatLon = latLon;
    }

    public LatLon getEndLatLon() {
        return this.endLatLon;
    }

    public void setEndLatLon(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.endLatLon = latLon;
    }

    public int getSamples() {
        return this.samples;
    }

    public void setSamples(int n) {
        this.samples = Math.abs(n);
    }

    public boolean getZeroBased() {
        return this.zeroBased;
    }

    public void setZeroBased(boolean bl) {
        this.zeroBased = bl;
    }

    public Position getObjectPosition() {
        return this.objectPosition;
    }

    public void setObjectPosition(Position position) {
        this.objectPosition = position;
    }

    public Angle getObjectHeading() {
        return this.objectHeading;
    }

    public void setObjectHeading(Angle angle) {
        this.objectHeading = angle;
    }

    public List<? extends LatLon> getPathPositions() {
        return this.pathPositions;
    }

    public void setPathPositions(ArrayList<? extends LatLon> arrayList) {
        if (arrayList == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.pathPositions = arrayList;
    }

    public int getPathType() {
        return this.pathType;
    }

    public void setPathType(int n) {
        this.pathType = n;
    }

    public Polyline getProfileLine() {
        return this.selectionShape;
    }

    public Polyline getPickedLine() {
        return this.selectionShape;
    }

    public boolean isShowProfileLine() {
        return this.showProfileLine;
    }

    public void setShowProfileLine(boolean bl) {
        this.showProfileLine = bl;
    }

    public boolean isShowPickedLine() {
        return this.showPickedLine;
    }

    public void setShowPickedLine(boolean bl) {
        this.showPickedLine = bl;
    }

    @Override
    public void doRender(DrawContext drawContext) {
        drawContext.addOrderedRenderable(this.orderedImage);
        if (!this.isMinimized && this.positions != null && this.selectionShape != null) {
            if (this.showProfileLine) {
                this.selectionShape.render(drawContext);
            }
            if (this.showPickedLine && this.pickedSample != -1 && this.pickedShape != null) {
                this.pickedShape.render(drawContext);
            }
        }
    }

    @Override
    public void doPick(DrawContext drawContext, Point point) {
        drawContext.addOrderedRenderable(this.orderedImage);
    }

    protected void initialize(DrawContext drawContext) {
        if (this.initialized || this.positions != null) {
            return;
        }
        if (this.wwd != null) {
            this.computeProfile(drawContext);
        }
        if (this.positions != null) {
            this.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawProfile(DrawContext drawContext) {
        this.computeProfile(drawContext);
        if ((this.positions == null || this.minElevation == 0.0 && this.maxElevation == 0.0) && !this.initialized) {
            this.initialize(drawContext);
        }
        if (this.positions == null || this.minElevation == 0.0 && this.maxElevation == 0.0) {
            return;
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            gL2.glPushAttrib(30977);
            bl = true;
            gL2.glDisable(3553);
            gL2.glEnable(3042);
            gL2.glBlendFunc(770, 771);
            gL2.glDisable(2929);
            Rectangle rectangle = drawContext.getView().getViewport();
            Dimension dimension = this.isMinimized ? new Dimension(32, 32) : (this.isMaximized ? new Dimension(rectangle.width - this.borderWidth * 2, rectangle.height * 2 / 3 - this.borderWidth * 2) : this.size);
            double d = dimension.width;
            double d2 = dimension.height;
            gL2.glMatrixMode(5889);
            gL2.glPushMatrix();
            bl3 = true;
            gL2.glLoadIdentity();
            double d3 = d > d2 ? d : d2;
            gL2.glOrtho(0.0, (double)rectangle.width, 0.0, (double)rectangle.height, -0.6 * d3, 0.6 * d3);
            gL2.glMatrixMode(5888);
            gL2.glPushMatrix();
            bl2 = true;
            gL2.glLoadIdentity();
            double d4 = this.computeScale(rectangle);
            Vec4 vec4 = this.computeLocation(rectangle, d4);
            gL2.glTranslated(vec4.x(), vec4.y(), vec4.z());
            gL2.glScaled(d4, d4, 1.0);
            if (!drawContext.isPickingMode()) {
                this.drawGrid(drawContext, dimension);
                this.drawGraph(drawContext, dimension);
                if (!this.isMinimized) {
                    this.drawGUI(drawContext, dimension);
                    String string = String.format("min %.0fm   max %.0fm", this.minElevation, this.maxElevation);
                    if (this.unit.equals(UNIT_IMPERIAL)) {
                        string = String.format("min %.0fft   max %.0fft", this.minElevation * 3.280839895, this.maxElevation * 3.280839895);
                    }
                    gL2.glLoadIdentity();
                    gL2.glDisable(2884);
                    this.drawLabel(drawContext, string, vec4.add3(new Vec4(0.0, -12.0, 0.0)), -1);
                    if (this.pickedSample != -1) {
                        double d5 = this.positions[this.pickedSample].getElevation();
                        string = String.format("%.0fm", d5);
                        if (this.unit.equals(UNIT_IMPERIAL)) {
                            string = String.format("%.0fft", d5 * 3.280839895);
                        }
                        this.drawLabel(drawContext, string, vec4.add3(new Vec4(d, -12.0, 0.0)), 1);
                    }
                }
            } else {
                this.pickSupport.clearPickList();
                this.pickSupport.beginPicking(drawContext);
                Color color = drawContext.getUniquePickColor();
                int n = color.getRGB();
                if (!this.isMinimized) {
                    this.computePickPosition(drawContext, vec4, new Dimension((int)(d * d4), (int)(d2 * d4)));
                    this.drawGUI(drawContext, dimension);
                } else {
                    this.pickSupport.addPickableObject(n, this);
                    gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
                    gL2.glBegin(9);
                    gL2.glVertex3d(0.0, 0.0, 0.0);
                    gL2.glVertex3d(d, 0.0, 0.0);
                    gL2.glVertex3d(d, d2, 0.0);
                    gL2.glVertex3d(0.0, d2, 0.0);
                    gL2.glVertex3d(0.0, 0.0, 0.0);
                    gL2.glEnd();
                }
                this.pickSupport.endPicking(drawContext);
                this.pickSupport.resolvePick(drawContext, drawContext.getPickPoint(), this);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (bl3) {
                gL2.glMatrixMode(5889);
                gL2.glPopMatrix();
            }
            if (bl2) {
                gL2.glMatrixMode(5888);
                gL2.glPopMatrix();
            }
            if (bl) {
                gL2.glPopAttrib();
            }
        }
    }

    protected void drawGrid(DrawContext drawContext, Dimension dimension) {
        Color color = this.getBackgroundColor(this.color);
        this.drawFilledRectangle(drawContext, new Vec4(0.0, 0.0, 0.0), dimension, new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)((double)color.getAlpha() * 0.5)));
        float[] fArray = this.color.getRGBColorComponents(null);
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glColor4d((double)fArray[0], (double)fArray[1], (double)fArray[2], this.getOpacity());
        this.drawVerticalLine(drawContext, dimension, 0.0);
        this.drawVerticalLine(drawContext, dimension, dimension.getWidth());
        this.drawHorizontalLine(drawContext, dimension, 0.0);
    }

    protected void drawGraph(DrawContext drawContext, Dimension dimension) {
        double d;
        double d2;
        int n;
        GL2 gL2 = drawContext.getGL().getGL2();
        double d3 = this.minElevation;
        double d4 = this.maxElevation;
        if (this.showEyePosition && this.follow.equals(FOLLOW_EYE)) {
            d4 = Math.max(d4, drawContext.getView().getEyePosition().getElevation());
        }
        if (this.showEyePosition && (this.follow.equals(FOLLOW_OBJECT) || this.follow.equals(FOLLOW_PATH)) && this.objectPosition != null) {
            d4 = Math.max(d4, this.objectPosition.getElevation());
        }
        if (this.zeroBased) {
            if (d3 > 0.0) {
                d3 = 0.0;
            }
            if (d4 < 0.0) {
                d4 = 0.0;
            }
        }
        double d5 = dimension.getWidth() / this.length;
        double d6 = dimension.getHeight() / (d4 - d3);
        if (this.keepProportions) {
            d6 = d5 = Math.min(d5, d6);
        }
        double d7 = this.length / (double)(this.samples - 1);
        double d8 = 0.0;
        gL2.glColor4ub((byte)this.color.getRed(), (byte)this.color.getGreen(), (byte)this.color.getBlue(), (byte)100);
        gL2.glBegin(5);
        for (n = 0; n < this.samples; ++n) {
            d8 = (double)n * d7 * d5;
            d2 = (this.positions[n].getElevation() - d3) * d6;
            gL2.glVertex3d(d8, 0.0, 0.0);
            gL2.glVertex3d(d8, d2, 0.0);
        }
        gL2.glEnd();
        float[] fArray = this.color.getRGBColorComponents(null);
        gL2.glColor4d((double)fArray[0], (double)fArray[1], (double)fArray[2], this.getOpacity());
        gL2.glBegin(3);
        for (n = 0; n < this.samples; ++n) {
            d8 = (double)n * d7 * d5;
            d2 = (this.positions[n].getElevation() - d3) * d6;
            gL2.glVertex3d(d8, d2, 0.0);
        }
        gL2.glEnd();
        gL2.glColor4d((double)fArray[0], (double)fArray[1], (double)fArray[2], this.getOpacity() * 0.3);
        if (!this.follow.equals(FOLLOW_PATH)) {
            this.drawVerticalLine(drawContext, dimension, d8 / 2.0);
        }
        double d9 = -1.0;
        double d10 = -1.0;
        if ((this.follow.equals(FOLLOW_EYE) || this.follow.equals(FOLLOW_OBJECT) && this.objectPosition != null || this.follow.equals(FOLLOW_PATH) && this.objectPosition != null) && this.showEyePosition) {
            d9 = d8 / 2.0;
            d10 = (drawContext.getView().getEyePosition().getElevation() - d3) * d6;
            if (this.follow.equals(FOLLOW_PATH)) {
                d9 = (double)this.computeObjectSample(this.objectPosition) * d7 * d5;
            }
            if (this.follow.equals(FOLLOW_OBJECT) || this.follow.equals(FOLLOW_PATH)) {
                d10 = (this.objectPosition.getElevation() - d3) * d6;
            }
            if (d9 >= 0.0 && d10 >= 0.0) {
                this.drawFilledRectangle(drawContext, new Vec4(d9 - 2.0, d10 - 2.0, 0.0), new Dimension(5, 5), this.color);
            }
            if (this.follow.equals(FOLLOW_PATH) && d9 >= 0.0) {
                this.drawVerticalLine(drawContext, dimension, d9);
            }
        }
        if (this.pickedSample != -1) {
            d = (double)this.pickedSample * d7 * d5;
            double d11 = (this.positions[this.pickedSample].getElevation() - d3) * d6;
            gL2.glColor4d((double)fArray[0], (double)fArray[1], (double)fArray[2] * 0.5, this.getOpacity() * 0.8);
            this.drawVerticalLine(drawContext, dimension, d);
            this.drawHorizontalLine(drawContext, dimension, d11);
            if (d9 >= 0.0 && d10 >= 0.0) {
                this.drawLine(drawContext, d, d11, d9, d10);
                double d12 = drawContext.getView().getEyePoint().distanceTo3(drawContext.getGlobe().computePointFromPosition(this.positions[this.pickedSample]));
                if (this.follow.equals(FOLLOW_OBJECT) || this.follow.equals(FOLLOW_PATH)) {
                    d12 = drawContext.getGlobe().computePointFromPosition(this.objectPosition).distanceTo3(drawContext.getGlobe().computePointFromPosition(this.positions[this.pickedSample]));
                }
                String string = String.format("Dist %.0fm", d12);
                if (this.unit.equals(UNIT_IMPERIAL)) {
                    string = String.format("Dist %.0fft", d12 * 3.280839895);
                }
                this.drawLabel(drawContext, string, new Vec4(d + 5.0, d11 - 12.0, 0.0), -1);
            }
        }
        if (this.minElevation != d3) {
            d2 = (this.minElevation - d3) * d6;
            gL2.glColor4d((double)fArray[0], (double)fArray[1], (double)fArray[2], this.getOpacity() * 0.5);
            this.drawHorizontalLine(drawContext, dimension, d2);
        }
        if (this.maxElevation != d4) {
            d2 = (this.maxElevation - d3) * d6;
            gL2.glColor4d((double)fArray[0], (double)fArray[1], (double)fArray[2], this.getOpacity() * 0.5);
            this.drawHorizontalLine(drawContext, dimension, d2);
        }
        if (d3 < 0.0 && d4 >= 0.0) {
            gL2.glColor4d((double)fArray[0] * 0.7, (double)fArray[1] * 0.7, (double)fArray[2], this.getOpacity() * 0.5);
            d2 = -this.minElevation * d6;
            d = -1.0;
            for (n = 0; n < this.samples; ++n) {
                d8 = (double)n * d7 * d5;
                if (this.positions[n].getElevation() > 0.0 || n == this.samples - 1) {
                    if (!(d >= 0.0)) continue;
                    gL2.glBegin(3);
                    gL2.glVertex3d(d, d2, 0.0);
                    gL2.glVertex3d(d8, d2, 0.0);
                    gL2.glEnd();
                    d = -1.0;
                    continue;
                }
                d = d < 0.0 ? d8 : d;
            }
        }
    }

    protected void drawGUI(DrawContext drawContext, Dimension dimension) {
        int n;
        Color color;
        Object object;
        GL2 gL2 = drawContext.getGL().getGL2();
        int n2 = 16;
        int n3 = n2 / 2;
        int n4 = 4;
        Dimension dimension2 = new Dimension(n2, n2);
        Color color2 = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), (int)((double)this.color.getAlpha() * 0.5));
        Color color3 = this.getBackgroundColor(this.color);
        color3 = new Color(color3.getRed(), color3.getGreen(), color3.getBlue(), (int)((double)color3.getAlpha() * 0.5));
        int n5 = dimension.height - dimension2.height - n4;
        int n6 = dimension.width;
        Object object2 = object = drawContext.getPickedObjects() != null ? drawContext.getPickedObjects().getTopObject() : null;
        if (!this.isMaximized) {
            n6 -= dimension2.width + n4;
            if (drawContext.isPickingMode()) {
                color = drawContext.getUniquePickColor();
                n = color.getRGB();
                this.pickSupport.addPickableObject(n, this.buttonMaximize, null, false);
            } else {
                color = this.buttonMaximize == object ? color2 : color3;
            }
            this.drawFilledRectangle(drawContext, new Vec4(n6, n5, 0.0), dimension2, color);
            if (!drawContext.isPickingMode()) {
                gL2.glColor4ub((byte)this.color.getRed(), (byte)this.color.getGreen(), (byte)this.color.getBlue(), (byte)this.color.getAlpha());
                this.drawLine(drawContext, n6 + 3, n5 + n3, n6 + dimension2.width - 3, n5 + n3);
                this.drawLine(drawContext, n6 + n3, n5 + 3, n6 + n3, n5 + dimension2.height - 3);
            }
        }
        n6 -= dimension2.width + n4;
        if (drawContext.isPickingMode()) {
            color = drawContext.getUniquePickColor();
            n = color.getRGB();
            this.pickSupport.addPickableObject(n, this.buttonMinimize, null, false);
        } else {
            color = this.buttonMinimize == object ? color2 : color3;
        }
        this.drawFilledRectangle(drawContext, new Vec4(n6, n5, 0.0), dimension2, color);
        if (!drawContext.isPickingMode()) {
            gL2.glColor4ub((byte)this.color.getRed(), (byte)this.color.getGreen(), (byte)this.color.getBlue(), (byte)this.color.getAlpha());
            this.drawLine(drawContext, n6 + 3, n5 + n3, n6 + dimension2.width - 3, n5 + n3);
        }
    }

    protected void drawHorizontalLine(DrawContext drawContext, Dimension dimension, double d) {
        this.drawLine(drawContext, 0.0, d, dimension.getWidth(), d);
    }

    protected void drawVerticalLine(DrawContext drawContext, Dimension dimension, double d) {
        this.drawLine(drawContext, d, 0.0, d, dimension.getHeight());
    }

    protected void drawFilledRectangle(DrawContext drawContext, Vec4 vec4, Dimension dimension, Color color) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glColor4ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue(), (byte)color.getAlpha());
        gL2.glDisable(3553);
        gL2.glBegin(9);
        gL2.glVertex3d(vec4.x, vec4.y, 0.0);
        gL2.glVertex3d(vec4.x + dimension.getWidth(), vec4.y, 0.0);
        gL2.glVertex3d(vec4.x + dimension.getWidth(), vec4.y + dimension.getHeight(), 0.0);
        gL2.glVertex3d(vec4.x, vec4.y + dimension.getHeight(), 0.0);
        gL2.glVertex3d(vec4.x, vec4.y, 0.0);
        gL2.glEnd();
    }

    protected void drawLine(DrawContext drawContext, double d, double d2, double d3, double d4) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glBegin(3);
        gL2.glVertex3d(d, d2, 0.0);
        gL2.glVertex3d(d3, d4, 0.0);
        gL2.glEnd();
    }

    protected void drawLabel(DrawContext drawContext, String string, Vec4 vec4, int n) {
        TextRenderer textRenderer = OGLTextRenderer.getOrCreateTextRenderer(drawContext.getTextRendererCache(), this.defaultFont);
        Rectangle2D rectangle2D = textRenderer.getBounds(string);
        int n2 = (int)vec4.x();
        if (n == 0) {
            n2 = (int)(vec4.x() - rectangle2D.getWidth() / 2.0);
        }
        if (n > 0) {
            n2 = (int)(vec4.x() - rectangle2D.getWidth());
        }
        int n3 = (int)vec4.y();
        textRenderer.begin3DRendering();
        textRenderer.setColor(this.getBackgroundColor(this.color));
        textRenderer.draw(string, n2 + 1, n3 - 1);
        textRenderer.setColor(this.color);
        textRenderer.draw(string, n2, n3);
        textRenderer.end3DRendering();
    }

    protected Color getBackgroundColor(Color color) {
        float[] fArray = new float[4];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        if ((double)fArray[2] > 0.5) {
            return new Color(0, 0, 0, (int)((float)this.color.getAlpha() * 0.7f));
        }
        return new Color(255, 255, 255, (int)((float)this.color.getAlpha() * 0.7f));
    }

    protected double computeScale(Rectangle rectangle) {
        if (this.resizeBehavior.equals("gov.nasa.worldwind.CompassLayer.ResizeShrinkOnly")) {
            return Math.min(1.0, this.toViewportScale * (double)rectangle.width / (double)this.size.width);
        }
        if (this.resizeBehavior.equals("gov.nasa.worldwind.CompassLayer.ResizeStretch")) {
            return this.toViewportScale * (double)rectangle.width / (double)this.size.width;
        }
        if (this.resizeBehavior.equals("gov.nasa.worldwind.CompassLayer.ResizeKeepFixedSize")) {
            return 1.0;
        }
        return 1.0;
    }

    protected Vec4 computeLocation(Rectangle rectangle, double d) {
        double d2;
        double d3;
        double d4 = d * (double)(this.isMinimized ? 32 : (this.isMaximized ? rectangle.width - this.borderWidth * 2 : this.size.width));
        double d5 = d * (double)(this.isMinimized ? 32 : (this.isMaximized ? rectangle.height * 2 / 3 - this.borderWidth * 2 : this.size.height));
        if (this.locationCenter != null) {
            d3 = (double)this.locationCenter.x - d4 / 2.0;
            d2 = (double)this.locationCenter.y - d5 / 2.0;
        } else if (this.position.equals("gov.nasa.worldwind.layers.ViewControlsLayer.NorthEast")) {
            d3 = rectangle.getWidth() - d4 - (double)this.borderWidth;
            d2 = rectangle.getHeight() - d5 - (double)this.borderWidth;
        } else if (this.position.equals("gov.nasa.worldwind.layers.ViewControlsLayer.SouthEast")) {
            d3 = rectangle.getWidth() - d4 - (double)this.borderWidth;
            d2 = 0.0 + (double)this.borderWidth;
        } else if (this.position.equals("gov.nasa.worldwind.layers.ViewControlsLayer.NorthWest")) {
            d3 = 0.0 + (double)this.borderWidth;
            d2 = rectangle.getHeight() - d5 - (double)this.borderWidth;
        } else if (this.position.equals("gov.nasa.worldwind.layers.ViewControlsLayer.SouthWest")) {
            d3 = 0.0 + (double)this.borderWidth;
            d2 = 0.0 + (double)this.borderWidth;
        } else {
            d3 = rectangle.getWidth() - d4 / 2.0 - (double)this.borderWidth;
            d2 = rectangle.getHeight() - d5 / 2.0 - (double)this.borderWidth;
        }
        if (this.locationOffset != null) {
            d3 += this.locationOffset.x;
            d2 += this.locationOffset.y;
        }
        return new Vec4(d3, d2, 0.0);
    }

    protected Position computePickPosition(DrawContext drawContext, Vec4 vec4, Dimension dimension) {
        Position position = null;
        this.pickedSample = -1;
        Point point = drawContext.getPickPoint();
        if (point != null && this.positions != null && !this.follow.equals(FOLLOW_CURSOR)) {
            int n;
            Rectangle rectangle = drawContext.getView().getViewport();
            if (point.getX() >= vec4.getX() && point.getX() < vec4.getX() + (double)dimension.width && (double)rectangle.height - point.getY() >= vec4.getY() && (double)rectangle.height - point.getY() < vec4.getY() + (double)dimension.height && (n = (int)((point.getX() - vec4.getX()) / (double)dimension.width * (double)this.samples)) >= 0 && n < this.samples) {
                position = this.positions[n];
                this.pickedSample = n;
                ArrayList<Position> arrayList = new ArrayList<Position>();
                arrayList.add(this.positions[n]);
                arrayList.add(new Position(this.positions[n].getLatitude(), this.positions[n].getLongitude(), this.positions[n].getElevation() + this.length / 10.0));
                if (this.pickedShape == null) {
                    this.pickedShape = new Polyline(arrayList);
                    this.pickedShape.setPathType(1);
                    this.pickedShape.setLineWidth(2.0);
                    this.pickedShape.setColor(new Color(this.color.getRed(), this.color.getGreen(), (int)((double)this.color.getBlue() * 0.8), 204));
                } else {
                    this.pickedShape.setPositions(arrayList);
                }
            }
        }
        return position;
    }

    protected int computeObjectSample(LatLon latLon) {
        double d;
        if (this.pathPositions.size() < 2) {
            return -1;
        }
        double d2 = this.wwd.getModel().getGlobe().getRadius();
        double d3 = 1000.0;
        double d4 = 0.0;
        int n = 0;
        LatLon latLon2 = this.pathPositions.get(n);
        for (int i = 1; i < this.pathPositions.size(); ++i) {
            LatLon latLon3 = this.pathPositions.get(i);
            double d5 = LatLon.greatCircleDistance((LatLon)latLon2, (LatLon)latLon3).radians * d2;
            Vec4 vec4 = new Vec4(latLon.getLatitude().radians, latLon.getLongitude().radians, 0.0, 0.0);
            Vec4 vec42 = new Vec4(latLon2.getLatitude().radians, latLon2.getLongitude().radians, 0.0, 0.0);
            Vec4 vec43 = new Vec4(latLon3.getLatitude().radians, latLon3.getLongitude().radians, 0.0, 0.0);
            Line line = new Line(vec42, vec43.subtract3(vec42));
            if (line.distanceTo(vec4) * d2 <= d3) {
                double d6 = LatLon.greatCircleDistance((LatLon)latLon2, (LatLon)latLon).radians * d2;
                double d7 = LatLon.greatCircleDistance((LatLon)latLon3, (LatLon)latLon).radians * d2;
                if (d6 <= d5 && d7 <= d5) {
                    d4 += d6 / (d6 + d7) * d5;
                    break;
                }
                d4 += d5;
            } else {
                d4 += d5;
            }
            latLon2 = latLon3;
        }
        return d4 < (d = this.computePathLength()) ? (int)(d4 / d * (double)this.samples) : -1;
    }

    @Override
    public void moved(PositionEvent positionEvent) {
        this.positions = null;
    }

    @Override
    public void selected(SelectEvent selectEvent) {
        if (selectEvent.hasObjects() && selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftClick")) {
            if (selectEvent.getMouseEvent() != null && selectEvent.getMouseEvent().isConsumed()) {
                return;
            }
            Object object = selectEvent.getTopObject();
            if (object == this.buttonMinimize) {
                if (this.isMaximized) {
                    this.setIsMaximized(false);
                } else {
                    this.setIsMinimized(true);
                }
            } else if (object == this.buttonMaximize) {
                this.setIsMaximized(true);
            } else if (object == this && this.isMinimized) {
                this.setIsMinimized(false);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.positions = null;
    }

    public void setEventSource(WorldWindow worldWindow) {
        if (this.wwd != null) {
            this.wwd.removePositionListener(this);
            this.wwd.getView().removePropertyChangeListener(this);
            this.wwd.removeSelectListener(this);
        }
        this.wwd = worldWindow;
        if (this.wwd != null) {
            this.wwd.addPositionListener(this);
            this.wwd.getView().addPropertyChangeListener(this);
            this.wwd.addSelectListener(this);
        }
    }

    protected void computeProfile(DrawContext drawContext) {
        if (this.wwd == null) {
            return;
        }
        try {
            View view = this.wwd.getView();
            Position position = null;
            if (this.follow.equals(FOLLOW_VIEW)) {
                position = this.computeViewCenterPosition(drawContext);
            } else if (this.follow.equals(FOLLOW_CURSOR)) {
                position = this.computeCursorPosition(drawContext);
            } else if (this.follow.equals(FOLLOW_EYE)) {
                position = view.getEyePosition();
            } else if (this.follow.equals(FOLLOW_OBJECT)) {
                position = this.objectPosition;
            }
            if (this.follow.equals(FOLLOW_VIEW) && position != null || this.follow.equals(FOLLOW_EYE) && position != null || this.follow.equals(FOLLOW_CURSOR) && position != null || this.follow.equals(FOLLOW_NONE) && this.startLatLon != null && this.endLatLon != null || this.follow.equals(FOLLOW_OBJECT) && this.objectPosition != null && this.objectHeading != null || this.follow.equals(FOLLOW_PATH) && this.pathPositions != null && this.pathPositions.size() >= 2) {
                this.positions = new Position[this.samples];
                this.minElevation = Double.MAX_VALUE;
                this.maxElevation = -1.7976931348623157E308;
                if (this.follow.equals(FOLLOW_PATH)) {
                    this.computePathPositions();
                } else {
                    this.computeMirroredPositions(position);
                }
                if (this.selectionShape == null) {
                    this.selectionShape = new Polyline(Arrays.asList(this.positions));
                    this.selectionShape.setLineWidth(2.0);
                    this.selectionShape.setFollowTerrain(true);
                    this.selectionShape.setColor(new Color(this.color.getRed(), this.color.getGreen(), (int)((double)this.color.getBlue() * 0.5), 204));
                } else {
                    this.selectionShape.setPositions(Arrays.asList(this.positions));
                }
            } else {
                this.positions = null;
            }
        }
        catch (Exception exception) {
            this.positions = null;
        }
    }

    protected Position computeViewCenterPosition(DrawContext drawContext) {
        View view = drawContext.getView();
        Line line = view.computeRayFromScreenPoint(view.getViewport().getWidth() / 2.0, view.getViewport().getHeight() / 2.0);
        Intersection[] intersectionArray = drawContext.getSurfaceGeometry().intersect(line);
        if (intersectionArray.length > 0) {
            return drawContext.getGlobe().computePositionFromPoint(intersectionArray[0].getIntersectionPoint());
        }
        return null;
    }

    protected void computeMirroredPositions(LatLon latLon) {
        View view = this.wwd.getView();
        this.length = view instanceof OrbitView ? Math.min(((OrbitView)view).getZoom() * 0.8 * this.profileLengthFactor, this.wwd.getModel().getGlobe().getRadius() * Math.PI) : Math.min(Math.abs(view.getEyePosition().getElevation()) * 0.8 * this.profileLengthFactor, this.wwd.getModel().getGlobe().getRadius() * Math.PI);
        if (this.follow.equals(FOLLOW_NONE)) {
            this.length = LatLon.greatCircleDistance((LatLon)this.startLatLon, (LatLon)this.endLatLon).radians * this.wwd.getModel().getGlobe().getRadius();
        } else if (this.follow.equals(FOLLOW_OBJECT)) {
            this.length = Math.min(Math.abs(this.objectPosition.getElevation()) * 0.8 * this.profileLengthFactor, this.wwd.getModel().getGlobe().getRadius() * Math.PI);
        }
        double d = this.length / this.wwd.getModel().getGlobe().getRadius();
        double d2 = d / (double)(this.samples - 1);
        for (int i = 0; i < this.samples; ++i) {
            LatLon latLon2 = null;
            if (!this.follow.equals(FOLLOW_NONE)) {
                double d3 = view.getHeading().subtract((Angle)Angle.POS90).radians;
                if (this.follow.equals(FOLLOW_OBJECT)) {
                    d3 = this.objectHeading.subtract((Angle)Angle.POS90).radians;
                }
                if ((float)i > (float)(this.samples - 1) / 2.0f) {
                    d3 += Math.PI;
                }
                double d4 = Math.abs(((double)i - (double)(this.samples - 1) / 2.0) * d2);
                latLon2 = LatLon.greatCircleEndPosition(latLon, d3, d4);
            } else if (this.follow.equals(FOLLOW_NONE) && this.startLatLon != null && this.endLatLon != null) {
                latLon2 = LatLon.interpolate((double)i / (double)(this.samples - 1), this.startLatLon, this.endLatLon);
            }
            this.setPosition(i, latLon2);
        }
    }

    protected void computePathPositions() {
        this.length = this.computePathLength();
        double d = this.length / this.wwd.getModel().getGlobe().getRadius();
        double d2 = d / (double)(this.samples - 1);
        int n = 0;
        LatLon latLon = this.pathPositions.get(n);
        this.setPosition(0, latLon);
        for (int i = 1; i < this.samples - 1; ++i) {
            double d3 = d2;
            while (d3 > 0.0) {
                double d4 = this.pathType == 2 ? LatLon.rhumbDistance((LatLon)latLon, (LatLon)this.pathPositions.get((int)(n + 1))).radians : LatLon.greatCircleDistance((LatLon)latLon, (LatLon)this.pathPositions.get((int)(n + 1))).radians;
                if (d4 >= d3) {
                    double d5;
                    if (this.pathType == 2) {
                        d5 = LatLon.rhumbAzimuth((LatLon)latLon, (LatLon)this.pathPositions.get((int)(n + 1))).radians;
                        latLon = LatLon.rhumbEndPosition(latLon, d5, d3);
                    } else {
                        d5 = LatLon.greatCircleAzimuth((LatLon)latLon, (LatLon)this.pathPositions.get((int)(n + 1))).radians;
                        latLon = LatLon.greatCircleEndPosition(latLon, d5, d3);
                    }
                    this.setPosition(i, latLon);
                    d3 = 0.0;
                    continue;
                }
                latLon = this.pathPositions.get(++n);
                d3 -= d4;
            }
        }
        this.setPosition(this.samples - 1, this.pathPositions.get(this.pathPositions.size() - 1));
    }

    protected double computePathLength() {
        double d = 0.0;
        LatLon latLon = null;
        for (LatLon latLon2 : this.pathPositions) {
            if (latLon != null) {
                d += LatLon.greatCircleDistance((LatLon)latLon, (LatLon)latLon2).radians;
            }
            latLon = latLon2;
        }
        return d * this.wwd.getModel().getGlobe().getRadius();
    }

    protected void setPosition(int n, LatLon latLon) {
        Double d = this.wwd.getModel().getGlobe().getElevation(latLon.getLatitude(), latLon.getLongitude());
        this.minElevation = d < this.minElevation ? d : this.minElevation;
        this.maxElevation = d > this.maxElevation ? d : this.maxElevation;
        this.positions[n] = new Position(latLon, d);
    }

    protected Position computeCursorPosition(DrawContext drawContext) {
        Position position = this.wwd.getCurrentPosition();
        if (position == null && drawContext.getPickPoint() != null) {
            Line line = drawContext.getView().computeRayFromScreenPoint(drawContext.getPickPoint().x, drawContext.getPickPoint().y);
            Intersection[] intersectionArray = drawContext.getSurfaceGeometry().intersect(line);
            if (intersectionArray != null && intersectionArray.length > 0) {
                position = drawContext.getGlobe().computePositionFromPoint(intersectionArray[0].getIntersectionPoint());
            }
        }
        if (position == null && drawContext.getPickPoint() != null) {
            position = drawContext.getView().computePositionFromScreenPoint(drawContext.getPickPoint().x, drawContext.getPickPoint().y);
        }
        return position;
    }

    @Override
    public String toString() {
        return Logging.getMessage("layers.Earth.TerrainProfileLayer.Name");
    }

    protected class OrderedIcon
    implements OrderedRenderable {
        protected OrderedIcon() {
        }

        @Override
        public double getDistanceFromEye() {
            return 0.0;
        }

        @Override
        public void pick(DrawContext drawContext, Point point) {
            TerrainProfileLayer.this.drawProfile(drawContext);
        }

        @Override
        public void render(DrawContext drawContext) {
            TerrainProfileLayer.this.drawProfile(drawContext);
        }
    }
}

