/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import com.jogamp.opengl.util.texture.TextureData;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.FileStore;
import gov.nasa.worldwind.event.BulkRetrievalListener;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.formats.dds.DDSCompressor;
import gov.nasa.worldwind.formats.dds.DXTCompressionAttributes;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.BasicTiledImageLayerBulkDownloader;
import gov.nasa.worldwind.layers.TextureTile;
import gov.nasa.worldwind.layers.TiledImageLayer;
import gov.nasa.worldwind.ogc.wms.WMSCapabilities;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ScreenCredit;
import gov.nasa.worldwind.retrieve.AbstractRetrievalPostProcessor;
import gov.nasa.worldwind.retrieve.BulkRetrievable;
import gov.nasa.worldwind.retrieve.BulkRetrievalThread;
import gov.nasa.worldwind.retrieve.Retriever;
import gov.nasa.worldwind.retrieve.RetrieverFactory;
import gov.nasa.worldwind.retrieve.URLRetriever;
import gov.nasa.worldwind.util.DataConfigurationUtils;
import gov.nasa.worldwind.util.LevelSet;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLUtil;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.SessionCacheUtils;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWXML;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BasicTiledImageLayer
extends TiledImageLayer
implements BulkRetrievable {
    protected final Object fileLock = new Object();
    protected static final int RESOURCE_ID_OGC_CAPABILITIES = 1;

    public BasicTiledImageLayer(LevelSet levelSet) {
        super(levelSet);
    }

    public BasicTiledImageLayer(AVList aVList) {
        this(new LevelSet(aVList));
        ScreenCredit screenCredit;
        Object object;
        Boolean bl;
        Double d;
        String[] stringArray;
        String string = aVList.getStringValue("gov.nasa.worldwind.avkey.DisplayName");
        if (string != null) {
            this.setName(string);
        }
        if ((stringArray = (String[])aVList.getValue("gov.nasa.worldwind.avkey.AvailableImageFormats")) != null && stringArray.length > 0) {
            this.setAvailableImageFormats(stringArray);
        }
        if ((string = aVList.getStringValue("gov.nasa.worldwind.avkey.TextureFormat")) != null) {
            this.setTextureFormat(string);
        }
        if ((d = (Double)aVList.getValue("gov.nasa.worldwind.avkey.Opacity")) != null) {
            this.setOpacity(d);
        }
        if ((d = (Double)aVList.getValue("gov.nasa.worldwind.avkey.MaxActiveAltitude")) != null) {
            this.setMaxActiveAltitude(d);
        }
        if ((d = (Double)aVList.getValue("gov.nasa.worldwind.avkey.MinActiveAltitude")) != null) {
            this.setMinActiveAltitude(d);
        }
        if ((d = (Double)aVList.getValue("gov.nasa.worldwind.avkey.MapScale")) != null) {
            this.setValue("gov.nasa.worldwind.avkey.MapScale", d);
        }
        if ((d = (Double)aVList.getValue("gov.nasa.worldwind.avkey.DetailHint")) != null) {
            this.setDetailHint(d);
        }
        if ((bl = (Boolean)aVList.getValue("gov.nasa.worldwind.avkey.ForceLevelZeroLoads")) != null) {
            this.setForceLevelZeroLoads(bl);
        }
        if ((bl = (Boolean)aVList.getValue("gov.nasa.worldwind.avkey.RetainLevelZeroTiles")) != null) {
            this.setRetainLevelZeroTiles(bl);
        }
        if ((bl = (Boolean)aVList.getValue("gov.nasa.worldwind.avkey.NetworkRetrievalEnabled")) != null) {
            this.setNetworkRetrievalEnabled(bl);
        }
        if ((bl = (Boolean)aVList.getValue("gov.nasa.worldwind.avkey.UseMipMaps")) != null) {
            this.setUseMipMaps(bl);
        }
        if ((bl = (Boolean)aVList.getValue("gov.nasa.worldwind.avkey.UseTransparentTextures")) != null) {
            this.setUseTransparentTextures(bl);
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.URLConnectTimeout")) != null) {
            this.setValue("gov.nasa.worldwind.avkey.URLConnectTimeout", object);
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.URLReadTimeout")) != null) {
            this.setValue("gov.nasa.worldwind.avkey.URLReadTimeout", object);
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.RetrievalStaleRequestLimit")) != null) {
            this.setValue("gov.nasa.worldwind.avkey.RetrievalStaleRequestLimit", object);
        }
        if ((screenCredit = (ScreenCredit)aVList.getValue("gov.nasa.worldwind.avkey.ScreenCredit")) != null) {
            this.setScreenCredit(screenCredit);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.TransparencyColors") != null) {
            this.setValue("gov.nasa.worldwind.avkey.TransparencyColors", aVList.getValue("gov.nasa.worldwind.avkey.TransparencyColors"));
        }
        this.setValue("gov.nasa.worldwind.avkey.ConstructionParameters", aVList.copy());
        if (this.isRetrieveResources()) {
            this.startResourceRetrieval();
        }
    }

    public BasicTiledImageLayer(Document document, AVList aVList) {
        this(document.getDocumentElement(), aVList);
    }

    public BasicTiledImageLayer(Element element, AVList aVList) {
        this(BasicTiledImageLayer.getParamsFromDocument(element, aVList));
    }

    public BasicTiledImageLayer(String string) {
        this(BasicTiledImageLayer.restorableStateToParams(string));
        RestorableSupport restorableSupport;
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string2 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2, exception);
        }
        this.doRestoreState(restorableSupport, null);
    }

    protected static AVList getParamsFromDocument(Element element, AVList aVList) {
        if (element == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        BasicTiledImageLayer.getTiledImageLayerConfigParams(element, aVList);
        BasicTiledImageLayer.setFallbacks(aVList);
        return aVList;
    }

    protected static void setFallbacks(AVList aVList) {
        if (aVList.getValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta") == null) {
            Angle angle = Angle.fromDegrees(36.0);
            aVList.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", new LatLon(angle, angle));
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.TileWidthKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileWidthKey", 512);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.TileHeightKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileHeightKey", 512);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.FormatSuffixKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", ".dds");
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.NumLevels") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.NumLevels", 19);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.NumEmptyLevels") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", 0);
        }
    }

    @Override
    protected void forceTextureLoad(TextureTile textureTile) {
        URL uRL = this.getDataFileStore().findFile(textureTile.getPath(), true);
        if (uRL != null && !this.isTextureFileExpired(textureTile, uRL, this.getDataFileStore())) {
            this.loadTexture(textureTile, uRL);
        }
    }

    @Override
    protected void requestTexture(DrawContext drawContext, TextureTile textureTile) {
        Vec4 vec4 = textureTile.getCentroidPoint(drawContext.getGlobe());
        Vec4 vec42 = this.getReferencePoint(drawContext);
        if (vec42 != null) {
            textureTile.setPriority(vec4.distanceTo3(vec42));
        }
        RequestTask requestTask = this.createRequestTask(textureTile);
        this.getRequestQ().add(requestTask);
    }

    protected RequestTask createRequestTask(TextureTile textureTile) {
        return new RequestTask(textureTile, this);
    }

    protected boolean isTextureFileExpired(TextureTile textureTile, URL uRL, FileStore fileStore) {
        if (!WWIO.isFileOutOfDate(uRL, textureTile.getLevel().getExpiryTime())) {
            return false;
        }
        fileStore.removeFile(uRL);
        String string = Logging.getMessage("generic.DataFileExpired", uRL);
        Logging.logger().fine(string);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadTexture(TextureTile textureTile, URL uRL) {
        TextureData textureData;
        Object object = this.fileLock;
        synchronized (object) {
            textureData = this.readTexture(uRL, this.getTextureFormat(), this.isUseMipMaps());
        }
        if (textureData == null) {
            return false;
        }
        textureTile.setTextureData(textureData);
        if (textureTile.getLevelNumber() != 0 || !this.isRetainLevelZeroTiles()) {
            this.addTileToCache(textureTile);
        }
        return true;
    }

    protected TextureData readTexture(URL uRL, String string, boolean bl) {
        try {
            if ("image/dds".equalsIgnoreCase(string) && !uRL.toString().toLowerCase().endsWith("dds")) {
                DXTCompressionAttributes dXTCompressionAttributes = DDSCompressor.getDefaultCompressionAttributes();
                dXTCompressionAttributes.setBuildMipmaps(bl);
                ByteBuffer byteBuffer = DDSCompressor.compressImageURL(uRL, dXTCompressionAttributes);
                return OGLUtil.newTextureData(Configuration.getMaxCompatibleGLProfile(), WWIO.getInputStreamFromByteBuffer(byteBuffer), bl);
            }
            return OGLUtil.newTextureData(Configuration.getMaxCompatibleGLProfile(), uRL, bl);
        }
        catch (Exception exception) {
            String string2 = Logging.getMessage("layers.TextureLayer.ExceptionAttemptingToReadTextureFile", uRL);
            Logging.logger().log(Level.SEVERE, string2, exception);
            return null;
        }
    }

    protected void addTileToCache(TextureTile textureTile) {
        TextureTile.getMemoryCache().add(textureTile.getTileKey(), textureTile);
    }

    @Override
    public BulkRetrievalThread makeLocal(Sector sector, double d, BulkRetrievalListener bulkRetrievalListener) {
        return this.makeLocal(sector, d, null, bulkRetrievalListener);
    }

    @Override
    public BulkRetrievalThread makeLocal(Sector sector, double d, FileStore fileStore, BulkRetrievalListener bulkRetrievalListener) {
        Sector sector2;
        Sector sector3 = sector2 = sector != null ? this.getLevels().getSector().intersection(sector) : null;
        if (sector2 == null) {
            return null;
        }
        BasicTiledImageLayerBulkDownloader basicTiledImageLayerBulkDownloader = new BasicTiledImageLayerBulkDownloader(this, sector2, d, fileStore != null ? fileStore : this.getDataFileStore(), bulkRetrievalListener);
        basicTiledImageLayerBulkDownloader.setDaemon(true);
        basicTiledImageLayerBulkDownloader.start();
        return basicTiledImageLayerBulkDownloader;
    }

    @Override
    public long getEstimatedMissingDataSize(Sector sector, double d) {
        return this.getEstimatedMissingDataSize(sector, d, null);
    }

    @Override
    public long getEstimatedMissingDataSize(Sector sector, double d, FileStore fileStore) {
        Sector sector2;
        Sector sector3 = sector2 = sector != null ? this.getLevels().getSector().intersection(sector) : null;
        if (sector2 == null) {
            return 0L;
        }
        BasicTiledImageLayerBulkDownloader basicTiledImageLayerBulkDownloader = new BasicTiledImageLayerBulkDownloader(this, sector, d, fileStore != null ? fileStore : this.getDataFileStore(), null);
        return basicTiledImageLayerBulkDownloader.getEstimatedMissingDataSize();
    }

    protected void retrieveTexture(TextureTile textureTile, DownloadPostProcessor downloadPostProcessor) {
        if (this.getValue("gov.nasa.worldwind.avkey.RetrieverFactoryLocal") != null) {
            this.retrieveLocalTexture(textureTile, downloadPostProcessor);
        } else {
            this.retrieveRemoteTexture(textureTile, downloadPostProcessor);
        }
    }

    protected void retrieveLocalTexture(TextureTile textureTile, DownloadPostProcessor downloadPostProcessor) {
        if (!WorldWind.getLocalRetrievalService().isAvailable()) {
            return;
        }
        RetrieverFactory retrieverFactory = (RetrieverFactory)this.getValue("gov.nasa.worldwind.avkey.RetrieverFactoryLocal");
        if (retrieverFactory == null) {
            return;
        }
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", textureTile.getSector());
        aVListImpl.setValue("gov.nasa.worldwind.avkey.Width", textureTile.getWidth());
        aVListImpl.setValue("gov.nasa.worldwind.avkey.Height", textureTile.getHeight());
        aVListImpl.setValue("gov.nasa.worldwind.avkey.FileName", textureTile.getPath());
        Retriever retriever = retrieverFactory.createRetriever(aVListImpl, downloadPostProcessor);
        WorldWind.getLocalRetrievalService().runRetriever(retriever, textureTile.getPriority());
    }

    protected void retrieveRemoteTexture(TextureTile textureTile, DownloadPostProcessor downloadPostProcessor) {
        Integer n;
        Integer n2;
        URLRetriever uRLRetriever;
        URL uRL;
        if (!this.isNetworkRetrievalEnabled()) {
            this.getLevels().markResourceAbsent(textureTile);
            return;
        }
        if (!WorldWind.getRetrievalService().isAvailable()) {
            return;
        }
        try {
            uRL = textureTile.getResourceURL();
            if (uRL == null) {
                return;
            }
            if (WorldWind.getNetworkStatus().isHostUnavailable(uRL)) {
                this.getLevels().markResourceAbsent(textureTile);
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            Logging.logger().log(Level.SEVERE, Logging.getMessage("layers.TextureLayer.ExceptionCreatingTextureUrl", textureTile), malformedURLException);
            return;
        }
        if (downloadPostProcessor == null) {
            downloadPostProcessor = this.createDownloadPostProcessor(textureTile);
        }
        if ((uRLRetriever = URLRetriever.createRetriever(uRL, downloadPostProcessor)) == null) {
            Logging.logger().severe(Logging.getMessage("layers.TextureLayer.UnknownRetrievalProtocol", uRL.toString()));
            return;
        }
        uRLRetriever.setValue("URLRetriever.ExtractZipEntry", "true");
        Integer n3 = AVListImpl.getIntegerValue(this, "gov.nasa.worldwind.avkey.URLConnectTimeout");
        if (n3 != null && n3 > 0) {
            uRLRetriever.setConnectTimeout(n3);
        }
        if ((n2 = AVListImpl.getIntegerValue(this, "gov.nasa.worldwind.avkey.URLReadTimeout")) != null && n2 > 0) {
            uRLRetriever.setReadTimeout(n2);
        }
        if ((n = AVListImpl.getIntegerValue(this, "gov.nasa.worldwind.avkey.RetrievalStaleRequestLimit")) != null && n > 0) {
            uRLRetriever.setStaleRequestLimit(n);
        }
        WorldWind.getRetrievalService().runRetriever(uRLRetriever, textureTile.getPriority());
    }

    protected DownloadPostProcessor createDownloadPostProcessor(TextureTile textureTile) {
        return new DownloadPostProcessor(textureTile, this);
    }

    protected String retrieveResources() {
        AVList aVList = (AVList)this.getValue("gov.nasa.worldwind.avkey.ConstructionParameters");
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ConstructionParametersIsNull");
            Logging.logger().warning(string);
            return "gov.nasa.worldwind.avkey.RetrievalStateSuccessful";
        }
        URL uRL = DataConfigurationUtils.getOGCGetCapabilitiesURL(aVList);
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.CapabilitiesURLIsNull");
            Logging.logger().warning(string);
            return "gov.nasa.worldwind.avkey.RetrievalStateSuccessful";
        }
        WMSCapabilities wMSCapabilities = this.isNetworkRetrievalEnabled() ? SessionCacheUtils.getOrRetrieveSessionCapabilities(uRL, WorldWind.getSessionCache(), uRL.toString(), null, 1L, null, null) : SessionCacheUtils.getSessionCapabilities(WorldWind.getSessionCache(), uRL.toString(), uRL.toString());
        if (wMSCapabilities == null) {
            return null;
        }
        this.initFromOGCCapabilitiesResource(wMSCapabilities, aVList);
        return "gov.nasa.worldwind.avkey.RetrievalStateSuccessful";
    }

    protected void initFromOGCCapabilitiesResource(WMSCapabilities wMSCapabilities, AVList aVList) {
        if (wMSCapabilities == null) {
            String string = Logging.getMessage("nullValue.CapabilitiesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = DataConfigurationUtils.getOGCLayerNames(aVList);
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        final Long l = wMSCapabilities.getLayerLatestLastUpdateTime(wMSCapabilities, stringArray);
        if (l == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BasicTiledImageLayer.this.setExpiryTime(l);
                BasicTiledImageLayer.this.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, BasicTiledImageLayer.this);
            }
        });
    }

    protected boolean isRetrieveResources() {
        AVList aVList = (AVList)this.getValue("gov.nasa.worldwind.avkey.ConstructionParameters");
        if (aVList == null) {
            return false;
        }
        Boolean bl = (Boolean)aVList.getValue("gov.nasa.worldwind.avkey.RetrievePropertiesFromService");
        return bl != null && bl != false;
    }

    protected void startResourceRetrieval() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                BasicTiledImageLayer.this.retrieveResources();
            }
        });
        thread.setName("Capabilities retrieval for " + this.getName());
        thread.start();
    }

    protected void writeConfigurationFile(FileStore fileStore) {
        try {
            AVList aVList = this.getConfigurationParams(null);
            this.writeConfigurationParams(fileStore, aVList);
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionAttemptingToWriteConfigurationFile");
            Logging.logger().log(Level.SEVERE, string, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeConfigurationParams(FileStore fileStore, AVList aVList) {
        String string = DataConfigurationUtils.getDataConfigFilename(aVList, ".xml");
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new WWRuntimeException(string2);
        }
        if (!this.needsConfigurationFile(fileStore, string, aVList, false)) {
            return;
        }
        Object object = this.fileLock;
        synchronized (object) {
            if (!this.needsConfigurationFile(fileStore, string, aVList, true)) {
                return;
            }
            this.doWriteConfigurationParams(fileStore, string, aVList);
        }
    }

    protected void doWriteConfigurationParams(FileStore fileStore, String string, AVList aVList) {
        File file = fileStore.newFile(string);
        if (file == null) {
            String string2 = Logging.getMessage("generic.CannotCreateFile", string);
            Logging.logger().severe(string2);
            throw new WWRuntimeException(string2);
        }
        Document document = this.createConfigurationDocument(aVList);
        WWXML.saveDocumentToFile(document, file.getPath());
        String string3 = Logging.getMessage("generic.ConfigurationFileCreated", string);
        Logging.logger().fine(string3);
    }

    protected boolean needsConfigurationFile(FileStore fileStore, String string, AVList aVList, boolean bl) {
        long l = this.getExpiryTime();
        if (l <= 0L) {
            l = AVListImpl.getLongValue(aVList, "gov.nasa.worldwind.avkey.ExpiryTime", 0L);
        }
        return !DataConfigurationUtils.hasDataConfigFile(fileStore, string, bl, l);
    }

    protected AVList getConfigurationParams(AVList aVList) {
        AVList aVList2;
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        if ((aVList2 = (AVList)this.getValue("gov.nasa.worldwind.avkey.ConstructionParameters")) != null) {
            aVList.setValues(aVList2);
        }
        DataConfigurationUtils.getLevelSetConfigParams(this.getLevels(), aVList);
        return aVList;
    }

    protected Document createConfigurationDocument(AVList aVList) {
        return BasicTiledImageLayer.createTiledImageLayerConfigDocument(aVList);
    }

    @Override
    public String getRestorableState() {
        AVList aVList = (AVList)this.getValue("gov.nasa.worldwind.avkey.ConstructionParameters");
        if (aVList == null) {
            return null;
        }
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        if (restorableSupport == null) {
            return null;
        }
        this.doGetRestorableState(restorableSupport, null);
        return restorableSupport.getStateAsXml();
    }

    @Override
    public void restoreState(String string) {
        String string2 = Logging.getMessage("RestorableSupport.RestoreRequiresConstructor");
        Logging.logger().severe(string2);
        throw new UnsupportedOperationException(string2);
    }

    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        AVList aVList = (AVList)this.getValue("gov.nasa.worldwind.avkey.ConstructionParameters");
        if (aVList != null) {
            for (Map.Entry<String, Object> object : aVList.getEntries()) {
                this.getRestorableStateForAVPair(object.getKey(), object.getValue(), restorableSupport, stateObject);
            }
        }
        restorableSupport.addStateValueAsBoolean(stateObject, "Layer.Enabled", this.isEnabled());
        restorableSupport.addStateValueAsDouble(stateObject, "Layer.Opacity", this.getOpacity());
        restorableSupport.addStateValueAsDouble(stateObject, "Layer.MinActiveAltitude", this.getMinActiveAltitude());
        restorableSupport.addStateValueAsDouble(stateObject, "Layer.MaxActiveAltitude", this.getMaxActiveAltitude());
        restorableSupport.addStateValueAsBoolean(stateObject, "Layer.NetworkRetrievalEnabled", this.isNetworkRetrievalEnabled());
        restorableSupport.addStateValueAsString(stateObject, "Layer.Name", this.getName());
        restorableSupport.addStateValueAsBoolean(stateObject, "TiledImageLayer.UseMipMaps", this.isUseMipMaps());
        restorableSupport.addStateValueAsBoolean(stateObject, "TiledImageLayer.UseTransparentTextures", this.isUseTransparentTextures());
        RestorableSupport.StateObject stateObject2 = restorableSupport.addStateObject(stateObject, "avlist");
        for (Map.Entry<String, Object> entry : this.getEntries()) {
            this.getRestorableStateForAVPair(entry.getKey(), entry.getValue(), restorableSupport, stateObject2);
        }
    }

    @Override
    public void getRestorableStateForAVPair(String string, Object object, RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        if (object == null) {
            return;
        }
        if (string.equals("gov.nasa.worldwind.avkey.ConstructionParameters")) {
            return;
        }
        if (object instanceof LatLon) {
            restorableSupport.addStateValueAsLatLon(stateObject, string, (LatLon)object);
        } else if (object instanceof Sector) {
            restorableSupport.addStateValueAsSector(stateObject, string, (Sector)object);
        } else if (object instanceof Color) {
            restorableSupport.addStateValueAsColor(stateObject, string, (Color)object);
        } else {
            super.getRestorableStateForAVPair(string, object, restorableSupport, stateObject);
        }
    }

    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        RestorableSupport.StateObject[] stateObjectArray;
        RestorableSupport.StateObject stateObject2;
        String string;
        Double d;
        Boolean bl = restorableSupport.getStateValueAsBoolean(stateObject, "Layer.Enabled");
        if (bl != null) {
            this.setEnabled(bl);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "Layer.Opacity")) != null) {
            this.setOpacity(d);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "Layer.MinActiveAltitude")) != null) {
            this.setMinActiveAltitude(d);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "Layer.MaxActiveAltitude")) != null) {
            this.setMaxActiveAltitude(d);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "Layer.NetworkRetrievalEnabled")) != null) {
            this.setNetworkRetrievalEnabled(bl);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "Layer.Name")) != null) {
            this.setName(string);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "TiledImageLayer.UseMipMaps")) != null) {
            this.setUseMipMaps(bl);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "TiledImageLayer.UseTransparentTextures")) != null) {
            this.setUseTransparentTextures(bl);
        }
        if ((stateObject2 = restorableSupport.getStateObject(stateObject, "avlist")) != null && (stateObjectArray = restorableSupport.getAllStateObjects(stateObject2, "")) != null) {
            for (RestorableSupport.StateObject stateObject3 : stateObjectArray) {
                if (stateObject3 == null) continue;
                this.doRestoreStateForObject(restorableSupport, stateObject3);
            }
        }
    }

    protected void doRestoreStateForObject(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        if (stateObject == null) {
            return;
        }
        this.setValue(stateObject.getName(), stateObject.getValue());
    }

    protected static AVList restorableStateToParams(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        AVListImpl aVListImpl = new AVListImpl();
        BasicTiledImageLayer.restoreStateForParams(restorableSupport, null, aVListImpl);
        return aVListImpl;
    }

    protected static void restoreStateForParams(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject, AVList aVList) {
        Sector sector;
        LatLon latLon;
        Long l;
        Integer n;
        String string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.DataCacheNameKey");
        if (string != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", string);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.ServiceURLKey")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", string);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.DatasetNameKey")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", string);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.FormatSuffixKey")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", string);
        }
        if ((n = restorableSupport.getStateValueAsInteger(stateObject, "gov.nasa.worldwind.avkey.NumEmptyLevels")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", n);
        }
        if ((n = restorableSupport.getStateValueAsInteger(stateObject, "gov.nasa.worldwind.avkey.NumLevels")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.NumLevels", n);
        }
        if ((n = restorableSupport.getStateValueAsInteger(stateObject, "gov.nasa.worldwind.avkey.TileWidthKey")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileWidthKey", n);
        }
        if ((n = restorableSupport.getStateValueAsInteger(stateObject, "gov.nasa.worldwind.avkey.TileHeightKey")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileHeightKey", n);
        }
        if ((l = restorableSupport.getStateValueAsLong(stateObject, "gov.nasa.worldwind.avkey.ExpiryTime")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ExpiryTime", l);
        }
        if ((latLon = restorableSupport.getStateValueAsLatLon(stateObject, "gov.nasa.worldwind.avkey.LevelZeroTileDelta")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", latLon);
        }
        if ((latLon = restorableSupport.getStateValueAsLatLon(stateObject, "gov.nasa.worldwind.avkey.TileOrigin")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileOrigin", latLon);
        }
        if ((sector = restorableSupport.getStateValueAsSector(stateObject, "gov.nasa.worldwind.avKey.Sector")) != null) {
            aVList.setValue("gov.nasa.worldwind.avKey.Sector", sector);
        }
    }

    protected static class DownloadPostProcessor
    extends AbstractRetrievalPostProcessor {
        protected final TextureTile tile;
        protected final BasicTiledImageLayer layer;
        protected final FileStore fileStore;

        public DownloadPostProcessor(TextureTile textureTile, BasicTiledImageLayer basicTiledImageLayer) {
            this(textureTile, basicTiledImageLayer, null);
        }

        public DownloadPostProcessor(TextureTile textureTile, BasicTiledImageLayer basicTiledImageLayer, FileStore fileStore) {
            super(basicTiledImageLayer);
            this.tile = textureTile;
            this.layer = basicTiledImageLayer;
            this.fileStore = fileStore;
        }

        protected FileStore getFileStore() {
            return this.fileStore != null ? this.fileStore : this.layer.getDataFileStore();
        }

        @Override
        protected void markResourceAbsent() {
            this.layer.getLevels().markResourceAbsent(this.tile);
        }

        @Override
        protected Object getFileLock() {
            return this.layer.fileLock;
        }

        @Override
        protected File doGetOutputFile() {
            return this.getFileStore().newFile(this.tile.getPath());
        }

        @Override
        protected ByteBuffer handleSuccessfulRetrieval() {
            ByteBuffer byteBuffer = super.handleSuccessfulRetrieval();
            if (byteBuffer != null) {
                this.layer.writeConfigurationFile(this.getFileStore());
                this.layer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, this);
            }
            return byteBuffer;
        }

        @Override
        protected ByteBuffer handleTextContent() throws IOException {
            this.markResourceAbsent();
            return super.handleTextContent();
        }
    }

    protected static class RequestTask
    implements Runnable,
    Comparable<RequestTask> {
        protected final BasicTiledImageLayer layer;
        protected final TextureTile tile;

        protected RequestTask(TextureTile textureTile, BasicTiledImageLayer basicTiledImageLayer) {
            this.layer = basicTiledImageLayer;
            this.tile = textureTile;
        }

        @Override
        public void run() {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            URL uRL = this.layer.getDataFileStore().findFile(this.tile.getPath(), false);
            if (uRL != null && !this.layer.isTextureFileExpired(this.tile, uRL, this.layer.getDataFileStore())) {
                if (this.layer.loadTexture(this.tile, uRL)) {
                    this.layer.getLevels().unmarkResourceAbsent(this.tile);
                    this.layer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, this);
                    return;
                }
                this.layer.getDataFileStore().removeFile(uRL);
                String string = Logging.getMessage("generic.DeletedCorruptDataFile", uRL);
                Logging.logger().info(string);
            }
            this.layer.retrieveTexture(this.tile, this.layer.createDownloadPostProcessor(this.tile));
        }

        @Override
        public int compareTo(RequestTask requestTask) {
            if (requestTask == null) {
                String string = Logging.getMessage("nullValue.RequestTaskIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return this.tile.getPriority() == requestTask.tile.getPriority() ? 0 : (this.tile.getPriority() < requestTask.tile.getPriority() ? -1 : 1);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            RequestTask requestTask = (RequestTask)object;
            return !(this.tile == null ? requestTask.tile != null : !this.tile.equals(requestTask.tile));
        }

        public int hashCode() {
            return this.tile != null ? this.tile.hashCode() : 0;
        }

        public String toString() {
            return this.tile.toString();
        }
    }
}

