/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.formats.vpf.GeoSymColumn;
import gov.nasa.worldwind.formats.vpf.GeoSymTable;
import gov.nasa.worldwind.formats.vpf.GeoSymTableHeader;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Scanner;
import java.util.logging.Level;

public class GeoSymTableReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canRead(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        Object object = null;
        boolean bl = false;
        try {
            object = WWIO.getFileOrResourceAsStream(string, this.getClass());
            bl = object != null && object instanceof InputStream;
        }
        finally {
            if (object instanceof InputStream) {
                WWIO.closeStream(object, string);
            }
        }
        return bl;
    }

    public GeoSymTable read(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            return this.doRead(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("VPF.ExceptionAttemptingToReadTable", string);
            Logging.logger().log(Level.SEVERE, string3, exception);
            throw new WWRuntimeException(string3, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GeoSymTable doRead(String string) throws IOException {
        InputStream inputStream = null;
        GeoSymTable geoSymTable = null;
        try {
            inputStream = WWIO.openFileOrResourceStream(string, this.getClass());
            geoSymTable = this.readTable(string, inputStream);
        }
        finally {
            WWIO.closeStream(inputStream, string);
        }
        return geoSymTable;
    }

    protected GeoSymTable readTable(String string, InputStream inputStream) {
        Scanner scanner = new Scanner(inputStream);
        GeoSymTableHeader geoSymTableHeader = new GeoSymTableHeader();
        this.readHeader(scanner, geoSymTableHeader);
        GeoSymTable geoSymTable = new GeoSymTable(geoSymTableHeader);
        this.readRecords(scanner, geoSymTable);
        return geoSymTable;
    }

    protected void readHeader(Scanner scanner, GeoSymTableHeader geoSymTableHeader) {
        geoSymTableHeader.removeAllColumns();
        String string = scanner.nextLine();
        String[] stringArray = string.split("[,:]");
        String string2 = stringArray[0].trim();
        if (string2 != null && !GeoSymTableReader.isEmpty(string2)) {
            geoSymTableHeader.setFileName(string2);
        }
        if ((string2 = stringArray[1].trim()) != null && !GeoSymTableReader.isEmpty(string2)) {
            geoSymTableHeader.setDescription(string2);
        }
        while (!(string = scanner.nextLine()).equals(";")) {
            GeoSymColumn geoSymColumn = this.readColumn(string);
            geoSymTableHeader.addColumn(geoSymColumn);
        }
    }

    protected GeoSymColumn readColumn(String string) {
        String[] stringArray = string.split("[=,:]");
        String string2 = stringArray[0].trim();
        if (string2 == null) {
            String string3 = Logging.getMessage("VPF.MissingColumnName");
            Logging.logger().severe(string3);
            throw new WWRuntimeException(string3);
        }
        GeoSymColumn geoSymColumn = new GeoSymColumn(string2);
        string2 = stringArray[1].trim();
        if (string2 != null) {
            geoSymColumn.setDataType(string2);
        }
        if ((string2 = stringArray[2].trim()) != null) {
            geoSymColumn.setDataSize(string2);
        }
        if ((string2 = stringArray[3].trim()) != null) {
            geoSymColumn.setDescription(string2);
        }
        if ((string2 = stringArray[4].trim()) != null && !GeoSymTableReader.isEmpty(string2)) {
            geoSymColumn.setCodeRef(string2);
        }
        return geoSymColumn;
    }

    protected void readRecords(Scanner scanner, GeoSymTable geoSymTable) {
        AVList[] aVListArray;
        ArrayList<AVListImpl> arrayList = new ArrayList<AVListImpl>();
        while (scanner.hasNextLine()) {
            aVListArray = scanner.nextLine().trim();
            if (aVListArray.length() == 0) continue;
            AVListImpl aVListImpl = new AVListImpl();
            this.readRecord((String)aVListArray, geoSymTable, aVListImpl);
            arrayList.add(aVListImpl);
        }
        aVListArray = new AVList[arrayList.size()];
        arrayList.toArray(aVListArray);
        geoSymTable.setRecords(aVListArray);
    }

    protected void readRecord(String string, GeoSymTable geoSymTable, AVList aVList) {
        Collection<GeoSymColumn> collection = geoSymTable.getHeader().getColumns();
        String[] stringArray = string.split("[|]");
        int n = 0;
        for (GeoSymColumn geoSymColumn : collection) {
            String string2 = n < stringArray.length ? stringArray[n++].trim() : null;
            Object object = null;
            if (geoSymColumn.getDataType().equalsIgnoreCase("N")) {
                if (string2 != null) {
                    object = WWUtil.convertStringToInteger(string2);
                }
            } else if (geoSymColumn.getDataType().equalsIgnoreCase("T") && string2 != null && string2.length() > 0) {
                object = string2;
            }
            aVList.setValue(geoSymColumn.getName(), object);
        }
    }

    protected static boolean isEmpty(String string) {
        return string.length() == 0 || string.equals("-");
    }
}

