/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.formats.vpf.GeoSymColumn;
import gov.nasa.worldwind.util.Logging;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Set;

public class GeoSymTableHeader {
    protected String fileName;
    protected String description;
    protected LinkedHashMap<String, GeoSymColumn> columnMap = new LinkedHashMap();

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public int getNumColumns() {
        return this.columnMap.size();
    }

    public boolean containsColumn(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.columnMap.containsKey(string);
    }

    public GeoSymColumn getColumn(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.columnMap.get(string);
    }

    public Set<String> getColumnNames() {
        return Collections.unmodifiableSet(this.columnMap.keySet());
    }

    public Collection<GeoSymColumn> getColumns() {
        return Collections.unmodifiableCollection(this.columnMap.values());
    }

    public void setColumns(Collection<? extends GeoSymColumn> collection) {
        this.removeAllColumns();
        if (collection != null) {
            this.addAllColumns(collection);
        }
    }

    public void addColumn(GeoSymColumn geoSymColumn) {
        if (geoSymColumn == null) {
            String string = Logging.getMessage("nullValue.ColumnIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.columnMap.put(geoSymColumn.getName(), geoSymColumn);
    }

    public void addAllColumns(Collection<? extends GeoSymColumn> collection) {
        if (collection == null) {
            String string = Logging.getMessage("nullValue.CollectionIsNulln");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (GeoSymColumn geoSymColumn : collection) {
            this.addColumn(geoSymColumn);
        }
    }

    public void removeColumn(GeoSymColumn geoSymColumn) {
        if (geoSymColumn == null) {
            String string = Logging.getMessage("nullValue.ColumnIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.columnMap.remove(geoSymColumn.getName());
    }

    public void removeAllColumns() {
        this.columnMap.clear();
    }
}

