/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.formats.vpf.GeoSymTableHeader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GeoSymTable {
    private GeoSymTableHeader header;
    private AVList[] records;
    private Map<Integer, Integer> indexOnId;

    public GeoSymTable(GeoSymTableHeader geoSymTableHeader) {
        this.header = geoSymTableHeader;
        this.indexOnId = new HashMap<Integer, Integer>();
    }

    public GeoSymTableHeader getHeader() {
        return this.header;
    }

    public AVList[] getRecords() {
        return this.records;
    }

    public void setRecords(AVList[] aVListArray) {
        this.records = aVListArray;
        this.buildRecordIndices();
    }

    public AVList getRecord(int n) {
        Integer n2 = this.indexOnId.get(n);
        return n2 != null && n2 >= 0 && n2 < this.records.length ? this.records[n2] : null;
    }

    public static void selectMatchingRows(String string, Object object, boolean bl, List<AVList> list) {
        Iterator<AVList> iterator = list.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        while (iterator.hasNext()) {
            Object object2;
            AVList aVList = iterator.next();
            if (aVList == null || ((object2 = aVList.getValue(string)) != null || bl) && (object2 == null || object2.equals(object))) continue;
            iterator.remove();
        }
    }

    public static void selectMatchingStringRows(String string, String string2, boolean bl, List<AVList> list) {
        Iterator<AVList> iterator = list.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        while (iterator.hasNext()) {
            Object object;
            AVList aVList = iterator.next();
            if (aVList == null || (object = aVList.getValue(string)) != null && !(object instanceof String)) continue;
            String string3 = (String)object;
            if (string3 == null || string3.length() == 0) {
                if (bl) continue;
                iterator.remove();
                continue;
            }
            if (string3.equalsIgnoreCase(string2)) continue;
            iterator.remove();
        }
    }

    protected void buildRecordIndices() {
        this.indexOnId.clear();
        for (int i = 0; i < this.records.length; ++i) {
            Integer n = AVListImpl.getIntegerValue(this.records[i], "id");
            if (n == null) continue;
            this.indexOnId.put(n, i);
        }
    }
}

