/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.util.Logging;

class Base34Converter {
    private static final char[] BASE34_ALPHABET = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    Base34Converter() {
    }

    public static char[] valueOf(int n, char[] cArray, int n2, int n3) {
        if (cArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0 || n3 < 0 || n2 + n3 >= cArray.length) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange");
            Logging.logger().fine(string);
            throw new IndexOutOfBoundsException(string);
        }
        for (int i = n3 + n2 - 1; i >= n2; --i) {
            cArray[i] = BASE34_ALPHABET[n % 34];
            n /= 34;
        }
        return cArray;
    }

    public static int parseChars(char[] cArray, int n, int n2) {
        if (cArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0 || n2 < 0 || n + n2 >= cArray.length) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange");
            Logging.logger().fine(string);
            throw new IndexOutOfBoundsException(string);
        }
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            int n4;
            char c = Character.toUpperCase(cArray[i]);
            if (c >= '0' && c <= '9') {
                n4 = c - 48;
            } else if (c >= 'A' && c <= 'H') {
                n4 = 10 + c - 65;
            } else if (c >= 'J' && c <= 'N') {
                n4 = 18 + c - 74;
            } else if (c >= 'P' && c <= 'Z') {
                n4 = 23 + c - 80;
            } else {
                String string = Logging.getMessage("Base34Converter.Base34Error");
                Logging.logger().fine(string);
                throw new IllegalArgumentException(string);
            }
            n3 = n3 * 34 + n4;
        }
        return n3;
    }

    public static boolean isBase34(char[] cArray, int n, int n2) {
        if (cArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0 || n2 < 0 || n + n2 >= cArray.length) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange");
            Logging.logger().fine(string);
            throw new IndexOutOfBoundsException(string);
        }
        for (int i = n; i < n + n2; ++i) {
            char c = Character.toUpperCase(cArray[i]);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'H' || c >= 'J' && c <= 'N' || c >= 'P' && c <= 'Z') continue;
            return false;
        }
        return true;
    }
}

