/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.nitfs;

import gov.nasa.worldwind.formats.nitfs.NITFSRuntimeException;
import gov.nasa.worldwind.formats.nitfs.NITFSUtil;
import gov.nasa.worldwind.formats.rpf.RPFColorMap;
import java.nio.ByteBuffer;

class CompressionLookupRecord {
    private int tableID;
    private int numOfRecords;
    private int numOfValuesPerRecord;
    private int valueBitLength;
    private int tableLocation;
    private short bytesPerRecord;
    private byte[] lut;

    public int getTableID() {
        return this.tableID;
    }

    public int getNumOfRecords() {
        return this.numOfRecords;
    }

    public int getNumOfValuesPerRecord() {
        return this.numOfValuesPerRecord;
    }

    public int getValueBitLength() {
        return this.valueBitLength;
    }

    public short getBytesPerRecord() {
        return this.bytesPerRecord;
    }

    public byte[] copyValues(byte[] byArray, int n, int n2, int n3) {
        if (n3 != this.bytesPerRecord) {
            throw new NITFSRuntimeException("NITFSReader.AttemptToCopyWithInvalidSizeOfRecord");
        }
        if (n2 >= this.numOfRecords) {
            throw new NITFSRuntimeException("NITFSReader.AttemptToCopyOutOfBoundsAtSource");
        }
        if (null == byArray) {
            throw new NITFSRuntimeException("NITFSReader.AttemptCopyToIvalidDestination");
        }
        if (byArray.length < n + n3) {
            throw new NITFSRuntimeException("NITFSReader.AttemptToCopyOutOfBoundsAtDestination");
        }
        System.arraycopy(this.lut, n2 * this.bytesPerRecord, byArray, n, this.bytesPerRecord);
        return byArray;
    }

    public CompressionLookupRecord(ByteBuffer byteBuffer, int n, RPFColorMap[] rPFColorMapArray) {
        this.tableID = NITFSUtil.getUShort(byteBuffer);
        this.numOfRecords = (int)NITFSUtil.getUInt(byteBuffer);
        this.numOfValuesPerRecord = NITFSUtil.getUShort(byteBuffer);
        this.valueBitLength = NITFSUtil.getUShort(byteBuffer);
        this.tableLocation = (int)(NITFSUtil.getUInt(byteBuffer) + (long)n);
        int n2 = byteBuffer.position();
        this.bytesPerRecord = (short)((long)(this.numOfValuesPerRecord * this.valueBitLength) / 8L);
        this.lut = new byte[this.numOfRecords * this.bytesPerRecord];
        byteBuffer.position(this.tableLocation);
        byteBuffer.get(this.lut, 0, this.numOfRecords * this.bytesPerRecord);
        byteBuffer.position(n2);
    }
}

