/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.Version;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.data.BufferWrapperRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwind.util.Logging;
import java.nio.ByteBuffer;
import java.util.Calendar;

public class ByteBufferRaster
extends BufferWrapperRaster {
    private ByteBuffer byteBuffer;

    public ByteBufferRaster(int n, int n2, Sector sector, ByteBuffer byteBuffer, AVList aVList) {
        super(n, n2, sector, BufferWrapper.wrap(byteBuffer, aVList), aVList);
        this.byteBuffer = byteBuffer;
        this.validateParameters(aVList);
    }

    private void validateParameters(AVList aVList) throws IllegalArgumentException {
        this.doValidateParameters(aVList);
    }

    protected void doValidateParameters(AVList aVList) throws IllegalArgumentException {
    }

    public ByteBufferRaster(int n, int n2, Sector sector, AVList aVList) {
        this(n, n2, sector, ByteBufferRaster.createCompatibleBuffer(n, n2, aVList), aVList);
    }

    public static ByteBuffer createCompatibleBuffer(int n, int n2, AVList aVList) {
        if (n < 1) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "width < 1");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 1) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "height < 1");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ParamsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Object object = aVList.getValue("gov.nasa.worldwind.avkey.DataType");
        int n3 = 0;
        if ("gov.nasa.worldwind.avkey.Int8".equals(object)) {
            n3 = 1;
        } else if ("gov.nasa.worldwind.avkey.Int16".equals(object)) {
            n3 = 2;
        } else if ("gov.nasa.worldwind.avkey.Int32".equals(object)) {
            n3 = 4;
        } else if ("gov.nasa.worldwind.avkey.Float32".equals(object)) {
            n3 = 4;
        }
        int n4 = n3 * n * n2;
        return ByteBuffer.allocate(n4);
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public static DataRaster createGeoreferencedRaster(AVList aVList) {
        double d;
        if (null == aVList) {
            String string = Logging.getMessage("nullValue.AVListIsNull");
            Logging.logger().finest(string);
            throw new IllegalArgumentException(string);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.Width")) {
            String string = Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avkey.Width");
            Logging.logger().finest(string);
            throw new IllegalArgumentException(string);
        }
        int n = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.Width");
        if (n <= 0) {
            String string = Logging.getMessage("generic.InvalidWidth", n);
            Logging.logger().finest(string);
            throw new IllegalArgumentException(string);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.Height")) {
            String string = Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avkey.Height");
            Logging.logger().finest(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.Height");
        if (n2 <= 0) {
            String string = Logging.getMessage("generic.InvalidWidth", n2);
            Logging.logger().finest(string);
            throw new IllegalArgumentException(string);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avKey.Sector")) {
            String string = Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avKey.Sector");
            Logging.logger().finest(string);
            throw new IllegalArgumentException(string);
        }
        Sector sector = (Sector)aVList.getValue("gov.nasa.worldwind.avKey.Sector");
        if (null == sector) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.CoordinateSystem")) {
            aVList.setValue("gov.nasa.worldwind.avkey.CoordinateSystem", "gov.nasa.worldwind.avkey.CoordinateSystem.Geographic");
        }
        String string = aVList.getStringValue("gov.nasa.worldwind.avkey.CoordinateSystem");
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.Projection.EPSG.Code")) {
            if ("gov.nasa.worldwind.avkey.CoordinateSystem.Geographic".equals(string)) {
                aVList.setValue("gov.nasa.worldwind.avkey.Projection.EPSG.Code", 4326);
            } else {
                String string2 = Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avkey.Projection.EPSG.Code");
                Logging.logger().finest(string2);
                throw new IllegalArgumentException(string2);
            }
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.PixelWidth")) {
            if ("gov.nasa.worldwind.avkey.CoordinateSystem.Geographic".equals(string)) {
                d = sector.getDeltaLonDegrees() / (double)n;
                aVList.setValue("gov.nasa.worldwind.avkey.PixelWidth", d);
            } else {
                String string3 = Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avkey.PixelWidth");
                Logging.logger().finest(string3);
                throw new IllegalArgumentException(string3);
            }
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.PixelHeight")) {
            if ("gov.nasa.worldwind.avkey.CoordinateSystem.Geographic".equals(string)) {
                d = sector.getDeltaLatDegrees() / (double)n2;
                aVList.setValue("gov.nasa.worldwind.avkey.PixelHeight", d);
            } else {
                String string4 = Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avkey.PixelHeight");
                Logging.logger().finest(string4);
                throw new IllegalArgumentException(string4);
            }
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.PixelFormat")) {
            String string5 = Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avkey.PixelFormat");
            Logging.logger().finest(string5);
            throw new IllegalArgumentException(string5);
        }
        Object object = aVList.getStringValue("gov.nasa.worldwind.avkey.PixelFormat");
        if (!"gov.nasa.worldwind.avkey.Elevation".equals(object) && !"gov.nasa.worldwind.avkey.Image".equals(object)) {
            String string6 = Logging.getMessage("generic.UnknownValueForKey", object, "gov.nasa.worldwind.avkey.PixelFormat");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.DataType")) {
            object = Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avkey.DataType");
            Logging.logger().finest((String)object);
            throw new IllegalArgumentException((String)object);
        }
        if ("gov.nasa.worldwind.avkey.Elevation".equals(aVList.getValue("gov.nasa.worldwind.avkey.PixelFormat")) && !"gov.nasa.worldwind.avkey.Float32".equals(object = aVList.getStringValue("gov.nasa.worldwind.avkey.DataType")) && !"gov.nasa.worldwind.avkey.Int16".equals(object)) {
            String string7 = Logging.getMessage("generic.UnknownValueForKey", object, "gov.nasa.worldwind.avkey.DataType");
            Logging.logger().severe(string7);
            throw new IllegalArgumentException(string7);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.Origin") && "gov.nasa.worldwind.avkey.CoordinateSystem.Geographic".equals(string)) {
            object = new LatLon(sector.getMaxLatitude(), sector.getMinLongitude());
            aVList.setValue("gov.nasa.worldwind.avkey.Origin", object);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.ByteOrder")) {
            object = Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avkey.ByteOrder");
            Logging.logger().finest((String)object);
            throw new IllegalArgumentException((String)object);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.DateTime")) {
            object = String.format("%1$tY:%1$tm:%1$td %tT\u0000", Calendar.getInstance());
            aVList.setValue("gov.nasa.worldwind.avkey.DateTime", object);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.Version")) {
            aVList.setValue("gov.nasa.worldwind.avkey.Version", Version.getVersion());
        }
        return new ByteBufferRaster(n, n2, sector, aVList);
    }
}

