/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.cache;

import gov.nasa.worldwind.cache.SessionCache;
import gov.nasa.worldwind.util.BoundedHashMap;
import gov.nasa.worldwind.util.Logging;
import java.util.Collections;
import java.util.Set;

public class BasicSessionCache
implements SessionCache {
    protected static final int DEFAULT_CAPACITY = 8;
    protected BoundedHashMap<Object, Object> entries;

    public BasicSessionCache(int n) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "capacity < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.entries = new BoundedHashMap(n);
    }

    public BasicSessionCache() {
        this(8);
    }

    @Override
    public synchronized int getCapacity() {
        return this.entries.getCapacity();
    }

    @Override
    public synchronized void setCapacity(int n) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "capacity < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.entries.setCapacity(n);
    }

    @Override
    public synchronized int getEntryCount() {
        return this.entries.size();
    }

    @Override
    public synchronized Set<Object> getKeySet() {
        return Collections.unmodifiableSet(this.entries.keySet());
    }

    @Override
    public synchronized boolean contains(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.entries.containsKey(object);
    }

    @Override
    public synchronized Object get(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.entries.get(object);
    }

    @Override
    public synchronized void put(Object object, Object object2) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.entries.put(object, object2);
    }

    @Override
    public synchronized Object remove(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.entries.remove(object);
    }

    @Override
    public synchronized void clear() {
        this.entries.clear();
    }
}

