/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.netbeans.tile.cli;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class TileModeGenerator {
    private static final String MODE_XML_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mode version=\"2.4\">\n    <name unique=\"$NAME\"/>\n    <kind type=\"editor\"/>\n    <state type=\"joined\"/>\n    <constraints>\n        <path orientation=\"vertical\" number=\"$ROW\" weight=\"0.5\"/>\n        <path orientation=\"horizontal\" number=\"$COL\" weight=\"0.5\"/>\n    </constraints>\n    <bounds x=\"0\" y=\"0\" width=\"400\" height=\"400\"/>\n    <frame state=\"0\"/>\n    <empty-behavior permanent=\"true\"/>\n</mode>\n";

    public static void main(String[] args) throws IOException {
        new File("modes").mkdir();
        ArrayList<String> modeNames = new ArrayList<String>();
        for (int row = 0; row < 16; ++row) {
            for (int col = 0; col < 16; ++col) {
                String modeName = String.format("editor_r%dc%d", row, col);
                modeNames.add(modeName);
                File modeFile = new File(new File("modes"), modeName + ".wsmode");
                try (FileWriter fileWriter = new FileWriter(modeFile);){
                    fileWriter.write(MODE_XML_TEMPLATE.replace("$NAME", modeName).replace("$COL", col + "").replace("$ROW", row + ""));
                    continue;
                }
            }
        }
        System.out.println("<folder name=\"Windows2\" >\n    <folder name=\"Modes\" >");
        for (String modeName : modeNames) {
            System.out.printf("        <file name=\"%s.wsmode\" url=\"modes/%s.wsmode\" />\n", modeName, modeName);
        }
        System.out.println("    </folder>\n</folder>");
    }
}

