/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.descriptor;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.esa.snap.core.gpf.descriptor.SystemVariable;
import org.esa.snap.core.gpf.descriptor.ToolAdapterOperatorDescriptor;

public abstract class VariableResolver {
    private static Map<ToolAdapterOperatorDescriptor, VariableResolver> resolverMap = new HashMap<ToolAdapterOperatorDescriptor, VariableResolver>();
    protected VariableResolver nextResolver;
    protected ToolAdapterOperatorDescriptor descriptor;

    public static VariableResolver newInstance(ToolAdapterOperatorDescriptor descriptor) {
        if (!resolverMap.containsKey(descriptor)) {
            SimpleVariableResolver simpleResolver = new SimpleVariableResolver(descriptor);
            SystemPathVariableResolver systemPathResolver = new SystemPathVariableResolver(descriptor);
            simpleResolver.setNextResolver(systemPathResolver);
            resolverMap.put(descriptor, simpleResolver);
        }
        return resolverMap.get(descriptor);
    }

    VariableResolver(ToolAdapterOperatorDescriptor operatorDescriptor) {
        this.descriptor = operatorDescriptor;
    }

    public abstract String resolve(String var1);

    public abstract File resolve(File var1);

    protected void setNextResolver(VariableResolver resolver) {
        this.nextResolver = resolver;
    }

    protected boolean isValidFileName(String fileName) {
        File f = new File(fileName);
        try {
            f.getCanonicalPath();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    static class SystemPathVariableResolver
    extends VariableResolver {
        private final String[] systemPath;

        SystemPathVariableResolver(ToolAdapterOperatorDescriptor operatorDescriptor) {
            super(operatorDescriptor);
            String sysPath = System.getenv("PATH");
            this.systemPath = sysPath.split(File.pathSeparator);
        }

        @Override
        public String resolve(String input) {
            File resolvedFile;
            String resolved = input;
            if (resolved != null && (resolvedFile = this.resolve(new File(input))) != null) {
                resolved = resolvedFile.getAbsolutePath();
            }
            return resolved;
        }

        @Override
        public File resolve(File input) {
            File resolved = null;
            if (input != null && !input.exists()) {
                for (String sysPath : this.systemPath) {
                    File current = new File(sysPath, input.getPath());
                    if (!current.exists()) continue;
                    resolved = current;
                    break;
                }
                if (resolved == null && this.nextResolver != null) {
                    resolved = this.nextResolver.resolve(input);
                }
            } else {
                resolved = input;
            }
            return resolved == null ? input : resolved;
        }
    }

    static class SimpleVariableResolver
    extends VariableResolver {
        SimpleVariableResolver(ToolAdapterOperatorDescriptor operatorDescriptor) {
            super(operatorDescriptor);
        }

        @Override
        public String resolve(String input) {
            String resolved = input;
            if (input != null) {
                Map<String, String> lookupVars = this.descriptor.getVariables().stream().collect(Collectors.toMap(SystemVariable::getKey, SystemVariable::getValue));
                for (String key : lookupVars.keySet()) {
                    resolved = resolved.replace("$" + key, lookupVars.get(key));
                }
                if (this.nextResolver != null && this.isValidFileName(resolved)) {
                    resolved = this.nextResolver.resolve(resolved);
                }
            }
            return resolved;
        }

        @Override
        public File resolve(File input) {
            File resolved = input;
            if (input != null && !input.exists()) {
                String expandedValue = input.getPath();
                Map<String, String> lookupVars = this.descriptor.getVariables().stream().collect(Collectors.toMap(SystemVariable::getKey, SystemVariable::getValue));
                for (String key : lookupVars.keySet()) {
                    String value = lookupVars.get(key);
                    if (value == null || value.isEmpty()) continue;
                    expandedValue = expandedValue.replace("$" + key, value);
                }
                resolved = new File(expandedValue);
                if (this.nextResolver != null && !resolved.exists()) {
                    resolved = this.nextResolver.resolve(resolved);
                }
            }
            return resolved == null ? input : resolved;
        }
    }
}

